      PROGRAM segmentrmsd                                               |
      INCLUDE '../comp/dimensions'                                      |
      INCLUDE '../dat/mem_region_maps0'                                 |
      INCLUDE '../str/mem_program_options'                              |
      INCLUDE '../str/mem_structure'                                    |
      INCLUDE '../fil/mem_trajectory'                                   |
      INCLUDE '../str/mem_search_subspace'                              |
      INCLUDE '../str/mem_backbone_defs'                                |
      CHARACTER*32  FAMILY                                              |
      CHARACTER*32  PROTEIN                                             |
      CHARACTER*32  SUBSET                                              |
      CHARACTER*32  CONFORMATION                                        |
      LOGICAL*4  file_exists                                            |
      CHARACTER*142  message                                            |
      REAL*8  D0ftot(oD0)                                               |
      REAL*8  D0fr(oD0)                                                 |
      REAL*8  D0fe(oD0)                                                 |
      REAL*8  D0fs(oD0)                                                 |
      REAL*8  D0ft(oD0)                                                 |
      REAL*8  D0fc(oD0)                                                 |
      REAL*8  D0fh(oD0)                                                 |
      REAL*8  D0fm(oD0)                                                 |
      REAL*8  D0fpro(oD0)                                               |
      REAL*8  D0fpol(oD0)                                               |
      REAL*8  D0fvac(oD0)                                               |
      CHARACTER*2  D0R1bbcnf(oR1,oD0)                                   |
      CHARACTER*1  buf                                                  |
      CHARACTER*1  alp1,alp2,alp3                                       |
      REAL*8  zZZZ                                                      |
      REAL*8  zD1,zD2,zD3,zRR                                           |
      REAL*8  D0rmsd(oD0)                                               |
      CHARACTER*4  aa                                                   |
      CHARACTER*2  bbcnf                                                |
      REAL*8  phi,psi                                                   |
      CHARACTER*128  lin1,lin2                                          |
      CALL DAT_REGION_MAPS0                                             |
CC                                                                      |
CC                                                                      |
CC                                                                      |
      IF( IARGC().NE.4 )THEN                                            |
 9000   FORMAT(('ERROR: Number of command line arguments '),            |
     1         ('should equal 4.'))                                     |
        WRITE( 6,9000)                                                  |
        STOP 2                                                          |
      ELSE                                                              |
        CALL GETARG(1,FAMILY)                                           |FAMILY
        CALL GETARG(2,PROTEIN)                                          |PROTEIN
        CALL GETARG(3,CONFORMATION)                                     |CONFORMATION
        CALL GETARG(4,SUBSET)                                           |SUBSET
      END IF                                                            |
CC                                                                      |
CC                                                                      |
CC                                                                      |
      fam=FAMILY                                                        |fam
      N_1=32                                                            |
 101  IF( fam(N_1:N_1).EQ.' ' )THEN                                     |
        N_1=N_1-1                                                       |N_1
        IF( N_1.GT. 0 )GO TO 101                                        |
      END IF                                                            |
      mol=PROTEIN                                                       |mol
      N_2=32                                                            |
 102  IF( mol(N_2:N_2).EQ.' ' )THEN                                     |
        N_2=N_2-1                                                       |N_2
        IF( N_2.GT. 0 )GO TO 102                                        |
      END IF                                                            |
      cnf=CONFORMATION                                                  |cnf
      N_3=32                                                            |
 103  IF( cnf(N_3:N_3).EQ.' ' )THEN                                     |
        N_3=N_3-1                                                       |N_3
        IF( N_3.GT. 0 )GO TO 103                                        |
      END IF                                                            |
      SUB=SUBSET                                                        |SUB
      N_4=32                                                            |
 104  IF( cnf(N_4:N_4).EQ.' ' )THEN                                     |
        N_4=N_4-1                                                       |N_4
        IF( N_4.GT. 0 )GO TO 104                                        |
      END IF                                                            |
CC                                                                      |
CC                                                                      |
CC input starting conformation                                          |
CC                                                                      |
      CALL FIL2SEQ                                                      |
      CALL FIL2TOR                                                      |
      CALL FIL2CAR                                                      |
      CALL STR2TRA( 0)                                                  |
CC                                                                      |
CC                                                                      |
CC construct Z2 arrays                                                  |
CC                                                                      |
      CALL FIL2STP                                                      |
      nZ2=0                                                             |
      DO 201 iR1= 1,nR1                                                 |
        IF( R1pt(iR1).GT.0 )THEN                                        |
          nZ2=nZ2+1                                                     |nZ2
          Z2CYC(nZ2)=iR1                                                |Z2CYC
        END IF                                                          |
 201    CONTINUE                                                        |
CC                                                                      |
      IF( nZ0.GT.1 )THEN                                                |
        mBOD=0                                                          |
        DO 202 iR1= 1,nR1                                               |
          IF( R1bb(iR1).EQ.0 )GO TO 202                                 |
          iZ0=R1Z0(iR1)                                                 |
          iR0=R1R0(iR1)                                                 |
          mR0=Z0R0a(iZ0)                                                |
          IF( iR0.EQ.mR0 )mBOD=1                                        |mBOD
 202      CONTINUE                                                      |
      END IF                                                            |
CC                                                                      |
CC                                                                      |
CC input solution of global search                                      |
CC                                                                      |
      INQUIRE(FILE='../../'//fam(1:N_1)//'/diag/glo_nc_sol.'//          |
     1             SUB(1:N_4)//'.'//mol(1:N_2),                         |
     1        EXIST=file_exists)                                        |file_exists
      IF( .NOT.file_exists )THEN                                        |
        n=(46+N_1+N_2+N_4)                                              |
        message(1:n)=('ERROR: ')//                                      |
     1    ('File ')//fam(1:N_1)//'/diag/glo_nc_sol.'//                  |
     1    SUB(1:N_4)//'.'//mol(1:N_2)//(' does not exist.')             |
 9001   FORMAT(142a1)                                                   |
        WRITE( 6,9001)(message(i:i),i=1,n)                              |
        STOP 2                                                          |
      END IF                                                            |
      OPEN(UNIT=21,FILE='../../'//fam(1:N_1)//'/diag/glo_nc_sol.'//     |
     1                  SUB(1:N_4)//'.'//mol(1:N_2))                    |
 1000 FORMAT(20i4)                                                      |
      WRITE(21,1000)nD0                                                 |
      DO 301 iD0= 1,nD0                                                 |
 1001   FORMAT(i4,2x,d12.5,2x,64a2)                                     |
        READ(21,1001)jD0,D0ftot(iD0),                                   |D0ftot
     1               (D0R1bbcnf(iR1,iD0),iR1= 1,nR1)                    |D0R1bbcnf
 1002   FORMAT(9f9.2)                                                   |
        READ(21,1002)D0fr(iD0),D0fe(iD0),D0fs(iD0),D0ft(iD0),D0fc(iD0), |D0fr
     1               D0fh(iD0),D0fm(iD0),D0fpro(iD0),D0fpol(iD0)        |D0fe
 1003   FORMAT(a1)                                                      |D0fs
        IF( mBOD.EQ.1 )THEN                                             |D0ft
          DO 303 iZ0= 2,nZ0                                             |D0fc
            READ(21,1003)buf                                            |D0fh
 303        CONTINUE                                                    |D0fm
        END IF                                                          |D0fpro
        DO 304 iR1= 1,nR1                                               |D0fpol
          READ(21,1003)buf                                              |
 304      CONTINUE                                                      |
 301    CONTINUE                                                        |
      CLOSE(UNIT=21)                                                    |
CC                                                                      |
CC                                                                      |
CC input low-energy conformations                                       |
CC                                                                      |
 2000 FORMAT(i1)                                                        |
      iD0=0                                                             |
      DO 401 i1=0,9                                                     |
        WRITE(alp1,2000)i1                                              |alp1
        DO 402 i2=0,9                                                   |
          WRITE(alp2,2000)i2                                            |alp2
          DO 403 i3=0,9                                                 |
            WRITE(alp3,2000)i3                                          |alp3
            iD0=iD0+1                                                   |
            IF( iD0.GT.nD0 )GO TO 404                                   |
            cnf(1:5)='nc'//alp1//alp2//alp3                             |
            N_3=5                                                       |
            CALL FIL2SEQ                                                |
            CALL FIL2TOR                                                |
            CALL FIL2CAR                                                |
            CALL STR2TRA(iD0)                                           |
 403        CONTINUE                                                    |
 402      CONTINUE                                                      |
 401    CONTINUE                                                        |
 404  CONTINUE                                                          |
      CALL TRA2STR( 0)                                                  |
CC                                                                      |
CC                                                                      |
CC calculate rmsd                                                       |
CC                                                                      |
      DO 501 iD0= 1,nD0                                                 |
        zZZZ= (0.00d0)                                                  |
        jP1=0                                                           |
        DO 502 iZ2= 1,nZ2                                               |
          iR1min=(Z2CYC(iZ2)+1)                                         |
          iR1max=(Z2CYC(iZ2)-1+R1pt(Z2CYC(iZ2)))                        |
          iR0min=R1R0(iR1min)                                           |
          iR0max=R1R0(iR1max)                                           |
          DO 503 iR0=iR0min,iR0max                                      |
            mP1=R0P1a(iR0)                                              |
            nP1=(mP1-1+R0cP1(iR0))                                      |
            DO 504 iP1=mP1,nP1                                          |
              IF( P1sub(iP1).EQ.0 )GO TO 504                            |
              iT2=P1typ(iP1)                                            |
              IF( iT2.LT. 8 )GO TO 504                                  |
              zD1=( M0P1x(1, iP1,iD0) -P1x(1, iP1))                     |
              zD2=( M0P1x(2, iP1,iD0) -P1x(2, iP1))                     |
              zD3=( M0P1x(3, iP1,iD0) -P1x(3, iP1))                     |
              zRR=( zD1*zD1 +zD2*zD2 +zD3*zD3)                          |
              zZZZ=zZZZ +zRR                                            |
              jP1=jP1+1                                                 |
 504          CONTINUE                                                  |
 503        CONTINUE                                                    |
 502      CONTINUE                                                      |
        zZZZ= (zZZZ/DBLE( jP1))                                         |
        zZZZ= DSQRT( zZZZ)                                              |
        D0rmsd(iD0)= zZZZ                                               |D0rmsd
 501    CONTINUE                                                        |
CC                                                                      |
CC                                                                      |
CC output table                                                         |
CC                                                                      |
      OPEN(UNIT=21,FILE='rmsdtab.'//SUB(1:N_4)//'.'//mol(1:N_2))        |
 8000 FORMAT(98a1)                                                      |
      WRITE(21,8000)(mol(i:i),i= 1,N_2),(' '),                          |
     1              (sub(i:i),i= 1,N_4),(' '),                          |
     1              (cnf(i:i),i= 1,N_3)                                 |
 8001 FORMAT(/)                                                         |
      WRITE(21,8001)                                                    |
 8002 FORMAT(('________________________________________')//             |
     1       ('________________________________________'))              |
      WRITE(21,8002)                                                    |
 8003 FORMAT(('  regularized crystal structure'))                       |
 8004 FORMAT(('res  aa          phi   psi   cnf'))                      |
 8005 FORMAT(('___ ___ ______ ____________ ____'))                      |
      WRITE(21,8003)                                                    |
      WRITE(21,8004)                                                    |
      WRITE(21,8005)                                                    |
      jR1=0                                                             |
      DO 901 iZ2= 1,nZ2                                                 |
        iR1min=(Z2CYC(iZ2)+1)                                           |
        iR1max=(Z2CYC(iZ2)-1+R1pt(Z2CYC(iZ2)))                          |
 8006   FORMAT(i3,1x,a4,3i2,1x,2f6.1,3x,a2)                             |
        DO 902 iR1=iR1min,iR1max                                        |
          jR1=jR1+1                                                     |
          iZ0=R1Z0(iR1)                                                 |
          iR0=R1R0(iR1)                                                 |
          mR0=Z0R0a(iZ0)                                                |
          nR0=(mR0-1+Z0cR0(iZ0))                                        |
          aa=R0aa(iR0)                                                  |
CC                                                                      |
          bbcnf='  '                                                    |
          IF( (aa.EQ.'ACE ').OR.(aa.EQ.'NME ').OR.                      |
     1        (aa.EQ.'NH2 ').OR.                                        |
     1        (aa(1:1).EQ.'e').OR.(aa(4:4).EQ.'e') )THEN                |
          ELSE                                                          |
            mT1=R0T1a(iR0  )                                            |
            phi= T1chi(mT1  )                                           |
            psi= T1chi(mT1+1)                                           |
            IF( phi.GT.(0.00d0) )THEN                                   |
              phi=-phi                                                  |
              psi=-psi                                                  |
              bbcnf(2:2)='*'                                            |
            ELSE                                                        |
              bbcnf(2:2)=' '                                            |
            END IF                                                      |
            iH4=1 +INT( phi +(180.00d0))/10                             |
            jH4=1 +INT( psi +(180.00d0))/10                             |
            IF( aa.EQ.'GLY ' )THEN                                      |
              bbcnf(1:1)=I0alp2(H4H4gly(iH4,jH4))                       |
            ELSE                                                        |
              bbcnf(1:1)=I0alp2(H4H4ala(iH4,jH4))                       |
            END IF                                                      |
          END IF                                                        |
CC                                                                      |
          WRITE(21,8006)(iR0-mR0+1),aa,R1bb(iR1),R1sc(iR1),R1pt(iR1),   |
     1      phi,psi,bbcnf                                               |
 902      CONTINUE                                                      |
 901    CONTINUE                                                        |
      WRITE(21,8002)                                                    |
 8007 FORMAT(('  global energy minimization'))                          |
      WRITE(21,8007)                                                    |
      WRITE(21,8001)                                                    |
      lin1( 1:23)=('      Ftot      bb conf')                           |
      lin2( 1:23)=(' __ _______  __________')                           |
      j=(2*jR1-10)                                                      |
      DO 903 i=1,j                                                      |
        lin1(23+i:23+i)=' '                                             |
        lin2(23+i:23+i)='_'                                             |
 903    CONTINUE                                                        |
      lin1(24+j:55+j)=('   Fvac    Fsol    Fpol    rmsd ')              |
      lin2(24+j:55+j)=(' _______ _______ _______ _______')              |
      n=(55+j)                                                          |
 8008 FORMAT(128a1)                                                     |
 8009 FORMAT(128a1)                                                     |
      WRITE(21,8008)(lin1(i:i),i=1,n)                                   |
      WRITE(21,8009)(lin2(i:i),i=1,n)                                   |
 8010 FORMAT(i3)                                                        |
 8011 FORMAT(f8.2)                                                      |
      DO 904 iD0= 1,nD0                                                 |
        D0fvac(iD0)=( D0fr(iD0) +D0fe(iD0) +D0fs(iD0) +D0ft(iD0)        |
     1               +D0fc(iD0) +D0fh(iD0) +D0fpro(iD0))                |
        WRITE(lin1( 1: 3),8010)iD0                                      |
        WRITE(lin1( 4:11),8011)D0ftot(iD0)                              |
        WRITE(lin1(13+2*j:20+2*j),8011)D0fvac(iD0)                      |
        WRITE(lin1(21+2*j:28+2*j),8011)D0fm(iD0)                        |
        WRITE(lin1(29+2*j:36+2*j),8011)D0fpol(iD0)                      |
        WRITE(lin1(37+2*j:44+2*j),8011)D0rmsd(iD0)                      |
        jR1=0                                                           |
        DO 905 iZ2= 1,nZ2                                               |
          iR1min=(Z2CYC(iZ2)+1)                                         |
          iR1max=(Z2CYC(iZ2)-1+R1pt(Z2CYC(iZ2)))                        |
          DO 906 iR1=iR1min,iR1max                                      |
            jR1=jR1+1                                                   |
            lin1(14+2*(jR1-1):13+2*jR1)=D0R1bbcnf(iR1,iD0)              |
 906        CONTINUE                                                    |
 905      CONTINUE                                                      |
        WRITE(21,8008)(lin1(i:i),i=1,n)                                 |
 904    CONTINUE                                                        |
      WRITE(21,8001)                                                    |
 8012 FORMAT(('     Fvac     Fr     Fe     Fs     Ft     Fh '))         |
 8013 FORMAT((' __ ______ ______ ______ ______ ______ ______'))         |
      WRITE(21,8012)                                                    |
      WRITE(21,8013)                                                    |
 8014 FORMAT(i3,6f7.1)                                                  |
      DO 907 iD0= 1,nD0                                                 |
        WRITE(21,8014)iD0,D0fvac(iD0),(D0fr(iD0)+D0fpro(iD0)),          |
     1                D0fe(iD0),D0fs(iD0),D0ft(iD0),D0fh(iD0)           |
 907    CONTINUE                                                        |
      WRITE(21,8001)                                                    |
 8015 FORMAT(('  Ftot=( Fvac +Fsol +Fpol)'))                            |
 8016 FORMAT(('  Fvac=( Fr +Fe +Fs +Ft +Fc +Fh)'))                      |
      WRITE(21,8015)                                                    |
      WRITE(21,8016)                                                    |
      WRITE(21,8001)                                                    |
 8017 FORMAT(('  Fr  repulsion +dispersion component'))                 |
 8018 FORMAT(('  Fe  electrostatic component'))                         |
 8019 FORMAT(('  Fs  disulfide bond component'))                        |
 8020 FORMAT(('  Ft  intrinsic torsional component'))                   |
 8021 FORMAT(('  Fc  harmonic distance constraints'))                   |
 8022 FORMAT(('  Fh  hydrophobic component'))                           |
      WRITE(21,8001)                                                    |
      WRITE(21,8017)                                                    |
      WRITE(21,8018)                                                    |
      WRITE(21,8019)                                                    |
      WRITE(21,8020)                                                    |
      WRITE(21,8021)                                                    |
      WRITE(21,8022)                                                    |
 8023 FORMAT(('  Fvac  vacuum potential energy'))                       |
 8024 FORMAT(('  Fsol  energy of interaction with dielectric medium'))  |
      WRITE(21,8023)                                                    |
      WRITE(21,8024)                                                    |
      WRITE(21,8001)                                                    |
      WRITE(21,8002)                                                    |
      CLOSE(UNIT=21)                                                    |
CC                                                                      |
      STOP                                                              |
CC                                                                      |
CC                                                                      |
CC                                                                      |
      END                                                               |
