#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include <vector>
#include <cmath>

class MEM_tra_stp_surf {
public:
   class tQ5 { /*cluster of dots representing connected surface*/
   public:
      double sa;                //
      int ord;                  //
      int inv;                  //
      tQ5():sa( 0.00){}
   };
private:
   std::vector<int> o_D5I3a;    //start index of elems within threshold
   std::vector<int> o_D5cI3;    //number of elems within threshold
   std::vector<int> o_D5I3b;    //start index of higher neighbor elems
   std::vector<int> o_D5dI3;    //number of lower neighbor elems
public:
   std::vector<int> o_I3D5;     //mapping to index of neighbor elem
   std::vector<int> o_XQ5;      //
   std::vector<int> o_Q5map;    //
   std::vector<tQ5> Q5;         //
   MEM_tra_stp_surf(int oD5):
      o_D5I3a(oD5),
      o_D5cI3(oD5, 0),
      o_D5I3b(oD5),
      o_D5dI3(oD5, 0)
   {
   }
   int& D5I3a(int i){
      return o_D5I3a.at( i);  }
   int& D5cI3(int i){
      return o_D5cI3.at( i);  }
   int& D5I3b(int i){
      return o_D5I3b.at( i);  }
   int& D5dI3(int i){
      return o_D5dI3.at( i);  }
   int& I3D5(int i){
      return o_I3D5.at( i);  }
   int& XQ5(int i){
      return o_XQ5.at( i);  }
   int& Q5map(int i){
      return o_Q5map.at( i);  }
};

void Structure::TRA_STP_SURF(Dielec_Continu& med,
                             const DAT_PHYSICS_CONSTS& physics_consts){
   int oD5=med.nD5;
   MEM_tra_stp_surf vv(oD5);
//
//
// neighbor surface elements
//
   for(int iD5= 0;iD5<oD5;iD5++){
      med.D5[iD5].Q5=-1;
   }
   double z= std::pow((1.50)*med.probe/(1.40),2);
   int mI3=0;
   for(int i0G5=-16;i0G5<=16;i0G5++){
      int iG5min=(i0G5-2);
      if( iG5min<-16 )iG5min=-16;
      int iG5max=(i0G5+2);
      if( iG5max> 16 )iG5max= 16;
      for(int j0G5=-16;j0G5<=16;j0G5++){
         int jG5min=(j0G5-2);
         if( jG5min<-16 )jG5min=-16;
         int jG5max=(j0G5+2);
         if( jG5max> 16 )jG5max= 16;
         for(int k0G5=-16;k0G5<=16;k0G5++){
            int kG5min=(k0G5-2);
            if( kG5min<-16 )kG5min=-16;
            int kG5max=(k0G5+2);
            if( kG5max> 16 )kG5max= 16;
            if( med.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
            int iD5min=med.G5G5G5(i0G5,j0G5,k0G5).i;
            int iD5max=(iD5min-1+med.G5G5G5(i0G5,j0G5,k0G5).n);
            for(int iD5=iD5min;iD5<=iD5max;iD5++){
               int aDOT=med.D5[iD5].DOTa;
               int bDOT=(aDOT-1+med.D5[iD5].cDOT);
               vv.D5I3a(iD5)=mI3;
               int n=vv.D5cI3(iD5);
               for(int i=0;i<n;i++){
                  vv.o_I3D5.push_back(-1);
                  mI3++;
               }
               vv.D5I3b(iD5)=mI3;
               for(int iG5=iG5min;iG5<=iG5max;iG5++){
                  for(int jG5=jG5min;jG5<=jG5max;jG5++){
                     for(int kG5=kG5min;kG5<=kG5max;kG5++){
                        if( med.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                        int jD5min=med.G5G5G5(iG5,jG5,kG5).i;
                        int jD5max=(jD5min-1+med.G5G5G5(iG5,jG5,kG5).n);
                        for(int jD5=jD5min;jD5<=jD5max;jD5++){
                           if( jD5<=iD5 )continue;
                           int pDOT=med.D5[jD5].DOTa;
                           int qDOT=(pDOT-1+med.D5[jD5].cDOT);
                           bool HIT=(false);
                           double rr;
                           for(int iDOT=aDOT;iDOT<=bDOT&&(!HIT);iDOT++){
                              for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                 rr=( med.DOT[jDOT].x -med.DOT[iDOT].x).rr();
                                 if( rr<z )HIT=true;
                              }
                           }
                           if( HIT ){
                              vv.o_I3D5.push_back(jD5);
                              mI3++;
                              vv.D5cI3(iD5)++;
                              vv.D5cI3(jD5)++;
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   }
   for(int iD5= 0;iD5<(oD5-1);iD5++){
      int iI3min=vv.D5I3b(iD5);
      int iI3max=(vv.D5I3a(iD5)-1+vv.D5cI3(iD5));
      for(int iI3=iI3min;iI3<=iI3max;iI3++){
         int jD5=vv.I3D5(iI3);
         vv.I3D5(vv.D5I3a(jD5)+vv.D5dI3(jD5))=iD5;
         vv.D5dI3(jD5)++;
      }
   }
//
//
// connected surfaces
//
   int nQ5=0;                   //number of connected surfaces
   for(int iD5= 0;iD5<oD5;iD5++){
      int nX=0;
      int aI3=vv.D5I3a(iD5);
      int bI3=(aI3-1+vv.D5cI3(iD5));
      for(int iI3=aI3;iI3<=bI3;iI3++){
         int jD5=vv.I3D5(iI3);
         int jQ5=med.D5[jD5].Q5;
         if( jQ5==-1 )continue;
         bool HIT=false;
         for(int iX= 0;iX<nX&&(!HIT);iX++){
            if( vv.XQ5(iX)==jQ5 )HIT=true;
         }
         if( !HIT ){
            nX++;
            vv.o_XQ5.push_back(jQ5);
         }
      }
      if      ( nX==0 ){
         med.D5[iD5].Q5=nQ5++;
      }else if( nX==1 ){
         med.D5[iD5].Q5=vv.XQ5( 0);
      }else{
         int iQ5=99999;
         for(int iX= 0;iX<nX;iX++){
            if( vv.XQ5(iX)<iQ5 )iQ5=vv.XQ5(iX);
         }
         med.D5[iD5].Q5=iQ5;
         vv.o_Q5map.resize(nQ5);
         for(int jQ5= 0;jQ5<nQ5;jQ5++){
            vv.Q5map(jQ5)=jQ5;
         }
         for(int iX= 0;iX<nX;iX++){
            int jQ5=vv.XQ5(iX);
            if( jQ5==iQ5 )continue;
            for(int kQ5=(jQ5+1);kQ5<nQ5;kQ5++){
               if( vv.Q5map(kQ5)>vv.Q5map(jQ5) )vv.Q5map(kQ5)--;
            }
            vv.Q5map(jQ5)=iQ5;
         }
         for(int jD5= 0;jD5<iD5;jD5++){
            med.D5[jD5].Q5=vv.Q5map(med.D5[jD5].Q5);
         }
         vv.o_Q5map.clear();
         nQ5-=(nX-1);
      }
      vv.o_XQ5.clear();
   }
   vv.Q5.resize(nQ5);
   for(int iD5= 0;iD5<oD5;iD5++){
      int iQ5=med.D5[iD5].Q5;
      vv.Q5[iQ5].sa+=med.D5[iD5].a;
   }
   for(int iQ5= 0;iQ5<nQ5;iQ5++){
      vv.Q5[iQ5].ord=iQ5;
   }
   if( nQ5> 1 ){
      for(int iQ5max=(nQ5-1);iQ5max> 0;iQ5max--){
         bool ORDERED=true;
         double z1= vv.Q5[ vv.Q5[ 0].ord].sa;
         for(int iQ5= 1;iQ5<=iQ5max;iQ5++){
            double z2= vv.Q5[ vv.Q5[iQ5].ord].sa;
            if( z2>z1 ){
               int L=vv.Q5[iQ5].ord;
               vv.Q5[iQ5].ord= vv.Q5[iQ5-1].ord;
               vv.Q5[iQ5-1].ord=L;
               ORDERED=false;
            }else{
               z1= z2;
            }
         }
         if( ORDERED )break;
      }
   }
   for(int iQ5= 0;iQ5<nQ5;iQ5++){
      vv.Q5[vv.Q5[iQ5].ord].inv=iQ5;
   }
   for(int iD5= 0;iD5<oD5;iD5++){
      med.D5[iD5].Q5=vv.Q5[med.D5[iD5].Q5].inv;
   }
   med.nQ5=nQ5;

   return;
}
