#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_tra_stp_stp {
public:
   class tZ2 { /*segments deformed in a step of global minimization*/
   public:
      int cR0min;               //min segment length
      int cR0max;               //max
      int cR0;                  //
      int iZ0max;               //start position max chain index
      int iR0max;               //max residue index
      int iZ0;                  //chain index
      int iR0;                  //start residue index
      int pZ0;                  //chain
      int pR0min;               //start residue of deformable bb segment
      int pR0max;               //end residue of deformable bb segment
      tZ2():cR0min( 7),cR0max( 9){}
   };
   class tR1 { /*residues of search subspace containing variable torsions*/
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      /*search through conformation space: 0=fixed
                                           1=variable, not searched
                                           2=variable, searched*/
      int bb;                   //
      int sc;                   //
      int pt;                   //length of variable segment
      tR1():Z0( 0),R0( 0),bb( 0),sc( 0),pt( 0){}
   };
private:
   std::vector<int> o_R0sub;        //for (CA,CB), { 0=(--), 1=(+-), 2=(++)}
   std::vector<Coordinates> o_R0a;  //position of CA atom (angstrom)
   std::vector<Coordinates> o_R0b;  //position of CB atom (angstrom)
   std::vector<Coordinates> o_R0c;  //unit vector along CA--CB
   std::vector<Coordinates> o_R0g;  //position of sc ellipsoid (angstrom)
   std::vector<double> o_R0f;       //smoothed defect energy profile
   std::vector<double> o_R0z;       //wt profile ortho to previous steps
public:
   std::vector<tZ2> Z2;             //segments deformed
   std::vector<tR1> R1;             //residues containing variable torsions
   MEM_tra_stp_stp(int oR0,int oR1):
      o_R0sub(oR0, 0),
      o_R0a(oR0),
      o_R0b(oR0),
      o_R0c(oR0),
      o_R0g(oR0),
      o_R0f(oR0,(0.00)),
      o_R0z(oR0,(0.00)),
      Z2( 8),
      R1(oR1)
   {
   }
   int& R0sub(int i){
      return o_R0sub.at( i);  }
   Coordinates& R0a(int i){
      return o_R0a.at( i);  }
   Coordinates& R0b(int i){
      return o_R0b.at( i);  }
   Coordinates& R0c(int i){
      return o_R0c.at( i);  }
   Coordinates& R0g(int i){
      return o_R0g.at( i);  }
   double& R0f(int i){
      return o_R0f.at( i);  }
   double& R0z(int i){
      return o_R0z.at( i);  }
};

void Structure::TRA_STP_STP(Stp_Automatic& aut,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            Output_Streams& out,
                            Search_Subspace& ful,
                            Search_Subspace& sub){
   int oR0=( Z0[nZ0-1].R0a +Z0[nZ0-1].cR0);
   int oR1=ful.nR1;
   MEM_tra_stp_stp vv(oR0,oR1);
//
//
// populate interaction sites
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( R0[iR0].c1!='a' )continue;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            if      ( atm==" CA " ){
               vv.R0a(iR0)= P1[iP1].x;
               vv.R0sub(iR0)++;
            }else if( atm==" CB " ){
               vv.R0b(iR0)= P1[iP1].x;
               vv.R0sub(iR0)++;
            }
         }
      }
   }
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( R0[iR0].c1!='a' )continue;
         std::string aa=R0[iR0].aa;
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         if( (aa=="GLY ")||(aa=="AIB ")||(aa=="PRO ") )continue;
         if( vv.R0sub(iR0)<2 )continue;
         int iL0=R0[iR0].L0;
         double del= residue_mappings.L0[iL0].del;
         vv.R0c(iR0)=( vv.R0b(iR0) -vv.R0a(iR0));
         vv.R0g(iR0)=( vv.R0b(iR0) +del*vv.R0c(iR0));
         vv.R0c(iR0).normalize();
      }
   }
//
//
// smooth energy profile
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         double f0= aut.R0[iR0].e[ 0];
         double f1= (f0/( 4.00));
         double f2= (f0/(16.00));
         if( (iR0-2)>=mR0 ){
            vv.R0f(iR0-2)+=f2;
            f0-=f2;
         }
         if( (iR0-1)>=mR0 ){
            vv.R0f(iR0-1)+=f1;
            f0-=f1;
         }
         if( (iR0+1)<=nR0 ){
            vv.R0f(iR0+1)+=f1;
            f0-=f1;
         }
         if( (iR0+2)<=nR0 ){
            vv.R0f(iR0+2)+=f2;
            f0-=f2;
         }
         vv.R0f(iR0  )+=f0;
      }
   }
//
//
// weight profile bias orthogonal to previous steps
//
   for(int iR1= 0;iR1<oR1;iR1++){
      int iR0=ful.R1[iR1].R0;
      vv.R0z(iR0)=( 1.00);
      int j=ful.R1[iR1].ortho;
      if      ( j==0 ){
      }else if( j==1 ){
         vv.R0z(iR0)*=(  .25);
      }else if( j==2 ){
         vv.R0z(iR0)*=(  .50);
      }
   }
//
//
// weight profile bias to coil
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( aut.R0[iR0].coil==1 ){
         }else{
            vv.R0z(iR0)*=(  .80);
         }
      }
   }
//
//
// scale energy profile
//
   for(int iR0= 0;iR0<oR0;iR0++){
      vv.R0f(iR0)*=vv.R0z(iR0);
   }
//
//
// exhaustive search over all search subspaces
//
   double Fmax= (0.00);
   int pZ2=-1;
   for(int nZ2=1;nZ2<2;nZ2++){
//
      int jZ2=0;
      vv.Z2[ 0].cR0=(vv.Z2[ 0].cR0min-2);
      for(;;){
         vv.Z2[jZ2].cR0+=2;
         if( vv.Z2[jZ2].cR0>vv.Z2[jZ2].cR0max ){
            if( jZ2==0 ){
               break;
            }else{
               jZ2--;
               continue;
            }
         }else{
            if( jZ2==(nZ2-1) ){
//
               int jZ0=(nZ0-1);
               int mR0=Z0[jZ0].R0a;
               int jR0=(mR0+Z0[jZ0].cR0);
               bool PASS=false;
               for(int iZ2=(nZ2-1);iZ2>=0&&(!PASS);iZ2--){
                  jR0-=vv.Z2[iZ2].cR0;
                  while( jR0<mR0 ){
                     if( --jZ0< 0 ){
                        PASS=true;
                        break;
                     }
                     mR0=Z0[jZ0].R0a;
                     jR0=(mR0+Z0[jZ0].cR0);
                     jR0-=vv.Z2[iZ2].cR0;
                  }
                  vv.Z2[iZ2].iZ0max=jZ0;
                  vv.Z2[iZ2].iR0max=jR0;
               }
               if( PASS )continue;
//
               jZ0= 0;
               mR0=Z0[jZ0].R0a;
               int nR0=(mR0-1+Z0[jZ0].cR0);
               jR0=(mR0-1+vv.Z2[ 0].cR0);
               PASS=false;
               while( jR0>nR0 ){
                  if( ++jZ0>(nZ0-1) ){
                     PASS=true;
                     break;
                  }
                  mR0=Z0[jZ0].R0a;
                  nR0=(mR0-1+Z0[jZ0].cR0);
                  jR0=(mR0-1+vv.Z2[ 0].cR0);
               }
               if( PASS )continue;
               int kZ2=0;
               vv.Z2[ 0].iZ0=jZ0;
               vv.Z2[ 0].iR0=(mR0-1);
//
               for(;;){
                  vv.Z2[kZ2].iR0++;
                  if( vv.Z2[kZ2].iR0>vv.Z2[kZ2].iR0max ){
                     if( kZ2==0 ){
                        break;
                     }else{
                        kZ2--;
                        continue;
                     }
                  }else{
                     jZ0=vv.Z2[kZ2].iZ0;
                     mR0=Z0[jZ0].R0a;
                     nR0=(mR0-1+Z0[jZ0].cR0);
                     jR0=(vv.Z2[kZ2].iR0-1+vv.Z2[kZ2].cR0);
                     while( jR0>nR0 ){
                        jZ0++;
                        vv.Z2[kZ2].iZ0=jZ0;
                        mR0=Z0[jZ0].R0a;
                        nR0=(mR0-1+Z0[jZ0].cR0);
                        jR0=(mR0-1+vv.Z2[kZ2].cR0);
                        vv.Z2[kZ2].iR0=mR0;
                     }
                     if( kZ2==(nZ2-1) ){
//
                        double F= (0.00);
                        double N= (0.00);
                        for(int iZ2= 0;iZ2<nZ2;iZ2++){
                           int jR0min=vv.Z2[iZ2].iR0;
                           int jR0max=(jR0min-1+vv.Z2[iZ2].cR0);
                           for(int jR0=jR0min;jR0<=jR0max;jR0++){
                              F+=vv.R0f(jR0);
                              N++;
                              if( vv.R0z(jR0)<=( 0.00) ){
                                 F-=( 8.00);
                              }
                           }
                        }
                        F/=std::exp( (.80)*std::log( N));
                        if( F>Fmax ){
                           Fmax= F;
                           pZ2=nZ2;
                           for(int iZ2= 0;iZ2<nZ2;iZ2++){
                              vv.Z2[iZ2].pZ0=vv.Z2[iZ2].iZ0;
                              vv.Z2[iZ2].pR0min=vv.Z2[iZ2].iR0;
                              vv.Z2[iZ2].pR0max=(vv.Z2[iZ2].pR0min-1
                                                +vv.Z2[iZ2].cR0);
                           }
                        }
//
                     }else{
                        kZ2++;
                        vv.Z2[kZ2].iZ0=vv.Z2[kZ2-1].iZ0;
                        vv.Z2[kZ2].iR0=(vv.Z2[kZ2-1].iR0-1+vv.Z2[kZ2-1].cR0);
                        continue;
                     }
                  }
               }
//
            }else{
               jZ2++;
               vv.Z2[jZ2].cR0=(vv.Z2[jZ2].cR0min-2);
               continue;
            }
         }
      }
//
   }
//
//
// initiate search subspace with variable segments
//
   int nR1=0;
   for(int iZ2= 0;iZ2<pZ2;iZ2++){
      int jZ0=vv.Z2[iZ2].pZ0;
      int mR0=Z0[jZ0].R0a;
//    int nR0=(mR0-1+Z0[jZ0].cR0);
      int jR0min=vv.Z2[iZ2].pR0min;
      int jR0max=vv.Z2[iZ2].pR0max;
      if( ((jR0min-1)>=mR0)&&
          ((iZ2== 0)||((jR0min-1)>vv.Z2[iZ2-1].pR0max)) ){
         vv.R1[nR1].Z0=jZ0;
         vv.R1[nR1].R0=(jR0min-1);
         nR1++;
      }
      for(int jR0=jR0min;jR0<=jR0max;jR0++){
         vv.R1[nR1].Z0=jZ0;
         vv.R1[nR1].R0=jR0;
         vv.R1[nR1].bb=2;
         vv.R1[nR1].sc=2;
         int jL0=R0[jR0].L0;
         if( residue_mappings.L0[jL0].cU0==0 )vv.R1[nR1].sc=0;
         if( residue_mappings.L0[jL0].cU0==1 )vv.R1[nR1].sc=1;
         if( R0[jR0].c1=='a' ){
            std::string aa=R0[jR0].aa;
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
            if( aa=="PRO " )vv.R1[nR1].sc=1;
         }
         if( jR0==jR0min )vv.R1[nR1].pt=(jR0max-jR0min+1);
         nR1++;
      }
   }
//
//
// add side chains in contact with variable segments
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0sub(iR0)<2 )continue;
         std::string aa=R0[iR0].aa;
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         if( aa=="PRO " )continue;
         int iL0=R0[iR0].L0;
         if( residue_mappings.L0[iL0].cU0<=1 )continue;
         double aai= std::pow(residue_mappings.L0[iL0].ea,2);
         double bbi= std::pow(residue_mappings.L0[iL0].eb,2);

         bool PASS=false;
         for(int iZ2= 0;iZ2<pZ2&&(!PASS);iZ2++){
            int jZ0=vv.Z2[iZ2].pZ0;
            int jR0min=vv.Z2[iZ2].pR0min;
            int jR0max=vv.Z2[iZ2].pR0max;
            if( (jZ0==iZ0)&&
                (jR0min<=iR0)&&(jR0max>=iR0) )PASS=true;
         }

         for(int iZ2= 0;iZ2<pZ2&&(!PASS);iZ2++){
//          int jZ0=vv.Z2[iZ2].pZ0;
            int jR0min=vv.Z2[iZ2].pR0min;
            int jR0max=vv.Z2[iZ2].pR0max;
            for(int jR0=jR0min;jR0<=jR0max&&(!PASS);jR0++){
               if( vv.R0sub(jR0)<2 )continue;
               int jL0=R0[jR0].L0;
               if( residue_mappings.L0[jL0].cU0<=1 )continue;
               double aaj= std::pow(residue_mappings.L0[jL0].ea,2);
               double bbj= std::pow(residue_mappings.L0[jL0].eb,2);
               Coordinates u=( vv.R0g(iR0) -vv.R0g(jR0));
               double r= u.r();
               u/=r;
               double CTi= dot( u,vv.R0c(iR0));
               double CTCTi= CTi*CTi;
               double STSTi=( (1.00) -CTCTi);
               double CTj= dot( u,vv.R0c(jR0));
               double CTCTj= CTj*CTj;
               double STSTj=( (1.00) -CTCTj);
               double ri= std::sqrt( aai*CTCTi +bbi*STSTi);
               double rj= std::sqrt( aaj*CTCTj +bbj*STSTj);
               if( r<(.750)*( ri +rj) ){
                  int jR1=-1;
                  for(int iR1= 0;iR1<nR1;iR1++){
                     if( vv.R1[iR1].R0==iR0 )jR1=iR1;
                  }
                  if( jR1>-1 ){
                     vv.R1[jR1].sc=2;
                  }else if( nR1<oR1 ){
                     vv.R1[nR1].Z0=iZ0;
                     vv.R1[nR1].R0=iR0;
                     vv.R1[nR1].sc=2;
                     nR1++;
                  }
                  PASS=true;
               }
            }
         }

      }
   }
//
//
// sort residues of search subspace
//
   for(int iR1max=(nR1-1);iR1max> 0;iR1max--){
      bool ORDERED=true;
      int i0=vv.R1[ 0].R0;
      for(int iR1= 1;iR1<=iR1max;iR1++){
         int i1=vv.R1[iR1].R0;
         if( i1<i0 ){
            int L=vv.R1[iR1  ].Z0;
            vv.R1[iR1  ].Z0=vv.R1[iR1-1].Z0;
            vv.R1[iR1-1].Z0=L;
            L=vv.R1[iR1  ].R0;
            vv.R1[iR1  ].R0=vv.R1[iR1-1].R0;
            vv.R1[iR1-1].R0=L;
            L=vv.R1[iR1  ].bb;
            vv.R1[iR1  ].bb=vv.R1[iR1-1].bb;
            vv.R1[iR1-1].bb=L;
            L=vv.R1[iR1  ].sc;
            vv.R1[iR1  ].sc=vv.R1[iR1-1].sc;
            vv.R1[iR1-1].sc=L;
            L=vv.R1[iR1  ].pt;
            vv.R1[iR1  ].pt=vv.R1[iR1-1].pt;
            vv.R1[iR1-1].pt=L;
            ORDERED=false;
         }else{
            i0=i1;
         }
      }
      if( ORDERED )break;
   }
//
//
// output stp
//
   out.FILE3<< std::setw( 4)<<nR1<<'\n';
   for(int iR1= 0;iR1<nR1;iR1++){
      int iZ0=vv.R1[iR1].Z0;
      int iR0=vv.R1[iR1].R0;
      out.FILE3<<'['<< std::setw( 2)<<iZ0
               <<':'<< std::setw( 4)<<iR0<<"] "
               << std::setw( 2)<<vv.R1[iR1].bb
               << std::setw( 2)<<vv.R1[iR1].sc
               << std::setw( 2)<<vv.R1[iR1].pt<<"  "
               <<R0[iR0].aa<<'\n';
   }
//
//
// construct stp
//
   sub.nR1=nR1;
   for(int iR1= 0;iR1<nR1;iR1++){
      sub.R1.push_back( Search_Subspace::tR1());
      sub.R1[iR1].Z0=vv.R1[iR1].Z0;
      sub.R1[iR1].R0=vv.R1[iR1].R0;
      int iR0=sub.R1[iR1].R0;
      sub.R1[iR1].L0=R0[iR0].L0;
      sub.R1[iR1].aa=R0[iR0].aa;
      sub.R1[iR1].bb=vv.R1[iR1].bb;
      sub.R1[iR1].sc=vv.R1[iR1].sc;
      sub.R1[iR1].pt=vv.R1[iR1].pt;
      sub.R1[iR1].R3a=iR1;
      sub.R1[iR1].cR3=1;
      sub.R3.push_back( Search_Subspace::tR3());
      sub.R3[iR1].L0=sub.R1[iR1].L0;
      sub.R3[iR1].aa=sub.R1[iR1].aa;
   }

   sub.mBOD=0;
   if( nZ0> 1 ){
      for(int iR1= 0;iR1<nR1;iR1++){
         if( sub.R1[iR1].bb==0 )continue;
         int iZ0=sub.R1[iR1].Z0;
         int iR0=sub.R1[iR1].R0;
         int mR0=Z0[iZ0].R0a;
         if( iR0==mR0 )sub.mBOD=1;
      }
   }

   int mT5=0;
   for(int iR1= 0;iR1<nR1;iR1++){
      int iR0=sub.R1[iR1].R0;
      int iL0=sub.R1[iR1].L0;
      char c1=residue_mappings.L0[iL0].c1;
      std::string aa=sub.R1[iR1].aa;
      if( c1=='a' ){
         if( (aa[0]=='e')||
             (aa[0]=='z') )aa=aa.substr(1,3)+' ';
         if( (aa[3]=='e')||
             (aa[3]=='z') )aa=aa.substr(0,3)+' ';
      }
      sub.R1[iR1].T5a=mT5;
      sub.R1[iR1].cT5=R0[iR0].cT1;
      int mT1=R0[iR0].T1a;
      int nT1=(mT1-1+R0[iR0].cT1);
      for(int iT1=mT1;iT1<=nT1;iT1++){
         sub.T5.push_back( Search_Subspace::tT5());
         sub.T5[iT1-mT1+mT5].tor=T1[iT1].tor;
      }
      mT5+=sub.R1[iR1].cT5;
      int mP1=R0[iR0].P1a;
      int nP1=(mP1-1+R0[iR0].cP1);
      for(int iP1=mP1;iP1<=nP1;iP1++){
         if( P1[iP1].sub==0 )continue;
         std::string atm=P1[iP1].atm;
         if      ( c1=='a' ){
            if( atm==" CA " )sub.R1[iR1].ca=P1[iP1].x;
            if( atm==" CB " )sub.R1[iR1].cb=P1[iP1].x;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
            if      ( aa=="RME " ){
               if( atm==" O2'" )sub.R1[iR1].ca=P1[iP1].x;
               if( atm==" CM'" )sub.R1[iR1].cb=P1[iP1].x;
            }else if( aa=="MOE " ){
               if( atm==" O2'" )sub.R1[iR1].ca=P1[iP1].x;
               if( atm==" CA'" )sub.R1[iR1].cb=P1[iP1].x;
            }
         }else if( c1=='b' ){
            if      ( (aa=="A   ")||(aa=="AP  ")||(aa=="G   ")||
                      (aa=="GP  ")||(aa=="GM  ") ){
               if( atm==" N9 " )sub.R1[iR1].ca=P1[iP1].x;
               if( atm==" N1 " )sub.R1[iR1].cb=P1[iP1].x;
            }else if( (aa=="T   ")||(aa=="TM  ")||(aa=="C   ")||
                      (aa=="CP  ")||(aa=="U   ")||(aa=="UM  ") ){
               if( atm==" N1 " )sub.R1[iR1].ca=P1[iP1].x;
               if( atm==" C4 " )sub.R1[iR1].cb=P1[iP1].x;
            }
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
//
//
// update memory of previous 2 steps
//
   for(int iR1= 0;iR1<oR1;iR1++){
      int j=ful.R1[iR1].ortho;
      if      ( j==0 ){
      }else if( j==1 ){
         ful.R1[iR1].ortho=2;
      }else if( j==2 ){
         ful.R1[iR1].ortho=0;
      }
   }
   for(int iR1= 0;iR1<nR1;iR1++){
      int jR0=sub.R1[iR1].R0;
      int jR1=ful.iresidue(jR0);
      ful.R1[jR1].ortho=1;
   }
   return;
}
