#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <cmath>

class MEM_tra_stp_hbnd {
private:
   std::vector<int> o_P1nH3;            //number of H-bonds
   std::vector<int> o_P1H3i;            //index of H-bonded atom
public:
   MEM_tra_stp_hbnd(int o):
      o_P1nH3(o, 0),
      o_P1H3i(o*8)
   {
   }
   int& P1nH3(int i){
      return o_P1nH3.at( i);  }
   int& P1H3i(int i,int j){
      return o_P1H3i.at( i*8 +j);  }
};

void Structure::TRA_STP_HBND(Stp_Automatic& aut,
                             const DAT_PHYSICS_CONSTS& physics_consts){
   int oP1=P1.size();
   MEM_tra_stp_hbnd vv(oP1);
//
//
// count H-bond donors and acceptors
//
   int nDON=0;
   int nACC=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if      ( (iT2== 2)||(iT2== 5) ){
               nDON++;
            }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
               nACC++;
            }
         }
      }
   }
//
//
// map H-bond connectivity
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2!= 2)&&(iT2!= 5) )continue;
            Coordinates u;
            int kP1=-1;
            for(int lP1=mP1;lP1<=nP1;lP1++){
               if( P1[lP1].sub==0 )continue;
               if( lP1==iP1 )continue;
               u=( P1[iP1].x -P1[lP1].x);
               double r= u.r();
               if( r<(1.11) ){
                  u/=r;
                  kP1=lP1;
                  break;
               }
            }
            if( kP1==-1 ){
               std::cerr<<"ERROR: Missing H-bond vector.\n";
               std::exit( 2);
            }
//
            for(int jZ0= 0;jZ0<nZ0;jZ0++){
               int aR0=Z0[jZ0].R0a;
               int bR0=(aR0-1+Z0[jZ0].cR0);
               for(int jR0=aR0;jR0<=bR0;jR0++){
                  int aP1=R0[jR0].P1a;
                  int bP1=(aP1-1+R0[jR0].cP1);
                  for(int jP1=aP1;jP1<=bP1;jP1++){
                     if( P1[jP1].sub==0 )continue;
                     int jT2=P1[jP1].typ;
                     if( (jT2!=12)&&(jT2!=13)&&(jT2!=14)&&
                         (jT2!=17) )continue;
                     Coordinates v=( P1[jP1].x -P1[iP1].x);
                     double r= v.r();
                     if( r>(2.80) )continue;
                     v/=r;
                     double Cthet= dot(u,v);
                     double thet= std::acos( Cthet)/physics_consts.RAD;
                     if( thet>(50.00) )continue;
                     vv.P1H3i(iP1,vv.P1nH3(iP1))=jP1;
                     vv.P1nH3(iP1)++;
//                   if( jT2!=15 ){
                        vv.P1H3i(jP1,vv.P1nH3(jP1))=iP1;
                        vv.P1nH3(jP1)++;
//                   }
                  }
               }
            }
//
         }
      }
   }
//
//
// partition H-bond donors and acceptors into buried+hydrated+paired
//
   int bDON=0;
   int bACC=0;
   int hDON=0;
   int hACC=0;
   int iA5=-1;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      bool POLYPEPTIDE=(aut.Z0[iZ0].c1=='a');
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            iA5++;
            if      ( (iT2== 2)&&(atm==" H  ") ){
               if( aut.A5[iA5].exsa>(.25) ){
                  vv.P1H3i(iP1,vv.P1nH3(iP1))=-1;
                  vv.P1nH3(iP1)++;
                  if( vv.P1nH3(iP1)==1 ){
                     hDON++;
                     aut.R0[iR0].e[ 7]+=(.50);
                  }
               }
               if( vv.P1nH3(iP1)==0 ){
                  bDON++;
                  aut.R0[iR0].e[ 7]+=(2.00);
                  if( aut.R0[iR0].coil==0 ){
                     char c=aut.R0[iR0].bbcnf[0];
                     if( (c=='E')||(c=='F')||(c=='D') ){
                        aut.R0[iR0].coil=1;
                     }
                  }
               }
            }else if( (iT2== 2)||(iT2== 5) ){
               if( aut.A5[iA5].exsa>(.25) ){
                  vv.P1H3i(iP1,vv.P1nH3(iP1))=-1;
                  vv.P1nH3(iP1)++;
                  if( vv.P1nH3(iP1)==1 ){
                     hDON++;
                     aut.R0[iR0].e[ 7]+=(.00);
                  }
               }
               if( vv.P1nH3(iP1)==0 ){
                  bDON++;
                  aut.R0[iR0].e[ 7]+=(.80);
//
                  for(int jZ0= 0;jZ0<nZ0;jZ0++){
                     int aR0=Z0[jZ0].R0a;
                     int bR0=(aR0-1+Z0[jZ0].cR0);
                     for(int jR0=aR0;jR0<=bR0;jR0++){
                        if( jR0==iR0 )continue;
                        int aP1=R0[jR0].P1a;
                        int bP1=(aP1-1+R0[jR0].cP1);
                        if( (jZ0==iZ0)&&
                           ((jR0==(iR0-1))||(jR0==(iR0+1)))&&
                           POLYPEPTIDE ){
                           aP1+=7;
                           char c1=R0[iR0].c1;
                           std::string aa=R0[jR0].aa;
                           if( c1=='a' ){
                              if( (aa[0]=='e')||
                                  (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                              if( (aa[3]=='e')||
                                  (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                           }
                           if( (aa=="PRO ")||(aa=="HPR ") )aP1--;
                        }
                        for(int jP1=aP1;jP1<=bP1;jP1++){
                           if( P1[jP1].sub==0 )continue;
                           double r=( P1[jP1].x -P1[iP1].x).r();
                           if( r<(4.00) ){
                              aut.R0[iR0].e[ 7]-=(.20);
                              aut.R0[jR0].e[ 7]+=(.20);
                              break;
                           }
                        }
                     }
                  }
//
               }
            }else if( (iT2==13)&&(atm==" O  ") ){
               if( aut.A5[iA5].exsa>(1.00) ){
                  vv.P1H3i(iP1,vv.P1nH3(iP1))=-1;
                  vv.P1nH3(iP1)++;
                  if( vv.P1nH3(iP1)==1 ){
                     hACC++;
                     aut.R0[iR0].e[ 8]+=(.50);
                  }
               }
               if( vv.P1nH3(iP1)==0 ){
                  bACC++;
                  aut.R0[iR0].e[ 8]+=(2.00);
                  if( aut.R0[iR0].coil==0 ){
                     char c=aut.R0[iR0].bbcnf[0];
                     if( (c=='E')||(c=='F')||(c=='D') ){
                        aut.R0[iR0].coil=1;
                     }
                  }
               }
            }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
               if( aut.A5[iA5].exsa>(1.00) ){
                  vv.P1H3i(iP1,vv.P1nH3(iP1))=-1;
                  vv.P1nH3(iP1)++;
                  if( vv.P1nH3(iP1)==1 ){
                     hACC++;
                     aut.R0[iR0].e[ 8]+=(.00);
                  }
               }
               if( vv.P1nH3(iP1)==0 ){
                  bACC++;
                  aut.R0[iR0].e[ 8]+=(1.00);
//
                  for(int jZ0= 0;jZ0<nZ0;jZ0++){
                     int aR0=Z0[jZ0].R0a;
                     int bR0=(aR0-1+Z0[jZ0].cR0);
                     for(int jR0=aR0;jR0<=bR0;jR0++){
                        if( jR0==iR0 )continue;
                        int aP1=R0[jR0].P1a;
                        int bP1=(aP1-1+R0[jR0].cP1);
                        if( (jZ0==iZ0)&&
                           ((jR0==(iR0-1))||(jR0==(iR0+1)))&&
                           POLYPEPTIDE ){
                           aP1+=7;
                           char c1=R0[iR0].c1;
                           std::string aa=R0[jR0].aa;
                           if( c1=='a' ){
                              if( (aa[0]=='e')||
                                  (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                              if( (aa[3]=='e')||
                                  (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                           }
                           if( (aa=="PRO ")||(aa=="HPR ") )aP1--;
                        }
                        for(int jP1=aP1;jP1<=bP1;jP1++){
                           if( P1[jP1].sub==0 )continue;
                           double r=( P1[jP1].x -P1[iP1].x).r();
                           if( r<(4.00) ){
                              aut.R0[iR0].e[ 8]-=(.25);
                              aut.R0[jR0].e[ 8]+=(.25);
                              break;
                           }
                        }
                     }
                  }
//
               }
            }else{
            }
         }
      }
   }
   return;
}
