#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <cmath>

void Structure::TRA_STP_EHP(Stp_Automatic& aut,
                            Dielec_Continu& med,
                            const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings){
//
//
// exposed surface area resolved wrt atoms
//
   for(int iA5= 0;iA5<med.nA5;iA5++){
      aut.A5[iA5].exsa= (0.00);
   }
   double ANGANG= std::pow(physics_consts.ANG,2);
   for(int iF5= 0;iF5<med.nF5;iF5++){
      int iC5=iF5;
      if( !med.C5[iC5].sub )continue;
      double z= (ANGANG*med.F5[iF5].sa/(3.00));
      for(int iN3=0;iN3<3;iN3++){
         int iA5=med.C5[iC5].N3A5[iN3];
         aut.A5[iA5].exsa+=z;
      }
   }
   for(int iF6= 0;iF6<med.nF6;iF6++){
      double z= (ANGANG*med.F6[iF6].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.H5[med.E6[med.F6[iF6].N2E6[iN2]].H5].A5;
         aut.A5[iA5].exsa+=z;
      }
   }
   for(int iF7= 0;iF7<med.nF7;iF7++){
      double z= (ANGANG*med.F7[iF7].sa);
      int iA5=med.F7[iF7].A5;
      aut.A5[iA5].exsa+=z;
   }
   for(int iA5= 0;iA5<med.nA5;iA5++){
      if( !med.A5[iA5].free )continue;
      double z= (ANGANG*med.A5[iA5].sa);
      aut.A5[iA5].exsa+=z;
   }
   for(int ijB5= 0;ijB5<med.nB5;ijB5++){
      if( !med.B5[ijB5].free )continue;
      double z= (ANGANG*med.B5[ijB5].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.B5[ijB5].N2A5[iN2];
         aut.A5[iA5].exsa+=z;
      }
   }
//
//
// partition of residues into {0=buried, 1=exposed}
//
   for(int iA5= 0;iA5<med.nA5;iA5++){
      if( aut.A5[iA5].exsa>(1.00) ){
         int iR0=aut.A5[iA5].R0;
         aut.R0[iR0].expo=1;
      }
   }
//
//
// partition of residues into {internal=sc buried, external=sc exposed}
//
   aut.nR0tot=0;
   aut.nR0in=0;
   aut.nR0ex=0;
   int nR0hp=0;
   int nR0inhp=0;
   int nR0exhp=0;
   int pA5=-1;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      aut.nR0tot+=(nR0-mR0+1);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int iL0=R0[iR0].L0;
         double asc= residue_mappings.L0[iL0].scsa;
         double a= (0.00);
//       double ahp= (0.00);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            pA5++;
            if      ( c1=='a' ){
               if( aa=="GLY " ){
                  if( atm==" CA " ){
                     a+=aut.A5[pA5].exsa;
                  }
               }else{
                  if( (atm!=" N  ")&&(atm!=" H  ")&&
                      (atm!=" C  ")&&(atm!=" O  ")&&
                      (atm!=" CA ") ){
                     a+=aut.A5[pA5].exsa;
                  }
               }
            }else if( c1=='e' ){
               if( atm==" CH3" ){
                  a+=aut.A5[pA5].exsa;
               }
            }else if( c1=='r' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='b' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='p' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='s' ){
               a+=aut.A5[pA5].exsa;
            }
//          if( (iT2== 8)||(iT2==10) ){
//             ahp+=aut.A5[pA5].exsa;
//          }
         }
         if( a>((.50)*asc) ){
            aut.nR0ex++;
         }else{
            aut.nR0in++;
         }
         if( (aa=="ALA ")||(aa=="PHE ")||(aa=="ILE ")||(aa=="LEU ")||
             (aa=="MET ")||(aa=="PRO ")||(aa=="VAL ")||(aa=="TRP ")||
             (aa=="TYR ")||(aa=="AIB ")||(aa=="ABU ")||(aa=="NLE ")||
             (aa=="CYS ")||(aa=="D   ")||(aa=="RF  ")||(aa=="CET ")||
             (aa=="A   ")||(aa=="G   ")||(aa=="T   ")||(aa=="C   ")||
             (aa=="U   ") ){
            nR0hp++;
            if( a>((.50)*asc) ){
               nR0exhp++;
            }else{
               nR0inhp++;
            }
         }
      }
   }
//
//
// total exposed hydrophobic surface area
//
   double ahp= (0.00);
   for(int iA5= 0;iA5<med.nA5;iA5++){
      int iT2=med.A5[iA5].typ;
      if( (iT2!= 8)&&(iT2!=10) )continue;
      ahp+=aut.A5[iA5].exsa;
   }
//
//
// entropy correction factor
//
   double C= (.025);            //coef relating hydrophobic energy to ahp
   double S= (0.00);            //-TS
   double F;                    //G=( C*ahp +S)=F*(C*ahp)
   bool BALANCE=( nR0hp<=aut.nR0in );
   {
      int n=( BALANCE )? nR0hp: (nR0hp-aut.nR0in);
      double z1=( BALANCE )? aut.nR0in: aut.nR0ex;
      double z2= (1.00);
      for(int i=0;i<n;i++){
         S+=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      z1= aut.nR0in;
      z2= (1.00);
      for(int i=0;i<nR0inhp;i++){
         S-=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      z1= aut.nR0ex;
      z2= (1.00);
      for(int i=0;i<nR0exhp;i++){
         S-=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      F=( (1.00) +S/(C*ahp));
   }
//
//
// hydrophobic residues with exposed hydrophobic surface area above threshold
//
   pA5=-1;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         double a= (0.00);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            pA5++;
            if( (iT2== 8)||(iT2==10) ){
               a+=aut.A5[pA5].exsa;
            }
         }
         if( (aa=="ALA ")||(aa=="PHE ")||(aa=="ILE ")||(aa=="LEU ")||
             (aa=="MET ")||(aa=="PRO ")||(aa=="VAL ")||(aa=="TRP ")||
             (aa=="TYR ")||(aa=="AIB ")||(aa=="ABU ")||(aa=="NLE ")||
             (aa=="CYS ")||(aa=="D   ")||(aa=="RF  ")||(aa=="CET ")||
             (aa=="A   ")||(aa=="G   ")||(aa=="T   ")||(aa=="C   ")||
             (aa=="U   ") ){
            if( (F*a)>(40.00) ){
               aut.R0[iR0].e[ 9]+=(C*F*a);
            }
         }
      }
   }
   return;
}
