#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <cstdlib>
#include <cmath>

void Structure::TRA_STP_CNF(Stp_Automatic& aut,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const DAT_REGION_MAPS& region_maps){
//
//
// torsion angle disallowed regions
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char ci=R0[iR0].c1;
         std::string aai=R0[iR0].aa;
         if( ci=='a' ){
            if( (aai[0]=='e')||
                (aai[0]=='z') )aai=aai.substr(1,3)+' ';
            if( (aai[3]=='e')||
                (aai[3]=='z') )aai=aai.substr(0,3)+' ';
         }
         int mT1=R0[iR0].T1a;
//       int nT1=(mT1-1+R0[iR0].cT1);
         int iL0=R0[iR0].L0;
         int nQ6=residue_mappings.L0[iL0].nQ6;
         int mC2=residue_mappings.L0[iL0].C2a;
         int nC2=(mC2-1+residue_mappings.L0[iL0].cC2);
         if( nQ6> 0 ){
            aut.R0[iR0].sccnf='-';
            int iT1=(mT1+3);
            double ch1= T1[iT1].chi;
            if( ch1>(999.0) )continue;
            double d1= (30.00);
            double ch2=( 0.00),d2=( 0.00);
            if( nQ6> 1 ){
               int jT1=(mT1+4);
               ch2= T1[jT1].chi;
               if( ch2>(999.0) )continue;
               d2=( (aai=="ASP ")||(aai=="PHE ")||(aai=="HIS ")||
                    (aai=="ASN ")||(aai=="TRP ")||(aai=="TYR ")||
                    (aai=="TYP ") )?
                  ( 45.00):( 30.00);
            }
            bool ROTAMER=false;
            for(int iC2=mC2;iC2<=nC2&&(!ROTAMER);iC2++){
               double d=( ch1 -residue_mappings.C2Q6chi(iC2, 0));
               if( d>( 180.0) )d-=( 360.0);
               if( d<(-180.0) )d+=( 360.0);
               if( std::abs( d)>d1 )continue;
               if( nQ6> 1 ){
                  d=( ch2 -residue_mappings.C2Q6chi(iC2, 1));
                  if( d>( 180.0) )d-=( 360.0);
                  if( d<(-180.0) )d+=( 360.0);
                  if( std::abs( d)>d2 )continue;
               }
               aut.R0[iR0].sccnf='+';
               ROTAMER=true;
            }
            if( ROTAMER )continue;
            aut.R0[iR0].e[ 4]+=(1.00);
            int mP1=R0[iR0].P1a;
            int nP1=(mP1-1+R0[iR0].cP1);
            mP1+=7;
            if( (aai=="PRO ")||(aai=="HPR ") )mP1-=1;
            for(int jZ0= 0;jZ0<nZ0;jZ0++){
               int aR0=Z0[jZ0].R0a;
               int bR0=(aR0-1+Z0[jZ0].cR0);
               for(int jR0=aR0;jR0<=bR0;jR0++){
                  if( jR0==iR0 )continue;
                  char cj=R0[jR0].c1;
                  std::string aaj=R0[jR0].aa;
                  if( cj=='a' ){
                     if( (aaj[0]=='e')||
                         (aaj[0]=='z') )aaj=aaj.substr(1,3)+' ';
                     if( (aaj[3]=='e')||
                         (aaj[3]=='z') )aaj=aaj.substr(0,3)+' ';
                  }
                  int aP1=R0[jR0].P1a;
                  int bP1=(aP1-1+R0[jR0].cP1);
                  if( (jZ0==iZ0)&&
                      ((jR0==(iR0-1))||(jR0==(iR0+1))) ){
                     aP1+=7;
                     if( (aaj=="PRO ")||(aaj=="HPR ") )aP1-=1;
                  }
                  bool CONTACT=false;
                  for(int iP1=mP1;iP1<=nP1&&(!CONTACT);iP1++){
                     if( P1[iP1].sub==0 )continue;
                     for(int jP1=aP1;jP1<=bP1&&(!CONTACT);jP1++){
                        if( P1[jP1].sub==0 )continue;
                        double r=( P1[jP1].x -P1[iP1].x).r();
                        if( r<(4.00) ){
                           aut.R0[iR0].e[ 4]-=(.125);
                           aut.R0[jR0].e[ 4]+=(.125);
                           CONTACT=true;
                        }
                     }
                  }
               }
            }
         }
      }
      for(int iR0=(mR0+1);iR0<nR0;iR0++){
//       char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         double phi= (999.0);
         double psi= (999.0);
         int iT1phi=-1;
         int iT1psi=-1;
         aut.R0[iR0].bbcnf="  ";
         int mT1=R0[iR0].T1a;
         int nT1=(mT1-1+R0[iR0].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if( T1[iT1].tor=="PHI" ){
               phi= T1[iT1].chi;
               iT1phi=iT1;
            }
            if( T1[iT1].tor=="PSI" ){
               psi= T1[iT1].chi;
               iT1psi=iT1;
            }
         }
         double omg= (999.0);
         int iT1omg=-1;
         mT1=R0[iR0-1].T1a;
         nT1=(mT1-1+R0[iR0-1].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if( T1[iT1].tor=="OMG" ){
               omg= T1[iT1].chi;
               iT1omg=iT1;
            }
         }
         if( iT1phi==-1 )continue;
         if( iT1psi==-1 )continue;
         if( iT1omg==-1 )continue;
         int iH4=1 +int( phi +(180.00))/10;
         int jH4=1 +int( psi +(180.00))/10;
         int kH4=1 +int( omg +(180.00))/10;
         bool NONGLY=(aa!="GLY ");
         bool NONPRO=(aa!="PRO ")&&(aa!="HPR ");
         int pI1=( NONGLY )? region_maps.H4H4dis(iH4,jH4): 0;
         int oI1=( NONPRO )? region_maps.K3H4dis(0,kH4):
                             region_maps.K3H4dis(1,kH4);
         int phiSCO= region_maps.I1sco(pI1);
         int omgSCO= region_maps.I1sco(oI1);
         if( phiSCO>=1 ){
            aut.R0[iR0].e[ 2]+=(3.00);
         }
         if( omgSCO>=1 ){
            aut.R0[iR0].e[ 3]+=(2.00);
         }
         if( omgSCO>=2 ){
            aut.R0[iR0].e[ 3]+=(2.00);
         }
         if( phi>(0.00) ){
            phi=-phi;
            psi=-psi;
            aut.R0[iR0].bbcnf[1]='*';
         }
         iH4=1 +int( phi +(180.00))/10;
         jH4=1 +int( psi +(180.00))/10;
         int iI0=( aa=="GLY " )? region_maps.H4H4gly(iH4,jH4):
                                 region_maps.H4H4ala(iH4,jH4);
         aut.R0[iR0].bbcnf[0]=region_maps.I0bet(iI0);
         aut.R0[iR0].bbsta=aut.R0[iR0].bbcnf;
         if      ( (aut.R0[iR0].bbsta[0]=='F')||
                   (aut.R0[iR0].bbsta[0]=='D') ){
            aut.R0[iR0].bbsta[0]='E';
         }else if( aut.R0[iR0].bbsta[0]=='B' ){
            aut.R0[iR0].bbsta[0]='A';
         }
         if( (aa=="GLY ")&&(aut.R0[iR0].bbsta=="E*") ){
            aut.R0[iR0].bbsta[1]=' ';
         }
      }
      for(int iR0=nR0;iR0<=nR0;iR0++){
//       char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         double omg= (999.0);
         int iT1omg=-1;
         int mT1=R0[iR0-1].T1a;
         int nT1=(mT1-1+R0[iR0-1].cT1);
         for(int iT1=mT1;iT1<=nT1;iT1++){
            if( T1[iT1].tor=="OMG" ){
               omg= T1[iT1].chi;
               iT1omg=iT1;
            }
         }
         if( iT1omg==-1 )continue;
         int kH4=1 +int( omg +(180.00))/10;
         bool NONPRO=(aa!="PROe")&&(aa!="HPRe");
         int oI1=( NONPRO )? region_maps.K3H4dis(0,kH4):
                             region_maps.K3H4dis(1,kH4);
         int omgSCO= region_maps.I1sco(oI1);
         if( omgSCO>=1 ){
            aut.R0[iR0].e[ 3]+=(2.00);
         }
         if( omgSCO>=2 ){
            aut.R0[iR0].e[ 3]+=(2.00);
         }
      }
   }
//
//
// assign inclusion in secondary structure elements
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int iR0min=(mR0+1);
      int iR0max=(nR0-6);
      for(int iR0=iR0min;iR0<=iR0max;iR0++){
         if( (aut.R0[iR0  ].bbsta=="A ")&&
             (aut.R0[iR0+1].bbsta=="A ")&&
             (aut.R0[iR0+2].bbsta=="A ")&&
             (aut.R0[iR0+3].bbsta=="A ")&&
             (aut.R0[iR0+4].bbsta=="A ")&&
             (aut.R0[iR0+5].bbsta=="A ") ){
            aut.R0[iR0  ].coil=0;
            aut.R0[iR0+1].coil=0;
            aut.R0[iR0+2].coil=0;
            aut.R0[iR0+3].coil=0;
            aut.R0[iR0+4].coil=0;
            aut.R0[iR0+5].coil=0;
         }
      }
      iR0max=(nR0-4);
      for(int iR0=iR0min;iR0<=iR0max;iR0++){
         if( (aut.R0[iR0  ].bbsta=="E ")&&
             (aut.R0[iR0+1].bbsta=="E ")&&
             (aut.R0[iR0+2].bbsta=="E ")&&
             (aut.R0[iR0+3].bbsta=="E ") ){
            aut.R0[iR0  ].coil=0;
            aut.R0[iR0+1].coil=0;
            aut.R0[iR0+2].coil=0;
            aut.R0[iR0+3].coil=0;
         }
      }
   }
   return;
}
