#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Stp_Automatic.hh"
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_tra_stp_cav {
public:
   class tQ5 { /*clusters of dots representing connected surfaces*/
   public:
      double sa;                //surf area
      tQ5():sa( 0.00){}
   };
private:
   std::vector<bool> o_DOTsub;  //buried dots of small radius surf
public:
   std::vector<tQ5> Q5;         //connected components of small radius surf
   MEM_tra_stp_cav(int oDOT,int oQ5):
      o_DOTsub(oDOT, true),
      Q5(oQ5)
   {
   }
   void DOTsub(int i,bool a){
      o_DOTsub[ i]=a;  }
   bool DOTsub(int i){
      return o_DOTsub[ i];  }
};

void Structure::TRA_STP_CAV(Stp_Automatic& aut,
                            Dielec_Continu& mlg,
                            Dielec_Continu& med,
                            const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            Output_Streams& out){
//
//
// large probe radius dots
//
   mlg.probe= ((2.80)/physics_consts.ANG);
   mlg.MED_SPHERE(physics_consts,out);
   mlg.MED_TORUS(physics_consts,out);
   TRA_STP_MOL(aut,mlg,physics_consts,energy_params);
   out.VERBOSE=false;
   mlg.bse_nA5=0;
   mlg.bse_nB5=0;
   mlg.bse_nC5=0;
   mlg.bse_nF5=0;
   mlg.bse_nE5=0;
   mlg.bse_nV5=0;
   mlg.bse_nH5=0;
   mlg.ENDSTATE=0;
   mlg.MED_SURF(physics_consts,out);
   if( mlg.ENDSTATE>0 ){
      out.FILE3<<"ENDSTATE="<< std::setw( 2)<<mlg.ENDSTATE<< std::endl;
      std::exit( 2);
      return;
   }
   mlg.bse_nD5=0;
   mlg.MED_DOT(physics_consts,array_consts,out);
   out.VERBOSE=true;
   TRA_STP_SURF(mlg,physics_consts);
//
//
// small probe radius dots
//
   med.probe= ((1.40)/physics_consts.ANG);
   med.MED_SPHERE(physics_consts,out);
   med.MED_TORUS(physics_consts,out);
   TRA_STP_MOL(aut,med,physics_consts,energy_params);
   out.VERBOSE=false;
   med.bse_nA5=0;
   med.bse_nB5=0;
   med.bse_nC5=0;
   med.bse_nF5=0;
   med.bse_nE5=0;
   med.bse_nV5=0;
   med.bse_nH5=0;
   med.ENDSTATE=0;
   med.MED_SURF(physics_consts,out);
   if( med.ENDSTATE>0 ){
      out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
      std::exit( 2);
      return;
   }
   med.bse_nD5=0;
   med.MED_DOT(physics_consts,array_consts,out);
   out.VERBOSE=true;
   TRA_STP_SURF(med,physics_consts);
   TRA_STP_EHP(aut,med,physics_consts,residue_mappings);
//
//
// subset of cavity and cleft dots
//
   MEM_tra_stp_cav vv(med.nDOT,med.nQ5);
   double rrcut= std::pow((3.20)/physics_consts.ANG,2);
   for(int i0G5=-16;i0G5<=16;i0G5++){
      int iG5min=(i0G5-3);
      if( iG5min<-16 )iG5min=-16;
      int iG5max=(i0G5+3);
      if( iG5max> 16 )iG5max= 16;
      for(int j0G5=-16;j0G5<=16;j0G5++){
         int jG5min=(j0G5-3);
         if( jG5min<-16 )jG5min=-16;
         int jG5max=(j0G5+3);
         if( jG5max> 16 )jG5max= 16;
         for(int k0G5=-16;k0G5<=16;k0G5++){
            int kG5min=(k0G5-3);
            if( kG5min<-16 )kG5min=-16;
            int kG5max=(k0G5+3);
            if( kG5max> 16 )kG5max= 16;
            if( med.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
            int iD5min=med.G5G5G5(i0G5,j0G5,k0G5).i;
            int iD5max=(iD5min-1+med.G5G5G5(i0G5,j0G5,k0G5).n);
            for(int iD5=iD5min;iD5<=iD5max;iD5++){
               int aDOT=med.D5[iD5].DOTa;
               int bDOT=(aDOT-1+med.D5[iD5].cDOT);
               for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                  bool HIT=(false);
                  for(int iG5=iG5min;iG5<=iG5max&&(!HIT);iG5++){
                     for(int jG5=jG5min;jG5<=jG5max&&(!HIT);jG5++){
                        for(int kG5=kG5min;kG5<=kG5max&&(!HIT);kG5++){
                           if( mlg.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                           int jD5min=mlg.G5G5G5(iG5,jG5,kG5).i;
                           int jD5max=(jD5min-1+mlg.G5G5G5(iG5,jG5,kG5).n);
                           for(int jD5=jD5min;jD5<=jD5max&&(!HIT);jD5++){
//                            if( mlg.D5[jD5].Q5> 0 )continue;
                              int pDOT=mlg.D5[jD5].DOTa;
                              int qDOT=(pDOT-1+mlg.D5[jD5].cDOT);
                              for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                 double rr=( mlg.DOT[jDOT].x
                                            -med.DOT[iDOT].x).rr();
                                 if( rr<rrcut ){
                                    vv.DOTsub(iDOT,false);
                                    HIT=true;
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   }
//
//
// accumulate cleft and cavity defect energy
//
   int oQ5=med.nQ5;
   double ANGANG= std::pow(physics_consts.ANG,2);
   for(int iD5= 0;iD5<med.nD5;iD5++){
      int iQ5=med.D5[iD5].Q5;
      double f=( iQ5== 0 )? (.016): (.032);
      f*=ANGANG;
      int aDOT=med.D5[iD5].DOTa;
      int bDOT=(aDOT-1+med.D5[iD5].cDOT);
      for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
         if( !vv.DOTsub(iDOT) )continue;
         vv.Q5[iQ5].sa+=(ANGANG*med.DOT[iDOT].a);
         double e= (f*med.DOT[iDOT].a);
         if      ( med.DOT[iDOT].typ==-1 ){
            int iC5=med.DOT[iDOT].elm;
            for(int iN3=0;iN3<3;iN3++){
               int iA5=med.C5[iC5].N3A5[iN3];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(3.));
            }
         }else if( med.DOT[iDOT].typ== 0 ){
            int elm=med.DOT[iDOT].elm;
            int iB5;
            if( elm< 0 ){
               iB5=(-1-elm);
            }else{
               int jE6=med.F6[elm].N2E6[0];
               int iE6=med.F6[elm].N2E6[1];
               int jH5=med.E6[jE6].H5;
               int iH5=med.E6[iE6].H5;
               iB5=med.H5[iH5].B5;
            }
            for(int iN2=0;iN2<2;iN2++){
               int iA5=med.B5[iB5].N2A5[iN2];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(2.));
            }
         }else if( med.DOT[iDOT].typ== 1 ){
            int elm=med.DOT[iDOT].elm;
            int iA5;
            if( elm< 0 ){
               iA5=(-1-elm);
            }else{
               iA5=med.F7[elm].A5;
            }
            int iR0=aut.A5[iA5].R0;
            aut.R0[iR0].e[ 6]+=e;
         }
      }
   }
//
//
// accumulate cavity defect energy
//
   for(int iD5= 0;iD5<med.nD5;iD5++){
      int iQ5=med.D5[iD5].Q5;
      if( iQ5== 0 )continue;
      if( vv.Q5[iQ5].sa<=(0.00) )continue;
      int aDOT=med.D5[iD5].DOTa;
      int bDOT=(aDOT-1+med.D5[iD5].cDOT);
      for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
         if( !vv.DOTsub(iDOT) )continue;
         double e= (2.00)*(ANGANG*med.DOT[iDOT].a/vv.Q5[iQ5].sa);
         if      ( med.DOT[iDOT].typ==-1 ){
            int iC5=med.DOT[iDOT].elm;
            for(int iN3=0;iN3<3;iN3++){
               int iA5=med.C5[iC5].N3A5[iN3];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(3.));
            }
         }else if( med.DOT[iDOT].typ== 0 ){
            int elm=med.DOT[iDOT].elm;
            int iB5;
            if( elm< 0 ){
               iB5=(-1-elm);
            }else{
               int jE6=med.F6[elm].N2E6[0];
               int iE6=med.F6[elm].N2E6[1];
               int jH5=med.E6[jE6].H5;
               int iH5=med.E6[iE6].H5;
               iB5=med.H5[iH5].B5;
            }
            for(int iN2=0;iN2<2;iN2++){
               int iA5=med.B5[iB5].N2A5[iN2];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(2.));
            }
         }else if( med.DOT[iDOT].typ== 1 ){
            int elm=med.DOT[iDOT].elm;
            int iA5;
            if( elm< 0 ){
               iA5=(-1-elm);
            }else{
               iA5=med.F7[elm].A5;
            }
            int iR0=aut.A5[iA5].R0;
            aut.R0[iR0].e[ 6]+=e;
         }
      }
   }
   return;
}
