#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Stp_Automatic.hh"
#include <string>
#include <iomanip>

void Structure::TRA_STP(const DAT_PHYSICS_CONSTS& physics_consts,
                        const DAT_ARRAY_CONSTS& array_consts,
                        const DAT_ENERGY_PARAMS& energy_params,
                        const DAT_RESIDUE_MAPPINGS& residue_mappings,
                        const DAT_REGION_MAPS& region_maps,
                        Search_Subspace& ful,
                        Search_Subspace& sub,
                        Output_Streams& out){

   int oZ0=nZ0;
   int oR0=(Z0[oZ0-1].R0a+Z0[oZ0-1].cR0);
   int oA5=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            oA5++;
         }
      }
   }
   Stp_Automatic aut(oZ0,oR0,oA5);
   Dielec_Continu mlg( 1, 1,oA5,oR0);
   Dielec_Continu med( 1, 1,oA5,oR0);

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
//    int nR0=(mR0-1+Z0[iZ0].cR0);
      char c1=R0[mR0].c1;
      if      ( (c1=='a')||
                (c1=='e') ){
         aut.Z0[iZ0].c1='a';
      }else if( (c1=='r')||
                (c1=='b')||
                (c1=='p') ){
         aut.Z0[iZ0].c1='p';
      }else if( (c1=='s') ){
         aut.Z0[iZ0].c1='s';
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aut.R0[iR0].coil=1;
         aut.R0[iR0].expo=0;
         for(int i= 0;i<12;i++){
            aut.R0[iR0].e[i]= (0.00);
         }
         aut.R0[iR0].bbcnf="  ";
         aut.R0[iR0].sccnf=' ';
      }
   }

   TRA_STP_OLP(aut);
   TRA_STP_CNF(aut,residue_mappings,region_maps);
   TRA_STP_CAV(aut,mlg,med,
              physics_consts,array_consts,energy_params,residue_mappings,
              out);
   TRA_STP_BCHG(aut,mlg,physics_consts);
   TRA_STP_HBND(aut,physics_consts);

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( aut.R0[iR0].coil==1 )continue;
         std::string cnf=aut.R0[iR0].bbcnf;
         int L=-1;
         if      ( (cnf=="A ")||(cnf=="B ") ){
            L=5;
         }else if( (cnf[0]=='E')||(cnf[0]=='F')||(cnf[0]=='D') ){
            L=3;
         }
         bool SSELEM=false;
         for(int iTER=-L;iTER<= 0;iTER++){
            int aR0=(iR0+iTER);
            int bR0=(aR0+L);
            if( (aR0<mR0)||(bR0>nR0) )continue;
            int ii=0;
            for(int jR0=aR0;jR0<=bR0;jR0++){
               ii+=aut.R0[jR0].coil;
            }
            if( ii<=1 )SSELEM=true;
         }
         if( !SSELEM )aut.R0[iR0].coil=1;
      }
   }

// TRA_STP_SSP(aut);

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aut.R0[iR0].loop= aut.R0[iR0].coil*aut.R0[iR0].expo;
         aut.R0[iR0].e[ 0]= aut.R0[iR0].e[ 1]
                           +aut.R0[iR0].e[ 2]
                           +aut.R0[iR0].e[ 3]
                           +aut.R0[iR0].e[ 4]
                           +aut.R0[iR0].e[ 5]
                           +aut.R0[iR0].e[ 6]
                           +aut.R0[iR0].e[ 7]
                           +aut.R0[iR0].e[ 8]
                           +aut.R0[iR0].e[ 9]
                           +aut.R0[iR0].e[10];
      }
   }
//
//
// compact analysis of defect energy
//
//Residue..................Overlap...................................Unpaired Hbond Acceptor......................
//|.........bb Conformation......Disallowed (phi,psi)................|.....Exposed Hydrophobic Surface............
//|.........|.sc Conformation....|.....Disallowed omega..............|.....|.....Improbable Secondary Structure...
//|.........|.|.Total Energy.....|.....|.....Disallowed chi..........|.....|.....|................................
//|.........|.|.|......isCoil....|.....|.....|.....Buried Charge.....|.....|.....|................................
//|.........|.|.|......|isExposed|.....|.....|.....|.....Cavity......|.....|.....|................................
//|.........|.|.|......||isLoop..|.....|.....|.....|.....|.....Unpaired HBond Donor...............................
//|.........|.|.|......|||.|.....|.....|.....|.....|.....|.....|.....|.....|.....|................................

   out.FILE3<< std::fixed<< std::setprecision( 2);

   out.FILE3<<"Residue..................Overlap.................."
              ".................Unpaired Hbond Acceptor.........."
              "............\n";
   out.FILE3<<"|.........bb Conformation......Disallowed (phi,psi"
              ")................|.....Exposed Hydrophobic Surface"
              "............\n";
   out.FILE3<<"|.........|.sc Conformation....|.....Disallowed om"
              "ega..............|.....|.....Improbable Secondary "
              "Structure...\n";
   out.FILE3<<"|.........|.|.Total Energy.....|.....|.....Disallo"
              "wed chi..........|.....|.....|...................."
              "............\n";
   out.FILE3<<"|.........|.|.|......isCoil....|.....|.....|.....B"
              "uried Charge.....|.....|.....|...................."
              "............\n";
   out.FILE3<<"|.........|.|.|......|isExposed|.....|.....|.....|"
              ".....Cavity......|.....|.....|...................."
              "............\n";
   out.FILE3<<"|.........|.|.|......||isLoop..|.....|.....|.....|"
              ".....|.....Unpaired HBond Donor..................."
              "............\n";
   out.FILE3<<"|.........|.|.|......|||.|.....|.....|.....|.....|"
              ".....|.....|.....|.....|.....|...................."
              "............\n";

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      out.FILE3<<"__________________________________________________"
                  "__________________________________________________\n";
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         char cha=R0[iR0].cha;
         int res=R0[iR0].res;
         char ins=R0[iR0].ins;
         std::string bbcnf=aut.R0[iR0].bbcnf;
         char sccnf=aut.R0[iR0].sccnf;
         int coil=aut.R0[iR0].coil;
         int expo=aut.R0[iR0].expo;
         int loop=aut.R0[iR0].loop;
         out.FILE3<<aa
                  <<cha
                  << std::setw( 4)<<res
                  <<ins
                  <<bbcnf
                  <<sccnf<<' '
                  << std::setw( 6)<<aut.R0[iR0].e[ 0]<<' '
                  << std::setw( 1)<<coil
                  << std::setw( 1)<<expo
                  << std::setw( 1)<<loop<<' ';
         for(int i= 1;i<11;i++){
            out.FILE3<< std::setw( 6)<<aut.R0[iR0].e[ i];
         }
         out.FILE3<<'\n';
      }
   }
   out.FILE3<<"__________________________________________________"
              "__________________________________________________\n";
//
//
// create step focused on defects
//
   TRA_STP_STP(aut,residue_mappings,out,ful,sub);
   return;
}
