#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <cmath>

void Local_Minimizq::TRA_LOQ_UPDATE(const DAT_PHYSICS_CONSTS& physics_consts,
                                    const Mechanical_System& mol,
                                    const Subset_Contracted_System::tM3& con,
                                    const Lagrange_Multiplier& lag,
                                    Energy_Surfq& enq){
   double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;

   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( !con.Z0[iZ0].sub )continue;
      for(int i=0;i<3;i++){
         enq.U2chi(iU2+i)+=(enq.U2uca(iU2+i)*lag.U2x(iU2+i));
      }

      alp= enq.U2chi(iU2+3);
      bet= enq.U2chi(iU2+4);
      gam= enq.U2chi(iU2+5);
      Rotation_Matrix ROT1(alp,bet,gam);

      alp= enq.U2uca(iU2+3)*lag.U2x(iU2+3);
      Calp= std::cos( alp);
      Salp= std::sin( alp);
      bet= enq.U2uca(iU2+4)*lag.U2x(iU2+4);
      Cbet= std::cos( bet);
      Sbet= std::sin( bet);
      gam= enq.U2uca(iU2+5)*lag.U2x(iU2+5);
      Cgam= std::cos( gam);
      Sgam= std::sin( gam);
      Rotation_Matrix ROT2;
      ROT2(0,0)= Cbet*Cgam;
      ROT2(1,0)=-Cbet*Sgam;
      ROT2(2,0)= Sbet;
      ROT2(0,1)= Salp*Sbet*Cgam +Calp*Sgam;
      ROT2(1,1)=-Salp*Sbet*Sgam +Calp*Cgam;
      ROT2(2,1)=-Salp*Cbet;
      ROT2(0,2)=-Calp*Sbet*Cgam +Salp*Sgam;
      ROT2(1,2)= Calp*Sbet*Sgam +Salp*Cgam;
      ROT2(2,2)= Calp*Cbet;

      Rotation_Matrix ROT;
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ROT(i,j)= ROT2(i,0)*ROT1(0,j)
                     +ROT2(i,1)*ROT1(1,j)
                     +ROT2(i,2)*ROT1(2,j);
         }
      }

      Cbet= ROT(2,2);
      Sbet= std::sqrt( (1.00) -Cbet*Cbet);
      bet= std::atan2(Sbet,Cbet);
      if( Sbet<(1.00e-12) ){
         gam= (0.00);
         if( Cbet>(0.00) ){
            Calp= ROT(0,0);
            Salp= ROT(0,1);
         }else{
            Calp=-ROT(0,0);
            Salp=-ROT(0,1);
         }
         alp= std::atan2(Salp,Calp);
      }else{
         Calp= (ROT(2,0)/Sbet);
         Salp= (ROT(2,1)/Sbet);
         alp= std::atan2(Salp,Calp);
         Cgam=-(ROT(0,2)/Sbet);
         Sgam= (ROT(1,2)/Sbet);
         gam= std::atan2(Sgam,Cgam);
      }

      enq.U2chi(iU2+3)= alp;
      enq.U2chi(iU2+4)= bet;
      enq.U2chi(iU2+5)= gam;

      iU2+=6;
   }

   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            enq.U2chi(iU2)+=(enq.U2uca(iU2)*lag.U2x(iU2));
            if      ( enq.U2chi(iU2)<-physics_consts.PI ){
               enq.U2chi(iU2)+=(2.00)*physics_consts.PI;
            }else if( enq.U2chi(iU2)> physics_consts.PI ){
               enq.U2chi(iU2)-=(2.00)*physics_consts.PI;
            }
            iU2++;
         }
      }
   }

   return;
}
