#include "../mov/Lagrange_Multiplier.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <cmath>

void Local_Minimizq::TRA_LOQ_BACKUP(Lagrange_Multiplier& lag,
                                    Energy_Surfq& enq,
                                    bool INFLATE){

   if( iM2==0 ){
      lag.accept(enq);
   }else{
      double d=( enq.TOT -M2[iM2-1].tot);
      double z=( ( .02)*std::abs( M2[iM2-1].tot) +( .04));
      if( INFLATE ){
         if      ( d>( 12.00) ){
            M2[iM2-1].bet*=(.50);
            lag.reject(enq);
         }else{
            lag.accept(enq);
         }
      }else{
         if( d<z ){
            lag.accept(enq);
         }else{
            M2[iM2-1].bet*=(.50);
            lag.reject(enq);
         }
      }
   }
   return;
}
