#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include "../tra/Tra_Automatic.hh"
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

int Local_Minimizq::TRA_LOQ(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_REGION_MAPS& region_maps,
                            const Thread_Options& opt,
                            Output_Streams& out,
                            const Mechanical_System& mol,
                            const Subset_Contracted_System::tM3& con,
                            Conf_Dependent_System& dep,
                            Energy_Surfq& enq,
                            bool INFLATE){
   bool BIAS=CYCS(iCYC);
//
//
// cartesian coords at start of optimization traj
//
   Tra_Automatic aut(enq.oF2, 0, 0, 0, 0);
   for(int iZ0= 0;iZ0<enq.oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
//
      Coordinates TRANS;
      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=enq.Z0[iZ0].U2a;
         TRANS(0)= enq.U2chi(iU2  );
         TRANS(1)= enq.U2chi(iU2+1);
         TRANS(2)= enq.U2chi(iU2+2);
         alp= enq.U2chi(iU2+3);
         bet= enq.U2chi(iU2+4);
         gam= enq.U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);
//
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 1)||(iT2== 4)||(iT2== 7)||(iT2>17) )continue;
         aut.F2[iF2].x.generate(TRANS,
                                ROT,
                                dep.F2[iF2].x);
      }
//
      if( nQ2>mQ2 ){
         aut.PR[ 0]= ROT;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              enq.U2chi(enq.Q2[iQ2].U2));
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 1)||(iT2== 4)||(iT2== 7)||(iT2>17) )continue;
               aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                      aut.PR[br],
                                      dep.G3[iG3].b);
            }
         }
      }
   }
//
//
// reduction of full chg elec field by dielec medium
//
// out.FILE3<<std::fixed<<std::setprecision( 4);
   Gaussian_Volume vf;
   {
      double z= physics_consts.ANG*physics_consts.ANG;
      vf.sig=(  2.5191);
      vf.eta=(  0.7745)*z;
   }
   for(int iF2= 0;iF2<enq.oF2;iF2++){
      enq.F2[iF2].fq= (1.00);
      if( con.F2[iF2].zet==0 )continue;
      double RRij=( 0.00);
      double e2=(  0.00);
      for(int i=0;i<4;i++){
         for(int j=0;j<4;j++){
            e2+=eef(physics_consts,
                    con.F2[iF2].ef[i],
                    con.F2[iF2].ef[j],
                    RRij);
         }
      }
      double e3=(  0.00);
      for(int kF2= 0;kF2<enq.oF2;kF2++){
         int kT2=con.F2[kF2].typ;
         if( (kT2< 8)||(kT2>17) )continue;
         if( con.F2[kF2].mu!=1 )continue;
         double RRik=( aut.F2[iF2].x -aut.F2[kF2].x).rr();
         double RRjk= RRik;
         for(int i=0;i<4;i++){
            for(int j=0;j<4;j++){
               e3+=eevf(physics_consts,
                        con.F2[iF2].ef[i],
                        con.F2[iF2].ef[j],
                        vf,
                        RRij,
                        RRik,
                        RRjk);
            }
         }
      }
//    out.FILE3<<" iF2="<<std::setw( 4)<<iF2
//             <<" atm="<<con.F2[iF2].atm
//             <<" iR0="<<std::setw( 3)<<con.F2[iF2].R0
//             <<" e2="<<std::setw( 9)<<e2
//             <<" e3="<<std::setw( 9)<<e3;
      if( e3> e2 )e3= e2;
      double x= (e3/e2);
      double b= std::exp( (1.50)*std::log( ( .375)));
      double a=( (1.00) -b);
      enq.F2[iF2].fq=( a*x +b);
//    out.FILE3<<" (e3/e2)="<<std::setw( 9)<<x
//             <<" fq="<<std::setw( 9)<<enq.F2[iF2].fq<<std::endl;
   }
//
//
// lagrange multipliers
//
   int oU2=enq.nU2;
   Lagrange_Multiplier lag(oU2);
   lag.bU2=(oU2-1);
   for(int iU2=(oU2-1);iU2>-1;iU2--){
      if( enq.U2uca(iU2)>(0.00) ){
         lag.bU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   lag.aU2= 0;
   for(int iU2= 0;iU2<oU2;iU2++){
      if( enq.U2uca(iU2)>(0.00) ){
         lag.aU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   lag.oP=0;
   Lagrange_Multiplier lae(oU2);
   if( INFLATE ){
      lae.bU2=lag.bU2;
      lae.aU2=lag.aU2;
   }
//
//
// control of optimization traj
//
   enq.ethresh= (1.00e-5);
   if( INFLATE ){
      if( BIAS ){
         oQ=(aQ+11 +1*bQ);
      }else{
         oQ=(aQ+ 9 +1*bQ);
      }
   }
   enq.E4RESET=true;
//
//
// optimization traj
//
   int ck1,ck2,ck3,ck4,ck5;             //loop counters
   if( INFLATE ){
//    out.FILE3<<' ';
//    for(int iQ= 0;iQ<16;iQ++){
//       out.FILE3<<"  "<<std::setw( 2)<<iQ<<"  ";
//    }
//    out.FILE3<<'\n';
   }
   int OSCILLATE=0;
   for(iM2=0;;iM2++){
      enq.TRA_ENQ(physics_consts,array_consts,energy_params,region_maps,
                  opt,out,mol,con,dep);
      TRA_LOQ_BACKUP(lag,enq,INFLATE);
      M2[iM2].tot= lag.TOT;
      double zz= lag.gradient();
      M2[iM2].z= zz;
      if( nM2==0 ){
         return ENDSTATE=0;
      }
      if( INFLATE ){
         if( OSCILLATE> 7 ){
            return ENDSTATE=0;
         }
      }else{
         if( zz<EPS1 ){
            return ENDSTATE=0;
         }
      }
      if( (iM2> 0)&&(M2[iM2-1].bet<=BMIN) ){
         return ENDSTATE=0;
      }
      if( INFLATE ){
         if( BIAS ){
            enq.ETARGET=CYCE(iCYC);
            enq.STARGET=CYCS(iCYC);
            enq.TTARGET=CYCT(iCYC);
            enq.HTARGET=CYCH(iCYC);
            enq.MTARGET=CYCM(iCYC);
            enq.WTARGET=CYCW(iCYC);
            double zFr(enq.Fr),zFe(enq.Fe),zFs(enq.Fs),zFt(enq.Ft),
                   zFc(enq.Fc),zFb(enq.Fb),zFh(enq.Fh),zFw(enq.Fw),
                   zFp(enq.Fp),
                   zFp_a(enq.Fp_a),zFp_b(enq.Fp_b),zFp_c(enq.Fp_c),
                   zFp_d(enq.Fp_d),zFp_e(enq.Fp_e);
            enq.TRA_ENQ(physics_consts,array_consts,energy_params,region_maps,
                        opt,out,mol,con,dep);
            lae.accept(enq);
            lae.TOT=( lag.TOT -lae.TOT);
            for(int iU2= 0;iU2<oU2;iU2++){
               lae.U2g(iU2)=( lag.U2g(iU2) -lae.U2g(iU2));
               for(int jU2=iU2;jU2<oU2;jU2++){
                  lae.U2U2a(iU2,jU2)=( lag.U2U2a(iU2,jU2) -lae.U2U2a(iU2,jU2));
               }
            }
            enq.ETARGET=false;
            enq.STARGET=false;
            enq.TTARGET=false;
            enq.HTARGET=false;
            enq.MTARGET=false;
            enq.WTARGET=false;
            enq.TOT= lag.TOT;
            enq.Fr= zFr;
            enq.Fe= zFe;
            enq.Fs= zFs;
            enq.Ft= zFt;
            enq.Fc= zFc;
            enq.Fb= zFb;
            enq.Fh= zFh;
            enq.Fw= zFw;
            enq.Fp= zFp;
            enq.Fp_a= zFp_a;
            enq.Fp_b= zFp_b;
            enq.Fp_c= zFp_c;
            enq.Fp_d= zFp_d;
            enq.Fp_e= zFp_e;
         }
      }
//
//
// target step length
//
      double beta1=TRA_LOQ_TARGETBETA(INFLATE);
//
//
// inversion of subspace st optimal step approaches transition state
//
      if( INFLATE ){
//
//
// adapt oQ
//
         if( iM2> 0 ){
            double dtot=( M2[iM2].tot -M2[ 0].tot);
            double dtar= ( .50)*physics_consts.ekT*double( oU2);
            if      ( dtot<( 0.64  )*dtar ){
               if( M2[iM2-1].s2<=std::pow( ( 5.00)*BMIN, 2) ){
                  if( oQ<14 )oQ+=2;
                  beta1= BETA;
                  M2[iM2].bet= beta1;
               }
            }else if( dtot<( 0.80  )*dtar ){
               if( M2[iM2-1].s2<=std::pow( ( 5.00)*BMIN, 2) ){
                  if( oQ<15 )oQ++;
                  beta1= BETA;
                  M2[iM2].bet= beta1;
               }
            }else if( dtot>( 1.5625)*dtar ){
               return ENDSTATE=0;
            }else if( dtot>( 1.25  )*dtar ){
               if( M2[iM2-1].s2> BETA*BETA ){
                  if( oQ> 7 ){
                     oQ--;
                     beta1= BETA;
                     M2[iM2].bet= beta1;
                  }
               }else if( M2[iM2-1].s2<=std::pow( ( 5.00)*BMIN, 2) ){
                  return ENDSTATE=0;
               }
            }
         }
//
//
// initial lamda st (A+lamda*I) is positive definite
//
         double beta0= std::sqrt( oU2);
         for(ck1=(iM2>0)? 6: 3;ck1>0;ck1--){
            TRA_LOQ_INITLAMDA(lag,ck1,beta0);
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
         }
         if( ck1==0 ){
            std::cerr<<"ERROR0: (A+lamda*I) not positive definite\n";
            std::exit( 2);
         }
         for(int iQ= 0;iQ<oQ;iQ++){
            for(int iU2= 0;iU2<oU2;iU2++){
               lag.U2x(iU2)= ( 1.00e-2);
            }
            lag.step(lag.o_U2x,( 1.00e-2),lag.o_U2x);
            double x= lag.normalize();
//
//
// iterate to lowest eigenvector
//
            for(ck2=5;ck2>0;ck2--){
               if( x>(beta0*( (1.00) -( .50)*EPS2)) )break;
               double z= std::abs( lag.lamda);
               if( z<( 1.00e-3) )z= ( 1.00e-3);
               for(ck4=8;ck4>0;ck4--){
                  for(int ii=0;ii<8;ii++){
                     lag.step(lag.o_U2x,z,lag.o_U2x);
                  }
                  double d= lag.normalize();
                  if( d>( 1.00e+10) )break;
               }
               double dlamda= lag.lamdastep(beta0,INFLATE);
//
//
// prevent numerical instability
//
               if( dlamda/z<( 1.00e-12) ){
                  lag.lamda+=(64.00)*dlamda;
                  break;
               }
               for(ck5=8;ck5>0;ck5--){
                  lag.diagonal();
                  bool pd=lag.lower();
                  if( pd )break;
                  lag.lamda+=dlamda;
                  dlamda*=(2.00);
               }
               if( ck5==0 ){
                  std::cerr<<"ERROR1: (A+lamda*I) not positive definite\n";
                  std::exit( 2);
               }
               lag.step(lag.o_U2x,( 1.00e-2),lag.o_U2x);
               x= lag.normalize();
            }
//
//
// inversion subspace
//
            for(int iU2= 0;iU2<oU2;iU2++){
               lag.QU2n(iQ,iU2)= lag.U2x(iU2);
            }
            double hn= lag.lamda;
            double gn= (0.00);
            for(int iU2= 0;iU2<oU2;iU2++){
               gn+=lag.U2g(iU2)*lag.QU2n(iQ,iU2);
            }
            lag.Qhn(iQ)= hn;
            lag.Qgn(iQ)= gn;
            lag.Qf(iQ)= ( 1.00);
//
//
// raise lowest eigenvalue
//
            for(int iU2= 0;iU2<oU2;iU2++){
               lag.U2h(iU2)+=((20.00)*lag.QU2n(iQ,iU2)
                                     *lag.QU2n(iQ,iU2));
            }
            for(int iU2= 0;iU2<(oU2- 1);iU2++){
               for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                  lag.U2U2a(iU2,jU2)+=((20.00)*lag.QU2n(iQ,iU2)
                                              *lag.QU2n(iQ,jU2));
               }
            }
            lag.diagonal();
            bool pd=lag.lower();
            if( !pd ){
               std::cerr<<"ERROR2: (A+lamda*I) not positive definite\n";
               std::exit( 2);
            }
         }
//
//
// measure of continuity of subspace Q
//
         if( iM2> 0 ){
            out.FILE3<<std::fixed<<std::setprecision( 2);
//          out.FILE3<<'0';
            int m=0;
            for(int iQ= 0;iQ<oQ;iQ++){
               double z= ( 0.00);
               for(int jQ= 0;jQ<lag.oQ_pre;jQ++){
                  double nj= (0.00);
                  for(int iU2= 0;iU2<oU2;iU2++){
                     nj+=lag.QU2n(iQ,iU2)*lag.QU2n_pre(jQ,iU2);
                  }
                  z+=(nj*nj);
               }
               z= std::sqrt( z);
               lag.Qf0(iQ)= z;
               lag.Qsub(iQ,( z>( 0.50) ));
               char c=( lag.Qsub(iQ) )?(' '):('_');
//             out.FILE3<<c<<std::setw( 5)<<z;
               if( !lag.Qsub(iQ) )m++;
            }
//          out.FILE3<<'\n';
            if( m>6 )m=6;
            beta1*=( (1.00) +( .50)*double( 1-m)*BDEL);
            if      ( beta1<BMIN ){
               beta1= BMIN;
            }else if( beta1>BMAX ){
               beta1= BMAX;
            }
            M2[iM2].bet= beta1;
         }else{
            for(int iQ= 0;iQ<oQ;iQ++){
               lag.Qf0(iQ)= (1.00);
               lag.Qsub(iQ,true);
            }
         }
//
//
// measure of transit over barrier
//
         if( iM2> 0 ){
            out.FILE3<<std::fixed<<std::setprecision( 2);
//          out.FILE3<<'1';
            double gg( 0.00),pp( 0.00);
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  double gn= lag.Qgn(iQ);
                  gg+=(gn*gn);
                  double pn= ( 0.00);
                  for(int iU2= 0;iU2<oU2;iU2++){
                     pn+=lag.U2g_pre(iU2)*lag.QU2n(iQ,iU2);
                  }
                  pp+=(pn*pn);
                  lag.Qf1(iQ)= gn*pn;
               }else{
               }
            }
            double gp= std::sqrt( gg*pp +( 1.00e-16));
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  double z= (lag.Qf1(iQ)/gp);
                  lag.Qf1(iQ)= z;
                  char c=( z<( -.02) )?('<'):(' ');
//                out.FILE3<<c<<std::setw( 5)<<z;
               }else{
                  lag.Qf1(iQ)= (0.00);
//                out.FILE3<<"      ";
               }
            }
//          out.FILE3<<'\n';
         }else{
            for(int iQ= 0;iQ<oQ;iQ++){
               lag.Qf1(iQ)= (1.00);
            }
         }
//
//
// favor decrease in energy components e+m
//
         if( BIAS ){
            out.FILE3<<std::fixed<<std::setprecision( 2);
//          out.FILE3<<'2';
            double gg( 0.00),ee( 0.00);
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  double gn= lag.Qgn(iQ);
                  gg+=(gn*gn);
                  double en= ( 0.00);
                  for(int iU2= 0;iU2<oU2;iU2++){
                     en+=lae.U2g(iU2)*lag.QU2n(iQ,iU2);
                  }
                  ee+=(en*en);
                  lag.Qf2(iQ)=-gn*en;
               }
            }
            double ge= std::sqrt( gg*ee +( 1.00e-16));
            ge/=(( 2.50)*double( oQ));
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  double z=(lag.Qf2(iQ)/ge);
                  if      ( z>( 1.00) ){
                     z= ( 1.00);
                  }else if( z<(-1.00) ){
                     z= (-1.00);
                  }
                  z=( ( .375)*z +( .625));
                  lag.Qf2(iQ)= z;
                  char c=( z<( 0.50) )?('#'):(' ');
//                out.FILE3<<c<<std::setw( 5)<<z;
               }else{
                  lag.Qf2(iQ)= (-1.00);
//                out.FILE3<<"      ";
               }
            }
//          out.FILE3<<'\n';
         }else{
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  lag.Qf2(iQ)= ( 1.00);
               }else{
                  lag.Qf2(iQ)= (-1.00);
               }
            }
         }
//
//
// maintain subspace P
//
         if( iM2>  7 ){
            int jP=0;
            for(int iP= 0;iP<lag.oP;iP++){
               double z= ( 0.00);
               for(int jQ= 0;jQ<oQ;jQ++){
                  if( lag.Qsub(jQ) ){
                     double nj= (0.00);
                     for(int iU2= 0;iU2<oU2;iU2++){
                        nj+=lag.PU2n(iP,iU2)*lag.QU2n(jQ,iU2);
                     }
                     lag.QPt(jQ,iP)= nj;
                     z+=(nj*nj);
                  }else{
                     lag.QPt(jQ,iP)= (0.00);
                  }
               }
               z= std::sqrt( z);
               if( z<(  .72) )continue;
               if( iP>jP ){
                  for(int iU2= 0;iU2<oU2;iU2++){
                     lag.PU2n(jP,iU2)= lag.PU2n(iP,iU2);
                  }
                  for(int jQ= 0;jQ<oQ;jQ++){
                     lag.QPt(jQ,jP)= lag.QPt(jQ,iP);
                  }
               }
               jP++;
            }
            lag.oP=jP;
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  if( lag.Qf1(iQ)>( -.02) )continue;
                  double pn= ( 0.00);
                  double yn= ( 0.00);
                  for(int iU2= 0;iU2<oU2;iU2++){
                     pn+=lag.U2g_pre(iU2)*lag.QU2n(iQ,iU2);
                     yn+=lag.U2x_pre(iU2)*lag.QU2n(iQ,iU2);
                  }
                  double z=(pn*yn);
                  if( z>(  .02) ){    //add PU2n
                     for(int iU2= 0;iU2<oU2;iU2++){
                        lag.PU2n(lag.oP,iU2)= lag.QU2n(iQ,iU2);
                     }
                     for(int jQ= 0;jQ<oQ;jQ++){
                        lag.QPt(jQ,lag.oP)= ( jQ==iQ )? ( 1.00): ( 0.00);
                     }
                     lag.oP++;
                  }else if( (z<( -.02) )&&(lag.oP> 0) ){ //remove PU2n
                     int jP=-1;
                     double zt= ( -.01);
                     for(int iP= 0;iP<lag.oP;iP++){
                        double t= std::abs( lag.QPt(iQ,iP));
                        if( t>zt ){
                           jP=iP;
                           zt= t;
                        }
                     }
                     if( zt>( .50) ){
                        for(int iP=(jP+ 1);iP<lag.oP;iP++){
                           for(int iU2= 0;iU2<oU2;iU2++){
                              lag.PU2n(iP- 1,iU2)= lag.PU2n(iP  ,iU2);
                           }
                           for(int jQ= 0;jQ<oQ;jQ++){
                              lag.QPt(jQ,iP-1)= lag.QPt(jQ,iP  );
                           }
                        }
                        lag.oP--;
                     }
                  }
               }else{
               }
            }
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  lag.Pgn(iQ)= ( 0.00);
                  for(int iP= 0;iP<lag.oP;iP++){
                     double zi= ( 0.00);
                     for(int jQ= 0;jQ<oQ;jQ++){
                        if( lag.Qsub(jQ) ){
                           double gj= lag.Qgn(jQ);
                           double tj= lag.QPt(jQ,iP);
                           zi+=gj*tj;
                        }else{
                        }
                     }
                     double ti= lag.QPt(iQ,iP);
                     lag.Pgn(iQ)+=zi*ti;
                  }
                  lag.Phn(iQ)= ( 0.00);
                  for(int iP= 0;iP<lag.oP;iP++){
                     double zi= ( 0.00);
                     for(int jQ= 0;jQ<oQ;jQ++){
                        if( lag.Qsub(jQ) ){
                           double hj= lag.Qhn(jQ);
                           double tj= lag.QPt(jQ,iP);
                           zi-=hj*tj*tj;
                        }else{
                        }
                     }
                     double ti= lag.QPt(iQ,iP);
                     lag.Phn(iQ)+=zi*ti*ti;
                  }
               }else{
               }
            }
         }
//
//
// patch energy surf
//
         for(int iQ= 0;iQ<oQ;iQ++){
            double z= (-20.00);
            for(int iU2= 0;iU2<oU2;iU2++){
               lag.U2h(iU2)+=(z*lag.QU2n(iQ,iU2)
                               *lag.QU2n(iQ,iU2));
            }
            for(int iU2= 0;iU2<(oU2- 1);iU2++){
               for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                  lag.U2U2a(iU2,jU2)+=(z*lag.QU2n(iQ,iU2)
                                        *lag.QU2n(iQ,jU2));
               }
            }
            if( lag.Qsub(iQ) ){
               double f=( ( 1.00) +lag.Qf2(iQ));
               double gn= f*lag.Qgn(iQ);
               double hn= f*lag.Qhn(iQ);
               for(int iU2= 0;iU2<oU2;iU2++){
                  lag.U2g(iU2)-=(gn*lag.QU2n(iQ,iU2));
                  lag.U2h(iU2)+=(hn*lag.QU2n(iQ,iU2)
                                   *lag.QU2n(iQ,iU2));
               }
               for(int iU2= 0;iU2<(oU2- 1);iU2++){
                  for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                     lag.U2U2a(iU2,jU2)+=(hn*lag.QU2n(iQ,iU2)
                                            *lag.QU2n(iQ,jU2));
                  }
               }
            }else{
            }
         }
         for(int iQ= 0;iQ<oQ;iQ++){
            if( lag.Qsub(iQ) ){
               double f=( ( 1.00) +lag.Qf2(iQ));
               double gn= f*lag.Pgn(iQ);
               double hn= f*lag.Phn(iQ);
               for(int iU2= 0;iU2<oU2;iU2++){
                  lag.U2g(iU2)+=(gn*lag.QU2n(iQ,iU2));
                  lag.U2h(iU2)+=(hn*lag.QU2n(iQ,iU2)
                                   *lag.QU2n(iQ,iU2));
               }
               for(int iU2= 0;iU2<(oU2- 1);iU2++){
                  for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                     lag.U2U2a(iU2,jU2)+=(hn*lag.QU2n(iQ,iU2)
                                            *lag.QU2n(iQ,jU2));
                  }
               }
            }else{
            }
         }
      }
//
//
// inital lamda st (A+lamda*I) is positive definite
//
      for(ck1=(iM2>0)? 6: 3;ck1>0;ck1--){
         TRA_LOQ_INITLAMDA(lag,ck1,beta1);
         lag.diagonal();
         bool pd=lag.lower();
         if( pd )break;
      }
      if( ck1==0 ){
         return ENDSTATE=1;
      }
      M2[iM2].k1=(iM2>0)? (6-ck1): (3-ck1);
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
      double dxx= (0.00);
      double xx=lag.length(dxx);
      M2[iM2].s0= xx;
      M2[iM2].ds0= dxx;
//
//
// decrease lamda st step length > beta1
//
      int k2=0;
      for(ck2=4;ck2>0;ck2--){
         if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
         if( lag.lamda<=(0.00) )break;

         M2[iM2].k4[k2]=100;
         for(ck4=10;ck4>0;ck4--){
            for(int ii=0;ii<10;ii++){
               lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
            }
            lag.normalize();
         }

         double dlamda= lag.lamdastep(beta1);
         M2[iM2].lam1[k2]= lag.lamda;

         for(ck5=30;ck5>0;ck5--){
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
            lag.lamda+=dlamda;
            M2[iM2].lam1[k2]= lag.lamda;
            dlamda*=(2.00);
         }
         if( ck5==0 ){
            return ENDSTATE=3;
         }

         M2[iM2].k5[k2]=(30-ck5);
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
         M2[iM2].s1[k2]= xx;
         M2[iM2].ds1[k2]= dxx;
         k2++;
      }
      M2[iM2].k2=(4-ck2);
//
//
// increase lamda st step length == beta1
//
      for(ck3=32;ck3>0;ck3--){
         if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
         lag.lamdastep(beta1,xx,dxx);
         lag.diagonal();
         bool pd=lag.lower();
         if( !pd ){
            return ENDSTATE=4;
         }
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
      }
      M2[iM2].k3=(32-ck3);

      TRA_LOQ_UPDATE(physics_consts,mol,con,lag,enq);
      M2[iM2].lam2= lag.lamda;
      M2[iM2].s2= xx;
      M2[iM2].ds2= dxx;
//
//
// restore energy surface
//
      if( INFLATE ){
         for(int iQ= 0;iQ<oQ;iQ++){
            if( lag.Qsub(iQ) ){
               double f=( ( 1.00) +lag.Qf2(iQ));
               double gn= f*lag.Qgn(iQ);
               double hn= f*lag.Qhn(iQ);
               for(int iU2= 0;iU2<oU2;iU2++){
                  lag.U2g(iU2)+=(gn*lag.QU2n(iQ,iU2));
                  lag.U2h(iU2)-=(hn*lag.QU2n(iQ,iU2)
                                   *lag.QU2n(iQ,iU2));
               }
               for(int iU2= 0;iU2<(oU2- 1);iU2++){
                  for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                     lag.U2U2a(iU2,jU2)-=(hn*lag.QU2n(iQ,iU2)
                                            *lag.QU2n(iQ,jU2));
                  }
               }
            }else{
            }
         }
         for(int iQ= 0;iQ<oQ;iQ++){
            if( lag.Qsub(iQ) ){
               double f=( ( 1.00) +lag.Qf2(iQ));
               double gn= f*lag.Pgn(iQ);
               double hn= f*lag.Phn(iQ);
               for(int iU2= 0;iU2<oU2;iU2++){
                  lag.U2g(iU2)-=(gn*lag.QU2n(iQ,iU2));
                  lag.U2h(iU2)-=(hn*lag.QU2n(iQ,iU2)
                                   *lag.QU2n(iQ,iU2));
               }
               for(int iU2= 0;iU2<(oU2- 1);iU2++){
                  for(int jU2=(iU2+ 1);jU2<oU2;jU2++){
                     lag.U2U2a(iU2,jU2)-=(hn*lag.QU2n(iQ,iU2)
                                            *lag.QU2n(iQ,jU2));
                  }
               }
            }else{
            }
         }
      }
      M2[iM2].delF= lag.deltaf();
      if( INFLATE ){
//
//
// measure of continuity of momentum
//
//       out.FILE3<<'[';
         if( BIAS ){
//          out.FILE3<<std::scientific<<std::setprecision( 3);
//          out.FILE3<<std::setw(10)<<lae.TOT;
         }
         if( iM2> 0 ){
            xx= ( 0.00);
            double yy( 0.00),xy( 0.00);
            for(int iQ= 0;iQ<oQ;iQ++){
               if( lag.Qsub(iQ) ){
                  double xn= ( 0.00);
                  double yn= ( 0.00);
                  for(int iU2= 0;iU2<oU2;iU2++){
                     xn+=lag.U2x(iU2)*lag.QU2n(iQ,iU2);
                     yn+=lag.U2x_pre(iU2)*lag.QU2n(iQ,iU2);
                  }
                  xx+=(xn*xn);
                  yy+=(yn*yn);
                  xy+=(xn*yn);
               }else{
               }
            }
            double z= xy/std::sqrt( xx*yy +( 1.00e-16));
//          out.FILE3<<std::fixed<<std::setprecision( 2);
            char c=' ';
            if( z<(-0.025) ){
               OSCILLATE++;
               c='#';
            }else{
               OSCILLATE=0;
            }
//          out.FILE3<<c<<std::setw( 5)<<z
//                   <<std::setw( 3)<<lag.oP;
         }
//       out.FILE3<<"]\n";
//
//
// enable reference to current inversion subspace in next step
//
         lag.oQ_pre=oQ;
         for(int iQ= 0;iQ<oQ;iQ++){
            for(int iU2= 0;iU2<oU2;iU2++){
               lag.QU2n_pre(iQ,iU2)= lag.QU2n(iQ,iU2);
            }
         }
         for(int iU2= 0;iU2<oU2;iU2++){
            lag.U2x_pre(iU2)= lag.U2x(iU2);
            lag.U2g_pre(iU2)= lag.U2g(iU2);
         }
      }
//
//
// update threshold
//
      double e=-M2[iM2].delF;
      if( INFLATE&&(e<( 0.00)) ){
         e=-e;
      }
      if( e>( 1.00e+3) )e= ( 1.00e+3);
      e*=( 1.00e-4);
/**/  if( (iM2==0)||(e<enq.ethresh) ){
/**/     enq.ethresh= e;
/**/  }

      nM2--;
   }
}
