#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <iomanip>
#include <cmath>

void Local_Minimizp::TRA_LOP_WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                                 const DAT_RESIDUE_MAPPINGS& residue_mappings,
                                 Output_Streams& out,
                                 Structure& str,
                                 const Mechanical_System& mol,
                                 const Subset_Contracted_System::tM3& con,
                                 Conf_Dependent_System& dep,
                                 const Energy_Surfp& enp,
                                 const Energy_Surfq& ene){

   int n=iM2;
   double zF1= (1.00)/std::sqrt( enp.nU3);

// if( n>0 ){
//    out.FILE3<<"  i"
//             <<"    "<<" k1"
//             <<" k2"
//             <<" k3"
//             <<"    "<<" k4"
//             <<" k5\n";
//    for(int i=0;i<n;i++){
//       int m=M2[i].k2;
//       out.FILE3<< std::setw( 3)<<i<<"    "
//                << std::setw( 3)<<M2[i].k1
//                << std::setw( 3)<<M2[i].k2
//                << std::setw( 3)<<M2[i].k3<<"  ";
//       for(int j=0;j<m;j++){
//          out.FILE3<<"  "
//                   << std::setw( 3)<<M2[i].k4[j]
//                   << std::setw( 3)<<M2[i].k5[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

   if( n>0 ){
      for(int i=0;i<n;i++){
         M2[i].z= zF1*std::sqrt( M2[i].z);
         M2[i].bet= zF1*M2[i].bet;
         M2[i].s0= zF1*std::sqrt( M2[i].s0);
         int m=M2[i].k2;
         for(int j=0;j<m;j++){
            M2[i].s1[j]= zF1*std::sqrt( M2[i].s1[j]);
         }
         M2[i].s2= zF1*std::sqrt( M2[i].s2);
      }
   }
// M2[n].z= zF1*std::sqrt( M2[n].z);

   if( out.VERBOSE ){
      out.FILE3<<"INFLATION TRAJECTORY\n";
      out.FILE3<< std::scientific;
      out.FILE3<<"  i"
               <<"        F   "
               <<"       z   "
               <<"       b   "
               <<"    lam2   "
               <<"      s2   "
               <<"    delF    \n";
      if( n>0 ){
         for(int i=0;i<n;i++){
            out.FILE3<< std::setw( 3)<<i
                     << std::setprecision(5)
                     << std::setw(12)<<M2[i].tot
                     << std::setprecision(4)
                     << std::setw(11)<<M2[i].z
                     << std::setw(11)<<M2[i].bet
                     << std::setw(11)<<M2[i].lam2
                     << std::setw(11)<<M2[i].s2
                     << std::setprecision(5)
                     << std::setw(12)<<M2[i].delF<<'\n';
         }
      }
//    out.FILE3<< std::setw( 3)<<n
//             << std::setprecision(5)<< std::setw(12)<<M2[n].tot
//             << std::setprecision(4)<< std::setw(11)<<M2[n].z<<'\n';
   }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam0   "
//             <<"      s0   \n";
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i
//                << std::setw(11)<<M2[i].lam0
//                << std::setw(11)<<M2[i].s0<<'\n';
//    }
// }

// if( n>0 ){
//    out.FILE3<< std::scientific<< std::setprecision(4);
//    out.FILE3<<"  i"
//             <<"    lam1   "
//             <<"      s1   "<<'\n';
//    for(int i=0;i<n;i++){
//       out.FILE3<< std::setw( 3)<<i;
//       int m=M2[i].k2;
//       for(int j=0;j<m;j++){
//          out.FILE3<< std::setw(11)<<M2[i].lam1[j]
//                   << std::setw(11)<<M2[i].s1[j];
//       }
//       out.FILE3<<'\n';
//    }
// }

// out.FILE3<< std::scientific<< std::setprecision(5);
// out.FILE3<<"       F    \n";
// out.FILE3<< std::setw(12)<<enp.TOT<<'\n';
//
//
// output compact tables of parameter target function minimization
//
   if( out.VERBOSE ){
      out.FILE3<< std::fixed<< std::setprecision(2);
      out.FILE3<<"    tot  |"
               <<"     Fr  "
               <<"     Fe  "
               <<"     Fs  "
               <<"     Ft  "
               <<"     Fc  "
               <<"     Fb  "
               <<"     Fh  "
               <<"     Fw  "
               <<"     Fp  \n";
      for(int i= 0;i<n;i++){
         out.FILE3<< std::setw( 9)<<M2e(i).F <<'|'
                  << std::setw( 9)<<M2e(i).Fr
                  << std::setw( 9)<<M2e(i).Fe
                  << std::setw( 9)<<M2e(i).Fs
                  << std::setw( 9)<<M2e(i).Ft
                  << std::setw( 9)<<M2e(i).Fc
                  << std::setw( 9)<<M2e(i).Fb
                  << std::setw( 9)<<M2e(i).Fh
                  << std::setw( 9)<<M2e(i).Fw
                  << std::setw( 9)<<M2e(i).Fp<<'\n';
      }
      out.FILE3<<"     F   |"
               <<"     Fy  "
               <<"     Fz  "
               <<"     Fw  |"
               <<"      z    "
               <<"     lamda "
               <<"      s    "
               <<"     delf  \n";
      for(int i= 0;i<n;i++){
         out.FILE3<< std::fixed<< std::setprecision(4)
                  << std::setw( 9)<<M2t(i).F <<'|'
                  << std::setw( 9)<<M2t(i).Fy
                  << std::setw( 9)<<M2t(i).Fz
                  << std::setw( 9)<<M2t(i).Fw<<'|'
                  << std::scientific<< std::setprecision(4)
                  << std::setw(11)<<M2t(i).z
                  << std::setw(11)<<M2t(i).lamda
                  << std::setw(11)<<M2t(i).s
                  << std::setw(11)<<M2t(i).delf<<'\n';
      }
   }

   return;
}
