#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <vector>
#include <iomanip>
#include <cmath>

void Local_Minimizp::TRA_LOP_UPDATE(const DAT_PHYSICS_CONSTS& physics_consts,
                                    Output_Streams& out,
                                    const Mechanical_System& mol,
                                    const Subset_Contracted_System::tM3& con,
                                    const Lagrange_Multiplier& lag,
                                    Energy_Surfp& enp,
                                    Energy_Surfq& ene,
                                    Energy_Surfq& enq){
   int oU3=enp.nU3;
   int oU2=ene.nU2;
//
//
// step in space of params
//
   for(int iU3= 0;iU3<oU3;iU3++){
      enp.U3chi(iU3)+=(enp.U3uca(iU3)*lag.U2x(iU3));
   }
   {
      int iU3=0;
      for(int iT= 0;iT<enp.oT;iT++){
         if( enp.Tb[iT] ){
            if( enp.U3chi(iU3)<enp.Tr_pre(iT) ){
               enp.U3chi(iU3)= enp.Tr_pre(iT);
            }
            iU3++;
         }
      }
      for(int iH= 0;iH<enp.oH;iH++){
         if( enp.Hb[iH] ){
            if( enp.U3chi(iU3)<enp.Hr_pre(iH) ){
               enp.U3chi(iU3)= enp.Hr_pre(iH);
            }
            iU3++;
         }
      }
   }
   out.FILE3<< std::fixed<< std::setprecision( 3);
   out.FILE3<<" change in RHO\n";
   out.FILE3<<" iM2";
   for(int iT= 0;iT<enp.oT;iT++){
      if( !enp.Tb[iT] )continue;
      out.FILE3<<"     "<<enp.Tatm(iT)<<' ';
   }
   for(int iH= 0;iH<enp.oH;iH++){
      if( !enp.Hb[iH] )continue;
      int iT=enp.Hdon(iH);
      int jT=enp.Hacc(iH);
      out.FILE3<<' '<<enp.Tatm(iT)<<".."<<enp.Tatm(jT);
   }
   out.FILE3<<'\n';
   out.FILE3<< std::setw( 4)<<iM2;
   {
      int iU3=0;
      for(int iT= 0;iT<enp.oT;iT++){
         if( enp.Tb[iT] ){
            out.FILE3<< std::setw( 9)<<( enp.U3chi(iU3) -enp.Tr_pre(iT));
            iU3++;
         }
      }
      for(int iH= 0;iH<enp.oH;iH++){
         if( enp.Hb[iH] ){
            out.FILE3<< std::setw( 9)<<( enp.U3chi(iU3) -enp.Hr_pre(iH));
            iU3++;
         }
      }
   }
   out.FILE3<<'\n';
//
//
// step in space of generalized coords
//
   {
      double z= (0.00);
      for(int iU2= 0;iU2<oU2;iU2++){
         enq.U2dt(iU2)= enp.U2t(iU2);
         for(int iU3= 0;iU3<oU3;iU3++){
            enq.U2dt(iU2)+=enp.U3U2t(iU3,iU2)
                          *enp.U3uca(iU3)*lag.U2x(iU3);
            enq.U2dt(iU2)+=(0.50)*enp.U3U3U2t(iU3,iU3,iU2)
                                 *enp.U3uca(iU3)*lag.U2x(iU3)
                                 *enp.U3uca(iU3)*lag.U2x(iU3);
         }
         for(int iU3= 0;iU3<oU3;iU3++){
            for(int jU3=(iU3+1);jU3<oU3;jU3++){
               enq.U2dt(iU2)+=enp.U3U3U2t(iU3,jU3,iU2)
                             *enp.U3uca(iU3)*lag.U2x(iU3)
                             *enp.U3uca(jU3)*lag.U2x(jU3);
            }
         }
         ene.U2dt(iU2  )*=ene.U2uca(iU2  );
         z+=enq.U2dt(iU2)*enq.U2dt(iU2);
      }
      z= std::sqrt( z/double( oU2));
//    out.FILE3<< std::fixed<< std::setprecision( 5);
//    out.FILE3<<" length of U2dt (normalized, deg units of circular arc)="
//             << std::setw( 8)<<(z/physics_consts.RAD)<<'\n';
      if( z>(  .01) ){
         for(int iU2= 0;iU2<oU2;iU2++){
            enq.U2dt(iU2)*=((0.01)/z);
         }
      }
   }
   {
      int iU2=0;
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         if( !con.Z0[iZ0].sub )continue;
         double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;
         ene.U2chi(iU2  )+=ene.U2dt(iU2  );
         ene.U2chi(iU2+1)+=ene.U2dt(iU2+1);
         ene.U2chi(iU2+2)+=ene.U2dt(iU2+2);
         alp= ene.U2chi(iU2+3);
         bet= ene.U2chi(iU2+4);
         gam= ene.U2chi(iU2+5);
         Rotation_Matrix ROT1(alp,bet,gam);
         alp= ene.U2dt(iU2+3);
         Calp= std::cos( alp);
         Salp= std::sin( alp);
         bet= ene.U2dt(iU2+4);
         Cbet= std::cos( bet);
         Sbet= std::sin( bet);
         gam= ene.U2dt(iU2+5);
         Cgam= std::cos( gam);
         Sgam= std::sin( gam);
         Rotation_Matrix ROT2;
         ROT2(0,0)= Cbet*Cgam;
         ROT2(1,0)=-Cbet*Sgam;
         ROT2(2,0)= Sbet;
         ROT2(0,1)= Salp*Sbet*Cgam +Calp*Sgam;
         ROT2(1,1)=-Salp*Sbet*Sgam +Calp*Cgam;
         ROT2(2,1)=-Salp*Cbet;
         ROT2(0,2)=-Calp*Sbet*Cgam +Salp*Sgam;
         ROT2(1,2)= Calp*Sbet*Sgam +Salp*Cgam;
         ROT2(2,2)= Calp*Cbet;
         Rotation_Matrix ROT;
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               ROT(i,j)= ROT2(i,0)*ROT1(0,j)
                        +ROT2(i,1)*ROT1(1,j)
                        +ROT2(i,2)*ROT1(2,j);
            }
         }
         Cbet= ROT(2,2);
         Sbet= std::sqrt( (1.00) -Cbet*Cbet);
         bet= std::atan2(Sbet,Cbet);
         if( Sbet<(1.00e-12) ){
            gam= (0.00);
            if( Cbet>(0.00) ){
               Calp= ROT(0,0);
               Salp= ROT(0,1);
            }else{
               Calp=-ROT(0,0);
               Salp=-ROT(0,1);
            }
            alp= std::atan2(Salp,Calp);
         }else{
            Calp= (ROT(2,0)/Sbet);
            Salp= (ROT(2,1)/Sbet);
            alp= std::atan2(Salp,Calp);
            Cgam=-(ROT(0,2)/Sbet);
            Sgam= (ROT(1,2)/Sbet);
            gam= std::atan2(Sgam,Cgam);
         }
         ene.U2chi(iU2+3)= alp;
         ene.U2chi(iU2+4)= bet;
         ene.U2chi(iU2+5)= gam;
         iU2+=6;
      }
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         if( nQ2>mQ2 ){
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               ene.U2chi(iU2)+=enq.U2dt(iU2);
               if      ( ene.U2chi(iU2)<-physics_consts.PI ){
                  ene.U2chi(iU2)+=(2.00)*physics_consts.PI;
               }else if( ene.U2chi(iU2)> physics_consts.PI ){
                  ene.U2chi(iU2)-=(2.00)*physics_consts.PI;
               }
               iU2++;
            }
         }
      }
   }
//
//
// normalize step in generalized coords
//
   {
      double z= (0.00);
      for(int iU2= 0;iU2<oU2;iU2++){
         z+=enq.U2dt(iU2)*enq.U2dt(iU2);
      }
      z= std::sqrt( z/double( oU2));
      for(int iU2= 0;iU2<oU2;iU2++){
         enq.U2dt(iU2)/=z;
      }
   }

   return;
}
