#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <cmath>

double Local_Minimizp::TRA_LOP_TARGETBETA(Energy_Surfp& enp){
   double beta1;
   if( iM2==0 ){
      beta1= BETA;
   }else{
      double beta2= M2[iM2-1].bet*M2[iM2-1].bet*( (1.00) -EPS2);
      double deltaf=( M2e(iM2).F -M2e(iM2-1).F);
      double deltaz= std::abs( M2t(iM2).Fz -M2t(iM2-1).Fz);
      if( M2[iM2-1].s2<beta2 ){
         beta1=( (1.00) -BDEL)*M2[iM2-1].bet;
      }else if( deltaf>( 8.00) ){
         beta1=( (1.00) -BDEL)*M2[iM2-1].bet;
      }else if( deltaz<((0.10)*std::sqrt(enp.nU2)) ){
         beta1=( (1.00) +BDEL)*M2[iM2-1].bet;
      }else{
         beta1= M2[iM2-1].bet;
      }
   }
   if      ( beta1<BMIN ){
      beta1= BMIN;
   }else if( beta1>BMAX ){
      beta1= BMAX;
   }
   M2[iM2].bet= beta1;
   return beta1;
}
