#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

int Local_Minimizp::TRA_LOP(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            const DAT_ENERGY_PARAMS& energy_params,
                            const DAT_REGION_MAPS& region_maps,
                            Thread_Options& opt,
                            Output_Streams& out,
                            Structure& str,
                            const Mechanical_System& mol,
                            const Subset_Contracted_System::tM3& con,
                            Conf_Dependent_System& dep,
                            Energy_Surfp& enp,
                            Energy_Surfq& ene,
                            Local_Minimizq& loq,
                            Energy_Surfq& enq){
   int oU3=enp.nU3;
   Lagrange_Multiplier lag(oU3);
   {
      lag.bU2=(oU3-1);
      lag.aU2= 0;
   }
   int ck1,ck2,ck3,ck4,ck5;     //loop counters
   int oZ0=str.nZ0;
   int oU2=ene.nU2;
   int oF2=ene.oF2;

   double dTOT= ( .25)*physics_consts.ekT*double( oU2);
   if( loq.iCYC==4 ){
      loq.iCYC=0;
   }
   Trajectory xtra;
   {
      xtra.STR2TRA( 0,str);
   }
   double zTOT( 1.00d+5);       //e, restch+m(approx), of initial local min
   double gTOT( 1.00d+5);       //e of current local min
   for(iM2=0;;iM2++){
      SYNC(physics_consts,energy_params,
           enp,enq,ene);
//
//
// initial minimization of restchm wrt generalized coords
//
      out.FILE3<<"LOCAL MINIMIZATION TRAJECTORY\n";
      out.VERBOSE=true;
      loq.BETA=( 2.00e-02);
      loq.BETA*=std::sqrt( oU2);
      loq.BMIN=( 1.00e-05);
      loq.BMIN*=std::sqrt( oU2);
      loq.BMAX=( 1.00e-01);
      loq.BMAX*=std::sqrt( oU2);
      loq.EPS1=( 1.00e-04);
      loq.EPS1= oU2*loq.EPS1*loq.EPS1;
      bool INFLATE=false;
      loq.nM2=128;
      std::cout<<" LOCAL MINIMIZATION TRAJECTORY"<< std::endl;
      loq.TRA_LOQ(physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep,
                  enq,INFLATE);
      loq.TRA_LOQ_WRT(physics_consts,residue_mappings,
                      out,str,mol,con,dep,
                      enq,INFLATE);
      out.VERBOSE=true;
      if( iM2==0 ){
         zTOT= enq.TOT;
      }
      gTOT= enq.TOT;
      str.CAR(physics_consts,residue_mappings);
      double rd= str.SUP(physics_consts,out,xtra);
      xtra.STR2TRA( 0,str);
//
//
// test conditions for exit of inflation traj
//
      if( nM2==0 ){
         return ENDSTATE=0;
      }
      if( gTOT>( zTOT +dTOT) ){
         return ENDSTATE=0;
      }
      double dRHO( 1.00e-8);
      {
         int iU3=0;
         for(int iT= 0;iT<enp.oT;iT++){
            if( enp.Tb[iT] ){
               double z= ( enp.U3chi(iU3) -enp.Tr_pre(iT));
               dRHO+=z*z;
               iU3++;
            }
         }
         for(int iH= 0;iH<enp.oH;iH++){
            if( enp.Hb[iH] ){
               double z= ( enp.U3chi(iU3) -enp.Hr_pre(iH));
               dRHO+=z*z;
               iU3++;
            }
         }
         dRHO= std::sqrt( dRHO/double( oU3));
      }
      if( dRHO>( 1.20) ){
         return ENDSTATE=0;
      }
      if( (nM2< 4)&&
          (gTOT<( zTOT +( 4.00) +double(iM2)*( 1.00))) ){
         return ENDSTATE=0;
      }
//
//
// set point of reference for target func Fz
//
      for(int iU2= 0;iU2<oU2;iU2++){
         enp.U2chi_por(iU2)= enq.U2chi(iU2);
      }
//
//
// set component bias for move to transition state
//
      if( iM2> 0 ){
         if( rd<( .15) ){
            loq.iCYC=((++loq.iCYC)%5);
         }
      }
      out.FILE3<<"GENTLE ASCENT TRAJECTORY\n";
      out.FILE3<<std::fixed;
      out.FILE3<<" iCYC="<<std::setw( 1)<<loq.iCYC
               <<'['
               <<(loq.CYCE(loq.iCYC)? 'e':' ')
               <<(loq.CYCS(loq.iCYC)? 's':' ')
               <<(loq.CYCT(loq.iCYC)? 't':' ')
               <<(loq.CYCH(loq.iCYC)? 'h':' ')
               <<(loq.CYCM(loq.iCYC)? 'm':' ')
               <<(loq.CYCW(loq.iCYC)? 'w':' ')
               <<"]\n";
//
//
// initiate direction bias
//
      for(int iU2= 0;iU2<oU2;iU2++){
         enq.U2dt(iU2)= (0.00);
      }
//
//
// optimization of generalized coords to transiton state on restchm
//
      out.VERBOSE=true;
      loq.BETA=( 2.50e-02);
      loq.BETA*=std::sqrt( oU2);
      loq.BMIN=( 2.00e-04);
      loq.BMIN*=std::sqrt( oU2);
      loq.BMAX=( 5.00e-02);
      loq.BMAX*=std::sqrt( oU2);
      loq.EPS1=( 1.00e-03);
      loq.EPS1= oU2*loq.EPS1*loq.EPS1;
      INFLATE=true;
      loq.nM2=512;
      std::cout<<" GENTLE ASCENT TRAJECTORY"<< std::endl;
      loq.TRA_LOQ(physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep,
                  enq,INFLATE);
      loq.TRA_LOQ_WRT(physics_consts,residue_mappings,
                      out,str,mol,con,dep,
                      enq,INFLATE);
      out.VERBOSE=true;
      str.CAR(physics_consts,residue_mappings);
      double ri= str.SUP(physics_consts,out,xtra);
//
//
// avoid change to energy surf st current U2chi remains a transition state
//
      for(int iU2= 0;iU2<oU2;iU2++){
         ene.U2chi(iU2)= enq.U2chi(iU2);
      }
      for(int iF2= 0;iF2<oF2;iF2++){
         ene.F2[iF2].fq= enq.F2[iF2].fq;
         ene.F2[iF2].D= enq.F2[iF2].D;
         ene.F2[iF2].A= enq.F2[iF2].A;
      }
      ene.ethresh= enq.ethresh;
      ene.E4RESET=false;
      for(int iR0= 0;iR0<enq.oR0;iR0++){
         for(int jR0= 0;jR0<enq.oR0;jR0++){
            ene.R0R0(iR0,jR0).b=enq.R0R0(iR0,jR0).b;
         }
      }
      ene.oD=enq.oD;
      ene.oA=enq.oA;
      ene.o_DAF2F2.clear();
      ene.o_DAF2F2.resize(enq.oD*enq.oA, -1);
      for(int iD= 0;iD<enq.oD;iD++){
         for(int iA= 0;iA<enq.oA;iA++){
            ene.DAF2F2(iD,iA)=enq.DAF2F2(iD,iA);
         }
      }
      ene.oF2F2=enq.oF2F2;
      ene.o_F2F2.clear();
      ene.o_F2F2.resize(enq.oF2F2);
      for(int iF2F2= 0;iF2F2<enq.oF2F2;iF2F2++){
         ene.F2F2(iF2F2).b=enq.F2F2(iF2F2).b;
         ene.F2F2(iF2F2).iF2=enq.F2F2(iF2F2).iF2;
         ene.F2F2(iF2F2).jF2=enq.F2F2(iF2F2).jF2;
      }
      ene.nE4=enq.nE4;
      ene.E4.clear();
      ene.E4.resize(enq.nE4);
      for(int iE4= 0;iE4<enq.nE4;iE4++){
         ene.E4[iE4].iF2=enq.E4[iE4].iF2;
         ene.E4[iE4].jF2=enq.E4[iE4].jF2;
         ene.E4[iE4].kF2=enq.E4[iE4].kF2;
         ene.E4[iE4].lF2=enq.E4[iE4].lF2;
         ene.E4[iE4].f= enq.E4[iE4].f;
      }
//
//
// target func surface wrt params
//
      std::cout<<" STEP IN PARAMETER SPACE"<< std::endl;
      out.FILE3<<"STEP IN PARAMETER SPACE\n";
      enp.TRA_ENP(physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep,
                  enq,ene);
      TRA_LOP_BACKUP(lag,enp,ene);

      M2e(iM2).F= ene.TOT;
      M2e(iM2).Fr= ene.Fr;
      M2e(iM2).Fe= ene.Fe;
      M2e(iM2).Fs= ene.Fs;
      M2e(iM2).Ft= ene.Ft;
      M2e(iM2).Fc= ene.Fc;
      M2e(iM2).Fb= ene.Fb;
      M2e(iM2).Fh= ene.Fh;
      M2e(iM2).Fw= ene.Fw;
      M2e(iM2).Fp= ene.Fp;
      M2e(iM2).Fp_a= ene.Fp_a;
      M2e(iM2).Fp_b= ene.Fp_b;
      M2e(iM2).Fp_c= ene.Fp_c;
      M2e(iM2).Fp_d= ene.Fp_d;
      M2e(iM2).Fp_e= ene.Fp_e;

      M2t(iM2).F= enp.TOT;
      M2t(iM2).Fw= enp.Fw;
      M2t(iM2).Fy= enp.Fy;
      M2t(iM2).Fz= enp.Fz;
      M2t(iM2).z= enp.z;
      M2t(iM2).lamda= enp.lamda;
      M2t(iM2).s= enp.s;
      M2t(iM2).delf= enp.delf;

      M2[iM2].tot= lag.TOT;
      double zz= lag.gradient();
      M2[iM2].z= zz;
      for(double beta1= BETA;
          beta1> std::sqrt( oU3)*( 4.00e-4);
          beta1*=( .40)){
         M2[iM2].bet= beta1;

         for(ck1=(iM2>0)? 6: 3;ck1>0;ck1--){
            TRA_LOQ_INITLAMDA(lag,ck1,beta1);
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
         }
         if( ck1==0 ){
            return ENDSTATE=1;
         }

         M2[iM2].k1=(iM2>0)? (6-ck1): (3-ck1);
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         double dxx;
         double xx=lag.length(dxx);
         M2[iM2].s0= xx;
         M2[iM2].ds0= dxx;

         int k2=0;
         for(ck2=4;ck2>0;ck2--){
            if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
            if( lag.lamda<=(0.00) )break;

            M2[iM2].k4[k2]=100;
            for(ck4=10;ck4>0;ck4--){
               for(int ii=0;ii<10;ii++){
                  lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
               }
               lag.normalize();
            }

            double dlamda= lag.lamdastep(beta1);
            M2[iM2].lam1[k2]= lag.lamda;

            for(ck5=30;ck5>0;ck5--){
               lag.diagonal();
               bool pd=lag.lower();
               if( pd )break;
               lag.lamda+=dlamda;
               M2[iM2].lam1[k2]= lag.lamda;
               dlamda*=(2.00);
            }
            if( ck5==0 ){
               return ENDSTATE=2;
            }

            M2[iM2].k5[k2]=(30-ck5);
            lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
            lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
            xx=lag.length(dxx);
            M2[iM2].s1[k2]= xx;
            M2[iM2].ds1[k2]= dxx;
            k2++;
         }

         M2[iM2].k2=(4-ck2);
         for(ck3=32;ck3>0;ck3--){
            if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
            lag.lamdastep(beta1,xx,dxx);
            lag.diagonal();
            bool pd=lag.lower();
            if( !pd ){
               return ENDSTATE=3;
            }
            lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
            lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
            xx=lag.length(dxx);
         }

         M2[iM2].k3=(32-ck3);

         M2[iM2].lam2= lag.lamda;
         M2[iM2].s2= xx;
         M2[iM2].ds2= dxx;
         M2[iM2].delF= lag.deltaf();
         if( std::abs( M2[iM2].delF)< (24.00) )break;
      }
      TRA_LOP_UPDATE(physics_consts,out,mol,con,lag,enp,ene,enq);
//
//
// transfer updated conf ene.U2chi to enq
//
      for(int iU2= 0;iU2<oU2;iU2++){
         enq.U2chi(iU2)= ene.U2chi(iU2);
      }
//
//
// transfer updated conf ene.U2chi to str
//
      {
         int iU2=0;
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            if( con.Z0[iZ0].sub ){
               dep.Z0[iZ0].trans(0)= ene.U2chi(iU2  );
               dep.Z0[iZ0].trans(1)= ene.U2chi(iU2+1);
               dep.Z0[iZ0].trans(2)= ene.U2chi(iU2+2);
               dep.Z0[iZ0].rot(0)= ene.U2chi(iU2+3);
               dep.Z0[iZ0].rot(1)= ene.U2chi(iU2+4);
               dep.Z0[iZ0].rot(2)= ene.U2chi(iU2+5);
               iU2+=6;
               str.Z0[iZ0].trans=dep.Z0[iZ0].trans;
               str.Z0[iZ0].rot=dep.Z0[iZ0].rot;
            }
         }
         for(int iZ0= 0;iZ0<oZ0;iZ0++){
            int mQ2=con.Z0[iZ0].Q2a;
            int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               dep.Q2[iQ2].chi= ene.U2chi(iU2);
               iU2++;
            }
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
//       int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         int mQ1=mol.Z0[iZ0].Q1a;
         int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               dep.Q1[iQ1].chi= dep.Q2[++iQ2].chi;
            }
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ1=mol.Z0[iZ0].Q1a;
         int iQ1bb=(mQ1+1);
         int iQ1sc=(mQ1+mol.Z0[iZ0].cQ1bb);
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL0=str.R0[iR0].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            if( nQ0>=mQ0 ){
               for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                  int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
                  std::string tor=mol.Q1[iQ1].tor;
                  int jR0=( tor=="OMG" )? iR0-1 : iR0;
                  int mT1=str.R0[jR0].T1a;
                  int nT1=(mT1-1+str.R0[jR0].cT1);
                  for(int iT1=mT1;iT1<=nT1;iT1++){
                     if( str.T1[iT1].tor==tor ){
                        str.T1[iT1].chi= (dep.Q1[iQ1].chi/physics_consts.RAD);
                        tor="xxx";
                     }
                  }
                  if( tor!="xxx" ){
                     std::cerr<<"ERROR: Unmatched torsion angle name."
                              <<" iZ0="<< std::setw( 2)<<iZ0
                              <<" iR0="<< std::setw( 4)<<iR0
                              <<" aa="<<str.R0[iR0].aa
                              <<" tor="<<tor<<".\n";
                     std::exit( 3);
                  }
               }
            }
         }
      }
      nM2--;
   }
}
