#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <iomanip>

void Energy_Surfq::TRA_ENQ_XQ(Tra_Automatic& aut,
                              const DAT_ARRAY_CONSTS& array_consts,
                              Output_Streams& out,
                              const Mechanical_System& mol,
                              const Subset_Contracted_System::tM3& con,
                              const Conf_Dependent_System& dep){

   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);

      Coordinates TRANS;
      double alp,bet,gam;
      if( !con.Z0[iZ0].sub ){
         TRANS=dep.Z0[iZ0].trans;
         alp= dep.Z0[iZ0].rot(0);
         bet= dep.Z0[iZ0].rot(1);
         gam= dep.Z0[iZ0].rot(2);
      }else{
         int iU2=Z0[iZ0].U2a;
         TRANS(0)= U2chi(iU2  );
         TRANS(1)= U2chi(iU2+1);
         TRANS(2)= U2chi(iU2+2);
         alp= U2chi(iU2+3);
         bet= U2chi(iU2+4);
         gam= U2chi(iU2+5);
      }
      Rotation_Matrix ROT(alp,bet,gam);
      Q2[mQ2].c= ROT;
      Q2[mQ2].x= TRANS;

      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         aut.F2[iF2].x.generate(TRANS,
                                ROT,
                                dep.F2[iF2].x);
         aut.F2[iF2].q.rotate(array_consts,
                              ROT,
                              dep.F2[iF2].q);
         aut.F2[iF2].p.rotate(array_consts,
                              ROT,
                              dep.F2[iF2].p);
         if( !con.F2[iF2].ion ){
         }else{
            aut.F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
         }
      }

      for(int jZ0= 0;jZ0<iZ0;jZ0++){
         Coordinates t=( Q2[mQ2].x -Q2[con.Z0[jZ0].Q2a].x);
         for(int j=0;j<3;j++){
            Coordinates b= array_consts.dROTx[j]*t;
            for(int i=0;i<3;i++){
               Z0Z0y(jZ0,iZ0)(i,j)= b(i);
            }
         }
      }

      if( nQ2>mQ2 ){
         aut.PR[ 0]= ROT;

         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int br=con.Q2[iQ2].br;
            int cbr=con.Q2[iQ2].cbr;
            aut.PR[br].extend(aut.PR[cbr],
                              dep.Q2[iQ2].tu,
                              U2chi(Q2[iQ2].U2));
            Q2[iQ2].c= aut.PR[br];
            Q2[iQ2].x= aut.F2[con.Q2[iQ2].bseF2].x;
            Coordinates c;
            c(0)= Q2[iQ2].c(0,0);
            c(1)= Q2[iQ2].c(1,0);
            c(2)= Q2[iQ2].c(2,0);
            for(int jZ0= 0;jZ0<oZ0;jZ0++){
               Coordinates x=Q2[iQ2].x;
               if( !con.Z0[jZ0].sub ){
                  x-=dep.Z0[jZ0].trans;
               }else{
                  int jU2=Z0[jZ0].U2a;
                  x(0)-=U2chi(jU2  );
                  x(1)-=U2chi(jU2+1);
                  x(2)-=U2chi(jU2+2);
               }
               Z0Q2y(jZ0,iQ2)= cross(c,x);
            }
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               aut.F2[iF2].x.generate(aut.F2[con.Q2[iQ2].bseF2].x,
                                      aut.PR[br],
                                      dep.G3[iG3].b);
               aut.F2[iF2].q.rotate(array_consts,
                                    aut.PR[br],
                                    dep.F2[iF2].q);
               aut.F2[iF2].p.rotate(array_consts,
                                    aut.PR[br],
                                    dep.F2[iF2].p);
               if( !con.F2[iF2].ion ){
               }else{
                  aut.F2[iF2].q.r(0,0)+=( .375)*con.F2[iF2].off;
               }
            }
         }
      }

      int mQ3=con.Z0[iZ0].Q3a;
      int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
      int jQ3=(con.Q2[mQ2].Q3a-1+con.Q2[mQ2].cQ3);
      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         if( con.Q3[iQ3].lte==0 )continue;
         int pQ1min=con.Q3[iQ3].Q1a;
         int pQ1max=(pQ1min-1+con.Q3[iQ3].cQ1);

         aut.Q3[iQ3].x.zero();
         int nF2=0;
         for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            int i_3min=con.Q1[iQ1].G3a;
            int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=( iQ3<=jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               aut.Q3[iQ3].x+=aut.F2[iF2].x;
               nF2++;
            }
         }
         aut.Q3[iQ3].x/=nF2;

         aut.Q3[iQ3].q.zero();
         aut.Q3[iQ3].r= (3.20);
         for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            int i_3min=con.Q1[iQ1].G3a;
            int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=( iQ3<=jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               Coordinates zD=( aut.Q3[iQ3].x -aut.F2[iF2].x);
               aut.Q3[iQ3].q.translate(array_consts,zD,aut.F2[iF2].q);
               double zR= zD.r();
               if( ( zR +(3.20))>aut.Q3[iQ3].r ){
                  aut.Q3[iQ3].r=( zR +(3.20));
               }
            }
         }
      }

      for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
         int pQ1min=con.Q3[iQ3].Q1a;
         int pQ1max=(pQ1min-1+con.Q3[iQ3].cQ1);
         for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
            int iQ1=con.Q1[pQ1].ord;
            if( con.Q1[iQ1].lte==0 )continue;
            int i_3min=con.Q1[iQ1].G3a;
            int i_3max=(i_3min-1+con.Q1[iQ1].cG3);

            aut.Q1[iQ1].x.zero();
            int nF2=0;
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=( iQ3<=jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               aut.Q1[iQ1].x+=aut.F2[iF2].x;
               nF2++;
            }
            aut.Q1[iQ1].x/=nF2;

            aut.Q1[iQ1].q.zero();
            aut.Q1[iQ1].r= (3.20);
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=( iQ3<=jQ3 )? con.B3[i_3].F2: con.G3[i_3].F2;
               if( con.F2[iF2].lte<0 )continue;
               Coordinates zD=( aut.Q1[iQ1].x -aut.F2[iF2].x);
               aut.Q1[iQ1].q.translate(array_consts,zD,aut.F2[iF2].q);
               double zR= zD.r();
               if( ( zR +(3.20))>aut.Q1[iQ1].r ){
                  aut.Q1[iQ1].r=( zR +(3.20));
               }
            }
         }
      }

      int mX2=con.Z0[iZ0].X2a;
      int nX2=(mX2-1+con.Z0[iZ0].cX2);
      for(int iX2=mX2;iX2<=nX2;iX2++){
         if( con.X2[iX2].lte==0 )continue;
         int pX1min=con.X2[iX2].X1a;
         int pX1max=(pX1min-1+con.X2[iX2].cX1);

         aut.X2[iX2].x.zero();
         int nF2=0;
         for(int pX1=pX1min;pX1<=pX1max;pX1++){
            int iX1=con.X1[pX1].ord;
            int iF2min=con.X1[iX1].F2a;
            int iF2max=(iF2min-1+con.X1[iX1].cF2);
            for(int iF2=iF2min;iF2<=iF2max;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               aut.X2[iX2].x+=aut.F2[iF2].x;
               nF2++;
            }
         }
         aut.X2[iX2].x/=nF2;

         aut.X2[iX2].q.zero();
         aut.X2[iX2].r= (3.20);
         for(int pX1=pX1min;pX1<=pX1max;pX1++){
            int iX1=con.X1[pX1].ord;
            int iF2min=con.X1[iX1].F2a;
            int iF2max=(iF2min-1+con.X1[iX1].cF2);
            for(int iF2=iF2min;iF2<=iF2max;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               Coordinates zD=( aut.X2[iX2].x -aut.F2[iF2].x);
               aut.X2[iX2].q.translate(array_consts,zD,aut.F2[iF2].q);
               double zR= zD.r();
               if( ( zR +(3.20))>aut.X2[iX2].r ){
                  aut.X2[iX2].r=( zR +(3.20));
               }
            }
         }
      }

      for(int iX2=mX2;iX2<=nX2;iX2++){
         int pX1min=con.X2[iX2].X1a;
         int pX1max=(pX1min-1+con.X2[iX2].cX1);
         for(int pX1=pX1min;pX1<=pX1max;pX1++){
            int iX1=con.X1[pX1].ord;
            if( con.X1[iX1].lte==0 )continue;
            int iF2min=con.X1[iX1].F2a;
            int iF2max=(iF2min-1+con.X1[iX1].cF2);

            aut.X1[iX1].x.zero();
            int nF2=0;
            for(int iF2=iF2min;iF2<=iF2max;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               aut.X1[iX1].x+=aut.F2[iF2].x;
               nF2++;
            }
            aut.X1[iX1].x/=nF2;

            aut.X1[iX1].q.zero();
            aut.X1[iX1].r= (3.20);
            for(int iF2=iF2min;iF2<=iF2max;iF2++){
               if( con.F2[iF2].lte<0 )continue;
               Coordinates zD=( aut.X1[iX1].x -aut.F2[iF2].x);
               aut.X1[iX1].q.translate(array_consts,zD,aut.F2[iF2].q);
               double zR= zD.r();
               if( ( zR +(3.20))>aut.X1[iX1].r ){
                  aut.X1[iX1].r=( zR +(3.20));
               }
            }
         }
      }

   }

// out.FILE3<< std::fixed;
// for(int iZ0= 0;iZ0<oZ0;iZ0++){
//    int mQ1=mol.Z0[iZ0].Q1a;
//    int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
//    for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
//       int Lmax=con.Q1[iQ1].lte;
//       if( Lmax==0 )continue;
//       out.FILE3<<" iQ1="<< std::setw( 5)<<iQ1
//                <<" x="<<aut.Q1[iQ1].x<< std::setprecision(2)
//                <<" r="<< std::setw( 6)<< aut.Q1[iQ1].r
//                <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//       out.FILE3<<aut.Q1[iQ1].q;
//    }
//    int mX1=(mQ1+1);
//    int nX1=nQ1;
//    if( nX1>=mX1 ){
//       for(int iX1=mX1;iX1<=nX1;iX1++){
//          int Lmax=con.X1[iX1].lte;
//          if( Lmax==0 )continue;
//          out.FILE3<<" iX1="<< std::setw( 5)<<iX1
//                   <<" x="<<aut.X1[iX1].x<< std::setprecision(2)
//                   <<" r="<< std::setw( 6)<< aut.X1[iX1].r
//                   <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//          out.FILE3<<aut.X1[iX1].q;
//       }
//    }
//    int mQ3=con.Z0[iZ0].Q3a;
//    int nQ3=(mQ3-1+con.Z0[iZ0].cQ3);
//    for(int iQ3=mQ3;iQ3<=nQ3;iQ3++){
//       int Lmax=con.Q3[iQ3].lte;
//       if( Lmax==0 )continue;
//       out.FILE3<<" iQ3="<< std::setw( 5)<<iQ3
//                <<" x="<<aut.Q3[iQ3].x<< std::setprecision(2)
//                <<" r="<< std::setw( 6)<< aut.Q3[iQ3].r
//                <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//       out.FILE3<<aut.Q3[iQ3].q;
//    }
//    int mX2=con.Z0[iZ0].X2a;
//    int nX2=(mX2-1+con.Z0[iZ0].cX2);
//    if( nX2>=mX2 ){
//       for(int iX2=mX2;iX2<=nX2;iX2++){
//          int Lmax=con.X2[iX2].lte;
//          if( Lmax==0 )continue;
//          out.FILE3<<" iX2="<< std::setw( 5)<<iX2
//                   <<" x="<<aut.X2[iX2].x<< std::setprecision(2)
//                   <<" r="<< std::setw( 6)<< aut.X2[iX2].r
//                   <<" lte="<< std::setw( 1)<<Lmax<<'\n';
//          out.FILE3<<aut.X2[iX2].q;
//       }
//    }
// }
   return;
}
