#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_WPAR(Tra_Automatic& aut,
                                const DAT_PHYSICS_CONSTS& physics_consts,
                                const Subset_Contracted_System::tM3& con){
//
//
// isolate subset of F2 on which Fw is dependent
//
   aut.DOT.clear();
   int oDOT=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mB3=con.Z0[iZ0].B3a;
      int nB3=(mB3-1+con.Z0[iZ0].cB3);
      for(int iB3=mB3;iB3<=nB3;iB3++){
         int iF2=con.B3[iB3].F2;
         if( con.F2[iF2].typ==30 ){
            if( con.F2[iF2].u(0)<=( 0.00) ){
            }else{
               aut.DOT.push_back( Tra_Automatic::tDOT());
               aut.DOT[oDOT++].F2=iF2;
            }
         }else{
            if( con.F2[iF2].mu==1 ){
               aut.DOT.push_back( Tra_Automatic::tDOT());
               aut.DOT[oDOT++].F2=iF2;
            }
         }
      }
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            int mG3=con.Q2[iQ2].G3a;
            int nG3=(mG3-1+con.Q2[iQ2].cG3);
            for(int iG3=mG3;iG3<=nG3;iG3++){
               int iF2=con.G3[iG3].F2;
               if( con.F2[iF2].typ==30 ){
                  if( con.F2[iF2].u(0)<=( 0.00) ){
                  }else{
                     aut.DOT.push_back( Tra_Automatic::tDOT());
                     aut.DOT[oDOT++].F2=iF2;
                  }
               }else{
                  if( con.F2[iF2].mu==1 ){
                     aut.DOT.push_back( Tra_Automatic::tDOT());
                     aut.DOT[oDOT++].F2=iF2;
                  }
               }
            }
         }
      }
   }
//
//
// map DOT to grid
//
   for(int i= 0;i<35937;i++){
      aut.G5G5G5(i).n=0;
      aut.G5G5G5(i).i=-1;
   }
   Coordinates xMIN;                    //min value of dot coords
   Coordinates xMAX;                    //max value of dot coords
   Coordinates xMID;                    //mid value of dot coords
   Coordinates xDEL;                    //bin size of grid
   for(int i=0;i<3;i++){
      xMIN(i)=( 1.00e+6);
      xMAX(i)=(-1.00e+6);
      for(int iDOT= 0;iDOT<oDOT;iDOT++){
         int iF2=aut.DOT[iDOT].F2;
         if( aut.F2[iF2].x(i)<xMIN(i) )xMIN(i)= aut.F2[iF2].x(i);
         if( aut.F2[iF2].x(i)>xMAX(i) )xMAX(i)= aut.F2[iF2].x(i);
      }
      xMID(i)=( xMIN(i) +xMAX(i))/(2.00);
      xDEL(i)=( xMAX(i) -xMIN(i) +(.02))/(33.00);
      if( xDEL(i)<((4.00)/physics_consts.ANG) ){
         xDEL(i)= ((4.00)/physics_consts.ANG);
      }
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int iF2=aut.DOT[iDOT].F2;
      int iG5[3];
      for(int i=0;i<3;i++){
         double z=( aut.F2[iF2].x(i) -xMID(i))/xDEL(i);
         iG5[i]=int( std::floor( (.50) +z));
      }
      aut.DOT[iDOT].G5= 1089*(iG5[0]+16)
                         +33*(iG5[1]+16)
                            +(iG5[2]+16);
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int i=aut.DOT[iDOT].G5;
      aut.G5G5G5(i).n++;
   }
   {
      int iDOT=0;
      for(int i= 0;i<35937;i++){
         if( aut.G5G5G5(i).n==0 )continue;
         aut.G5G5G5(i).i=iDOT;
         iDOT+=aut.G5G5G5(i).n;
      }
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int i=aut.DOT[iDOT].G5;
      aut.DOT[aut.G5G5G5(i).i++].ord=iDOT;
   }
   for(int i= 0;i<35937;i++){
      if( aut.G5G5G5(i).n==0 )continue;
      aut.G5G5G5(i).i-=aut.G5G5G5(i).n;
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      aut.DOT[aut.DOT[iDOT].ord].inv=iDOT;
   }
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int jDOT=aut.DOT[iDOT].ord;
      int kDOT=aut.DOT[iDOT].inv;
      int L=aut.DOT[iDOT].F2;
      aut.DOT[iDOT].F2=aut.DOT[jDOT].F2;
      aut.DOT[jDOT].F2=L;
      L=aut.DOT[iDOT].G5;
      aut.DOT[iDOT].G5=aut.DOT[jDOT].G5;
      aut.DOT[jDOT].G5=L;
      aut.DOT[iDOT].ord=iDOT;
      aut.DOT[iDOT].inv=iDOT;
      aut.DOT[kDOT].ord=jDOT;
      aut.DOT[jDOT].inv=kDOT;
   }
//
//
// volume of hydration site excluded by protein
//
   for(int aG5=-16;aG5<= 16;aG5++){
      int iG5min=(aG5-3);
      int iG5max=(aG5+3);
      if( iG5min<-16 )iG5min=-16;
      if( iG5max> 16 )iG5max= 16;
      for(int bG5=-16;bG5<= 16;bG5++){
         int jG5min=(bG5-3);
         int jG5max=(bG5+3);
         if( jG5min<-16 )jG5min=-16;
         if( jG5max> 16 )jG5max= 16;
         for(int cG5=-16;cG5<= 16;cG5++){
            int kG5min=(cG5-3);
            int kG5max=(cG5+3);
            if( kG5min<-16 )kG5min=-16;
            if( kG5max> 16 )kG5max= 16;
            int i=( 1089*(aG5+16) +33*(bG5+16) +(cG5+16));
            if( aut.G5G5G5(i).n==0 )continue;
            int iDOTmin=aut.G5G5G5(i).i;
            int iDOTmax=(iDOTmin-1+aut.G5G5G5(i).n);
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               int iF2=aut.DOT[iDOT].F2;
               if( con.F2[iF2].typ!=30 )continue;
               aut.F2[iF2].v= (0.00);
               for(int iG5=iG5min;iG5<=iG5max;iG5++){
                  for(int jG5=jG5min;jG5<=jG5max;jG5++){
                     for(int kG5=kG5min;kG5<=kG5max;kG5++){
                        int j=( 1089*(iG5+16) +33*(jG5+16) +(kG5+16));
                        if( aut.G5G5G5(j).n==0 )continue;
                        int jDOTmin=aut.G5G5G5(j).i;
                        int jDOTmax=(jDOTmin-1+aut.G5G5G5(j).n);
                        for(int jDOT=jDOTmin;jDOT<=jDOTmax;jDOT++){
                           int jF2=aut.DOT[jDOT].F2;
                           if( con.F2[jF2].typ==30 )continue;
                           double RR=( aut.F2[jF2].x -aut.F2[iF2].x).rr();
                           double v= pairf(physics_consts,
                                           con.F2[iF2].gau,con.F2[jF2].gau,
                                           RR);
                           aut.F2[iF2].v+=v;
                        }
                     }
                  }
               }
            }
         }
      }
   }
//
//
// calc 1st and 2nd derivs of energy wrt v
//
   for(int iDOT= 0;iDOT<oDOT;iDOT++){
      int iF2=aut.DOT[iDOT].F2;
      if( con.F2[iF2].typ!=30 )continue;
      double x=( con.F2[iF2].u(1)*aut.F2[iF2].v -con.F2[iF2].u(2));
      double ztanh= std::tanh( x);
      aut.F2[iF2].g= con.F2[iF2].u(0)*( (1.00) -ztanh*ztanh)
                    *con.F2[iF2].u(1);
      aut.F2[iF2].h= (-2.00)*ztanh*aut.F2[iF2].g
                    *con.F2[iF2].u(1);
   }
   return;
}
