#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_WM(Tra_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ARRAY_CONSTS& array_consts,
                              const Subset_Contracted_System::tM3& con,
                              int jF2,
                              int kQ2,
                              int jZ0,
                              int iF2,
                              int iQ2,
                              int iZ0){
//
//
// screen site pair
//
   if( con.F2[iF2].typ==30 ){
      if( con.F2[iF2].u(0)<=( 0.00) )return;
      if( con.F2[jF2].typ==30 ){
         return;
      }else{
         if( WTARGET )return;
         if( con.F2[jF2].mu!=1 )return;
//
//
// derivs of Fw
//
         double g= aut.F2[iF2].g;
         aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
         aut.RR= aut.x.rr();
         if( aut.RR>( 576.) )return;
         aut.R= std::sqrt( aut.RR);
         if( aut.R<( 1.00e-12) )aut.R=( 1.00e-12);
         double e= pairfga(physics_consts,
                           con.F2[jF2].gau,con.F2[iF2].gau,
                           aut.R,
                           aut.dedr,aut.ddedrdr);
         if( F2F2E2(jF2,iF2)==-1 ){
            TRA_ENQ_E2(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0);
            E2[nE2- 1].dv= aut.dedr/((2.00)*aut.R);
         }
         aut.dedr*=g;
         aut.ddedrdr*=g;
      }
   }else{
      if( con.F2[jF2].typ==30 ){
         if( WTARGET )return;
         if( con.F2[jF2].u(0)<=( 0.00) )return;
         if( con.F2[iF2].mu!=1 )return;
//
//
// derivs of Fw
//
         double g= aut.F2[jF2].g;
         aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
         aut.RR= aut.x.rr();
         if( aut.RR>( 576.) )return;
         aut.R= std::sqrt( aut.RR);
         if( aut.R<( 1.00e-12) )aut.R=( 1.00e-12);
         double e= pairfga(physics_consts,
                           con.F2[jF2].gau,con.F2[iF2].gau,
                           aut.R,
                           aut.dedr,aut.ddedrdr);
         if( F2F2E2(jF2,iF2)==-1 ){
            TRA_ENQ_E2(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0);
            E2[nE2- 1].dv= aut.dedr/((2.00)*aut.R);
         }
         aut.dedr*=g;
         aut.ddedrdr*=g;
      }else{
         if( MTARGET )return;
//
//
// derivs of Fm
//
         if      ( (con.F2[jF2].zet==1)&&
                   (con.F2[iF2].zet==1) ){
            aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
            aut.RR= aut.x.rr();
            aut.R= std::sqrt( aut.RR);
            if( aut.R<( 1.00e-12) )aut.R=( 1.00e-12);
            aut.dedr= (0.00);
            aut.ddedrdr=(0.00);
            double zF1= fac_m2*(2.00)*F2[iF2].fq*F2[jF2].fq;
            double zG2,zA2;
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  double zF2= eefga(physics_consts,
                                    con.F2[iF2].ef[i],
                                    con.F2[jF2].ef[j],
                                    aut.R,
                                    zG2,zA2);
//                Fm+=(zF1*zF2);
                  aut.dedr+=(zF1*zG2);
                  aut.ddedrdr+=(zF1*zA2);
               }
            }
            zF1= fac_m3*(2.00)*F2[iF2].fq*F2[jF2].fq;
            for(int kF2= 0;kF2<oF2;kF2++){
               if( con.F2[kF2].kap==0 )continue;
               double Rik=( aut.F2[iF2].x -aut.F2[kF2].x).r();
               double Rjk=( aut.F2[jF2].x -aut.F2[kF2].x).r();
               for(int i=0;i<4;i++){
                  for(int j=0;j<4;j++){
                     double zF2= eevfga(physics_consts,
                                        con.F2[iF2].ef[i],
                                        con.F2[jF2].ef[j],
                                        con.F2[kF2].vf,
                                        aut.R,
                                        Rik,
                                        Rjk,
                                        zG2,zA2);
//                   Fm+=(zF1*zF2);
                     aut.dedr+=(zF1*zG2);
                     aut.ddedrdr+=(zF1*zA2);
                  }
               }
            }
            if( F2F2E2(jF2,iF2)==-1 ){
               TRA_ENQ_E2(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0);
            }
         }else if( (con.F2[jF2].zet==1)&&
                   (con.F2[iF2].kap==1) ){
            aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
            aut.RR= aut.x.rr();
            aut.R= std::sqrt( aut.RR);
            if( aut.R<( 1.00e-12) )aut.R=( 1.00e-12);
            aut.dedr= (0.00);
            aut.ddedrdr=(0.00);
            double zF1= fac_m3*F2[jF2].fq;
            double zG2,zA2;
            for(int kF2= 0;kF2<oF2;kF2++){
               if( con.F2[kF2].zet==0 )continue;
               double z=(( kF2==jF2 )? (1.00): (2.00))
                       *F2[kF2].fq;
               double Rik=( aut.F2[iF2].x -aut.F2[kF2].x).r();
               double Rjk=( aut.F2[jF2].x -aut.F2[kF2].x).r();
               for(int j=0;j<4;j++){
                  for(int k=0;k<4;k++){
                     double zF2= evefga(physics_consts,
                                        con.F2[jF2].ef[j],
                                        con.F2[kF2].ef[k],
                                        con.F2[iF2].vf,
                                        Rjk,
                                        aut.R,
                                        Rik,
                                        zG2,zA2);
//                   Fm+=(zF1*z*zF2);
                     aut.dedr+=(zF1*z*zG2);
                     aut.ddedrdr+=(zF1*z*zA2);
                  }
               }
            }
            if( F2F2E2(jF2,iF2)==-1 ){
               TRA_ENQ_E2(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0);
            }
         }else if( (con.F2[jF2].kap==1)&&
                   (con.F2[iF2].zet==1) ){
            aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
            aut.RR= aut.x.rr();
            aut.R= std::sqrt( aut.RR);
            if( aut.R<( 1.00e-12) )aut.R=( 1.00e-12);
            aut.dedr= (0.00);
            aut.ddedrdr=(0.00);
            double zF1= fac_m3*F2[iF2].fq;
            double zG2,zA2;
            for(int kF2= 0;kF2<oF2;kF2++){
               if( con.F2[kF2].zet==0 )continue;
               double z=(( kF2==iF2 )? (1.00): (2.00))
                       *F2[kF2].fq;
               double Rik=( aut.F2[iF2].x -aut.F2[kF2].x).r();
               double Rjk=( aut.F2[jF2].x -aut.F2[kF2].x).r();
               for(int i=0;i<4;i++){
                  for(int k=0;k<4;k++){
                     double zF2= evefga(physics_consts,
                                        con.F2[iF2].ef[i],
                                        con.F2[kF2].ef[k],
                                        con.F2[jF2].vf,
                                        Rik,
                                        aut.R,
                                        Rjk,
                                        zG2,zA2);
//                   Fm+=(zF1*z*zF2);
                     aut.dedr+=(zF1*z*zG2);
                     aut.ddedrdr+=(zF1*z*zA2);
                  }
               }
            }
            if( F2F2E2(jF2,iF2)==-1 ){
               TRA_ENQ_E2(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0);
            }
         }else{
            return;
         }
      }
   }
//
//
// spherical polar coords
//
   aut.ZZ= (1.00)/aut.R;
   aut.CT= (aut.x(2)*aut.ZZ);
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
      aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }
//
//
// accumulate block pair derivatives
//
   TRA_ENQ_PART(aut,
                array_consts,
                kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
   return;
}
