#include "../phi/Conf_Dependent_System.hh"
#include "../tra/Energy_Surf.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_T1D(const DAT_PHYSICS_CONSTS& physics_consts,
                               const Conf_Dependent_System& dep,
                               int iQ2){
   int iU2=Q2[iQ2].U2;
   double g,a;
   Ft+=dep.Q2[iQ2].tau.fga(U2chi(iU2),g,a);
   U2g(iU2)+=g;
   U2U2a(iU2,iU2)+=a;
   if( OU2b(iU2) ){
      double fac= (1.25)/physics_consts.CAL;
      double d=( U2chi(iU2) -OU2chi(iU2));
      if      ( d<-physics_consts.PI ){
         d+=(2.00)*physics_consts.PI;
      }else if( d> physics_consts.PI ){
         d-=(2.00)*physics_consts.PI;
      }
      double Cd= std::cos( d);
      double Sd= std::sin( d);
      Ft+=fac*( (1.00) -Cd);
      U2g(iU2)+=fac*Sd;
      U2U2a(iU2,iU2)+=fac*Cd;
   }
   return;
}
