#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENQ_RESTCH(Tra_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  const DAT_ENERGY_PARAMS& energy_params,
                                  const Thread_Options& opt,
                                  Output_Streams& out,
                                  const Subset_Contracted_System::tM3& con,
                                  const Conf_Dependent_System& dep){
   Fr= (0.00);
   Fe= (0.00);
   Fs= (0.00);
   Ft= (0.00);
   Fc= (0.00);
   Fb= (0.00);
   Fh= (0.00);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( !con.Z0[iZ0].sub ){
         aut.TRANS=dep.Z0[iZ0].trans;
      }else{
         int iU2=Z0[iZ0].U2a;
         aut.TRANS(0)= U2chi(iU2  );
         aut.TRANS(1)= U2chi(iU2+1);
         aut.TRANS(2)= U2chi(iU2+2);
      }
//
//
// Fr, Fe, Fs, Fh
//
      int mE1=con.Z0[iZ0].E1a;
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
         aut.br=con.Q2[iQ2].br;
         if( aut.br==0 ){
            aut.BBw=iQ2;
            aut.SCa=(nQ2+1);
         }else{
            if( con.Q2[iQ2].cbr==0 )aut.SCa=iQ2;
         }
//
//
// Ft (1D component)
//
         if( iQ2>mQ2 ){
            if( !TTARGET ){
               TRA_ENQ_T1D(physics_consts,dep,iQ2);
            }
         }
         int nE1=(mE1-1+con.Q2[iQ2].cE1);
         if( nE1>=mE1 ){
            for(int iE1=mE1;iE1<=nE1;iE1++){
               TRA_ENQ_E1RESH(aut,
                              physics_consts,array_consts,energy_params,
                              con,
                              iZ0,mQ2,iQ2,iE1);
            }
            mE1+=con.Q2[iQ2].cE1;
         }
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
      }
//
//
// Ft (2D and 3D components)
//
      if( !TTARGET ){
         TRA_ENQ_T2D(con,dep,iZ0);
      }
//
//
// Fc+Fb
//
      if( !TTARGET ){
         if( con.Z0[iZ0].cC1==0 ){
         }else{
            aut.ISOTROPIC=true;
            iQ2=mQ2;
            int mC1=con.Z0[iZ0].C1a;
            int mB3=con.Z0[iZ0].B3a;
            int nB3=(mB3-1+con.Z0[iZ0].cB3);
            for(int iB3=mB3;iB3<=nB3;iB3++){
               int iF2=con.B3[iB3].F2;
               int iT2=con.F2[iF2].typ;
               if( (iT2== 7)||(iT2==30)||(iT2== 1)||(iT2== 4) )continue;
               int nC1=(mC1-1+con.B3[iB3].cC1);
               if( nC1>=mC1 ){
                  for(int iC1=mC1;iC1<=nC1;iC1++){
                     int jZ0=con.C1[iC1].Z0;
//                   int kQ2=con.C1[iC1].k;
                     int lam=con.C1[iC1].lam;
                     int jF2=con.C1[iC1].F2a;
                     if      ( lam==0 ){
                     }else if( lam==1 ){
                        jF2=con.H2[jF2].F2;
                     }else if( lam==2 ){
                        jF2=con.G3[jF2].F2;
                     }else if( lam==3 ){
                        jF2=con.B3[jF2].F2;
                     }
                     TRA_ENQ_C(aut,
                               array_consts,energy_params,
                               opt,con,
                               jF2,jZ0,iC1,iF2,iQ2,iZ0);
                  }
                  mC1+=con.B3[iB3].cC1;
               }
            }
            if( nQ2>mQ2 ){
               int iQ2=mQ2;
               int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
               for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
                  if( con.Q2[iQ2].omg==1 ){
                     int L=iQ2hold;
                     iQ2hold=(iQ2+1);
                     iQ2=L;
                  }else{
                     iQ2++;
                  }
                  int mG3=con.Q2[iQ2].G3a;
                  int nG3=(mG3-1+con.Q2[iQ2].cG3);
                  for(int iG3=mG3;iG3<=nG3;iG3++){
                     int iF2=con.G3[iG3].F2;
                     int iT2=con.F2[iF2].typ;
                     if( (iT2== 7)||(iT2==30)||(iT2== 1)||(iT2== 4) )continue;
                     int nC1=(mC1-1+con.G3[iG3].cC1);
                     if( nC1>=mC1 ){
                        for(int iC1=mC1;iC1<=nC1;iC1++){
                           int jZ0=con.C1[iC1].Z0;
//                         int kQ2=con.C1[iC1].k;
                           int lam=con.C1[iC1].lam;
                           int jF2=con.C1[iC1].F2a;
                           if      ( lam==0 ){
                           }else if( lam==1 ){
                              jF2=con.H2[jF2].F2;
                           }else if( lam==2 ){
                              jF2=con.G3[jF2].F2;
                           }else if( lam==3 ){
                              jF2=con.B3[jF2].F2;
                           }
                           TRA_ENQ_C(aut,
                                     array_consts,energy_params,
                                     opt,con,
                                     jF2,jZ0,iC1,iF2,iQ2,iZ0);
                        }
                        mC1+=con.G3[iG3].cC1;
                     }
                  }
               }
            }
         }
      }
   }
   return;
}
