#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_RESH(Tra_Automatic& aut,
                                const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_ENERGY_PARAMS& energy_params,
                                const Subset_Contracted_System::tM3& con,
                                int jF2,
                                int kQ2,
                                int jZ0,
                                int iE1,
                                int iF2,
                                int i_3,
                                int iQ2,
                                int iZ0,
                                bool EPASS){
//
//
// calc Fr, Fe, Fs, Fh
//
   int iT2=con.F2[iF2].typ;
   if( iT2==30 )return;
   int jT2=con.F2[jF2].typ;
   if( jT2==30 )return;
   int iHB=con.F2[iF2].hb;
   int jHB=con.F2[jF2].hb;
//
//
// patch (jT2,iT2) (jHB,iHB)
//
   if      ( (jHB==1)&&(iHB==2) ){
      if      ( (con.F2[jF2].atm==" H  ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 2) ){
            jT2= 1;
            jHB=3;
         }
      }else if( (con.F2[jF2].atm==" HG ")&&
                (con.F2[iF2].atm==" O  ") ){
         if( con.F2[jF2].R0==(con.F2[iF2].R0+ 1) ){
            jT2= 1;
            jHB=3;
         }
      }
   }else if( (jHB==2)&&(iHB==1) ){
      if      ( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" H  ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 2) ){
            iT2= 1;
            iHB=3;
         }
      }else if( (con.F2[jF2].atm==" O  ")&&
                (con.F2[iF2].atm==" HG ") ){
         if( con.F2[iF2].R0==(con.F2[jF2].R0+ 1) ){
            iT2= 1;
            iHB=3;
         }
      }
   }
   int LTE1=con.F2[jF2].lte;
   int LTE2=con.F2[iF2].lte;
   bool atomatom=(LTE1>=0)&&(LTE2>=0);
   int n1=con.F2[jF2].mu;
   int n2=con.F2[iF2].mu;
   bool sitesite=(n1>0)&&(n2>0);
   int iS3=-1;
   bool BLOCKEDRES=false;

   if( atomatom ){
      if( con.E1[iE1].sse==1 ){
         int i=( con.F2[jF2].sf&  7);
         int k=(con.F2[jF2].sf-i);
         if( iQ2>con.Z0[iZ0].Q2a ){
            int j=( con.G3[i_3].sg&  7);
            if( (con.G3[i_3].sg-j)==k )iS3=energy_params.S2S2S3(i,j);
         }else{
            int j=( con.B3[i_3].sb&  7);
            if( (con.B3[i_3].sb-j)==k )iS3=energy_params.S2S2S3(i,j);
         }
         if( iS3==-2 )return;
      }
      int iR0=con.F2[iF2].R0;
      int jR0=con.F2[jF2].R0;
      std::string ai=con.F2[iF2].atm;
      std::string aj=con.F2[jF2].atm;
//
//
// set BLOCKEDRES
//
      if( jZ0==iZ0 ){
         bool iACE=( (ai==" CA ")||(ai==" C  ")||(ai=="+C  ")||(ai==" O  ") );
         bool iNME=( (ai==" N  ")||(ai=="+N  ")||(ai==" H  ")||(ai==" CA ") );
         bool jACE=( (aj==" CA ")||(aj==" C  ")||(aj=="+C  ")||(aj==" O  ") );
         bool jNME=( (aj==" N  ")||(aj=="+N  ")||(aj==" H  ")||(aj==" CA ") );
         if      ( jR0==(iR0   ) ){
            BLOCKEDRES=true;
         }else if( jR0==(iR0+ 1) ){
            if( iACE||jNME ){
               BLOCKEDRES=true;
            }
         }else if( jR0==(iR0+ 2) ){
            if( iACE&&jNME ){
               BLOCKEDRES=true;
            }
         }else if( jR0==(iR0- 1) ){
            if( jACE||iNME ){
               BLOCKEDRES=true;
            }
         }else if( jR0==(iR0- 2) ){
            if( jACE&&iNME ){
               BLOCKEDRES=true;
            }
         }
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
   }else if( sitesite ){
      if( HTARGET )return;
      if( jZ0==iZ0 ){
         for(int i1= 0;i1<n1;i1++){
            for(int i2= 0;i2<n2;i2++){
               if( con.F2[iF2].fac[i2]==con.F2[jF2].fac[i1] )return;
            }
         }
      }
      aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
      aut.RR= aut.x.rr();
      if( aut.RR>( 576.) )return;
   }else{
      return;
   }

   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   aut.ZZ= (1.00)/aut.R;
   aut.CT= aut.x(2)*aut.ZZ;
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= aut.x(0)*aut.ZZ/aut.ST;
      aut.SP= aut.x(1)*aut.ZZ/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }

   aut.ISOTROPIC=true;
   if( atomatom ){
//
//
// calc Fr
//
      if( (iS3<1)&&
          (iT2!= 7)&&(jT2!= 7)&&(iT2!=29)&&(jT2!=29)&&
          (jF2!=con.F2[iF2].lnk) ){
         bool NEIGHBOR=F2F2b(jF2,iF2);
         double EPS= TTe(iT2,jT2);
         double RHO= TTr(iT2,jT2);
         if( NEIGHBOR ){
            EPS= energy_params.T2T2e(iT2,jT2);
            RHO= energy_params.T2T2r(iT2,jT2);
         }
         double Z= (aut.R/RHO);
         double Z2= Z*Z;
         double Z5= Z*Z2*Z2;
         double Z6= Z*Z5;
         double Z7= Z*Z6;
         double alp= TTa(iT2,jT2);
         if( NEIGHBOR ){
            alp= energy_params.T2T2a(iT2,jT2);
         }

         double FF  =( (1.00) +alp)
                    /( Z +alp);
         double FF3= FF*FF*FF;
         double FF4= FF*FF3;
         double FF5= FF*FF4;
         double FF6= FF*FF5;
         double FF7= FF*FF6;
         double dFF =-FF
                    /(( Z +alp)*RHO);
         double ddFF=-(2.00)*dFF
                    /(( Z +alp)*RHO);
         double GG  = (1.12)
                    /( Z7 +(.12));
         double dGG =-GG*(7.00)*Z6
                    /(( Z7 +(.12))*RHO);
         double ddGG= dGG*( (6.00)*(.12)/Z -(8.00)*Z6)
                    /(( Z7 +(.12))*RHO);

         double e=EPS*(
             FF7*( GG -(2.00))
                );
         aut.dedr= EPS*(
             (7.00)*FF6*dFF*( GG -(2.00))
            +FF7*dGG
                        );
         aut.ddedrdr= EPS*(
             (42.00)*FF5*dFF*dFF*( GG -(2.00))
            +( 7.00)*FF6*ddFF*( GG -(2.00))
            +(14.00)*FF6*dFF*dGG
            +FF7*ddGG
                           );
         Fr+=e;
         int iU3=TTiU3(iT2,jT2);
         int jU3=TTjU3(iT2,jT2);
         if( ((iU3>= 0)||
              (jU3>= 0))&&!NEIGHBOR ){
            double RHO2= RHO*RHO;
            double RHO3= RHO*RHO2;
            double RHO4= RHO*RHO3;
            double ZBUF=( Z +alp);
            double ZBUF2= ZBUF*ZBUF;
            double ZBUF3= ZBUF*ZBUF2;
            double ZBUF4= ZBUF*ZBUF3;
            double ZBUF5= ZBUF*ZBUF4;
            double Z7BUF=( Z7 +(.12));
            double Z7BUF2= Z7BUF*Z7BUF;
            double Z7BUF3= Z7BUF*Z7BUF2;
            double Z7BUF4= Z7BUF*Z7BUF3;
            double Z7BUF5= Z7BUF*Z7BUF4;
//
//
// derivatives of e wrt parameters (Te,Tr,Ta)
//
            double FF_r =-dFF*Z;
            double FF_rr=( ddFF*Z2 +dFF*(2.)*Z/RHO);
            double FF_a =( Z -(1.))
                        /ZBUF2;
            double FF_aa= (-2.)*FF_a
                        /( Z +alp);
            double FF_ra=( Z -alp -(2.))*(Z/RHO)
                        /ZBUF3;
            double GG_r =-dGG*Z;
            double GG_rr=( ddGG*Z2 +dGG*(2.)*Z/RHO);

            double e_e= e/EPS;
            double e_r= EPS*(  7.)*FF6*( GG -(2.))*FF_r
                       +EPS*FF7*GG_r;
            double e_a= EPS*(  7.)*FF6*( GG -(2.))*FF_a;
            double e_ee= (0.);
            double e_er= e_r/EPS;
            double e_ea= e_a/EPS;
            double e_rr= EPS*( 42.)*FF5*( GG -(2.))*FF_r*FF_r
                        +EPS*( 14.)*FF6*GG_r*FF_r
                        +EPS*( 7.)*FF6*( GG -(2.))*FF_rr
                        +EPS*FF7*GG_rr;
            double e_ra= EPS*( 42.)*FF5*( GG -(2.))*FF_r*FF_a
                        +EPS*(  7.)*FF6*( GG -(2.))*FF_ra
                        +EPS*(  7.)*FF6*GG_r*FF_a;
            double e_aa= EPS*( 42.)*FF5*( GG -(2.))*FF_a*FF_a
                        +EPS*(  7.)*FF6*( GG -(2.))*FF_aa;

            TRA_ENE_CHAIN(e_e,e_r,e_a,
                          e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                          iT2,jT2,
                          aut.de,aut.dde);
//
//
// accumulate parameter surface for e
//
            if( iU3>= 0 ){
               U3f(iU3)+=aut.de[1];
               U3U3f(iU3,iU3)+=aut.dde[ 1*6 +1];
            }
            if( jU3>= 0 ){
               U3f(jU3)+=aut.de[4];
               U3U3f(jU3,jU3)+=aut.dde[ 4*6 +4];
            }
            if( (iU3>= 0)&&(jU3>= 0) ){
               if( jU3<=iU3 ){
                  U3U3f(jU3,iU3)+=aut.dde[ 4*6 +1];
               }
               if( iU3<=jU3 ){
                  U3U3f(iU3,jU3)+=aut.dde[ 1*6 +4];
               }
            }
//
//
// derivatives of dedr wrt parameters (Te,Tr,Ta)
//
            double dFF_r =( (1.) +alp)*(-Z +alp)
                         /(RHO2*ZBUF3);
            double dFF_rr=( (1.) +alp)*(2.)*alp*( (2.)*Z -alp)
                         /(RHO3*ZBUF4);
            double dFF_a =(-Z +alp +(2.))
                         /(RHO*ZBUF3);
            double dFF_ra=(-Z2 +(4.)*Z*( (1.) +alp) -alp*( alp +(2.)))
                         /(RHO2*ZBUF4);
            double dFF_aa=(2.)*( (2.)*Z -alp -(3.))
                         /(RHO*ZBUF4);
            double dGG_r =(1.12)*(49.)*Z6*( (.12) -Z7)
                         /(RHO2*Z7BUF3);
            double dGG_rr=(1.12)*(49.)*Z6
                         *(-( 6.)*Z7*Z7 +(28.)*(.12)*Z7 -( 8.)*(.12)*(.12))
                         /(RHO3*Z7BUF4);

            e_e= aut.dedr/EPS;
            e_r= EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_r
                +EPS*(  7.)*FF6*GG_r*dFF
                +EPS*(  7.)*FF6*( GG -(2.))*dFF_r
                +EPS*(  7.)*FF6*dGG*FF_r
                +EPS*FF7*dGG_r;
            e_a= EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_a
                +EPS*(  7.)*FF6*( GG -(2.))*dFF_a
                +EPS*(  7.)*FF6*dGG*FF_a;
            e_ee= (0.00);
            e_er= e_r/EPS;
            e_ea= e_a/EPS;
            e_rr= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_r*FF_r
                 +EPS*( 42.)*FF5*GG_r*dFF*FF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_rr
                 +EPS*( 42.)*FF5*GG_r*dFF*FF_r
                 +EPS*(  7.)*FF6*GG_rr*dFF
                 +EPS*(  7.)*FF6*GG_r*dFF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_r
                 +EPS*(  7.)*FF6*GG_r*dFF_r
                 +EPS*(  7.)*FF6*( GG -(2.))*dFF_rr
                 +EPS*( 42.)*FF5*dGG*FF_r*FF_r
                 +EPS*(  7.)*FF6*dGG_r*FF_r
                 +EPS*(  7.)*FF6*dGG*FF_rr
                 +EPS*(  7.)*FF6*dGG_r*FF_r
                 +EPS*FF7*dGG_rr;
            e_ra= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_r*FF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_ra
                 +EPS*( 42.)*FF5*GG_r*dFF*FF_a
                 +EPS*(  7.)*FF6*GG_r*dFF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_a
                 +EPS*(  7.)*FF6*( GG -(2.))*dFF_ra
                 +EPS*( 42.)*FF5*dGG*FF_r*FF_a
                 +EPS*(  7.)*FF6*dGG*FF_ra
                 +EPS*(  7.)*FF6*dGG_r*FF_a;
            e_aa= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_a*FF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_aa
                 +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_a
                 +EPS*(  7.)*FF6*( GG -(2.))*dFF_aa
                 +EPS*( 42.)*FF5*dGG*FF_a*FF_a
                 +EPS*(  7.)*FF6*dGG*FF_aa;

            TRA_ENE_CHAIN(e_e,e_r,e_a,
                          e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                          iT2,jT2,
                          aut.ddedr,aut.dddedr);
//
//
// derivatives of ddedrdr wrt parameters (Te,Tr,Ta)
//
            double ddFF_r = (2.)*( (1.) +alp)*( Z -(2.)*alp)
                          /(RHO3*ZBUF4);
            double ddFF_a = (2.)*( Z -(2.)*alp -(3.))
                          /(RHO2*ZBUF4);
            double ddFF_rr=-(12.)*alp*( (1.) +alp)*( Z -alp)
                          /(RHO4*ZBUF5);
            double ddFF_ra= (2.)*( Z*( Z -(7.)*alp -(6.))
                                  +alp*( (4.)*alp +(6.)))
                          /(RHO3*ZBUF5);
            double ddFF_aa=-(12.)*( Z -alp -(2.))
                          /(RHO2*ZBUF5);
            double ddGG_r = (1.12)*(98.)*Z5
                          *( (4.)*Z7*Z7 -(14.)*(.12)*Z7 +(3.)*(.12)*(.12))
                          /(RHO3*Z7BUF4);
            double ddGG_rr= (1.12)*(98.)*Z5*(6.)
                          *( (4.)*Z7*Z7*Z7
                            -(45.)*(.12)*Z7*Z7
                            +(45.)*(.12)*(.12)*Z7
                            -(4.)*(.12)*(.12)*(.12))
                          /(RHO4*Z7BUF5);

            e_e= aut.ddedrdr/EPS;
            e_r= EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_r
                +EPS*( 42.)*FF5*GG_r*dFF*dFF
                +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF
                +EPS*( 84.)*FF5*dGG*dFF*FF_r
                +EPS*( 14.)*FF6*dGG_r*dFF
                +EPS*( 14.)*FF6*dGG*dFF_r
                +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_r
                +EPS*(  7.)*FF6*GG_r*ddFF
                +EPS*(  7.)*FF6*( GG -(2.))*ddFF_r
                +EPS*(  7.)*FF6*ddGG*FF_r
                +EPS*FF7*ddGG_r;
            e_a= EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_a
                +EPS*( 84.)*FF5*( GG -(2.))*dFF_a*dFF
                +EPS*( 84.)*FF5*dGG*dFF*FF_a
                +EPS*( 14.)*FF6*dGG*dFF_a
                +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_a
                +EPS*(  7.)*FF6*( GG -(2.))*ddFF_a
                +EPS*(  7.)*FF6*ddGG*FF_a;
            e_ee= (0.00);
            e_er= e_r/EPS;
            e_ea= e_a/EPS;
            e_rr= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_r*FF_r
                 +EPS*(420.)*FF4*GG_r*dFF*dFF*FF_r
                 +EPS*(840.)*FF4*( GG -(2.))*dFF_r*dFF*FF_r
                 +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_rr
                 +EPS*( 42.)*FF5*GG_rr*dFF*dFF
                 +EPS*(168.)*FF5*GG_r*dFF_r*dFF
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_rr*dFF
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF_r
                 +EPS*(420.)*FF4*dGG*dFF*FF_r*FF_r
                 +EPS*(168.)*FF5*dGG_r*dFF*FF_r
                 +EPS*(168.)*FF5*dGG*dFF_r*FF_r
                 +EPS*( 84.)*FF5*dGG*dFF*FF_rr
                 +EPS*( 14.)*FF6*dGG_rr*dFF
                 +EPS*( 28.)*FF6*dGG_r*dFF_r
                 +EPS*( 14.)*FF6*dGG*dFF_rr
                 +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_r*FF_r
                 +EPS*( 84.)*FF5*GG_r*ddFF*FF_r
                 +EPS*( 84.)*FF5*( GG -(2.))*ddFF_r*FF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_rr
                 +EPS*(  7.)*FF6*GG_rr*ddFF
                 +EPS*( 14.)*FF6*GG_r*ddFF_r
                 +EPS*(  7.)*FF6*( GG -(2.))*ddFF_rr
                 +EPS*( 42.)*FF5*ddGG*FF_r*FF_r
                 +EPS*( 14.)*FF6*ddGG_r*FF_r
                 +EPS*(  7.)*FF6*ddGG*FF_rr
                 +EPS*FF7*ddGG_rr;
            e_ra= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_r*FF_a
                 +EPS*(420.)*FF4*( GG -(2.))*dFF_a*dFF*FF_r
                 +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_ra
                 +EPS*(210.)*FF4*GG_r*dFF*dFF*FF_a
                 +EPS*( 84.)*FF5*GG_r*dFF_a*dFF
                 +EPS*(420.)*FF4*( GG -(2.))*dFF_r*dFF*FF_a
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_ra*dFF
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF_a
                 +EPS*(420.)*FF4*dGG*dFF*FF_r*FF_a
                 +EPS*( 84.)*FF5*dGG*dFF_a*FF_r
                 +EPS*( 84.)*FF5*dGG*dFF*FF_ra
                 +EPS*( 84.)*FF5*dGG_r*dFF*FF_a
                 +EPS*( 14.)*FF6*dGG_r*dFF_a
                 +EPS*( 84.)*FF5*dGG*dFF_r*FF_a
                 +EPS*( 14.)*FF6*dGG*dFF_ra
                 +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_r*FF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*ddFF_a*FF_r
                 +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_ra
                 +EPS*( 42.)*FF5*GG_r*ddFF*FF_a
                 +EPS*(  7.)*FF6*GG_r*ddFF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*ddFF_r*FF_a
                 +EPS*(  7.)*FF6*( GG -(2.))*ddFF_ra
                 +EPS*( 42.)*FF5*ddGG*FF_r*FF_a
                 +EPS*(  7.)*FF6*ddGG*FF_ra
                 +EPS*(  7.)*FF6*ddGG_r*FF_a;
            e_aa= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_a*FF_a
                 +EPS*(840.)*FF4*( GG -(2.))*dFF_a*dFF*FF_a
                 +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_aa
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_aa*dFF
                 +EPS*( 84.)*FF5*( GG -(2.))*dFF_a*dFF_a
                 +EPS*(420.)*FF4*dGG*dFF*FF_a*FF_a
                 +EPS*(168.)*FF5*dGG*dFF_a*FF_a
                 +EPS*( 84.)*FF5*dGG*dFF*FF_aa
                 +EPS*( 14.)*FF6*dGG*dFF_aa
                 +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_a*FF_a
                 +EPS*( 84.)*FF5*( GG -(2.))*ddFF_a*FF_a
                 +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_aa
                 +EPS*(  7.)*FF6*( GG -(2.))*ddFF_aa
                 +EPS*( 42.)*FF5*ddGG*FF_a*FF_a
                 +EPS*(  7.)*FF6*ddGG*FF_aa;

            TRA_ENE_CHAIN(e_e,e_r,e_a,
                          e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                          iT2,jT2,
                          aut.dddedrdr,aut.ddddedrdr);
            TRA_ENE_PART(aut,
                         array_consts,
                         kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0,
                         iU3,jU3);
         }

         if( (jHB&iHB)==0 ){
            aut.ISOTROPIC=false;
            double dFdt,dFdp,
                   dFdq[3];
            double ddFdtdt,ddFdtdp,ddFdpdp,
                   ddFdqdt[3],ddFdqdp[3],
                   ddFdqdq[3][3];
            double dCdt,dCdp,
                   dCdq[3];
            double ddCdtdt,ddCdtdp,ddCdpdp,
                   ddCdqdt[3],ddCdqdp[3],
                   ddCdqdq[3][3];

            aut.QQ.populate(1);
            double zF= std::sqrt( (2.00));
            int dT2,aT2;
            if( (iT2== 2)||(iT2== 5) ){
               dT2=(iT2-1);
               aT2=jT2;
               aut.QQ.populate(1,aut.F2[iF2].q);
               Coordinates U;
               U(0)= aut.QQ.r(1,-1)*zF;
               U(1)=-aut.QQ.i(1,-1)*zF;
               U(2)= aut.QQ.r(1, 0);
               double r= U.r();
               aut.QQ*=((-1.00)/r);
               aut.QQ.chain(array_consts,aut.QdQ,aut.QddQ);
            }else{
               dT2=(jT2-1);
               aT2=iT2;
               aut.QQ.populate(1,aut.F2[jF2].q);
               Coordinates U;
               U(0)= aut.QQ.r(1,-1)*zF;
               U(1)=-aut.QQ.i(1,-1)*zF;
               U(2)= aut.QQ.r(1, 0);
               double r= U.r();
               aut.QQ*=(( 1.00)/r);
               for(int i=0;i<3;i++){
                  aut.QdQ[i].populate(1);
                  aut.QdQ[i].zero();
                  for(int j=0;j<3;j++){
                     aut.QddQ[i][j].populate(1);
                     aut.QddQ[i][j].zero();
                  }
               }
            }

            aut.H.populate(array_consts,1,
                           aut.CT,aut.ST,aut.CP,aut.SP,
                           aut.dH,aut.ddH);

            double C= (0.00);
            dCdt= (0.00);
            dCdp= (0.00);
            ddCdtdt= (0.00);
            ddCdtdp= (0.00);
            ddCdpdp= (0.00);
            for(int i=0;i<3;i++){
               dCdq[i]= (0.00);
               ddCdqdt[i]= (0.00);
               ddCdqdp[i]= (0.00);
               for(int j=0;j<3;j++){
                  ddCdqdq[i][j]= (0.00);
               }
            }
            for(int M=-1;M<=1;M++){
               double F_r=( aut.QQ.r(1,M)*aut.H.r(1,M)
                           -aut.QQ.i(1,M)*aut.H.i(1,M));
               double F_i=( aut.QQ.r(1,M)*aut.H.i(1,M)
                           +aut.QQ.i(1,M)*aut.H.r(1,M));
               C+=F_r;
               dCdp+=(M)*F_i;
               ddCdpdp-=(M*M)*F_r;
               double dF_r=( aut.QQ.r(1,M)*aut.dH.r(1,M)
                            -aut.QQ.i(1,M)*aut.dH.i(1,M));
               double dF_i=( aut.QQ.r(1,M)*aut.dH.i(1,M)
                            +aut.QQ.i(1,M)*aut.dH.r(1,M));
               dCdt+=dF_r;
               ddCdtdp+=(M)*dF_i;
               double ddF_r=( aut.QQ.r(1,M)*aut.ddH.r(1,M)
                             -aut.QQ.i(1,M)*aut.ddH.i(1,M));
//             double ddF_i=( aut.QQ.r(1,M)*aut.ddH.i(1,M)
//                           +aut.QQ.i(1,M)*aut.ddH.r(1,M));
               ddCdtdt+=ddF_r;
               for(int i=0;i<3;i++){
                  dF_r=( aut.QdQ[i].r(1,M)*aut.H.r(1,M)
                        -aut.QdQ[i].i(1,M)*aut.H.i(1,M));
                  dF_i=( aut.QdQ[i].r(1,M)*aut.H.i(1,M)
                        +aut.QdQ[i].i(1,M)*aut.H.r(1,M));
                  dCdq[i]+=dF_r;
                  ddCdqdp[i]+=(M)*dF_i;
                  dF_r=( aut.QdQ[i].r(1,M)*aut.dH.r(1,M)
                        -aut.QdQ[i].i(1,M)*aut.dH.i(1,M));
//                dF_i=( aut.QdQ[i].r(1,M)*aut.dH.i(1,M)
//                      +aut.QdQ[i].i(1,M)*aut.dH.r(1,M));
                  ddCdqdt[i]+=dF_r;
                  for(int j=0;j<3;j++){
                     ddF_r=( aut.QddQ[i][j].r(1,M)*aut.H.r(1,M)
                            -aut.QddQ[i][j].i(1,M)*aut.H.i(1,M));
//                   ddF_i=( aut.QddQ[i][j].r(1,M)*aut.H.i(1,M)
//                          +aut.QddQ[i][j].i(1,M)*aut.H.r(1,M));
                     ddCdqdq[i][j]+=ddF_r;
                  }
               }
            }

            double F=( (1.00) -C*C*C*C);
            if( F<( 1.00e-10) )F=( 1.00e-10);
            dFdt=-(4.00)*C*C*C*dCdt;
            dFdp=-(4.00)*C*C*C*dCdp;
            ddFdtdt=-(4.00)*( (3.00)*C*C*dCdt*dCdt +C*C*C*ddCdtdt);
            ddFdtdp=-(4.00)*( (3.00)*C*C*dCdt*dCdp +C*C*C*ddCdtdp);
            ddFdpdp=-(4.00)*( (3.00)*C*C*dCdp*dCdp +C*C*C*ddCdpdp);
            for(int i=0;i<3;i++){
               dFdq[i]=-(4.00)*C*C*C*dCdq[i];
               ddFdqdt[i]=-(4.00)*( (3.00)*C*C*dCdq[i]*dCdt +C*C*C*ddCdqdt[i]);
               ddFdqdp[i]=-(4.00)*( (3.00)*C*C*dCdq[i]*dCdp +C*C*C*ddCdqdp[i]);
               for(int j=0;j<3;j++){
                  ddFdqdq[i][j]=-(4.00)*( (3.00)*C*C*dCdq[i]*dCdq[j]
                                         +C*C*C*ddCdqdq[i][j]);
               }
            }
            if( ((iU3>= 0)||
                 (jU3>= 0))&&!NEIGHBOR ){
               for(int i=1;i<6;i+=3){
                  aut.de[i]*=(-F);
                  aut.ddedr[i]*=(-F);
                  aut.dddedrdr[i]*=(-F);
                  for(int j=1;j<6;j+=3){
                     aut.dde[ i*6 +j]*=(-F);
                     aut.dddedr[ i*6 +j]*=(-F);
                     aut.ddddedrdr[ i*6 +j]*=(-F);
                  }
               }
               aut.dedt= (dFdt/F);
               aut.dedp= (dFdp/F);
               aut.ddedtdt= (ddFdtdt/F);
               aut.ddedtdp= (ddFdtdp/F);
               aut.ddedpdp= (ddFdpdp/F);
               for(int i=0;i<3;i++){
                  aut.dedq[i]= (dFdq[i]/F);
                  aut.ddedqdt[i]= (ddFdqdt[i]/F);
                  aut.ddedqdp[i]= (ddFdqdp[i]/F);
                  for(int j=0;j<3;j++){
                     aut.ddedqdq[i][j]= (ddFdqdq[i][j]/F);
                  }
               }
               if( iU3>= 0 ){
                  U3f(iU3)+=aut.de[1];
                  U3U3f(iU3,iU3)+=aut.dde[ 1*6 +1];
               }
               if( jU3>= 0 ){
                  U3f(jU3)+=aut.de[4];
                  U3U3f(jU3,jU3)+=aut.dde[ 4*6 +4];
               }
               if( (iU3>= 0)&&(jU3>= 0) ){
                  if( jU3<=iU3 ){
                     U3U3f(jU3,iU3)+=aut.dde[ 4*6 +1];
                  }
                  if( iU3<=jU3 ){
                     U3U3f(iU3,jU3)+=aut.dde[ 1*6 +4];
                  }
               }
               TRA_ENE_PART(aut,
                            array_consts,
                            kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0,
                            iU3,jU3);
            }

            EPS= TTe(dT2,aT2);
            RHO= TTr(dT2,aT2);
            if( NEIGHBOR ){
               EPS= energy_params.T2T2e(dT2,aT2);
               RHO= energy_params.T2T2r(dT2,aT2);
            }
            Z= (aut.R/RHO);
            double Z2= Z*Z;
            double Z5= Z*Z2*Z2;
            double Z6= Z*Z5;
            double Z7= Z*Z6;
            alp= TTa(dT2,aT2);
            if( NEIGHBOR ){
               alp= energy_params.T2T2a(dT2,aT2);
            }

            FF  =( (1.00) +alp)
                /( Z +alp);
            FF3= FF*FF*FF;
            FF4= FF*FF3;
            FF5= FF*FF4;
            FF6= FF*FF5;
            FF7= FF*FF6;
            dFF =-FF
                /(( Z +alp)*RHO);
            ddFF=-(2.00)*dFF
                /(( Z +alp)*RHO);
            GG  = (1.12)
                /( Z7 +(.12));
            dGG =-GG*(7.00)*Z6
                /(( Z7 +(.12))*RHO);
            ddGG= dGG*( (6.00)*(.12)/Z -(8.00)*Z6)
                /(( Z7 +(.12))*RHO);

            double G= EPS*(
                FF7*( GG -(2.00))
                           );
            double dGdr= EPS*(
                (7.00)*FF6*dFF*( GG -(2.00))
               +FF7*dGG
                              );
            double ddGdrdr= EPS*(
                (42.00)*FF5*dFF*dFF*( GG -(2.00))
               +( 7.00)*FF6*ddFF*( GG -(2.00))
               +(14.00)*FF6*dFF*dGG
               +FF7*ddGG
                                 );
            int dU3=TTiU3(dT2,aT2);
            int aU3=TTjU3(dT2,aT2);
            if( ((dU3>= 0)||
                 (aU3>= 0))&&!NEIGHBOR ){
               double RHO2= RHO*RHO;
               double RHO3= RHO*RHO2;
               double RHO4= RHO*RHO3;
               double ZBUF=( Z +alp);
               double ZBUF2= ZBUF*ZBUF;
               double ZBUF3= ZBUF*ZBUF2;
               double ZBUF4= ZBUF*ZBUF3;
               double ZBUF5= ZBUF*ZBUF4;
               double Z7BUF=( Z7 +(.12));
               double Z7BUF2= Z7BUF*Z7BUF;
               double Z7BUF3= Z7BUF*Z7BUF2;
               double Z7BUF4= Z7BUF*Z7BUF3;
               double Z7BUF5= Z7BUF*Z7BUF4;
//
//
// derivatives of G wrt parameters (Te,Tr,Ta)
//
               double FF_r =-dFF*Z;
               double FF_rr=( ddFF*Z2 +dFF*(2.)*Z/RHO);
               double FF_a =( Z -(1.))
                           /ZBUF2;
               double FF_aa= (-2.)*FF_a
                           /( Z +alp);
               double FF_ra=( Z -alp -(2.))*(Z/RHO)
                           /ZBUF3;
               double GG_r =-dGG*Z;
               double GG_rr=( ddGG*Z2 +dGG*(2.)*Z/RHO);

               double e_e= G/EPS;
               double e_r= EPS*(  7.)*FF6*( GG -(2.))*FF_r
                          +EPS*FF7*GG_r;
               double e_a= EPS*(  7.)*FF6*( GG -(2.))*FF_a;
               double e_ee= (0.);
               double e_er= e_r/EPS;
               double e_ea= e_a/EPS;
               double e_rr= EPS*( 42.)*FF5*( GG -(2.))*FF_r*FF_r
                           +EPS*( 14.)*FF6*GG_r*FF_r
                           +EPS*(  7.)*FF6*( GG -(2.))*FF_rr
                           +EPS*FF7*GG_rr;
               double e_ra= EPS*( 42.)*FF5*( GG -(2.))*FF_r*FF_a
                           +EPS*(  7.)*FF6*( GG -(2.))*FF_ra
                           +EPS*(  7.)*FF6*GG_r*FF_a;
               double e_aa= EPS*( 42.)*FF5*( GG -(2.))*FF_a*FF_a
                           +EPS*(  7.)*FF6*( GG -(2.))*FF_aa;

               TRA_ENE_CHAIN(e_e,e_r,e_a,
                             e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                             dT2,aT2,
                             aut.dG,aut.ddG);
//
//
// derivatives of dGdr wrt parameters (Te,Tr,Ta)
//
               double dFF_r =( (1.) +alp)*(-Z +alp)
                            /(RHO2*ZBUF3);
               double dFF_rr=( (1.) +alp)*(2.)*alp*( (2.)*Z -alp)
                            /(RHO3*ZBUF4);
               double dFF_a =(-Z +alp +(2.))
                            /(RHO*ZBUF3);
               double dFF_ra=(-Z2 +(4.)*Z*( (1.) +alp) -alp*( alp +(2.)))
                            /(RHO2*ZBUF4);
               double dFF_aa=(2.)*( (2.)*Z -alp -(3.))
                            /(RHO*ZBUF4);
               double dGG_r =(1.12)*(49.)*Z6*( (.12) -Z7)
                            /(RHO2*Z7BUF3);
               double dGG_rr=(1.12)*(49.)*Z6
                            *(-( 6.)*Z7*Z7 +(28.)*(.12)*Z7 -( 8.)*(.12)*(.12))
                            /(RHO3*Z7BUF4);

               e_e= dGdr/EPS;
               e_r= EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_r
                   +EPS*(  7.)*FF6*GG_r*dFF
                   +EPS*(  7.)*FF6*( GG -(2.))*dFF_r
                   +EPS*(  7.)*FF6*dGG*FF_r
                   +EPS*FF7*dGG_r;
               e_a= EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_a
                   +EPS*(  7.)*FF6*( GG -(2.))*dFF_a
                   +EPS*(  7.)*FF6*dGG*FF_a;
               e_ee= (0.00);
               e_er= e_r/EPS;
               e_ea= e_a/EPS;
               e_rr= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_r*FF_r
                    +EPS*( 42.)*FF5*GG_r*dFF*FF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_rr
                    +EPS*( 42.)*FF5*GG_r*dFF*FF_r
                    +EPS*(  7.)*FF6*GG_rr*dFF
                    +EPS*(  7.)*FF6*GG_r*dFF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_r
                    +EPS*(  7.)*FF6*GG_r*dFF_r
                    +EPS*(  7.)*FF6*( GG -(2.))*dFF_rr
                    +EPS*( 42.)*FF5*dGG*FF_r*FF_r
                    +EPS*(  7.)*FF6*dGG_r*FF_r
                    +EPS*(  7.)*FF6*dGG*FF_rr
                    +EPS*(  7.)*FF6*dGG_r*FF_r
                    +EPS*FF7*dGG_rr;
               e_ra= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_r*FF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_ra
                    +EPS*( 42.)*FF5*GG_r*dFF*FF_a
                    +EPS*(  7.)*FF6*GG_r*dFF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_r*FF_a
                    +EPS*(  7.)*FF6*( GG -(2.))*dFF_ra
                    +EPS*( 42.)*FF5*dGG*FF_r*FF_a
                    +EPS*(  7.)*FF6*dGG*FF_ra
                    +EPS*(  7.)*FF6*dGG_r*FF_a;
               e_aa= EPS*(210.)*FF4*( GG -(2.))*dFF*FF_a*FF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF*FF_aa
                    +EPS*( 42.)*FF5*( GG -(2.))*dFF_a*FF_a
                    +EPS*(  7.)*FF6*( GG -(2.))*dFF_aa
                    +EPS*( 42.)*FF5*dGG*FF_a*FF_a
                    +EPS*(  7.)*FF6*dGG*FF_aa;

               TRA_ENE_CHAIN(e_e,e_r,e_a,
                             e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                             dT2,aT2,
                             aut.ddGdr,aut.dddGdr);
//
//
// derivatives of ddGdrdr wrt parameters (Te,Tr,Ta)
//
               double ddFF_r = (2.)*( (1.) +alp)*( Z -(2.)*alp)
                             /(RHO3*ZBUF4);
               double ddFF_a = (2.)*( Z -(2.)*alp -(3.))
                             /(RHO2*ZBUF4);
               double ddFF_rr=-(12.)*alp*( (1.) +alp)*( Z -alp)
                             /(RHO4*ZBUF5);
               double ddFF_ra= (2.)*( Z*( Z -(7.)*alp -(6.))
                                     +alp*( (4.)*alp +(6.)))
                             /(RHO3*ZBUF5);
               double ddFF_aa=-(12.)*( Z -alp -(2.))
                             /(RHO2*ZBUF5);
               double ddGG_r = (1.12)*(98.)*Z5
                             *( (4.)*Z7*Z7 -(14.)*(.12)*Z7 +(3.)*(.12)*(.12))
                             /(RHO3*Z7BUF4);
               double ddGG_rr= (1.12)*(98.)*Z5*(6.)
                             *( (4.)*Z7*Z7*Z7
                               -(45.)*(.12)*Z7*Z7
                               +(45.)*(.12)*(.12)*Z7
                               -(4.)*(.12)*(.12)*(.12))
                             /(RHO4*Z7BUF5);

               e_e= ddGdrdr/EPS;
               e_r= EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_r
                   +EPS*( 42.)*FF5*GG_r*dFF*dFF
                   +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF
                   +EPS*( 84.)*FF5*dGG*dFF*FF_r
                   +EPS*( 14.)*FF6*dGG_r*dFF
                   +EPS*( 14.)*FF6*dGG*dFF_r
                   +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_r
                   +EPS*(  7.)*FF6*GG_r*ddFF
                   +EPS*(  7.)*FF6*( GG -(2.))*ddFF_r
                   +EPS*(  7.)*FF6*ddGG*FF_r
                   +EPS*FF7*ddGG_r;
               e_a= EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_a
                   +EPS*( 84.)*FF5*( GG -(2.))*dFF_a*dFF
                   +EPS*( 84.)*FF5*dGG*dFF*FF_a
                   +EPS*( 14.)*FF6*dGG*dFF_a
                   +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_a
                   +EPS*(  7.)*FF6*( GG -(2.))*ddFF_a
                   +EPS*(  7.)*FF6*ddGG*FF_a;
               e_ee= (0.00);
               e_er= e_r/EPS;
               e_ea= e_a/EPS;
               e_rr= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_r*FF_r
                    +EPS*(420.)*FF4*GG_r*dFF*dFF*FF_r
                    +EPS*(840.)*FF4*( GG -(2.))*dFF_r*dFF*FF_r
                    +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_rr
                    +EPS*( 42.)*FF5*GG_rr*dFF*dFF
                    +EPS*(168.)*FF5*GG_r*dFF_r*dFF
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_rr*dFF
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF_r
                    +EPS*(420.)*FF4*dGG*dFF*FF_r*FF_r
                    +EPS*(168.)*FF5*dGG_r*dFF*FF_r
                    +EPS*(168.)*FF5*dGG*dFF_r*FF_r
                    +EPS*( 84.)*FF5*dGG*dFF*FF_rr
                    +EPS*( 14.)*FF6*dGG_rr*dFF
                    +EPS*( 28.)*FF6*dGG_r*dFF_r
                    +EPS*( 14.)*FF6*dGG*dFF_rr
                    +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_r*FF_r
                    +EPS*( 84.)*FF5*GG_r*ddFF*FF_r
                    +EPS*( 84.)*FF5*( GG -(2.))*ddFF_r*FF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_rr
                    +EPS*(  7.)*FF6*GG_rr*ddFF
                    +EPS*( 14.)*FF6*GG_r*ddFF_r
                    +EPS*(  7.)*FF6*( GG -(2.))*ddFF_rr
                    +EPS*( 42.)*FF5*ddGG*FF_r*FF_r
                    +EPS*( 14.)*FF6*ddGG_r*FF_r
                    +EPS*(  7.)*FF6*ddGG*FF_rr
                    +EPS*FF7*ddGG_rr;
               e_ra= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_r*FF_a
                    +EPS*(420.)*FF4*( GG -(2.))*dFF_a*dFF*FF_r
                    +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_ra
                    +EPS*(210.)*FF4*GG_r*dFF*dFF*FF_a
                    +EPS*( 84.)*FF5*GG_r*dFF_a*dFF
                    +EPS*(420.)*FF4*( GG -(2.))*dFF_r*dFF*FF_a
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_ra*dFF
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_r*dFF_a
                    +EPS*(420.)*FF4*dGG*dFF*FF_r*FF_a
                    +EPS*( 84.)*FF5*dGG*dFF_a*FF_r
                    +EPS*( 84.)*FF5*dGG*dFF*FF_ra
                    +EPS*( 84.)*FF5*dGG_r*dFF*FF_a
                    +EPS*( 14.)*FF6*dGG_r*dFF_a
                    +EPS*( 84.)*FF5*dGG*dFF_r*FF_a
                    +EPS*( 14.)*FF6*dGG*dFF_ra
                    +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_r*FF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*ddFF_a*FF_r
                    +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_ra
                    +EPS*( 42.)*FF5*GG_r*ddFF*FF_a
                    +EPS*(  7.)*FF6*GG_r*ddFF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*ddFF_r*FF_a
                    +EPS*(  7.)*FF6*( GG -(2.))*ddFF_ra
                    +EPS*( 42.)*FF5*ddGG*FF_r*FF_a
                    +EPS*(  7.)*FF6*ddGG*FF_ra
                    +EPS*(  7.)*FF6*ddGG_r*FF_a;
               e_aa= EPS*(840.)*FF3*( GG -(2.))*dFF*dFF*FF_a*FF_a
                    +EPS*(840.)*FF4*( GG -(2.))*dFF_a*dFF*FF_a
                    +EPS*(210.)*FF4*( GG -(2.))*dFF*dFF*FF_aa
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_aa*dFF
                    +EPS*( 84.)*FF5*( GG -(2.))*dFF_a*dFF_a
                    +EPS*(420.)*FF4*dGG*dFF*FF_a*FF_a
                    +EPS*(168.)*FF5*dGG*dFF_a*FF_a
                    +EPS*( 84.)*FF5*dGG*dFF*FF_aa
                    +EPS*( 14.)*FF6*dGG*dFF_aa
                    +EPS*(210.)*FF4*( GG -(2.))*ddFF*FF_a*FF_a
                    +EPS*( 84.)*FF5*( GG -(2.))*ddFF_a*FF_a
                    +EPS*( 42.)*FF5*( GG -(2.))*ddFF*FF_aa
                    +EPS*(  7.)*FF6*( GG -(2.))*ddFF_aa
                    +EPS*( 42.)*FF5*ddGG*FF_a*FF_a
                    +EPS*(  7.)*FF6*ddGG*FF_aa;

               TRA_ENE_CHAIN(e_e,e_r,e_a,
                             e_ee,e_er,e_ea,e_rr,e_ra,e_aa,
                             dT2,aT2,
                             aut.dddGdrdr,aut.ddddGdrdr);

               for(int i=1;i<6;i+=3){
                  aut.de[i]= F*aut.dG[i];
                  aut.ddedr[i]= F*aut.ddGdr[i];
                  aut.dddedrdr[i]= F*aut.dddGdrdr[i];
                  for(int j=1;j<6;j+=3){
                     aut.dde[ i*6 +j]= F*aut.ddG[ i*6 +j];
                     aut.dddedr[ i*6 +j]= F*aut.dddGdr[ i*6 +j];
                     aut.ddddedrdr[ i*6 +j]= F*aut.ddddGdrdr[ i*6 +j];
                  }
               }
               if( dU3>= 0 ){
                  U3f(dU3)+=aut.de[1];
                  U3U3f(dU3,dU3)+=aut.dde[ 1*6 +1];
               }
               if( aU3>= 0 ){
                  U3f(aU3)+=aut.de[4];
                  U3U3f(aU3,aU3)+=aut.dde[ 4*6 +4];
               }
               if( (dU3>= 0)&&(aU3>= 0) ){
                  if( aU3<=dU3 ){
                     U3U3f(aU3,dU3)+=aut.dde[ 4*6 +1];
                  }
                  if( dU3<=aU3 ){
                     U3U3f(dU3,aU3)+=aut.dde[ 1*6 +4];
                  }
               }
               TRA_ENE_PART(aut,
                            array_consts,
                            kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0,
                            dU3,aU3);
            }
            G-=e;
            dGdr-=aut.dedr;
            ddGdrdr-=aut.ddedrdr;

            Fr+=F*G;
            aut.dedr+=F*dGdr;
            aut.dedt=dFdt*G;
            aut.dedp=dFdp*G;
            aut.ddedrdr+=F*ddGdrdr;
            aut.ddedrdt=dFdt*dGdr;
            aut.ddedrdp=dFdp*dGdr;
            aut.ddedtdt=ddFdtdt*G;
            aut.ddedtdp=ddFdtdp*G;
            aut.ddedpdp=ddFdpdp*G;
            for(int i=0;i<3;i++){
               aut.dedq[i]=dFdq[i]*G;
               aut.ddedqdr[i]=dFdq[i]*dGdr;
               aut.ddedqdt[i]=ddFdqdt[i]*G;
               aut.ddedqdp[i]=ddFdqdp[i]*G;
               for(int j=0;j<3;j++){
                  aut.ddedqdq[i][j]=ddFdqdq[i][j]*G;
               }
            }

            if( con.F2[jF2].ion||con.F2[iF2].ion ){
               EPS= energy_params.T2T2e(dT2,aT2)*(  .32);
               RHO= energy_params.T2T2r(dT2,aT2);
               Z= (aut.R/RHO);
               Z2= Z*Z;
               Z5= Z*Z2*Z2;
               Z6= Z*Z5;
               Z7= Z*Z6;
               alp= energy_params.T2T2a(dT2,aT2);

               FF  =( (1.00) +alp)
                    /( Z +alp);
               FF3= FF*FF*FF;
               FF4= FF*FF3;
               FF5= FF*FF4;
               FF6= FF*FF5;
               FF7= FF*FF6;
               dFF =-FF
                    /(( Z +alp)*RHO);
               ddFF=-(2.00)*dFF
                    /(( Z +alp)*RHO);
               GG  = (1.12)
                    /( Z7 +(.12));
               dGG =-GG*(7.00)*Z6
                    /(( Z7 +(.12))*RHO);
               ddGG= dGG*( (6.00)*(.12)/Z -(8.00)*Z6)
                    /(( Z7 +(.12))*RHO);

               e=EPS*(
                   FF7*( GG -(2.00))
                      );
               aut.dedr+= EPS*(
                   (7.00)*FF6*dFF*( GG -(2.00))
                  +FF7*dGG
                              );
               aut.ddedrdr+= EPS*(
                   (42.00)*FF5*dFF*dFF*( GG -(2.00))
                  +( 7.00)*FF6*ddFF*( GG -(2.00))
                  +(14.00)*FF6*dFF*dGG
                  +FF7*ddGG
                                 );
               Fr+=e;
            }

         }
      }else{
         aut.dedr= (0.00);
         aut.ddedrdr= (0.00);
      }
//
//
// calc Fs
//
      if( !STARGET ){
         if( iS3>=0 ){
            double a0= energy_params.S3[iS3].a;
            double r0= energy_params.S3[iS3].r;
            Fs+=a0*std::pow(( aut.R -r0),2);
            aut.dedr+=(2.00)*a0*( aut.R -r0);
            aut.ddedrdr+=(2.00)*a0;
            if( iS3==2 ){
               double zF= std::pow( (1.00)/(aut.R*physics_consts.ANG), 9);
               Fs+=zF;
               aut.dedr-=(9.00)*zF*aut.ZZ;
               aut.ddedrdr+=(90.0)*zF/aut.RR;
            }
         }
      }
//
//
// calc Fh
//
      if( sitesite ){
         if( !HTARGET ){
            if( aut.R<(24.00) ){
               double zF1= array_consts.SGN(n1+n2-1);
               double zG2,zA2;
               double zF2= pairfga(physics_consts,
                                   con.F2[jF2].gau,con.F2[iF2].gau,
                                   aut.R,
                                   zG2,zA2);
               Fh+=(zF1*zF2);
               aut.dedr+=(zF1*zG2);
               aut.ddedrdr+=(zF1*zA2);
            }
         }
      }
//
//
// calc Fe
//
      if( ( BLOCKEDRES)||
          ( (!BLOCKEDRES)&&(!ETARGET) ) ){
         if( aut.R>( 1.00) ){
         if( !EPASS ){
            int LTE=TRA_ENQ_L(aut.R,(3.20),energy_params.LTE);
            TRA_ENQ_ME(aut,
                       array_consts,
                       aut.F2[jF2].q,LTE1,aut.F2[iF2].q,LTE2,LTE,
                       false);
         }
         }
      }

   }else if( sitesite ){
//
//
// calc Fh
//
      if( !HTARGET ){
         double zF1= array_consts.SGN(n1+n2-1);
         double zF2= pairfga(physics_consts,
                             con.F2[jF2].gau,con.F2[iF2].gau,
                             aut.R,
                             aut.dedr,aut.ddedrdr);
         Fh+=(zF1*zF2);
         aut.dedr*=zF1;
         aut.ddedrdr*=zF1;
      }
   }
   TRA_ENQ_PART(aut,
                array_consts,
                kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
   return;
}

