#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include <string>
#include <cmath>

void Energy_Surfq::TRA_ENQ_PPAR(Tra_Automatic& aut,
                                const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_ARRAY_CONSTS& array_consts,
                                const DAT_REGION_MAPS& region_maps,
                                const Mechanical_System& mol,
                                const Subset_Contracted_System::tM3& con,
                                const Conf_Dependent_System& dep){
//
//
// initiate connectivity of peptide-peptide H-bonds
//
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         R0R0(iR0,jR0).e= (0.00);
         R0R0(iR0,jR0).a=false;
         if( E4RESET ){
            R0R0(iR0,jR0).b=false;
         }
         R0R0(iR0,jR0).o=false;
         R0R0(iR0,jR0).C= (0.00);
         R0R0(iR0,jR0).B= (0.00);
         R0R0(iR0,jR0).D= (0.00);
      }
   }
//
//
// initiate connectivity of other H-bonds
//
   if( E4RESET ){
      E4.clear();
      nE4=0;
      oD=0;
      oA=0;
      for(int iF2= 0;iF2<oF2;iF2++){
         F2[iF2].D=-1;
         F2[iF2].A=-1;
         if( con.F2[iF2].lhb==-1 )continue;
         int iT2=con.F2[iF2].typ;
         if( (iT2== 2)||(iT2== 5) ){
            F2[iF2].D=oD++;
         }else{
            F2[iF2].A=oA++;
         }
      }
      o_DAF2F2.clear();
      o_DAF2F2.resize(oD*oA, -1);
      o_F2F2.clear();
      oF2F2=0;
      for(int iF2= 0;iF2<oF2;iF2++){
         int iD=F2[iF2].D;
         if( iD==-1 )continue;
         std::string atmi=con.F2[iF2].atm;
         int iR0=con.F2[iF2].R0;
         for(int jF2= 0;jF2<oF2;jF2++){
            int iA=F2[jF2].A;
            if( iA==-1 )continue;
            std::string atmj=con.F2[jF2].atm;
            int jR0=con.F2[jF2].R0;
            if( (atmi==" H  ")&&
                (atmj==" O  ") )continue;
            if( std::abs( jR0-iR0)<2 )continue;
            DAF2F2(iD,iA)=oF2F2;
            o_F2F2.push_back( tF2F2());
            F2F2(oF2F2).iF2= iF2;
            F2F2(oF2F2).jF2= jF2;
            oF2F2++;
         }
      }
   }
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      F2F2(iF2F2).e= (0.00);
      F2F2(iF2F2).a=false;
      if( E4RESET ){
         F2F2(iF2F2).b=false;
      }
      F2F2(iF2F2).o=false;
      F2F2(iF2F2).C= (0.00);
      F2F2(iF2F2).B= (0.00);
      F2F2(iF2F2).D= (0.00);
   }
//
//
// peptide-peptide H-bond crosslinks
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<nR0;iR0++){
         char ci=mol.R0[iR0].c1;
         if( (ci!='a')&&(ci!='e') )continue;
         int iF2=con.R0N6F2(iR0+1, 3);
         if( iF2==-1 )continue;
         Coordinates n=( aut.F2[iF2].x
                        -aut.F2[con.R0N6F2(iR0+1, 0)].x).normalize();
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<bR0;jR0++){
               char cj=mol.R0[jR0].c1;
               if( (cj!='a')&&(cj!='e') )continue;
               if( std::abs( jR0-iR0)<2 )continue;
               int jF2=con.R0N6F2(jR0  , 5);
               Coordinates m=( aut.F2[con.R0N6F2(jR0  , 2)].x
                              -aut.F2[jF2].x).normalize();
//
               aut.x=( aut.F2[jF2].x -aut.F2[iF2].x);
               aut.R= aut.x.r();
               if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
               aut.ZZ= (1.00)/aut.R;
               aut.CT= (aut.x(2)*aut.ZZ);
               aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
               if( aut.ST>(1.00e-12) ){
                  aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
                  aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
               }else{
                  aut.CP= (1.00);
                  aut.SP= (0.00);
               }
//
               double Cnx= aut.ZZ*dot(n,aut.x);
               double Cmx= aut.ZZ*dot(m,aut.x);
               if( E4RESET ){
                  R0R0(iR0,jR0).b=( (aut.R<((12.00)/physics_consts.ANG))&&
                                    (Cnx>( 0.00))&&
                                    (Cmx>( 0.00)) );
               }
               if( R0R0(iR0,jR0).b ){
//
//
// truncated multipole expansion of electrostatic interaction energy
//
                  double EPS= ( 1.22)/physics_consts.CAL;
                  double RHO= ( 1.81)/physics_consts.ANG;
                  double ZZ= (RHO*aut.ZZ);
                  Fe= EPS*std::pow( ZZ, 14);
                  if( aut.ZZ>(1.00) )aut.ZZ= (1.00);
                  aut.q1.populate( 3,aut.F2[iF2].p);
                  aut.q2.populate( 3,aut.F2[jF2].p);
                  aut.QQ.populate( 6);
                  aut.QQ.product(array_consts,aut.q1,aut.q2);
                  double Lr[ 8];
                  Lr[ 1]= aut.ZZ;
                  for(int L=2;L<8;L++){
                     Lr[L  ]= aut.ZZ*Lr[L-1];
                  }
                  aut.H.populate(array_consts, 6,
                                 aut.CT,aut.ST,aut.CP,aut.SP);
                  for(int L=0;L<= 6;L++){
                     double F= (0.00);
                     for(int M=-L;M<=L;M++){
                        double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                                    -aut.QQ.i(L,M)*aut.H.i(L,M));
                        F+=F_r;
                     }
                     Fe+=Lr[L+1]*F;
                  }
//
                  R0R0(iR0,jR0).e= Fe;
                  R0R0(iR0,jR0).a=( aut.R<(( 2.40)/physics_consts.ANG) );
                  R0R0(iR0,jR0).o=( aut.R<(( 1.70)/physics_consts.ANG) );
                  int N4N2U2[4][2];
                  N4N2U2[0][0]=con.R0[iR0   ].U2phi;
                  N4N2U2[0][1]=con.R0[iR0   ].U2psi;
                  N4N2U2[1][0]=con.R0[iR0+ 1].U2phi;
                  N4N2U2[1][1]=con.R0[iR0+ 1].U2psi;
                  N4N2U2[2][0]=con.R0[jR0   ].U2phi;
                  N4N2U2[2][1]=con.R0[jR0   ].U2psi;
                  N4N2U2[3][0]=con.R0[jR0+ 1].U2phi;
                  N4N2U2[3][1]=con.R0[jR0+ 1].U2psi;
                  int N4N2Q1[4][2];
                  N4N2Q1[0][0]=con.R0[iR0   ].Q1phi;
                  N4N2Q1[0][1]=con.R0[iR0   ].Q1psi;
                  N4N2Q1[1][0]=con.R0[iR0+ 1].Q1phi;
                  N4N2Q1[1][1]=con.R0[iR0+ 1].Q1psi;
                  N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
                  N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
                  N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
                  N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
                  double phi(   0.00),psi(   0.00);
                  for(int i=0;i<4;i++){
                     if( N4N2U2[i][0]>-1 ){
                        phi= U2chi(N4N2U2[i][0]);
                     }else{
                        phi= dep.Q1[N4N2Q1[i][0]].chi;
                     }
                     if( N4N2U2[i][1]>-1 ){
                        psi= U2chi(N4N2U2[i][1]);
                     }else{
                        psi= dep.Q1[N4N2Q1[i][1]].chi;
                     }
                     R0R0(iR0,jR0).D+=region_maps.phi.f(phi);
                     R0R0(iR0,jR0).D+=region_maps.psi.f(psi);
                     R0R0(iR0,jR0).D+=region_maps.phipsi.f(phi,psi);
                  }
               }
            }
         }
      }
   }
//
//
// other H-bond crosslinks
//
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      int iF2=F2F2(iF2F2).iF2;
      std::string atmi=con.F2[iF2].atm;
      int iR0=con.F2[iF2].R0;
      int jF2=F2F2(iF2F2).jF2;
      std::string atmj=con.F2[jF2].atm;
      int jR0=con.F2[jF2].R0;
//
      aut.x=( aut.F2[jF2].x -aut.F2[iF2].x);
      aut.R= aut.x.r();
      if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
      aut.ZZ= (1.00)/aut.R;
      aut.CT= (aut.x(2)*aut.ZZ);
      aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
      if( aut.ST>(1.00e-12) ){
         aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
         aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
      }else{
         aut.CP= (1.00);
         aut.SP= (0.00);
      }
//
      double Cnx( 0.00);
      if( atmi==" H  " ){
         Coordinates n=( aut.F2[iF2].x
                        -aut.F2[con.R0N6F2(iR0, 0)].x).normalize();
         Cnx= aut.ZZ*dot(n,aut.x);
      }
      double Cmx( 0.00);
      if( atmi==" O  " ){
         Coordinates m=( aut.F2[con.R0N6F2(jR0, 2)].x
                        -aut.F2[jF2].x).normalize();
         Cmx= aut.ZZ*dot(m,aut.x);
      }
      if( E4RESET ){
         F2F2(iF2F2).b=( (aut.R<((12.00)/physics_consts.ANG))&&
                         (Cnx>=( 0.00))&&
                         (Cmx>=( 0.00)) );
      }
      if( F2F2(iF2F2).b ){
//
//
// truncated multipole expansion of electrostatic interaction energy
//
         double EPS= ( 1.22)/physics_consts.CAL;
         double RHO= ( 1.71)/physics_consts.ANG;
         double ZZ= (RHO*aut.ZZ);
         Fe= EPS*std::pow( ZZ, 14);
         if( aut.ZZ>(1.00) )aut.ZZ= (1.00);
         aut.q1.populate( 3,aut.F2[iF2].p);
         aut.q2.populate( 3,aut.F2[jF2].p);
         aut.QQ.populate( 6);
         aut.QQ.product(array_consts,aut.q1,aut.q2);
         double Lr[ 8];
         Lr[ 1]= aut.ZZ;
         for(int L=2;L<8;L++){
            Lr[L  ]= aut.ZZ*Lr[L-1];
         }
         aut.H.populate(array_consts, 6,
                        aut.CT,aut.ST,aut.CP,aut.SP);
         for(int L=0;L<= 6;L++){
            double F= (0.00);
            for(int M=-L;M<=L;M++){
               double F_r=( aut.QQ.r(L,M)*aut.H.r(L,M)
                           -aut.QQ.i(L,M)*aut.H.i(L,M));
               F+=F_r;
            }
            Fe+=Lr[L+1]*F;
         }
//
         F2F2(iF2F2).e= Fe;
         F2F2(iF2F2).a=( aut.R<(( 2.40)/physics_consts.ANG) );
         F2F2(iF2F2).o=( aut.R<(( 1.65)/physics_consts.ANG) );
         int N4N2U2[4][2],N4N2Q1[4][2];
         double phi(   0.00),psi(   0.00);
         if( atmi==" H  " ){
            if( iR0== 0 )continue;
            N4N2U2[0][0]=con.R0[iR0- 1].U2phi;
            N4N2U2[0][1]=con.R0[iR0- 1].U2psi;
            N4N2U2[1][0]=con.R0[iR0   ].U2phi;
            N4N2U2[1][1]=con.R0[iR0   ].U2psi;
            N4N2Q1[0][0]=con.R0[iR0- 1].Q1phi;
            N4N2Q1[0][1]=con.R0[iR0- 1].Q1psi;
            N4N2Q1[1][0]=con.R0[iR0   ].Q1phi;
            N4N2Q1[1][1]=con.R0[iR0   ].Q1psi;
            for(int i=0;i<2;i++){
               if( N4N2U2[i][0]>-1 ){
                  phi= U2chi(N4N2U2[i][0]);
               }else{
                  phi= dep.Q1[N4N2Q1[i][0]].chi;
               }
               if( N4N2U2[i][1]>-1 ){
                  psi= U2chi(N4N2U2[i][1]);
               }else{
                  psi= dep.Q1[N4N2Q1[i][1]].chi;
               }
               F2F2(iF2F2).D+=region_maps.phi.f(phi);
               F2F2(iF2F2).D+=region_maps.psi.f(psi);
               F2F2(iF2F2).D+=region_maps.phipsi.f(phi,psi);
            }
         }
         if( (atmj==" O  ")&&(jR0<(oR0- 1)) ){
            if( jR0==(oR0- 1) )continue;
            N4N2U2[2][0]=con.R0[jR0   ].U2phi;
            N4N2U2[2][1]=con.R0[jR0   ].U2psi;
            N4N2U2[3][0]=con.R0[jR0+ 1].U2phi;
            N4N2U2[3][1]=con.R0[jR0+ 1].U2psi;
            N4N2Q1[2][0]=con.R0[jR0   ].Q1phi;
            N4N2Q1[2][1]=con.R0[jR0   ].Q1psi;
            N4N2Q1[3][0]=con.R0[jR0+ 1].Q1phi;
            N4N2Q1[3][1]=con.R0[jR0+ 1].Q1psi;
            for(int i=2;i<4;i++){
               if( N4N2U2[i][0]>-1 ){
                  phi= U2chi(N4N2U2[i][0]);
               }else{
                  phi= dep.Q1[N4N2Q1[i][0]].chi;
               }
               if( N4N2U2[i][1]>-1 ){
                  psi= U2chi(N4N2U2[i][1]);
               }else{
                  psi= dep.Q1[N4N2Q1[i][1]].chi;
               }
               F2F2(iF2F2).D+=region_maps.phi.f(phi);
               F2F2(iF2F2).D+=region_maps.psi.f(psi);
               F2F2(iF2F2).D+=region_maps.phipsi.f(phi,psi);
            }
         }
      }
   }
//
//
// chains of peptide plane alignment
//
   double z= ( .50)*physics_consts.CAL/(-2.25);
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int jR0= 0;jR0<oR0;jR0++){
         if( !R0R0(iR0,jR0).b )continue;
         for(int lR0= 0;lR0<oR0;lR0++){
            if( !R0R0(jR0,lR0).b )continue;
            if( std::abs( lR0-iR0)<2 )continue;
            if( (!R0R0(iR0,jR0).o)&&(!R0R0(jR0,lR0).o) ){
               if( (jR0==(iR0- 2))&&(lR0==(jR0- 2)) ){
                  R0R0(iR0,jR0).C+=( 1.44)*z*R0R0(jR0,lR0).e;
                  R0R0(jR0,lR0).C+=( 1.44)*z*R0R0(iR0,jR0).e;
               }else{
                  R0R0(iR0,jR0).C+=z*R0R0(jR0,lR0).e;
                  R0R0(jR0,lR0).C+=z*R0R0(iR0,jR0).e;
               }
            }
            if( E4RESET ){
               E4.push_back( tE4());
               E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
               E4[nE4].jF2=con.R0N6F2(jR0  , 5);
               E4[nE4].kF2=con.R0N6F2(jR0+1, 3);
               E4[nE4].lF2=con.R0N6F2(lR0  , 5);
               if( (jR0==(iR0- 2))&&(lR0==(jR0- 2)) ){
                  E4[nE4++].f= ( 1.44)*z;
               }else{
                  E4[nE4++].f= z;
               }
            }
         }
      }
   }
   for(int iF2F2= 0;iF2F2<oF2F2;iF2F2++){
      if( !F2F2(iF2F2).b )continue;
      int pF2=F2F2(iF2F2).iF2;
      std::string atmp=con.F2[pF2].atm;
      int pR0=con.F2[pF2].R0;
      int qF2=F2F2(iF2F2).jF2;
      std::string atmq=con.F2[qF2].atm;
      int qR0=con.F2[qF2].R0;
      if( atmp==" H  " ){
         for(int iR0= 0;iR0<oR0;iR0++){
            if( std::abs( iR0-qR0)<2 )continue;
            if( !R0R0(iR0,pR0- 1).b )continue;
            if( (!R0R0(iR0,pR0- 1).o)&&(!F2F2(iF2F2).o) ){
               if( pR0==(iR0- 1) ){
                  R0R0(iR0,pR0- 1).C+=( 1.20)*z*F2F2(iF2F2).e;
                  F2F2(iF2F2).C+=( 1.20)*z*R0R0(iR0,pR0- 1).e;
               }else{
                  R0R0(iR0,pR0- 1).C+=z*F2F2(iF2F2).e;
                  F2F2(iF2F2).C+=z*R0R0(iR0,pR0- 1).e;
               }
            }
            if( E4RESET ){
               E4.push_back( tE4());
               E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
               E4[nE4].jF2=con.R0N6F2(pR0-1, 5);
               E4[nE4].kF2=pF2;
               E4[nE4].lF2=qF2;
               if( pR0==(iR0- 1) ){
                  E4[nE4++].f= ( 1.20)*z;
               }else{
                  E4[nE4++].f= z;
               }
            }
         }
      }
      if( atmq==" O  " ){
         for(int jR0= 0;jR0<oR0;jR0++){
            if( std::abs( jR0-pR0)<2 )continue;
            if( !R0R0(qR0,jR0).b )continue;
            if( (!R0R0(qR0,jR0).o)&&(!F2F2(iF2F2).o) ){
               if( jR0==(qR0- 2) ){
                  R0R0(qR0,jR0).C+=( 1.20)*z*F2F2(iF2F2).e;
                  F2F2(iF2F2).C+=( 1.20)*z*R0R0(qR0,jR0).e;
               }else{
                  R0R0(qR0,jR0).C+=z*F2F2(iF2F2).e;
                  F2F2(iF2F2).C+=z*R0R0(qR0,jR0).e;
               }
            }
            if( E4RESET ){
               E4.push_back( tE4());
               E4[nE4].iF2=con.R0N6F2(qR0+1, 3);
               E4[nE4].jF2=con.R0N6F2(jR0  , 5);
               E4[nE4].kF2=pF2;
               E4[nE4].lF2=qF2;
               if( jR0==(qR0- 2) ){
                  E4[nE4++].f= ( 1.20)*z;
               }else{
                  E4[nE4++].f= z;
               }
            }
         }
      }
   }
//
// patterns of H-bonds in helices or sheets
// helix, disfavor 3-10 and 4-13
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,jR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,jR0).o) ){
            R0R0(iR0,jR0).B-=( 1.20)*z*R0R0(kR0,jR0).e;
            R0R0(kR0,jR0).B-=( 1.20)*z*R0R0(iR0,jR0).e;
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(jR0  , 5);
            E4[nE4++].f=-( 1.20)*z;
         }
      }
   }
//
//
// helix, disfavor 4-13 and 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,jR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,jR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B+=(  .25)*z*R0R0(kR0,jR0).e;
               R0R0(kR0,jR0).B+=(  .25)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B-=( 1.00)*z*R0R0(kR0,jR0).e;
               R0R0(kR0,jR0).B-=( 1.00)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(jR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f= (  .25)*z;
            }else{
               E4[nE4++].f=-( 1.00)*z;
            }
         }
      }
   }
//
//
// helix, disfavor 3-10 and 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 2);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,jR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,jR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B-=( 1.20)*z*R0R0(kR0,jR0).e;
               R0R0(kR0,jR0).B-=( 1.20)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B-=( 1.20)*z*R0R0(kR0,jR0).e;
               R0R0(kR0,jR0).B-=( 1.20)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(jR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f=-( 1.20)*z;
            }else{
               E4[nE4++].f=-( 1.20)*z;
            }
         }
      }
   }
//
//
// helix, favor consecutive 4-13 
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,lR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B-=(  .15)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=(  .15)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B+=(  .85)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B+=(  .85)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(lR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f=-(  .15)*z;
            }else{
               E4[nE4++].f= (  .85)*z;
            }
         }
      }
   }
//
//
// helix, favor consecutive 3-10
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 2);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 2);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,lR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B-=(  .18)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=(  .18)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B+=( 1.00)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B+=( 1.00)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(lR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f=-(  .18)*z;
            }else{
               E4[nE4++].f= ( 1.00)*z;
            }
         }
      }
   }
//
//
// helix, disfavor consecutive 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 4);iR0<(nR0- 1);iR0++){
         int jR0=(iR0- 4);
         int kR0=(iR0+ 1);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,lR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B-=( 1.75)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=( 1.75)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B-=( 1.25)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=( 1.25)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(lR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f=-( 1.75)*z;
            }else{
               E4[nE4++].f=-( 1.25)*z;
            }
         }
      }
   }
//
//
// helix, disfavor consecutive 4-13, 5-16
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 3);iR0<(nR0- 2);iR0++){
         int jR0=(iR0- 3);
         int kR0=(iR0+ 2);
         int lR0=(jR0+ 1);
         if( !R0R0(iR0,jR0).b )continue;
         if( !R0R0(kR0,lR0).b )continue;
         if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
            if( mol.R0[kR0].aa=="GLY " ){
               R0R0(iR0,jR0).B-=(  .00)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=(  .00)*z*R0R0(iR0,jR0).e;
            }else{
               R0R0(iR0,jR0).B-=( 1.25)*z*R0R0(kR0,lR0).e;
               R0R0(kR0,lR0).B-=( 1.25)*z*R0R0(iR0,jR0).e;
            }
         }
         if( E4RESET ){
            E4.push_back( tE4());
            E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
            E4[nE4].jF2=con.R0N6F2(jR0  , 5);
            E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
            E4[nE4].lF2=con.R0N6F2(lR0  , 5);
            if( mol.R0[kR0].aa=="GLY " ){
               E4[nE4++].f=-(  .00)*z;
            }else{
               E4[nE4++].f=-( 1.25)*z;
            }
         }
      }
   }
//
//
// sheet, antiparallel
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 1);iR0++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=(aR0+ 1);jR0<bR0;jR0++){
               if( !R0R0(iR0,jR0).b )continue;
               int kR0=(jR0- 1);
               int lR0=(iR0+ 1);
               if( !R0R0(kR0,lR0).b )continue;
               if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
                  R0R0(iR0,jR0).B+=( .50)*z*R0R0(kR0,lR0).e;
                  R0R0(kR0,lR0).B+=( .50)*z*R0R0(iR0,jR0).e;
               }
               if( E4RESET ){
                  E4.push_back( tE4());
                  E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
                  E4[nE4].jF2=con.R0N6F2(jR0  , 5);
                  E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
                  E4[nE4].lF2=con.R0N6F2(lR0  , 5);
                  E4[nE4++].f= ( .50)*z;
               }
            }
         }
      }
   }
//
//
// sheet, antiparallel
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 1);iR0<nR0;iR0++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<(bR0- 1);jR0++){
               if( !R0R0(iR0,jR0).b )continue;
               int kR0=(jR0+ 1);
               int lR0=(iR0- 1);
               if( !R0R0(kR0,lR0).b )continue;
               if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
                  R0R0(iR0,jR0).B+=( .50)*z*R0R0(kR0,lR0).e;
                  R0R0(kR0,lR0).B+=( .50)*z*R0R0(iR0,jR0).e;
               }
               if( E4RESET ){
                  E4.push_back( tE4());
                  E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
                  E4[nE4].jF2=con.R0N6F2(jR0  , 5);
                  E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
                  E4[nE4].lF2=con.R0N6F2(lR0  , 5);
                  E4[nE4++].f= ( .50)*z;
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 2);iR0++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=(aR0+ 2);jR0<bR0;jR0++){
               if( !R0R0(iR0,jR0).b )continue;
               int kR0=(iR0+ 2);
               int lR0=(jR0- 2);
               if( !R0R0(kR0,lR0).b )continue;
               if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
                  R0R0(iR0,jR0).B+=( .50)*z*R0R0(kR0,lR0).e;
                  R0R0(kR0,lR0).B+=( .50)*z*R0R0(iR0,jR0).e;
               }
               if( E4RESET ){
                  E4.push_back( tE4());
                  E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
                  E4[nE4].jF2=con.R0N6F2(jR0  , 5);
                  E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
                  E4[nE4].lF2=con.R0N6F2(lR0  , 5);
                  E4[nE4++].f= ( .50)*z;
               }
            }
         }
      }
   }
//
//
// sheet parallel
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=(mR0+ 1);iR0<nR0;iR0++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=(aR0+ 1);jR0<bR0;jR0++){
               if( !R0R0(iR0,jR0).b )continue;
               int kR0=(jR0- 1);
               int lR0=(iR0- 1);
               if( !R0R0(kR0,lR0).b )continue;
               if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
                  R0R0(iR0,jR0).B+=( .50)*z*R0R0(kR0,lR0).e;
                  R0R0(kR0,lR0).B+=( .50)*z*R0R0(iR0,jR0).e;
               }
               if( E4RESET ){
                  E4.push_back( tE4());
                  E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
                  E4[nE4].jF2=con.R0N6F2(jR0  , 5);
                  E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
                  E4[nE4].lF2=con.R0N6F2(lR0  , 5);
                  E4[nE4++].f= ( .50)*z;
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<(nR0- 1);iR0++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int aR0=mol.Z0[jZ0].R0a;
            int bR0=(aR0-1+mol.Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<(bR0- 1);jR0++){
               if( !R0R0(iR0,jR0).b )continue;
               int kR0=(jR0+ 1);
               int lR0=(iR0+ 1);
               if( !R0R0(kR0,lR0).b )continue;
               if( (!R0R0(iR0,jR0).o)&&(!R0R0(kR0,lR0).o) ){
                  R0R0(iR0,jR0).B+=( .50)*z*R0R0(kR0,lR0).e;
                  R0R0(kR0,lR0).B+=( .50)*z*R0R0(iR0,jR0).e;
               }
               if( E4RESET ){
                  E4.push_back( tE4());
                  E4[nE4].iF2=con.R0N6F2(iR0+1, 3);
                  E4[nE4].jF2=con.R0N6F2(jR0  , 5);
                  E4[nE4].kF2=con.R0N6F2(kR0+1, 3);
                  E4[nE4].lF2=con.R0N6F2(lR0  , 5);
                  E4[nE4++].f= ( .50)*z;
               }
            }
         }
      }
   }
   return;
}
