#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENQ_PART(Tra_Automatic& aut,
                                const DAT_ARRAY_CONSTS& array_consts,
                                int kQ2,
                                int jZ0,
                                const Coordinates& x2,
                                int iQ2,
                                int iZ0){
//
//
// reusable values
//
   double CTCT= aut.CT*aut.CT;
   double CTST= aut.CT*aut.ST;
   double STST= aut.ST*aut.ST;
   double CPCP= aut.CP*aut.CP;
   double CPSP= aut.CP*aut.SP;
   double SPSP= aut.SP*aut.SP;
//
   aut.x=( x2 -aut.TRANS);
   aut.x.chain(aut.dx,aut.ddx);
//
//
// d(rtp)dx, dd(rtp)dxdx
//
   double dRdx[3];
   double ddRdxdx[3][3];
   dRdx[0]= aut.ST*aut.CP;
   dRdx[1]= aut.ST*aut.SP;
   dRdx[2]= aut.CT;
   ddRdxdx[0][0]=( CTCT*CPCP +SPSP)*aut.ZZ;
   ddRdxdx[1][0]=-STST*CPSP*aut.ZZ;
   ddRdxdx[2][0]=-CTST*aut.CP*aut.ZZ;
   ddRdxdx[0][1]= ddRdxdx[1][0];
   ddRdxdx[1][1]=( CTCT*SPSP +CPCP)*aut.ZZ;
   ddRdxdx[2][1]=-CTST*aut.SP*aut.ZZ;
   ddRdxdx[0][2]= ddRdxdx[2][0];
   ddRdxdx[1][2]= ddRdxdx[2][1];
   ddRdxdx[2][2]= STST*aut.ZZ;
   double dTdx[3];
   double ddTdxdx[3][3];
   double dPdx[3];
   double ddPdxdx[3][3];
   if( !aut.ISOTROPIC ){
      double ZZZZ= aut.ZZ*aut.ZZ;
      dTdx[0]= aut.CT*aut.CP*aut.ZZ;
      dTdx[1]= aut.CT*aut.SP*aut.ZZ;
      dTdx[2]=-aut.ST*aut.ZZ;
      if( aut.ST<(1.00e-12) ){
         ddTdxdx[0][0]= (0.00);
         ddTdxdx[1][0]= (0.00);
         ddTdxdx[1][1]= (0.00);
      }else{
         double z= aut.CT*ZZZZ/aut.ST;
         ddTdxdx[0][0]= z*( SPSP -(2.)*STST*CPCP);
         ddTdxdx[1][0]=-z*( CPSP +(2.)*STST*CPSP);
         ddTdxdx[1][1]= z*( CPCP -(2.)*STST*SPSP);
      }
      ddTdxdx[2][0]=( STST -CTCT)*aut.CP*ZZZZ;
      ddTdxdx[0][1]= ddTdxdx[1][0];
      ddTdxdx[2][1]=( STST -CTCT)*aut.SP*ZZZZ;
      ddTdxdx[0][2]= ddTdxdx[2][0];
      ddTdxdx[1][2]= ddTdxdx[2][1];
      ddTdxdx[2][2]= (2.)*CTST*ZZZZ;
//
      if( aut.ST<(1.00e-12) ){
         dPdx[0]= (0.00);
         dPdx[1]= (0.00);
      }else{
         double z= aut.ZZ/aut.ST;
         dPdx[0]=-z*aut.SP;
         dPdx[1]= z*aut.CP;
      }
      dPdx[2]= (0.00);
      if( aut.ST<(1.00e-12) ){
         ddPdxdx[0][0]= (0.00);
         ddPdxdx[1][0]= (0.00);
         ddPdxdx[1][1]= (0.00);
      }else{
         double z= ZZZZ/STST;
         ddPdxdx[0][0]= z*(2.)*CPSP;
         ddPdxdx[1][0]=-z*( CPCP -SPSP);
         ddPdxdx[1][1]=-z*(2.)*CPSP;
      }
      ddPdxdx[2][0]= (0.00);
      ddPdxdx[0][1]= ddPdxdx[1][0];
      ddPdxdx[2][1]= (0.00);
      ddPdxdx[0][2]= ddPdxdx[2][0];
      ddPdxdx[1][2]= ddPdxdx[2][1];
      ddPdxdx[2][2]= (0.00);
   }
//
//
// d(rtp)d(t,alp,bet.gam), dd(rtp)d(t,alp,bet.gam)d(t,alp,bet.gam)
//
   double dR[6];
   double ddR[6][6];
   for(int i=0;i<3;i++){
      dR[  i]= dRdx[i];
      dR[3+i]=( dRdx[0]*aut.dx[i](0)
               +dRdx[1]*aut.dx[i](1)
               +dRdx[2]*aut.dx[i](2));
      for(int j=0;j<3;j++){
         ddR[  i][  j]= ddRdxdx[i][j];
         ddR[  i][3+j]=( ddRdxdx[i][0]*aut.dx[j](0)
                        +ddRdxdx[i][1]*aut.dx[j](1)
                        +ddRdxdx[i][2]*aut.dx[j](2));
         ddR[3+j][  i]= ddR[  i][3+j]
                      +( dRdx[0]*array_consts.dROTx[j](0,i)
                        +dRdx[1]*array_consts.dROTx[j](1,i)
                        +dRdx[2]*array_consts.dROTx[j](2,i));
      }
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         ddR[3+i][3+j]=( dRdx[0]*aut.ddx[i][j](0)
                        +dRdx[1]*aut.ddx[i][j](1)
                        +dRdx[2]*aut.ddx[i][j](2))
                      +( ddR[0][3+j]*aut.dx[i](0)
                        +ddR[1][3+j]*aut.dx[i](1)
                        +ddR[2][3+j]*aut.dx[i](2));
      }
   }
   double dT[6];
   double ddT[6][6];
   double dP[6];
   double ddP[6][6];
   if( !aut.ISOTROPIC ){
      for(int i=0;i<3;i++){
         dT[  i]= dTdx[i];
         dT[3+i]=( dTdx[0]*aut.dx[i](0)
                  +dTdx[1]*aut.dx[i](1)
                  +dTdx[2]*aut.dx[i](2));
         for(int j=0;j<3;j++){
            ddT[  i][  j]= ddTdxdx[i][j];
            ddT[  i][3+j]=( ddTdxdx[i][0]*aut.dx[j](0)
                           +ddTdxdx[i][1]*aut.dx[j](1)
                           +ddTdxdx[i][2]*aut.dx[j](2));
            ddT[3+j][  i]= ddT[  i][3+j]
                         +( dTdx[0]*array_consts.dROTx[j](0,i)
                           +dTdx[1]*array_consts.dROTx[j](1,i)
                           +dTdx[2]*array_consts.dROTx[j](2,i));
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ddT[3+i][3+j]=( dTdx[0]*aut.ddx[i][j](0)
                           +dTdx[1]*aut.ddx[i][j](1)
                           +dTdx[2]*aut.ddx[i][j](2))
                         +( ddT[0][3+j]*aut.dx[i](0)
                           +ddT[1][3+j]*aut.dx[i](1)
                           +ddT[2][3+j]*aut.dx[i](2));
         }
      }
      for(int i=0;i<3;i++){
         dP[  i]= dPdx[i];
         dP[3+i]=( dPdx[0]*aut.dx[i](0)
                  +dPdx[1]*aut.dx[i](1)
                  +dPdx[2]*aut.dx[i](2));
         for(int j=0;j<3;j++){
            ddP[  i][  j]= ddPdxdx[i][j];
            ddP[  i][3+j]=( ddPdxdx[i][0]*aut.dx[j](0)
                           +ddPdxdx[i][1]*aut.dx[j](1)
                           +ddPdxdx[i][2]*aut.dx[j](2));
            ddP[3+j][  i]= ddP[  i][3+j]
                         +( dPdx[0]*array_consts.dROTx[j](0,i)
                           +dPdx[1]*array_consts.dROTx[j](1,i)
                           +dPdx[2]*array_consts.dROTx[j](2,i));
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ddP[3+i][3+j]=( dPdx[0]*aut.ddx[i][j](0)
                           +dPdx[1]*aut.ddx[i][j](1)
                           +dPdx[2]*aut.ddx[i][j](2))
                         +( ddP[0][3+j]*aut.dx[i](0)
                           +ddP[1][3+j]*aut.dx[i](1)
                           +ddP[2][3+j]*aut.dx[i](2));
         }
      }
   }
//
//
// atom pair contribution to block pair
//
   for(int i=0;i<6;i++){
      aut.e11(i)= aut.dedr*dR[i];
      for(int j=0;j<6;j++){
         aut.e11(i,j)= aut.dedr*ddR[i][j]
                      +aut.ddedrdr*dR[i]*dR[j];
      }
   }
   if( !aut.ISOTROPIC ){
      for(int i=0;i<6;i++){
         aut.e11(i)+=( aut.dedt*dT[i]
                        +aut.dedp*dP[i]);
         for(int j=0;j<6;j++){
            aut.e11(i,j)+=( aut.dedt*ddT[i][j]
                           +aut.dedp*ddP[i][j]
                           +aut.ddedrdt*( dR[i]*dT[j] +dT[i]*dR[j])
                           +aut.ddedrdp*( dR[i]*dP[j] +dP[i]*dR[j])
                           +aut.ddedtdt*dT[i]*dT[j]
                           +aut.ddedtdp*( dT[i]*dP[j] +dP[i]*dT[j])
                           +aut.ddedpdp*dP[i]*dP[j]);
         }
      }
      for(int i=0;i<3;i++){
         aut.e11(3+i)+=aut.dedq[i];
         for(int j=0;j<3;j++){
            aut.e11(3+i,3+j)+=aut.ddedqdq[i][j];
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<6;j++){
            aut.e11(3+i,  j)+=( aut.ddedqdr[i]*dR[j]
                               +aut.ddedqdt[i]*dT[j]
                               +aut.ddedqdp[i]*dP[j]);
            aut.e11(  j,3+i)+=( aut.ddedqdr[i]*dR[j]
                               +aut.ddedqdt[i]*dT[j]
                               +aut.ddedqdp[i]*dP[j]);
         }
      }
   }
//
//
// accumulate block pair
//
   Q2Q2e(kQ2,iQ2)+=aut.e11;
   if( jZ0==iZ0 )return;
//
//
// block pair wrt origin of chain of backward group
//
   for(int i=0;i<3;i++){
      aut.e00(  i)=-aut.e11(  i);
      aut.e00(3+i)=-aut.e11(3+i)
                   -aut.e11(  0)*Z0Z0y(jZ0,iZ0)(0,i)
                   -aut.e11(  1)*Z0Z0y(jZ0,iZ0)(1,i)
                   -aut.e11(  2)*Z0Z0y(jZ0,iZ0)(2,i);
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         aut.e01(  i,  j)=-aut.e11(  i,  j);
         aut.e01(3+i,  j)=-aut.e11(3+i,  j)
                          -aut.e11(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                          -aut.e11(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                          -aut.e11(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
         aut.e01(  i,3+j)=-aut.e11(  i,3+j);
         aut.e01(3+i,3+j)=-aut.e11(3+i,3+j)
                          -aut.e11(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                          -aut.e11(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                          -aut.e11(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
      }
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         aut.e00(  i,  j)=-aut.e01(  i,  j);
         aut.e00(3+i,  j)=-aut.e01(3+i,  j);
         aut.e00(  i,3+j)=-aut.e01(  i,3+j)
                          -aut.e01(  i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                          -aut.e01(  i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                          -aut.e01(  i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
         aut.e00(3+i,3+j)=-aut.e01(3+i,3+j)
                          -aut.e01(3+i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                          -aut.e01(3+i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                          -aut.e01(3+i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
      }
   }
   for(int i=0;i<6;i++){
      Q2Q2e(iQ2,kQ2)(i)+=aut.e00(i);
      for(int j=0;j<6;j++){
         Q2Q2e(iQ2,kQ2)(i,j)+=aut.e00(j,i);
      }
   }
   return;
}
