#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_P(Tra_Automatic& aut,
                             const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const Subset_Contracted_System::tM3& con,
                             int jF2,
                             int kQ2,
                             int jZ0,
                             int iF2,
                             int iQ2,
                             int iZ0){
//
//
// calc 1st and 2nd derivs of Fp
//
   bool JDONOR=( F2[jF2].D> -1 );
   bool IDONOR=( F2[iF2].D> -1 );
   double RHO= ( 1.81);
   if      ( ( JDONOR)&&(!IDONOR) ){
      if( (con.F2[jF2].atm==" H  ")&&
          (con.F2[iF2].atm==" O  ") ){
         int jR0=con.F2[jF2].R0- 1;
         int iR0=con.F2[iF2].R0;
         if( !R0R0(jR0,iR0).b )return;
         aut.pfac=( (1.00) +R0R0(jR0,iR0).D
                   +R0R0(jR0,iR0).B
                   +R0R0(jR0,iR0).C);
      }else{
         int jD=F2[jF2].D;
         int iA=F2[iF2].A;
         int jiF2F2=DAF2F2(jD,iA);
         if( jiF2F2==-1 )return;
         if( !F2F2(jiF2F2).b )return;
         aut.pfac=( (1.00) +F2F2(jiF2F2).D
                   +F2F2(jiF2F2).B
                   +F2F2(jiF2F2).C);
         RHO= ( 1.71);
      }
   }else if( (!JDONOR)&&( IDONOR) ){
      if( (con.F2[jF2].atm==" O  ")&&
          (con.F2[iF2].atm==" H  ") ){
         int jR0=con.F2[jF2].R0;
         int iR0=con.F2[iF2].R0- 1;
         if( !R0R0(iR0,jR0).b )return;
         aut.pfac=( (1.00) +R0R0(iR0,jR0).D
                   +R0R0(iR0,jR0).B
                   +R0R0(iR0,jR0).C);
      }else{
         int iD=F2[iF2].D;
         int jA=F2[jF2].A;
         int ijF2F2=DAF2F2(iD,jA);
         if( ijF2F2==-1 )return;
         if( !F2F2(ijF2F2).b )return;
         aut.pfac=( (1.00) +F2F2(ijF2F2).D
                   +F2F2(ijF2F2).B
                   +F2F2(ijF2F2).C);
         RHO= ( 1.71);
      }
   }else{
      return;
   }
//
//
// params of multipole expansion
//
   aut.pj=aut.F2[jF2].p;
   aut.pi=aut.F2[iF2].p;
   aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
   aut.RR= aut.x.rr();
   aut.R= std::sqrt( aut.RR);
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   aut.ZZ= (1.00)/aut.R;
   aut.CT= (aut.x(2)*aut.ZZ);
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= (aut.x(0)*aut.ZZ)/aut.ST;
      aut.SP= (aut.x(1)*aut.ZZ)/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }
//
//
// core repulsion
//
   double EPS= ( 1.22)/physics_consts.CAL;
   RHO/=physics_consts.ANG;
   double ZZ= (RHO*aut.ZZ);
   double e= EPS*std::pow( ZZ, 14);
   aut.dedr= (-14.00)*e*aut.ZZ;
   aut.ddedrdr= (-15.00)*aut.dedr*aut.ZZ;
//
//
// zero partial derivs wrt rtpq
//
   aut.dedt= (0.00);
   aut.dedp= (0.00);
   aut.ddedrdt= (0.00);
   aut.ddedrdp= (0.00);
   aut.ddedtdt= (0.00);
   aut.ddedtdp= (0.00);
   aut.ddedpdp= (0.00);
   for(int i=0;i<3;i++){
      aut.dedq[i]= (0.00);
      aut.ddedqdr[i]= (0.00);
      aut.ddedqdt[i]= (0.00);
      aut.ddedqdp[i]= (0.00);
      for(int j=0;j<3;j++){
         aut.ddedqdq[i][j]= (0.00);
      }
   }
//
// calc multipole expansion
// accumulate derivs (1st and 2nd) of e, not Fe
//
   bool MEDIUM=true;
   TRA_ENQ_ME(aut,
              array_consts,
              aut.pj, 3,aut.pi, 3, 6,MEDIUM);
//
// calc block pairs p_g and p_h (unscaled by pfac) for H-bond
// isolated from other atom pairs of E1
//
   TRA_ENQ_PART1(aut,
                 kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
//
// calc string of intervening torsions
// for each torsion, calc de/dchi
//
   int pE9=F2F2E9(jF2,iF2);
   if( pE9==-1 )pE9=nE9;
   TRA_ENQ_E9(aut,con,jF2,kQ2,jZ0,iF2,iQ2,iZ0,pE9);
//
//
// scale derivs of 2-bod H-bond by pfac
//
   aut.dedr*=aut.pfac;
   aut.dedt*=aut.pfac;
   aut.dedp*=aut.pfac;
   aut.ddedrdr*=aut.pfac;
   aut.ddedrdt*=aut.pfac;
   aut.ddedrdp*=aut.pfac;
   aut.ddedtdt*=aut.pfac;
   aut.ddedtdp*=aut.pfac;
   aut.ddedpdp*=aut.pfac;
   for(int i=0;i<3;i++){
      aut.dedq[i]*=aut.pfac;
      aut.ddedqdr[i]*=aut.pfac;
      aut.ddedqdt[i]*=aut.pfac;
      aut.ddedqdp[i]*=aut.pfac;
      for(int j=0;j<3;j++){
         aut.ddedqdq[i][j]*=aut.pfac;
      }
   }
//
//
// accumulate derivs of scaled H-bond to E1 block pair
//
   TRA_ENQ_PART(aut,
                array_consts,
                kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
   return;
}
