#include "../con/Subset_Contracted_System.hh"
#include "../phi/Coordinates.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENQ_O2(const Tra_Automatic& aut,
                              const Subset_Contracted_System::tM3& con,
                              int kQ2,
                              int kZ0,
                              int iF2,
                              int iZ0){

   if( kQ2>con.Z0[kZ0].Q2a ){
      O2.push_back( tO2());
      E2[nE2].cO2++;
      O2[nO2].U2=Q2[kQ2].U2;
      Coordinates b=( aut.F2[iF2].x -aut.F2[con.Q2[kQ2].bseF2].x);
      Coordinates c;
      c(0)= aut.sgnk*Q2[kQ2].c(0,0);
      c(1)= aut.sgnk*Q2[kQ2].c(1,0);
      c(2)= aut.sgnk*Q2[kQ2].c(2,0);
      O2[nO2].s= (2.00)*dot(aut.x, cross(c,b));
      nO2++;

   }else if( kZ0<iZ0 ){
      E2[nE2].cO2+=6;
      int kU2=Z0[kZ0].U2a;
      for(int i=0;i<6;i++){
         O2.push_back( tO2());
      }
      for(int i=0;i<3;i++){
         O2[nO2  +i].U2=(kU2+3+i);
         O2[nO2+3+i].U2=(kU2  +i);
      }
      Coordinates b;
      b(0)=( aut.F2[iF2].x(0) -U2chi(kU2  ));
      b(1)=( aut.F2[iF2].x(1) -U2chi(kU2+1));
      b(2)=( aut.F2[iF2].x(2) -U2chi(kU2+2));
      Coordinates t[6];
      t[0](0)= (0.00);
      t[0](1)=-b(2);
      t[0](2)= b(1);
      t[1](0)= b(2);
      t[1](1)= (0.00);
      t[1](2)=-b(0);
      t[2](0)=-b(1);
      t[2](1)= b(0);
      t[2](2)= (0.00);
      t[3](0)=-(1.00);
      t[3](1)= (0.00);
      t[3](2)= (0.00);
      t[4](0)= (0.00);
      t[4](1)=-(1.00);
      t[4](2)= (0.00);
      t[5](0)= (0.00);
      t[5](1)= (0.00);
      t[5](2)=-(1.00);
      for(int i=0;i<6;i++){
         O2[nO2+i].s= (2.00)*dot(aut.x,t[i]);
      }
      nO2+=6;

   }else if( kZ0==iZ0 ){
      E2[nE2].cO2+=6;
      int kU2=Z0[kZ0].U2a;
      for(int i=0;i<6;i++){
         O2.push_back( tO2());
      }
      for(int i=0;i<3;i++){
         O2[nO2  +i].U2=(kU2  +i);
         O2[nO2+3+i].U2=(kU2+5-i);
      }
      Coordinates b;
      b(0)=( aut.F2[iF2].x(0) -U2chi(kU2  ));
      b(1)=( aut.F2[iF2].x(1) -U2chi(kU2+1));
      b(2)=( aut.F2[iF2].x(2) -U2chi(kU2+2));
      Coordinates t[6];
      t[0](0)= (1.00);
      t[0](1)= (0.00);
      t[0](2)= (0.00);
      t[1](0)= (0.00);
      t[1](1)= (1.00);
      t[1](2)= (0.00);
      t[2](0)= (0.00);
      t[2](1)= (0.00);
      t[2](2)= (1.00);
      t[5](0)= (0.00);
      t[5](1)= b(2);
      t[5](2)=-b(1);
      t[4](0)=-b(2);
      t[4](1)= (0.00);
      t[4](2)= b(0);
      t[3](0)= b(1);
      t[3](1)=-b(0);
      t[3](2)= (0.00);
      for(int i=0;i<6;i++){
        O2[nO2+i].s= (2.00)*dot(aut.x,t[i]);
      }
      nO2+=6;

   }
   return;
}
