#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENQ_E1RESH(Tra_Automatic& aut,
                                  const DAT_PHYSICS_CONSTS& physics_consts,
                                  const DAT_ARRAY_CONSTS& array_consts,
                                  const DAT_ENERGY_PARAMS& energy_params,
                                  const Subset_Contracted_System::tM3& con,
                                  int iZ0,
                                  int mQ2,
                                  int iQ2,
                                  int iE1){
   int iQ3=con.E1[iE1].Q3;
   int pQ1min=con.Q3[iQ3].Q1a;
   int pQ1max=(pQ1min-1+con.Q3[iQ3].cQ1);
   int jZ0=con.E1[iE1].Z0;
   int kQ2=con.E1[iE1].k;
   int lam=con.E1[iE1].lam;
   if      ( lam==0 ){
      bool EPASS=false;
      int jX1=con.E1[iE1].X2;
      int jF2min=con.X1[jX1].F2a;
      int jF2max=(jF2min-1+con.X1[jX1].cF2);
      for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int i_3min=con.Q1[iQ1].G3a;
         int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
         for(int i_3=i_3min;i_3<=i_3max;i_3++){
            int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                con.G3[i_3].F2;
            for(int jF2=jF2min;jF2<=jF2max;jF2++){
               TRA_ENQ_RESH(aut,
                            physics_consts,array_consts,energy_params,
                            con,
                            jF2,kQ2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
            }
         }
      }

   }else if( lam==1 ){
      bool EPASS=false;
      int jU1=con.E1[iE1].X2;
      int jH2min=con.U1[jU1].H2a;
      int jH2max=(jH2min-1+con.U1[jU1].cH2);
      for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int i_3min=con.Q1[iQ1].G3a;
         int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
         for(int i_3=i_3min;i_3<=i_3max;i_3++){
            int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                con.G3[i_3].F2;
            for(int jH2=jH2min;jH2<=jH2max;jH2++){
               int jF2=con.H2[jH2].F2;
               TRA_ENQ_RESH(aut,
                            physics_consts,array_consts,energy_params,
                            con,
                            jF2,kQ2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
            }
         }
      }

   }else if( (lam==2)||(lam==3) ){
      bool EPASS=false;
      int jQ1=con.E1[iE1].X2;
      int j_3min=con.Q1[jQ1].G3a;
      int j_3max=(j_3min-1+con.Q1[jQ1].cG3);
      for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int i_3min=con.Q1[iQ1].G3a;
         int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
         for(int i_3=i_3min;i_3<=i_3max;i_3++){
            int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                con.G3[i_3].F2;
            for(int j_3=j_3min;j_3<=j_3max;j_3++){
               int jF2=( lam==3 )? con.B3[j_3].F2:
                                   con.G3[j_3].F2;
               TRA_ENQ_RESH(aut,
                            physics_consts,array_consts,energy_params,
                            con,
                            jF2,kQ2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
            }
         }
      }

   }else if( lam==4 ){
      int jX2=con.E1[iE1].X2;
      aut.x=( aut.Q3[iQ3].x -aut.X2[jX2].x);
      aut.R= aut.x.r();
      double d=( aut.Q3[iQ3].r>=aut.X2[jX2].r )? aut.Q3[iQ3].r: aut.X2[jX2].r;
      int LTEe=TRA_ENQ_L(aut.R,d, 8);
      bool GRPGRP=false;
      if( LTEe<8 ){
         GRPGRP=true;
         if( ETARGET ){
         }else{
            TRA_ENQ_E(aut,array_consts,
                      aut.X2[jX2].q,kQ2,jZ0,
                      aut.Q3[iQ3].x,aut.Q3[iQ3].q,iQ2,iZ0,
                      LTEe);
         }
      }
      int pX1min=con.X2[jX2].X1a;
      int pX1max=(pX1min-1+con.X2[jX2].cX1);
      for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int i_3min=con.Q1[iQ1].G3a;
         int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
         for(int pX1=pX1min;pX1<=pX1max;pX1++){
            int jX1=con.X1[pX1].ord;
            bool EPASS=GRPGRP;
            if( !EPASS ){
               aut.x=( aut.Q1[iQ1].x -aut.X1[jX1].x);
               aut.R= aut.x.r();
               d=( aut.Q1[iQ1].r>=aut.X1[jX1].r )? aut.Q1[iQ1].r: aut.X1[jX1].r;
               LTEe=TRA_ENQ_L(aut.R,d, 8);
               if( LTEe<8 ){
                  EPASS=true;
                  if( ETARGET ){
                  }else{
                     TRA_ENQ_E(aut,array_consts,
                               aut.X1[jX1].q,kQ2,jZ0,
                               aut.Q1[iQ1].x,aut.Q1[iQ1].q,iQ2,iZ0,
                               LTEe);
                  }
               }
            }
            int jF2min=con.X1[jX1].F2a;
            int jF2max=(jF2min-1+con.X1[jX1].cF2);
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                   con.G3[i_3].F2;
               for(int jF2=jF2min;jF2<=jF2max;jF2++){
                  TRA_ENQ_RESH(aut,
                               physics_consts,array_consts,energy_params,
                               con,
                               jF2,kQ2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
               }
            }
         }
      }

   }else if( (lam==6)||(lam==7) ){
      int jQ3=con.E1[iE1].X2;
      aut.x=( aut.Q3[iQ3].x -aut.Q3[jQ3].x);
      aut.R= aut.x.r();
      double d=( aut.Q3[iQ3].r>=aut.Q3[jQ3].r )? aut.Q3[iQ3].r: aut.Q3[jQ3].r;
      int LTEe=TRA_ENQ_L(aut.R,d, 8);
      bool GRPGRP=false;
      if( LTEe<8 ){
         GRPGRP=true;
         if( ETARGET ){
         }else{
            TRA_ENQ_E(aut,array_consts,
                      aut.Q3[jQ3].q,kQ2,jZ0,
                      aut.Q3[iQ3].x,aut.Q3[iQ3].q,iQ2,iZ0,
                      LTEe);
         }
      }
      int qQ1min=con.Q3[jQ3].Q1a;
      int qQ1max=(qQ1min-1+con.Q3[jQ3].cQ1);
      for(int pQ1=pQ1min;pQ1<=pQ1max;pQ1++){
         int iQ1=con.Q1[pQ1].ord;
         int i_3min=con.Q1[iQ1].G3a;
         int i_3max=(i_3min-1+con.Q1[iQ1].cG3);
         for(int qQ1=qQ1min;qQ1<=qQ1max;qQ1++){
            int jQ1=con.Q1[qQ1].ord;
            bool EPASS=GRPGRP;
            if( !EPASS ){
               aut.x=( aut.Q1[iQ1].x -aut.Q1[jQ1].x);
               aut.R= aut.x.r();
               d=( aut.Q1[iQ1].r>=aut.Q1[jQ1].r )? aut.Q1[iQ1].r: aut.Q1[jQ1].r;
               LTEe=TRA_ENQ_L(aut.R,d, 8);
               if( LTEe<8 ){
                  EPASS=true;
                  if( ETARGET ){
                  }else{
                     TRA_ENQ_E(aut,array_consts,
                               aut.Q1[jQ1].q,kQ2,jZ0,
                               aut.Q1[iQ1].x,aut.Q1[iQ1].q,iQ2,iZ0,
                               LTEe);
                  }
               }
            }
            int j_3min=con.Q1[jQ1].G3a;
            int j_3max=(j_3min-1+con.Q1[jQ1].cG3);
            for(int i_3=i_3min;i_3<=i_3max;i_3++){
               int iF2=(iQ2==mQ2)? con.B3[i_3].F2:
                                   con.G3[i_3].F2;
               for(int j_3=j_3min;j_3<=j_3max;j_3++){
                  int jF2=( lam==7 )? con.B3[j_3].F2:
                                      con.G3[j_3].F2;
                  TRA_ENQ_RESH(aut,
                               physics_consts,array_consts,energy_params,
                               con,
                               jF2,kQ2,jZ0,iE1,iF2,i_3,iQ2,iZ0,EPASS);
               }
            }
         }
      }

   }
   return;
}
