#include "../con/Subset_Contracted_System.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <vector>

class MEM_tra_enq_cont {
private:
   std::vector<int> o_Q2ORD;                    //order of generation
public:
   std::vector<std::vector<int> > o_Q2hQ2;      //connected Q2 with higher br
   std::vector<int> o_JNTQ2;                    //
   MEM_tra_enq_cont(int q):
      o_Q2ORD(q)
   {
   }
   int& Q2ORD(int i){
      return o_Q2ORD.at( i);  }
   std::vector<int>& Q2hQ2(int i){
      return o_Q2hQ2.at( i);  }
   int& JNTQ2(int i){
      return o_JNTQ2.at( i);  }
};

void Energy_Surfq::TRA_ENQ_CONT(Tra_Automatic& aut,
                                const Subset_Contracted_System::tM3& con){
   MEM_tra_enq_cont vv(oQ2);
//
//
// contract Q2Q2 interchain
//
   for(int iZ0= 1;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int jZ0= 0;jZ0<iZ0;jZ0++){
         int aQ2=con.Z0[jZ0].Q2a;
         int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);

// con.Q2[nQ2+1].jnt=mQ2
         {
            int iQ2ent=-1;
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
               if( con.Q2[iQ2].jnt==mQ2 )iQ2ent=iQ2;
               int ibr=con.Q2[iQ2].br;
               if( ((con.Q2[iQ2+1].jnt!=iQ2)&&(ibr>0))||
                   (icQ2==1) ){
// iQ2 is the terminal torsion of a branch
                  int jQ2=aQ2;
                  int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
                  for(int jcQ2=(bQ2-aQ2+1);jcQ2>0;jcQ2--){
                     int jbr=con.Q2[jQ2].br;
                     if( ((con.Q2[jQ2+1].jnt!=jQ2)&&(jbr>0))||
                         (jcQ2==1) ){
// jQ2 is the terminal torsion of a branch

                        for(int kQ2=iQ2;kQ2>mQ2;kQ2=con.Q2[kQ2].jnt){
                           for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                              Q2Q2e(iQ2ent,kQ2)+=Q2Q2e(lQ2,kQ2);
                              for(int iU3= 0;iU3<oU3;iU3++){
                                 U3Q2Q2e(iU3,iQ2ent,kQ2)+=
                                 U3Q2Q2e(iU3,lQ2,kQ2);
                                 for(int jU3=iU3;jU3<oU3;jU3++){
                                    U3U3Q2Q2e(iU3,jU3,iQ2ent,kQ2)+=
                                    U3U3Q2Q2e(iU3,jU3,lQ2,kQ2);
                                 }
                              }
                              if( lQ2==aQ2 )break;
                              if( (jcQ2>1)&&
                                  (con.Q2[lQ2].cbr<jbr) )break;
                           }
                           if( (icQ2>1)&&
                               (con.Q2[kQ2].cbr<ibr) )break;
                        }

                     }
                     if( con.Q2[jQ2].omg==1 ){
                        int L=jQ2hold;
                        jQ2hold=(jQ2+1);
                        jQ2=L;
                     }else{
                        jQ2++;
                     }
                  }
               }
            }
         }
         {
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2+1);icQ2>0;icQ2--){
               int ibr=con.Q2[iQ2].br;
               if( ((con.Q2[iQ2+1].jnt!=iQ2)&&(ibr>0))||
                   (icQ2==1) ){
// iQ2 is the terminal torsion of a branch
                  vv.o_Q2hQ2.resize(bQ2-aQ2+1);
                  int jQ2ent=aQ2;
                  int jQ2=aQ2;
                  int jQ2hold=(aQ2+con.Z0[jZ0].cQ2bb);
                  for(int jcQ2=(bQ2-aQ2+1);jcQ2>0;jcQ2--){
                     int jbr=con.Q2[jQ2].br;
                     if( jQ2>aQ2 ){
                        int gQ2=con.Q2[jQ2].jnt;
                        if( con.Q2[gQ2].br<jbr ){
                           vv.Q2hQ2(gQ2-aQ2).push_back(jQ2);
                        }
                     }
                     if( ((con.Q2[jQ2+1].jnt!=jQ2)&&(jbr>0))||
                         (jcQ2==1) ){
// jQ2 is the terminal torsion of a branch

                        for(int kQ2=iQ2;;kQ2=con.Q2[kQ2].jnt){
                           int gQ2=( kQ2>mQ2 )? con.Q2[kQ2].jnt: jQ2ent;
                           int hQ2=-1;
                           for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                              if( kQ2>mQ2 ){
                                 Q2Q2e(lQ2,gQ2)+=Q2Q2e(lQ2,kQ2);
                                 Q2Q2e(gQ2,lQ2)+=Q2Q2e(kQ2,lQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,lQ2,gQ2)+=
                                    U3Q2Q2e(iU3,lQ2,kQ2);
                                    U3Q2Q2e(iU3,gQ2,lQ2)+=
                                    U3Q2Q2e(iU3,kQ2,lQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,lQ2,gQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,lQ2,kQ2);
                                       U3U3Q2Q2e(iU3,jU3,gQ2,lQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,kQ2,lQ2);
                                    }
                                 }
                              }else if( lQ2>aQ2 ){
                                 Q2Q2e(gQ2,lQ2)+=Q2Q2e(kQ2,lQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,gQ2,lQ2)+=
                                    U3Q2Q2e(iU3,kQ2,lQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,gQ2,lQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,kQ2,lQ2);
                                    }
                                 }
                              }
                              if( lQ2!=jQ2 ){
                                 Q2Q2e(lQ2,kQ2)+=Q2Q2e(hQ2,kQ2);
                                 Q2Q2e(kQ2,lQ2)+=Q2Q2e(kQ2,hQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,lQ2,kQ2)+=
                                    U3Q2Q2e(iU3,hQ2,kQ2);
                                    U3Q2Q2e(iU3,kQ2,lQ2)+=
                                    U3Q2Q2e(iU3,kQ2,hQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,hQ2,kQ2);
                                       U3U3Q2Q2e(iU3,jU3,kQ2,lQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,kQ2,hQ2);
                                    }
                                 }
                                 for(size_t j=0;j<vv.Q2hQ2(lQ2-aQ2).size();j++){
                                    int eQ2=vv.Q2hQ2(lQ2-aQ2)[j];
                                    if( eQ2==hQ2 )continue;
                                    Q2Q2e(lQ2,kQ2)+=Q2Q2e(eQ2,kQ2);
                                    Q2Q2e(kQ2,lQ2)+=Q2Q2e(kQ2,eQ2);
                                    for(int iU3= 0;iU3<oU3;iU3++){
                                       U3Q2Q2e(iU3,lQ2,kQ2)+=
                                       U3Q2Q2e(iU3,eQ2,kQ2);
                                       U3Q2Q2e(iU3,kQ2,lQ2)+=
                                       U3Q2Q2e(iU3,kQ2,eQ2);
                                       for(int jU3=iU3;jU3<oU3;jU3++){
                                          U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                          U3U3Q2Q2e(iU3,jU3,eQ2,kQ2);
                                          U3U3Q2Q2e(iU3,jU3,kQ2,lQ2)+=
                                          U3U3Q2Q2e(iU3,jU3,kQ2,eQ2);
                                       }
                                    }
                                 }
                              }
                              if( lQ2==aQ2 )break;
                              if( (jcQ2>1)&&
                                  (con.Q2[lQ2].cbr<jbr) )break;
                              hQ2=lQ2;
                           }
                           if( kQ2==mQ2 )break;
                           if( (icQ2>1)&&
                               (con.Q2[kQ2].cbr<ibr) )break;
                        }

                     }
                     if( con.Q2[jQ2].omg==1 ){
                        int L=jQ2hold;
                        jQ2hold=(jQ2+1);
                        jQ2=L;
                     }else{
                        jQ2++;
                     }
                     if( con.Q2[jQ2].jnt==aQ2 )jQ2ent=jQ2;
                  }
                  vv.o_Q2hQ2.clear();
               }
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
            }
         }

      }
   }
//
//
// contract Q2Q2 intrachain
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      vv.o_JNTQ2.resize(nQ2-mQ2);
      int iORD=0;
      int iBBw=mQ2;
      int iSCa=(nQ2+1);
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         vv.Q2ORD(iQ2)=iORD++;
         int ibr=con.Q2[iQ2].br;
         int icbr=con.Q2[iQ2].cbr;
         if( ibr==0 ){
            iBBw=iQ2;
            iSCa=(nQ2+1);
         }else{
            if( icbr==0 )iSCa=iQ2;
         }
         if( (con.Q2[iQ2+1].jnt!=iQ2)&&
             ((ibr>0)||(icQ2==1)) ){
// iQ2 is the terminal torsion of a branch

            int nJNT=0;
            int jBBw=mQ2;
            int jSCa=(nQ2+1);
            int jQ2=mQ2;
            int jQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int jcQ2=(nQ2-mQ2)-(icQ2-1);jcQ2>0;jcQ2--){
               if( con.Q2[jQ2].omg==1 ){
                  int L=jQ2hold;
                  jQ2hold=(jQ2+1);
                  jQ2=L;
               }else{
                  jQ2++;
               }
               int jbr=con.Q2[jQ2].br;
               int jcbr=con.Q2[jQ2].cbr;
               if( jbr==0 ){
                  jBBw=jQ2;
                  jSCa=(nQ2+1);
               }else{
                  if( jcbr==0 )jSCa=jQ2;
               }

               if( (jQ2<=iBBw)||((jQ2>=iSCa)&&(jbr<=ibr)) ){
// jQ2 is in the path to iQ2
                  int hQ2=con.Q2[jQ2].jnt;
                  int gQ2;
                  for(int kQ2=iQ2;kQ2>=jQ2;kQ2=gQ2){
                     gQ2=con.Q2[kQ2].jnt;
                     if( gQ2>=jQ2 ){
                        Q2Q2e(jQ2,gQ2)+=Q2Q2e(jQ2,kQ2);
                        for(int iU3= 0;iU3<oU3;iU3++){
                           U3Q2Q2e(iU3,jQ2,gQ2)+=
                           U3Q2Q2e(iU3,jQ2,kQ2);
                           for(int jU3=iU3;jU3<oU3;jU3++){
                              U3U3Q2Q2e(iU3,jU3,jQ2,gQ2)+=
                              U3U3Q2Q2e(iU3,jU3,jQ2,kQ2);
                           }
                        }
                     }
                     if( hQ2>mQ2 ){
                        Q2Q2e(jQ2,kQ2)+=Q2Q2e(hQ2,kQ2);
                        for(int iU3= 0;iU3<oU3;iU3++){
                           U3Q2Q2e(iU3,jQ2,kQ2)+=
                           U3Q2Q2e(iU3,hQ2,kQ2);
                           for(int jU3=iU3;jU3<oU3;jU3++){
                              U3U3Q2Q2e(iU3,jU3,jQ2,kQ2)+=
                              U3U3Q2Q2e(iU3,jU3,hQ2,kQ2);
                           }
                        }
                     }
                     if( nJNT>0 ){
                        for(int iJNT=0;iJNT<nJNT;iJNT++){
                           int aQ2=vv.JNTQ2(iJNT);
                           Q2Q2e(jQ2,kQ2)+=Q2Q2e(aQ2,kQ2);
                           for(int iU3= 0;iU3<oU3;iU3++){
                              U3Q2Q2e(iU3,jQ2,kQ2)+=
                              U3Q2Q2e(iU3,aQ2,kQ2);
                              for(int jU3=iU3;jU3<oU3;jU3++){
                                 U3U3Q2Q2e(iU3,jU3,jQ2,kQ2)+=
                                 U3U3Q2Q2e(iU3,jU3,aQ2,kQ2);
                              }
                           }
                        }
                     }
                     if( (con.Q2[gQ2].br<ibr)&&(icQ2>1) )break;
                  }
                  nJNT=0;
               }else{
                  if( (jcbr==0)||((jQ2>=iSCa)&&(jcbr<jbr)) ){
                     vv.JNTQ2(nJNT++)=jQ2;
                  }
                  if( con.Q2[jQ2+1].jnt!=jQ2 ){
// jQ2 is the terminal torsion of a branch
                     int gQ2;
                     int eQ2=-1;
                     bool gPATH=true;
                     for(int kQ2=iQ2;kQ2!=jQ2;kQ2=gQ2){
                        if( (kQ2<=iBBw)||
                            ((kQ2>=iSCa)&&(con.Q2[kQ2].br<=ibr)) ){
                           eQ2=kQ2;
                           gQ2=con.Q2[kQ2].jnt;
                           if( gQ2==jBBw ){
                              gQ2=jSCa;
                              gPATH=false;
                           }else if( (gQ2>=iSCa)&&(gQ2<jQ2) ){
                              gQ2++;
                              gPATH=false;
                           }
                        }else{
                           gQ2=(kQ2+1);
                           while( con.Q2[gQ2].br>jbr ){
                              gQ2++;
                           }
                        }
                        int hQ2=0;
                        for(int lQ2=jQ2;;lQ2=con.Q2[lQ2].jnt){
                           if( gPATH ){
                              if( lQ2!=kQ2 ){
                                 Q2Q2e(lQ2,gQ2)+=Q2Q2e(lQ2,kQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,lQ2,gQ2)+=
                                    U3Q2Q2e(iU3,lQ2,kQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,lQ2,gQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,lQ2,kQ2);
                                    }
                                 }
                              }
                              if( lQ2!=jQ2 ){
                                 Q2Q2e(lQ2,kQ2)+=Q2Q2e(hQ2,kQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,lQ2,kQ2)+=
                                    U3Q2Q2e(iU3,hQ2,kQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,hQ2,kQ2);
                                    }
                                 }
                                 if( con.Q2[lQ2+1].br>con.Q2[lQ2].br ){
                                    Q2Q2e(lQ2,kQ2)+=Q2Q2e(lQ2+1,kQ2);
                                    for(int iU3= 0;iU3<oU3;iU3++){
                                       U3Q2Q2e(iU3,lQ2,kQ2)+=
                                       U3Q2Q2e(iU3,lQ2+1,kQ2);
                                       for(int jU3=iU3;jU3<oU3;jU3++){
                                          U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                          U3U3Q2Q2e(iU3,jU3,lQ2+1,kQ2);
                                       }
                                    }
                                 }
                              }
                           }else{
                              if( (lQ2!=jQ2)&&(kQ2==eQ2) ){
                                 Q2Q2e(lQ2,kQ2)+=Q2Q2e(hQ2,kQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,lQ2,kQ2)+=
                                    U3Q2Q2e(iU3,hQ2,kQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                       U3U3Q2Q2e(iU3,jU3,hQ2,kQ2);
                                    }
                                 }
                                 if( con.Q2[lQ2+1].br>con.Q2[lQ2].br ){
                                    Q2Q2e(lQ2,kQ2)+=Q2Q2e(lQ2+1,kQ2);
                                    for(int iU3= 0;iU3<oU3;iU3++){
                                       U3Q2Q2e(iU3,lQ2,kQ2)+=
                                       U3Q2Q2e(iU3,lQ2+1,kQ2);
                                       for(int jU3=iU3;jU3<oU3;jU3++){
                                          U3U3Q2Q2e(iU3,jU3,lQ2,kQ2)+=
                                          U3U3Q2Q2e(iU3,jU3,lQ2+1,kQ2);
                                       }
                                    }
                                 }
                              }
                              if( lQ2!=kQ2 ){
                                 int aQ2=lQ2;
                                 int bQ2=gQ2;
                                 if( vv.Q2ORD(lQ2)>vv.Q2ORD(gQ2) ){
                                    aQ2=gQ2;
                                    bQ2=lQ2;
                                 }
                                 Q2Q2e(aQ2,bQ2)-=Q2Q2e(lQ2,eQ2);
                                 for(int iU3= 0;iU3<oU3;iU3++){
                                    U3Q2Q2e(iU3,aQ2,bQ2)-=
                                    U3Q2Q2e(iU3,lQ2,eQ2);
                                    for(int jU3=iU3;jU3<oU3;jU3++){
                                       U3U3Q2Q2e(iU3,jU3,aQ2,bQ2)-=
                                       U3U3Q2Q2e(iU3,jU3,lQ2,eQ2);
                                    }
                                 }
                              }
                           }
                           if( lQ2==kQ2 )break;
                           if( con.Q2[lQ2].cbr<jbr )break;
                           hQ2=lQ2;
                        }
                        if( (con.Q2[gQ2].br<ibr)&&(icQ2>1) )break;
                     }
                  }
               }

            }

         }
      }
      vv.o_JNTQ2.clear();
   }
//
//
// chain derivatives
//
   aut.sgnj= (-1.00);
   for(int iZ0= 1;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         for(int jZ0= 0;jZ0<iZ0;jZ0++){
            int aQ2=con.Z0[jZ0].Q2a;
            int bQ2=(aQ2-1+con.Z0[jZ0].cQ2);
            for(int jQ2=aQ2;jQ2<=bQ2;jQ2++){
               if( oU3> 0 ){
                  TRA_ENE_A(aut,con,jZ0,jQ2,iZ0,iQ2);
               }
               TRA_ENQ_A(aut,con,jZ0,jQ2,iZ0,iQ2);
               Q2Q2e(jQ2,iQ2).zero();
               Q2Q2e(iQ2,jQ2).zero();
               for(int iU3= 0;iU3<oU3;iU3++){
                  U3Q2Q2e(iU3,jQ2,iQ2).zero();
                  U3Q2Q2e(iU3,iQ2,jQ2).zero();
                  for(int jU3=iU3;jU3<oU3;jU3++){
                     U3U3Q2Q2e(iU3,jU3,jQ2,iQ2).zero();
                     U3U3Q2Q2e(iU3,jU3,iQ2,jQ2).zero();
                  }
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int BBw=mQ2;
      int SCa=(nQ2+1);
      int iQ2=mQ2;
      int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
      for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
         if( con.Q2[iQ2].omg==1 ){
            int L=iQ2hold;
            iQ2hold=(iQ2+1);
            iQ2=L;
         }else{
            iQ2++;
         }
         int br=con.Q2[iQ2].br;
         int cbr=con.Q2[iQ2].cbr;
         if( br==0 ){
            BBw=iQ2;
            SCa=(nQ2+1);
         }else{
            if( cbr==0 )SCa=iQ2;
         }
         if( oU3> 0 ){
            TRA_ENE_G(iZ0,iQ2);
         }
         TRA_ENQ_G(iZ0,iQ2);
         int jQ2=mQ2;
         int jQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int jcQ2=(nQ2-mQ2)-(icQ2-1);jcQ2>0;jcQ2--){
            if( con.Q2[jQ2].omg==1 ){
               int L=jQ2hold;
               jQ2hold=(jQ2+1);
               jQ2=L;
            }else{
               jQ2++;
            }
            bool jPATH=false;
            if( con.Q2[jQ2].br<=br ){
               if( (jQ2<=BBw)||
                   (jQ2>=SCa) )jPATH=true;
// jQ2 is in the path to iQ2
            }
            aut.sgnj=( jPATH )? ( 1.00): (-1.00);
            if( oU3> 0 ){
               TRA_ENE_A(aut,con,iZ0,jQ2,iZ0,iQ2);
            }
            TRA_ENQ_A(aut,con,iZ0,jQ2,iZ0,iQ2);
            Q2Q2e(jQ2,iQ2).zero();
            for(int iU3= 0;iU3<oU3;iU3++){
               U3Q2Q2e(iU3,jQ2,iQ2).zero();
               for(int jU3=iU3;jU3<oU3;jU3++){
                  U3U3Q2Q2e(iU3,jU3,jQ2,iQ2).zero();
               }
            }
         }
      }
   }
   return;
}
