#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <cmath>

void Energy_Surfq::TRA_ENQ_C(Tra_Automatic& aut,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const DAT_ENERGY_PARAMS& energy_params,
                             const Thread_Options& opt,
                             const Subset_Contracted_System::tM3& con,
                             int jF2,
                             int jZ0,
                             int iC1,
                             int iF2,
                             int iQ2,
                             int iZ0){
//
//
// calc Fc+Fb
//
   aut.x=( aut.F2[iF2].x -aut.F2[jF2].x);
   aut.R= aut.x.r();
   if( aut.R<(1.00e-12) )aut.R= (1.00e-12);
   aut.ZZ= (1.00)/aut.R;
   aut.CT= aut.x(2)*aut.ZZ;
   aut.ST= std::sqrt( (1.00) -aut.CT*aut.CT);
   if( aut.ST>(1.00e-12) ){
      aut.CP= aut.x(0)*aut.ZZ/aut.ST;
      aut.SP= aut.x(1)*aut.ZZ/aut.ST;
   }else{
      aut.CP= (1.00);
      aut.SP= (0.00);
   }
   double r0= con.C1[iC1].d0;
   double a0;
   if( con.C1[iC1].CYCLE ){
      a0= con.C1[iC1].a0;
      Fb+=a0*std::pow(( aut.R -r0),2);
   }else{
//    int iW0=con.C1[iC1].W0;
      int iW0=opt.iW0_active;
      a0= energy_params.W0a(iW0);
      Fc+=a0*std::pow(( aut.R -r0),2);
   }
   aut.dedr= (2.00)*a0*( aut.R -r0);
   aut.ddedrdr= (2.00)*a0;
   int kQ2=con.C1[iC1].k;
   TRA_ENQ_PART(aut,
                array_consts,
                kQ2,jZ0,aut.F2[iF2].x,iQ2,iZ0);
   return;
}
