#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"
#include <string>
#include <iomanip>

void Energy_Surfq::TRA_ENQ(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_REGION_MAPS& region_maps,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep){
//
//
// initiate energy surface
//
   TOT= (0.00);
   for(int iU3= 0;iU3<oU3;iU3++){
      U3f(iU3)= (0.00);
      for(int jU3=iU3;jU3<oU3;jU3++){
         U3U3f(iU3,jU3)= (0.00);
      }
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      U2g(iU2)= (0.00);
      for(int iU3= 0;iU3<oU3;iU3++){
         U3U2g(iU3,iU2)= (0.00);
         for(int jU3=iU3;jU3<oU3;jU3++){
            U3U3U2g(iU3,jU3,iU2)= (0.00);
         }
      }
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2= 0;jU2<nU2;jU2++){
         U2U2a(iU2,jU2)= (0.00);
         for(int iU3= 0;iU3<oU3;iU3++){
            U3U2U2a(iU3,iU2,jU2)= (0.00);
            for(int jU3=iU3;jU3<oU3;jU3++){
               U3U3U2U2a(iU3,jU3,iU2,jU2)= (0.00);
            }
         }
      }
   }
//
//
// initiate block pair partition
//
   o_Q2Q2e.resize(oQ2*oQ2);
   o_U3Q2Q2e.resize(oU3*oQ2*oQ2);
   o_U3U3Q2Q2e.resize(oU3*(oU3+1)*oQ2*oQ2/2);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int iQ2min=con.Z0[iZ0].Q2a;
      int iQ2max=(iQ2min-1+con.Z0[iZ0].cQ2);
      for(int iQ2=iQ2min;iQ2<=iQ2max;iQ2++){
         for(int jZ0= 0;jZ0<oZ0;jZ0++){
            int jQ2min=con.Z0[jZ0].Q2a;
            int jQ2max=(jQ2min-1+con.Z0[jZ0].cQ2);
            for(int jQ2=jQ2min;jQ2<=jQ2max;jQ2++){
               Q2Q2e(iQ2,jQ2).zero();
               for(int iU3= 0;iU3<oU3;iU3++){
                  U3Q2Q2e(iU3,iQ2,jQ2).zero();
                  for(int jU3=iU3;jU3<oU3;jU3++){
                     U3U3Q2Q2e(iU3,jU3,iQ2,jQ2).zero();
                  }
               }
            }
         }
      }
   }
//
//
// initiate aut
//
   int oF2=(con.Z0[oZ0-1].F2a+con.Z0[oZ0-1].cF2);
   int oQ3=(con.Z0[oZ0-1].Q3a+con.Z0[oZ0-1].cQ3);
   int oQ1=(mol.Z0[oZ0-1].Q1a+mol.Z0[oZ0-1].cQ1);
   int oX2=(con.Z0[oZ0-1].X2a+con.Z0[oZ0-1].cX2);
   int oX1=oQ1;
   Tra_Automatic aut(oF2,oQ3,oQ1,oX2,oX1);
//
//
// generate coordinates and multipoles for atoms and groups
//
   TRA_ENQ_XQ(aut,
              array_consts,
              out,mol,con,dep);
//
//
// construct params of Fw
//
   TRA_ENQ_WPAR(aut,
                physics_consts,
                con);
//
//
// assemble peptide-peptide H-bonds, chains of H-bonds, bifurcations
//
   TRA_ENQ_PPAR(aut,
                physics_consts,array_consts,region_maps,
                mol,con,dep);
//
//
// energy surface
//
   TRA_ENQ_RESTCH(aut,
                  physics_consts,array_consts,energy_params,
                  opt,out,con,dep);
   TRA_ENQ_PWM(aut,
               physics_consts,array_consts,region_maps,
               out,mol,con,dep);
   TRA_ENQ_CONT(aut,
                con);
//
//
// units
//
   TOT*=(physics_consts.CAL);
   for(int iU3= 0;iU3<oU3;iU3++){
      U3f(iU3)*=(physics_consts.CAL);
      for(int jU3=iU3;jU3<oU3;jU3++){
         U3U3f(iU3,jU3)*=(physics_consts.CAL);
      }
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      double z= (physics_consts.CAL*U2uca(iU2));
      U2g(iU2)*=z;
      for(int iU3= 0;iU3<oU3;iU3++){
         U3U2g(iU3,iU2)*=z;
         for(int jU3=iU3;jU3<oU3;jU3++){
            U3U3U2g(iU3,jU3,iU2)*=z;
         }
      }
   }
   for(int iU2= 0;iU2<nU2;iU2++){
      for(int jU2=iU2;jU2<nU2;jU2++){
         double z= (physics_consts.CAL*U2uca(iU2)*U2uca(jU2));
         U2U2a(iU2,jU2)*=z;
         for(int iU3= 0;iU3<oU3;iU3++){
            U3U2U2a(iU3,iU2,jU2)*=z;
            for(int jU3=iU3;jU3<oU3;jU3++){
               U3U3U2U2a(iU3,jU3,iU2,jU2)*=z;
            }
         }
      }
   }
   Fr*= physics_consts.CAL;
   Fe*= physics_consts.CAL;
   Fs*= physics_consts.CAL;
   Ft*= physics_consts.CAL;
   Fc*= physics_consts.CAL;
   Fb*= physics_consts.CAL;
   Fh*= physics_consts.CAL;
   Fp*= physics_consts.CAL;
   Fw*= physics_consts.CAL;
   Fp_a*= physics_consts.CAL;
   Fp_b*= physics_consts.CAL;
   Fp_c*= physics_consts.CAL;
   Fp_d*= physics_consts.CAL;
   Fp_e*= physics_consts.CAL;
//
//
//
//
   o_Q2Q2e.clear();
   o_U3Q2Q2e.clear();
   o_U3U3Q2Q2e.clear();
//
//
//
//
//// std::string hrule="________________________________________"
////                   "________________________________________\n";
//// out.FILE3<<hrule;
//// out.FILE3<< std::fixed<< std::setprecision(5);
//// out.FILE3<<"     Fr       Fe       Fs       Ft       Fc  "
////            "     Fb       Fh       Fp       Fw  \n";
//// out.FILE3<< std::setw( 9)<<Fr
////          << std::setw( 9)<<Fe
////          << std::setw( 9)<<Fs
////          << std::setw( 9)<<Ft
////          << std::setw( 9)<<Fc
////          << std::setw( 9)<<Fb
////          << std::setw( 9)<<Fh
////          << std::setw( 9)<<Fp
////          << std::setw( 9)<<Fw<<'\n';
//// out.FILE3<< std::scientific<< std::setprecision( 8);
//// out.FILE3<<"TOT\n";
//// out.FILE3<< std::setw(15)<<TOT<<'\n';
//// out.FILE3<<"U2g\n";
//// for(int iU2= 0;iU2<nU2;iU2++){
////    out.FILE3<< std::setw(15)<<U2g(iU2);
////    if( ((iU2+1)%8==0)||(iU2==(nU2-1)) )out.FILE3<<'\n';
//// }
//// out.FILE3<<"U2U2a\n";
//// for(int iU2= 0;iU2<nU2;iU2++){
////    for(int jU2=iU2;jU2<nU2;jU2++){
////       out.FILE3<< std::setw(15)<<U2U2a(iU2,jU2);
////       if( ((jU2-iU2+1)%8==0)||(jU2==(nU2-1)) )out.FILE3<<'\n';
////    }
//// }
//// for(int iU3= 0;iU3<oU3;iU3++){
////    out.FILE3<<"U3f\n";
////    out.FILE3<< std::setw(15)<<U3f(iU3)<<'\n';
////    out.FILE3<<"U3U2g\n";
////    for(int iU2= 0;iU2<nU2;iU2++){
////       out.FILE3<< std::setw(15)<<U3U2g(iU3,iU2);
////       if( ((iU2+1)%8==0)||(iU2==(nU2-1)) )out.FILE3<<'\n';
////    }
////    out.FILE3<<"U3U2U2a\n";
////    for(int iU2= 0;iU2<nU2;iU2++){
////       for(int jU2=iU2;jU2<nU2;jU2++){
////          out.FILE3<< std::setw(15)<<U3U2U2a(iU3,iU2,jU2);
////          if( ((jU2-iU2+1)%8==0)||(jU2==(nU2-1)) )out.FILE3<<'\n';
////       }
////    }
//// }
//// for(int iU3= 0;iU3<oU3;iU3++){
////    for(int jU3=iU3;jU3<oU3;jU3++){
////       out.FILE3<<"U3U3f\n";
////       out.FILE3<< std::setw(15)<<U3U3f(iU3,jU3)<<'\n';
////       out.FILE3<<"U3U3U2g\n";
////       for(int iU2= 0;iU2<nU2;iU2++){
////          out.FILE3<< std::setw(15)<<U3U3U2g(iU3,jU3,iU2);
////          if( ((iU2+1)%8==0)||(iU2==(nU2-1)) )out.FILE3<<'\n';
////       }
////       out.FILE3<<"U3U3U2U2a\n";
////       for(int iU2= 0;iU2<nU2;iU2++){
////          for(int jU2=iU2;jU2<nU2;jU2++){
////             out.FILE3<< std::setw(15)<<U3U3U2U2a(iU3,jU3,iU2,jU2);
////             if( ((jU2-iU2+1)%8==0)||(jU2==(nU2-1)) )out.FILE3<<'\n';
////          }
////       }
////    }
//// }
   return;
}
