#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_tra_enp {
private:
   std::vector<double> o_U2d;           //displacement from local min
   std::vector<double> o_U3gw;          //w component of U3g
   std::vector<double> o_U3tdt;         //dot product(U2d,U3U2t)
   std::vector<double> o_U3gz;          //z
   std::vector<double> o_U3gy;          //y
public:
   MEM_tra_enp(int o,int p):
      o_U2d(o),
      o_U3gw(p),
      o_U3tdt(p),
      o_U3gz(p),
      o_U3gy(p)
   {
   }
   double& U2d(int i){
      return o_U2d.at( i);  }
   double& U3gw(int i){
      return o_U3gw.at( i);  }
   double& U3tdt(int i){
      return o_U3tdt.at( i);  }
   double& U3gz(int i){
      return o_U3gz.at( i);  }
   double& U3gy(int i){
      return o_U3gy.at( i);  }
};

void Energy_Surfp::TRA_ENP(const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_REGION_MAPS& region_maps,
                           const Thread_Options& opt,
                           Output_Streams& out,
                           const Mechanical_System& mol,
                           const Subset_Contracted_System::tM3& con,
                           Conf_Dependent_System& dep,
                           Energy_Surfq& enq,
                           Energy_Surfq& ene){
   MEM_tra_enp vv(oU2,oU3);
//
//
// zero surface for target func wrt params
//
   TOT= (0.00);
   for(int iU3= 0;iU3<nU3;iU3++){
      U3g(iU3)= (0.00);
   }
   for(int iU3= 0;iU3<nU3;iU3++){
      for(int jU3= 0;jU3<nU3;jU3++){
         U3U3a(iU3,jU3)= (0.00);
      }
   }
//
//
// evaluate surface for energy wrt coords and params
//
   ene.TRA_ENQ(physics_consts,array_consts,energy_params,region_maps,
               opt,out,mol,con,dep);
//
// evaluate surface for (TOT-Fe-Fh-Fp) wrt coords
// invert surface (TOT-Fe-Fh-Fp) to ( Fe+Fh+Fp)
//
   enq.ETARGET=true;
   enq.STARGET=true;
   enq.TTARGET=false;
   enq.HTARGET=true;
   enq.MTARGET=true;
   enq.WTARGET=false;
   enq.TRA_ENQ(physics_consts,array_consts,energy_params,region_maps,
               opt,out,mol,con,dep);
   enq.ETARGET=false;
   enq.STARGET=false;
   enq.TTARGET=false;
   enq.HTARGET=false;
   enq.MTARGET=false;
   enq.WTARGET=false;
   enq.TOT=( ene.TOT -enq.TOT);
   for(int iU2= 0;iU2<oU2;iU2++){
      enq.U2g(iU2)=( ene.U2g(iU2) -enq.U2g(iU2));
      for(int jU2=iU2;jU2<oU2;jU2++){
         enq.U2U2a(iU2,jU2)=( ene.U2U2a(iU2,jU2) -enq.U2U2a(iU2,jU2));
      }
   }
//
//
// evaluate step U2t to minimum on surface for energy wrt coords
//
   Lagrange_Multiplier lag(oU2);
   lag.bU2=(oU2-1);
   lag.aU2= 0;
   lag.accept(ene);
   z= std::sqrt( lag.gradient()/double(oU2));
   for(double BETA= std::sqrt( oU2)*( 4.00e-2);
       BETA> std::sqrt( oU2)*( 2.00e-5);
       BETA*=( .25)){
      int ck1,ck2,ck3,ck4,ck5;         //loop counters

      for(ck1=8;ck1>0;ck1--){
         if      ( ck1==8 ){
            lag.lamda= ( 8.00);
         }else if( ck1==1 ){
            lag.lamda=-lag.hbound;
         }else{
            lag.lamda*=( 8.00);
         }
         lag.diagonal();
         bool pd=lag.lower();
         if( pd )break;
      }
      if( ck1==0 ){
         std::cerr<<"ERROR: ( A +lam*I) is not positive definite.\n";
         std::exit( 3);
      }
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
      double dxx;
      double xx=lag.length(dxx);

      for(ck2=4;ck2>0;ck2--){
         if( xx>(BETA*BETA*(0.99)) )break;
         if( lag.lamda<=(0.00) )break;
         for(ck4=10;ck4>0;ck4--){
            for(int ii=0;ii<10;ii++){
               lag.step(lag.o_U2x,lag.lamda,lag.o_U2x);
            }
            lag.normalize();
         }
         double dlamda= lag.lamdastep(BETA);
         for(ck5=30;ck5>0;ck5--){
            lag.diagonal();
            bool pd=lag.lower();
            if( pd )break;
            lag.lamda+=dlamda;
            dlamda*=(2.00);
         }
         if( ck5==0 ){
            std::cerr<<"ERROR: ( A +lam*I) is not positive definite.\n";
            std::exit( 3);
         }
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
      }

      for(ck3=32;ck3>0;ck3--){
         if( xx<=(BETA*BETA*(1.01)) )break;
         lag.lamdastep(BETA,xx,dxx);
         lag.diagonal();
         bool pd=lag.lower();
         if( !pd ){
            std::cerr<<"ERROR: ( A +lam*I) is not positive definite.\n";
            std::exit( 3);
         }
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         lag.step(lag.o_U2dx,(-2.00),lag.o_U2x);
         xx=lag.length(dxx);
      }

      lamda= lag.lamda;
      s= std::sqrt( xx/oU2);
      delf= lag.deltaf();
      if( std::abs( delf)< (16.00) )break;
   }
//
//
// evaluate derivatives of step U2t wrt params
//
   for(int iU2= 0;iU2<oU2;iU2++){
      U2t(iU2)= lag.U2x(iU2);
      lag.U2g(iU2)= (0.00);
   }
   for(int iU3= 0;iU3<oU3;iU3++){
      for(int iU2= 0;iU2<oU2;iU2++){
         lag.U2g(iU2)+=( ene.U3U2g(iU3,iU2)
                        +ene.U3U2U2a(iU3,iU2,iU2)*U2t(iU2));
         for(int jU2=(iU2+1);jU2<oU2;jU2++){
            lag.U2g(iU2)+=( ene.U3U2U2a(iU3,iU2,jU2)*U2t(jU2));
            lag.U2g(jU2)+=( ene.U3U2U2a(iU3,iU2,jU2)*U2t(iU2));
         }
      }
      lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
      for(int iU2= 0;iU2<oU2;iU2++){
         U3U2t(iU3,iU2)= lag.U2x(iU2);
         lag.U2g(iU2)= (0.00);
      }
   }
   for(int iU3= 0;iU3<oU3;iU3++){
      for(int jU3=iU3;jU3<oU3;jU3++){
         for(int iU2= 0;iU2<oU2;iU2++){
            lag.U2g(iU2)+=( ene.U3U3U2g(iU3,jU3,iU2)
                           +ene.U3U3U2U2a(iU3,jU3,iU2,iU2)*U2t(iU2)
                           +ene.U3U2U2a(iU3,iU2,iU2)*U3U2t(jU3,iU2)
                           +ene.U3U2U2a(jU3,iU2,iU2)*U3U2t(iU3,iU2));
            for(int jU2=(iU2+1);jU2<oU2;jU2++){
               lag.U2g(iU2)+=( ene.U3U3U2U2a(iU3,jU3,iU2,jU2)*U2t(jU2)
                              +ene.U3U2U2a(iU3,iU2,jU2)*U3U2t(jU3,jU2)
                              +ene.U3U2U2a(jU3,iU2,jU2)*U3U2t(iU3,jU2));
               lag.U2g(jU2)+=( ene.U3U3U2U2a(iU3,jU3,iU2,jU2)*U2t(iU2)
                              +ene.U3U2U2a(iU3,iU2,jU2)*U3U2t(jU3,iU2)
                              +ene.U3U2U2a(jU3,iU2,jU2)*U3U2t(iU3,iU2));
            }
         }
         lag.step(lag.o_U2x,(-1.00),lag.o_U2g);
         for(int iU2= 0;iU2<oU2;iU2++){
            U3U3U2t(iU3,jU3,iU2)= lag.U2x(iU2);
            lag.U2g(iU2)= (0.00);
         }
      }
   }
//
//
// current displacement U2d=( U2chi -U2chi_por)/U2uca of inflation trajectory
//
   {
      int iU2=0;
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         if( !con.Z0[iZ0].sub )continue;
         double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;
         Rotation_Matrix ROT;
//
         vv.U2d(iU2  )=( ene.U2chi(iU2  ) -U2chi_por(iU2  ))
                      /ene.U2uca(iU2  );
         vv.U2d(iU2+1)=( ene.U2chi(iU2+1) -U2chi_por(iU2+1))
                      /ene.U2uca(iU2+1);
         vv.U2d(iU2+2)=( ene.U2chi(iU2+2) -U2chi_por(iU2+2))
                      /ene.U2uca(iU2+2);
         alp= ene.U2chi(iU2+3);
         bet= ene.U2chi(iU2+4);
         gam= ene.U2chi(iU2+5);
         Rotation_Matrix ROT2(alp,bet,gam);
         alp= U2chi_por(iU2+3);
         bet= U2chi_por(iU2+4);
         gam= U2chi_por(iU2+5);
         Rotation_Matrix ROT0(alp,bet,gam);
//
         ROT= ROT2*transpose(ROT0);
         Sbet= ROT(2,0);
         Cbet= std::sqrt( (1.00) -Sbet*Sbet);
         bet= std::atan2(Sbet,Cbet);
         if( Cbet<(1.00e-12) ){
            gam= (0.00);
            if( Sbet>(0.00) ){
               Calp= ROT2(1,1);
               Salp= ROT2(0,1);
            }else{
               Calp= ROT2(0,2);
               Salp= ROT2(1,2);
            }
            alp= std::atan2(Salp,Calp);
         }else{
            Calp= (ROT(2,2)/Cbet);
            Salp=-(ROT(2,1)/Cbet);
            alp= std::atan2(Salp,Calp);
            Cgam= (ROT(0,0)/Cbet);
            Sgam=-(ROT(1,0)/Cbet);
            gam= std::atan2(Sgam,Cgam);
         }
         vv.U2d(iU2+3)= alp/ene.U2uca(iU2+3);
         vv.U2d(iU2+4)= bet/ene.U2uca(iU2+4);
         vv.U2d(iU2+5)= gam/ene.U2uca(iU2+5);
         iU2+=6;
      }
      for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            vv.U2d(iU2)=( ene.U2chi(iU2) -U2chi_por(iU2));
            if      ( vv.U2d(iU2)<-physics_consts.PI ){
               vv.U2d(iU2)+=(2.00)*physics_consts.PI;
            }else if( vv.U2d(iU2)> physics_consts.PI ){
               vv.U2d(iU2)-=(2.00)*physics_consts.PI;
            }
            vv.U2d(iU2)/=ene.U2uca(iU2);
            iU2++;
         }
      }
   }
//
//
// surface for target func wrt params, param constraint
//
   {
      double a= fac_w*(1.50)*physics_consts.ekT*double(oU2)/double(oU3);
      Fw= (0.00);
      int iU3=0;
      for(int iT= 0;iT<oT;iT++){
         if( Tb[iT] ){
            double e= a*Tr_pre(iT)/Tr(iT);
            double dedr= -e/Tr(iT);
            double ddedrdr= -(2.00)*dedr/Tr(iT);
            Fw+=e;
            U3g(iU3)+=dedr;
            U3U3a(iU3,iU3)+=ddedrdr;
            vv.U3gw(iU3)= dedr;
            iU3++;
         }
      }
      for(int iH= 0;iH<oH;iH++){
         if( Hb[iH] ){
            double e= a*Hr_pre(iH)/Hr(iH);
            double dedr= -e/Hr(iH);
            double ddedrdr= -(2.00)*dedr/Hr(iH);
            Fw+=e;
            U3g(iU3)+=dedr;
            U3U3a(iU3,iU3)+=ddedrdr;
            vv.U3gw(iU3)= dedr;
            iU3++;
         }
      }
      TOT+=Fw;
   }
//
//
// surface for target func wrt params, generalized coord displacement
//
   {
      double tt= (0.00);
      double dd= (0.00);
      for(int iU2= 0;iU2<oU2;iU2++){
         tt+=( vv.U2d(iU2) +U2t(iU2))*( vv.U2d(iU2) +U2t(iU2));
         dd+=vv.U2d(iU2)*vv.U2d(iU2);
      }
      double t= std::sqrt( tt);
      double d= std::sqrt( dd);
      Fz= (fac_z/s)*( t -d);
      TOT+=Fz;
      double a= ((fac_z/s)/t);
      for(int iU3= 0;iU3<oU3;iU3++){
         vv.U3tdt(iU3)= (0.00);
         for(int iU2= 0;iU2<oU2;iU2++){
            vv.U3tdt(iU3)+=( vv.U2d(iU2) +U2t(iU2))*U3U2t(iU3,iU2);
         }
         U3g(iU3)+=a*vv.U3tdt(iU3);
         vv.U3gz(iU3)= a*vv.U3tdt(iU3);
      }
      double b= a/tt;
      for(int iU3= 0;iU3<oU3;iU3++){
         for(int jU3=iU3;jU3<oU3;jU3++){
            U3U3a(iU3,jU3)-=b*vv.U3tdt(jU3)*vv.U3tdt(iU3);
            for(int iU2= 0;iU2<oU2;iU2++){
               U3U3a(iU3,jU3)+=a*( ( vv.U2d(iU2) +U2t(iU2))*U3U3U2t(iU3,jU3,iU2)
                                  +U3U2t(jU3,iU2)*U3U2t(iU3,iU2));
            }
         }
      }
   }
//
//
// surface for target func wrt params, energy component
//
   {
      Fy= (0.00);
      for(int iU2= 0;iU2<oU2;iU2++){
         Fy+=fac_y*(
                 enq.U2g(iU2)*U2t(iU2)
                +(.5)*enq.U2U2a(iU2,iU2)*U2t(iU2)*U2t(iU2));
         for(int jU2=(iU2+1);jU2<oU2;jU2++){
            Fy+=fac_y*(
                    enq.U2U2a(iU2,jU2)*U2t(iU2)*U2t(jU2));
         }
      }
      TOT+=Fy;
      for(int iU3= 0;iU3<oU3;iU3++){
         vv.U3gy(iU3)= U3g(iU3);
         for(int iU2= 0;iU2<oU2;iU2++){
            U3g(iU3)+=fac_y*(
                    enq.U2g(iU2)*U3U2t(iU3,iU2)
                   +enq.U2U2a(iU2,iU2)*U2t(iU2)*U3U2t(iU3,iU2));
            for(int jU2=(iU2+1);jU2<oU2;jU2++){
               U3g(iU3)+=fac_y*(
                       enq.U2U2a(iU2,jU2)*( U3U2t(iU3,iU2)*U2t(jU2)
                                           +U2t(iU2)*U3U2t(iU3,jU2)));
            }
         }
         vv.U3gy(iU3)=( U3g(iU3) -vv.U3gy(iU3));
      }
      for(int iU3= 0;iU3<oU3;iU3++){
         for(int jU3=iU3;jU3<oU3;jU3++){
            for(int iU2= 0;iU2<oU2;iU2++){
               U3U3a(iU3,jU3)+=fac_y*(
                        enq.U2g(iU2)*U3U3U2t(iU3,jU3,iU2)
                       +enq.U2U2a(iU2,iU2)*( U3U2t(jU3,iU2)*U3U2t(iU3,iU2)
                                            +U2t(iU2)*U3U3U2t(iU3,jU3,iU2)));
               for(int jU2=(iU2+1);jU2<oU2;jU2++){
                  U3U3a(iU3,jU3)+=fac_y*(
                          enq.U2U2a(iU2,jU2)*( U3U3U2t(iU3,jU3,iU2)*U2t(jU2)
                                              +U3U2t(iU3,iU2)*U3U2t(jU3,jU2)
                                              +U3U2t(jU3,iU2)*U3U2t(iU3,jU2)
                                              +U2t(iU2)*U3U3U2t(iU3,jU3,jU2)));
               }
            }
         }
      }
   }
//
//
// normalize energy surface
//
   for(int iU3= 0;iU3<nU3;iU3++){
      U3g(iU3)*=U3uca(iU3);
   }
   for(int iU3= 0;iU3<nU3;iU3++){
      for(int jU3=iU3;jU3<nU3;jU3++){
         U3U3a(iU3,jU3)*=(U3uca(iU3)*U3uca(jU3));
      }
   }
//
//
// characterization of target func surf
//
   double gg= (0.00);
   for(int iU3= 0;iU3<nU3;iU3++){
      gg+=U3g(iU3)*U3g(iU3);
   }
   g= std::sqrt( gg/double(oU3));
//
//
// output energy surface
//
// out.FILE3<<"    F   "
//          <<"     z     "
//          <<"     lam   "
//          <<"     s     "
//          <<"     delf  "
//          <<"    Fy  "
//          <<"    Fz  "
//          <<"    Fw  \n";
// out.FILE3<< std::fixed<< std::setprecision( 4)
//          << std::setw( 8)<<TOT
//          << std::scientific<< std::setprecision( 4)
//          << std::setw(11)<<z
//          << std::setw(11)<<lamda
//          << std::setw(11)<<s
//          << std::setw(11)<<delf
//          << std::fixed<< std::setprecision( 4)
//          << std::setw( 8)<<Fy
//          << std::setw( 8)<<Fz
//          << std::setw( 8)<<Fw<<'\n';
// out.FILE3<<"    Fr  "
//          <<"    Fe  "
//          <<"    Fs  "
//          <<"    Ft  "
//          <<"    Fc  "
//          <<"    Fb  "
//          <<"    Fh  "
//          <<"    Fw  "
//          <<"    Fp  \n";
// out.FILE3<< std::fixed<< std::setprecision( 2)
//          << std::setw( 8)<<ene.Fr
//          << std::setw( 8)<<ene.Fe
//          << std::setw( 8)<<ene.Fs
//          << std::setw( 8)<<ene.Ft
//          << std::setw( 8)<<ene.Fc
//          << std::setw( 8)<<ene.Fb
//          << std::setw( 8)<<ene.Fh
//          << std::setw( 8)<<ene.Fw
//          << std::setw( 8)<<ene.Fp<<'\n';
// out.FILE3<< std::fixed<< std::setprecision( 7);
// out.FILE3<<"FUNC\n";
// out.FILE3<< std::setw(15)<<TOT;
// out.FILE3<<"1st DERIV\n";
// for(int iU3= 0;iU3<nU3;iU3++){
//    out.FILE3<< std::setw(15)<<U3g(iU3);
//    if( (iU3%6==5)||(iU3==(nU3-1)) ){
//       out.FILE3<<'\n';
//    }
// }
// out.FILE3<<"2nd DERIV\n";
// for(int iU3= 0;iU3<nU3;iU3++){
//    for(int jU3=iU3;jU3<nU3;jU3++){
//       out.FILE3<< std::setw(15)<<U3U3a(iU3,jU3);
//       if( (jU3%6==5)||(jU3==(nU3-1)) ){
//          out.FILE3<<'\n';
//       }
//    }
// }
// out.FILE3<< std::fixed<< std::setprecision( 5);
// out.FILE3<<" i"
//          <<"    U3gw   "
//          <<"    U3gy   "
//          <<"    U3gz   \n";
// for(int iU3= 0;iU3<oU3;iU3++){
//    out.FILE3<< std::setw( 2)<<iU3
//             << std::setw(11)<<vv.U3gw(iU3)
//             << std::setw(11)<<vv.U3gy(iU3)
//             << std::setw(11)<<vv.U3gz(iU3)<<'\n';
// }
   return;
}
