#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENE_PART(Tra_Automatic& aut,
                                const DAT_ARRAY_CONSTS& array_consts,
                                int kQ2,
                                int jZ0,
                                const Coordinates& x2,
                                int iQ2,
                                int iZ0,
                                int iU3,
                                int jU3){
//
//
// reusable values
//
   double CTCT= aut.CT*aut.CT;
   double CTST= aut.CT*aut.ST;
   double STST= aut.ST*aut.ST;
   double CPCP= aut.CP*aut.CP;
   double CPSP= aut.CP*aut.SP;
   double SPSP= aut.SP*aut.SP;
//
   Coordinates xbac= aut.x;
   aut.x=( x2 -aut.TRANS);
   aut.x.chain(aut.dx,aut.ddx);
   aut.x= xbac;
//
//
// d(rtp)dx, dd(rtp)dxdx
//
   double dRdx[3];
   double ddRdxdx[3][3];
   dRdx[0]= aut.ST*aut.CP;
   dRdx[1]= aut.ST*aut.SP;
   dRdx[2]= aut.CT;
   ddRdxdx[0][0]=( CTCT*CPCP +SPSP)*aut.ZZ;
   ddRdxdx[1][0]=-STST*CPSP*aut.ZZ;
   ddRdxdx[2][0]=-CTST*aut.CP*aut.ZZ;
   ddRdxdx[0][1]= ddRdxdx[1][0];
   ddRdxdx[1][1]=( CTCT*SPSP +CPCP)*aut.ZZ;
   ddRdxdx[2][1]=-CTST*aut.SP*aut.ZZ;
   ddRdxdx[0][2]= ddRdxdx[2][0];
   ddRdxdx[1][2]= ddRdxdx[2][1];
   ddRdxdx[2][2]= STST*aut.ZZ;
   double dTdx[3];
   double ddTdxdx[3][3];
   double dPdx[3];
   double ddPdxdx[3][3];
   if( !aut.ISOTROPIC ){
      double ZZZZ= aut.ZZ*aut.ZZ;
      dTdx[0]= aut.CT*aut.CP*aut.ZZ;
      dTdx[1]= aut.CT*aut.SP*aut.ZZ;
      dTdx[2]=-aut.ST*aut.ZZ;
      if( aut.ST<(1.00e-12) ){
         ddTdxdx[0][0]= (0.00);
         ddTdxdx[1][0]= (0.00);
         ddTdxdx[1][1]= (0.00);
      }else{
         double z= aut.CT*ZZZZ/aut.ST;
         ddTdxdx[0][0]= z*( SPSP -(2.)*STST*CPCP);
         ddTdxdx[1][0]=-z*( CPSP +(2.)*STST*CPSP);
         ddTdxdx[1][1]= z*( CPCP -(2.)*STST*SPSP);
      }
      ddTdxdx[2][0]=( STST -CTCT)*aut.CP*ZZZZ;
      ddTdxdx[0][1]= ddTdxdx[1][0];
      ddTdxdx[2][1]=( STST -CTCT)*aut.SP*ZZZZ;
      ddTdxdx[0][2]= ddTdxdx[2][0];
      ddTdxdx[1][2]= ddTdxdx[2][1];
      ddTdxdx[2][2]= (2.)*CTST*ZZZZ;
//
      if( aut.ST<(1.00e-12) ){
         dPdx[0]= (0.00);
         dPdx[1]= (0.00);
      }else{
         double z= aut.ZZ/aut.ST;
         dPdx[0]=-z*aut.SP;
         dPdx[1]= z*aut.CP;
      }
      dPdx[2]= (0.00);
      if( aut.ST<(1.00e-12) ){
         ddPdxdx[0][0]= (0.00);
         ddPdxdx[1][0]= (0.00);
         ddPdxdx[1][1]= (0.00);
      }else{
         double z= ZZZZ/STST;
         ddPdxdx[0][0]= z*(2.)*CPSP;
         ddPdxdx[1][0]=-z*( CPCP -SPSP);
         ddPdxdx[1][1]=-z*(2.)*CPSP;
      }
      ddPdxdx[2][0]= (0.00);
      ddPdxdx[0][1]= ddPdxdx[1][0];
      ddPdxdx[2][1]= (0.00);
      ddPdxdx[0][2]= ddPdxdx[2][0];
      ddPdxdx[1][2]= ddPdxdx[2][1];
      ddPdxdx[2][2]= (0.00);
   }
//
//
// d(rtp)d(t,alp,bet.gam), dd(rtp)d(t,alp,bet.gam)d(t,alp,bet.gam)
//
   double dR[6];
   double ddR[6][6];
   for(int i=0;i<3;i++){
      dR[  i]= dRdx[i];
      dR[3+i]=( dRdx[0]*aut.dx[i](0)
               +dRdx[1]*aut.dx[i](1)
               +dRdx[2]*aut.dx[i](2));
      for(int j=0;j<3;j++){
         ddR[  i][  j]= ddRdxdx[i][j];
         ddR[  i][3+j]=( ddRdxdx[i][0]*aut.dx[j](0)
                        +ddRdxdx[i][1]*aut.dx[j](1)
                        +ddRdxdx[i][2]*aut.dx[j](2));
         ddR[3+j][  i]= ddR[  i][3+j]
                      +( dRdx[0]*array_consts.dROTx[j](0,i)
                        +dRdx[1]*array_consts.dROTx[j](1,i)
                        +dRdx[2]*array_consts.dROTx[j](2,i));
      }
   }
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         ddR[3+i][3+j]=( dRdx[0]*aut.ddx[i][j](0)
                        +dRdx[1]*aut.ddx[i][j](1)
                        +dRdx[2]*aut.ddx[i][j](2))
                      +( ddR[0][3+j]*aut.dx[i](0)
                        +ddR[1][3+j]*aut.dx[i](1)
                        +ddR[2][3+j]*aut.dx[i](2));
      }
   }
   double dT[6];
   double ddT[6][6];
   double dP[6];
   double ddP[6][6];
   if( !aut.ISOTROPIC ){
      for(int i=0;i<3;i++){
         dT[  i]= dTdx[i];
         dT[3+i]=( dTdx[0]*aut.dx[i](0)
                  +dTdx[1]*aut.dx[i](1)
                  +dTdx[2]*aut.dx[i](2));
         for(int j=0;j<3;j++){
            ddT[  i][  j]= ddTdxdx[i][j];
            ddT[  i][3+j]=( ddTdxdx[i][0]*aut.dx[j](0)
                           +ddTdxdx[i][1]*aut.dx[j](1)
                           +ddTdxdx[i][2]*aut.dx[j](2));
            ddT[3+j][  i]= ddT[  i][3+j]
                         +( dTdx[0]*array_consts.dROTx[j](0,i)
                           +dTdx[1]*array_consts.dROTx[j](1,i)
                           +dTdx[2]*array_consts.dROTx[j](2,i));
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ddT[3+i][3+j]=( dTdx[0]*aut.ddx[i][j](0)
                           +dTdx[1]*aut.ddx[i][j](1)
                           +dTdx[2]*aut.ddx[i][j](2))
                         +( ddT[0][3+j]*aut.dx[i](0)
                           +ddT[1][3+j]*aut.dx[i](1)
                           +ddT[2][3+j]*aut.dx[i](2));
         }
      }
      for(int i=0;i<3;i++){
         dP[  i]= dPdx[i];
         dP[3+i]=( dPdx[0]*aut.dx[i](0)
                  +dPdx[1]*aut.dx[i](1)
                  +dPdx[2]*aut.dx[i](2));
         for(int j=0;j<3;j++){
            ddP[  i][  j]= ddPdxdx[i][j];
            ddP[  i][3+j]=( ddPdxdx[i][0]*aut.dx[j](0)
                           +ddPdxdx[i][1]*aut.dx[j](1)
                           +ddPdxdx[i][2]*aut.dx[j](2));
            ddP[3+j][  i]= ddP[  i][3+j]
                         +( dPdx[0]*array_consts.dROTx[j](0,i)
                           +dPdx[1]*array_consts.dROTx[j](1,i)
                           +dPdx[2]*array_consts.dROTx[j](2,i));
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ddP[3+i][3+j]=( dPdx[0]*aut.ddx[i][j](0)
                           +dPdx[1]*aut.ddx[i][j](1)
                           +dPdx[2]*aut.ddx[i][j](2))
                         +( ddP[0][3+j]*aut.dx[i](0)
                           +ddP[1][3+j]*aut.dx[i](1)
                           +ddP[2][3+j]*aut.dx[i](2));
         }
      }
   }
//
//
// atom pair contribution to block pair
//
   for(int u=1;u<6;u+=3){
      int iU=(u/3);
      for(int i=0;i<6;i++){
         aut.Ue11[iU](i)= aut.ddedr[u]*dR[i];
         for(int j=0;j<6;j++){
            aut.Ue11[iU](i,j)= aut.ddedr[u]*ddR[i][j]
                                 +aut.dddedrdr[u]*dR[i]*dR[j];
         }
      }
      for(int v=1;v<6;v+=3){
         int jU=(v/3);
         for(int i=0;i<6;i++){
            aut.UUe11[iU][jU](i)= aut.dddedr[ u*6 +v]*dR[i];
            for(int j=0;j<6;j++){
               aut.UUe11[iU][jU](i,j)= aut.dddedr[ u*6 +v]*ddR[i][j]
                                         +aut.ddddedrdr[ u*6 +v]*dR[i]*dR[j];
            }
         }
      }
   }
   if( !aut.ISOTROPIC ){
      for(int u=1;u<6;u+=3){
         int iU=(u/3);
         for(int i=0;i<6;i++){
            aut.Ue11[iU](i)+=(
               aut.dedt*aut.de[u]*dT[i]
              +aut.dedp*aut.de[u]*dP[i]
                                );
            for(int j=0;j<6;j++){
               aut.Ue11[iU](i,j)+=(
                  aut.dedt*aut.de[u]*ddT[i][j]
                 +aut.dedp*aut.de[u]*ddP[i][j]
                 +aut.dedt*aut.ddedr[u]*( dR[i]*dT[j] +dT[i]*dR[j])
                 +aut.dedp*aut.ddedr[u]*( dR[i]*dP[j] +dP[i]*dR[j])
                 +aut.ddedtdt*aut.de[u]*dT[i]*dT[j]
                 +aut.ddedtdp*aut.de[u]*( dT[i]*dP[j] +dP[i]*dT[j])
                 +aut.ddedpdp*aut.de[u]*dP[i]*dP[j]
                                      );
            }
         }
         for(int i=0;i<3;i++){
            aut.Ue11[iU](3+i)+=
               aut.dedq[i]*aut.de[u];
            for(int j=0;j<3;j++){
               aut.Ue11[iU](3+i,3+j)+=
                  aut.ddedqdq[i][j]*aut.de[u];
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<6;j++){
               aut.Ue11[iU](3+i,  j)+=(
                  aut.dedq[i]*aut.ddedr[u]*dR[j]
                 +aut.ddedqdt[i]*aut.de[u]*dT[j]
                 +aut.ddedqdp[i]*aut.de[u]*dP[j]
                                          );
               aut.Ue11[iU](  j,3+i)+=(
                  aut.dedq[i]*aut.ddedr[u]*dR[j]
                 +aut.ddedqdt[i]*aut.de[u]*dT[j]
                 +aut.ddedqdp[i]*aut.de[u]*dP[j]
                                          );
            }
         }
         for(int v=1;v<6;v+=3){
            int jU=(v/3);
            for(int i=0;i<6;i++){
               aut.UUe11[iU][jU](i)+=(
                  aut.dedt*aut.dde[ u*6 +v]*dT[i]
                 +aut.dedp*aut.dde[ u*6 +v]*dP[i]
                                        );
               for(int j=0;j<6;j++){
                  aut.UUe11[iU][jU](i,j)+=(
                     aut.dedt*aut.dde[ u*6 +v]*ddT[i][j]
                    +aut.dedp*aut.dde[ u*6 +v]*ddP[i][j]
                    +aut.dedt*aut.dddedr[ u*6 +v]*( dR[i]*dT[j] +dT[i]*dR[j])
                    +aut.dedp*aut.dddedr[ u*6 +v]*( dR[i]*dP[j] +dP[i]*dR[j])
                    +aut.ddedtdt*aut.dde[ u*6 +v]*dT[i]*dT[j]
                    +aut.ddedtdp*aut.dde[ u*6 +v]*( dT[i]*dP[j] +dP[i]*dT[j])
                    +aut.ddedpdp*aut.dde[ u*6 +v]*dP[i]*dP[j]
                                              );
               }
            }
            for(int i=0;i<3;i++){
               aut.UUe11[iU][jU](3+i)+=
                  aut.dedq[i]*aut.dde[ u*6 +v];
               for(int j=0;j<3;j++){
                  aut.UUe11[iU][jU](3+i,3+j)+=
                     aut.ddedqdq[i][j]*aut.dde[ u*6 +v];
               }
            }
            for(int i=0;i<3;i++){
               for(int j=0;j<6;j++){
                  aut.UUe11[iU][jU](3+i,  j)+=(
                     aut.dedq[i]*aut.dddedr[ u*6 +v]*dR[j]
                    +aut.ddedqdt[i]*aut.dde[ u*6 +v]*dT[j]
                    +aut.ddedqdp[i]*aut.dde[ u*6 +v]*dP[j]
                                                  );
                  aut.UUe11[iU][jU](  j,3+i)+=(
                     aut.dedq[i]*aut.dddedr[ u*6 +v]*dR[j]
                    +aut.ddedqdt[i]*aut.dde[ u*6 +v]*dT[j]
                    +aut.ddedqdp[i]*aut.dde[ u*6 +v]*dP[j]
                                                  );
               }
            }
         }
      }
   }
//
//
// accumulate block pair
//
   if( iU3>= 0 ){
      U3Q2Q2e(iU3,kQ2,iQ2)+=aut.Ue11[0];
      U3U3Q2Q2e(iU3,iU3,kQ2,iQ2)+=aut.UUe11[0][0];
   }
   if( jU3>= 0 ){
      U3Q2Q2e(jU3,kQ2,iQ2)+=aut.Ue11[1];
      U3U3Q2Q2e(jU3,jU3,kQ2,iQ2)+=aut.UUe11[1][1];
   }
   if( (iU3>= 0)&&(jU3>= 0) ){
      if( jU3<=iU3 ){
         U3U3Q2Q2e(jU3,iU3,kQ2,iQ2)+=aut.UUe11[1][0];
      }
      if( iU3<=jU3 ){
         U3U3Q2Q2e(iU3,jU3,kQ2,iQ2)+=aut.UUe11[0][1];
      }
   }
   if( jZ0==iZ0 )return;
//
//
// block pair wrt origin of chain of backward group
//
   for(int iU=0;iU<2;iU++){
      Block_Pair& Ue11=aut.Ue11[iU];
      Block_Pair& Ue01=aut.Ue01[iU];
      Block_Pair& Ue00=aut.Ue00[iU];
      for(int i=0;i<3;i++){
         Ue00(  i)=-Ue11(  i);
         Ue00(3+i)=-Ue11(3+i)
                     -Ue11(  0)*Z0Z0y(jZ0,iZ0)(0,i)
                     -Ue11(  1)*Z0Z0y(jZ0,iZ0)(1,i)
                     -Ue11(  2)*Z0Z0y(jZ0,iZ0)(2,i);
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            Ue01(  i,  j)=-Ue11(  i,  j);
            Ue01(3+i,  j)=-Ue11(3+i,  j)
                             -Ue11(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                             -Ue11(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                             -Ue11(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
            Ue01(  i,3+j)=-Ue11(  i,3+j);
            Ue01(3+i,3+j)=-Ue11(3+i,3+j)
                             -Ue11(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                             -Ue11(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                             -Ue11(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
         }
      }
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            Ue00(  i,  j)=-Ue01(  i,  j);
            Ue00(3+i,  j)=-Ue01(3+i,  j);
            Ue00(  i,3+j)=-Ue01(  i,3+j)
                             -Ue01(  i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                             -Ue01(  i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                             -Ue01(  i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
            Ue00(3+i,3+j)=-Ue01(3+i,3+j)
                             -Ue01(3+i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                             -Ue01(3+i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                             -Ue01(3+i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
         }
      }
      for(int jU=0;jU<2;jU++){
         Block_Pair& UUe11=aut.UUe11[iU][jU];
         Block_Pair& UUe01=aut.UUe01[iU][jU];
         Block_Pair& UUe00=aut.UUe00[iU][jU];
         for(int i=0;i<3;i++){
            UUe00(  i)=-UUe11(  i);
            UUe00(3+i)=-UUe11(3+i)
                         -UUe11(  0)*Z0Z0y(jZ0,iZ0)(0,i)
                         -UUe11(  1)*Z0Z0y(jZ0,iZ0)(1,i)
                         -UUe11(  2)*Z0Z0y(jZ0,iZ0)(2,i);
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               UUe01(  i,  j)=-UUe11(  i,  j);
               UUe01(3+i,  j)=-UUe11(3+i,  j)
                                 -UUe11(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                                 -UUe11(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                                 -UUe11(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
               UUe01(  i,3+j)=-UUe11(  i,3+j);
               UUe01(3+i,3+j)=-UUe11(3+i,3+j)
                                 -UUe11(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                                 -UUe11(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                                 -UUe11(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
            }
         }
         for(int i=0;i<3;i++){
            for(int j=0;j<3;j++){
               UUe00(  i,  j)=-UUe01(  i,  j);
               UUe00(3+i,  j)=-UUe01(3+i,  j);
               UUe00(  i,3+j)=-UUe01(  i,3+j)
                                 -UUe01(  i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                                 -UUe01(  i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                                 -UUe01(  i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
               UUe00(3+i,3+j)=-UUe01(3+i,3+j)
                                 -UUe01(3+i,  0)*Z0Z0y(jZ0,iZ0)(0,j)
                                 -UUe01(3+i,  1)*Z0Z0y(jZ0,iZ0)(1,j)
                                 -UUe01(3+i,  2)*Z0Z0y(jZ0,iZ0)(2,j);
            }
         }
      }
   }
   if( iU3>= 0 ){
      for(int i=0;i<6;i++){
         U3Q2Q2e(iU3,iQ2,kQ2)(i)+=aut.Ue00[0](i);
         U3U3Q2Q2e(iU3,iU3,iQ2,kQ2)(i)+=aut.UUe00[0][0](i);
         for(int j=0;j<6;j++){
            U3Q2Q2e(iU3,iQ2,kQ2)(i,j)+=aut.Ue00[0](j,i);
            U3U3Q2Q2e(iU3,iU3,iQ2,kQ2)(i,j)+=aut.UUe00[0][0](j,i);
         }
      }
   }
   if( jU3>= 0 ){
      for(int i=0;i<6;i++){
         U3Q2Q2e(jU3,iQ2,kQ2)(i)+=aut.Ue00[1](i);
         U3U3Q2Q2e(jU3,jU3,iQ2,kQ2)(i)+=aut.UUe00[1][1](i);
         for(int j=0;j<6;j++){
            U3Q2Q2e(jU3,iQ2,kQ2)(i,j)+=aut.Ue00[1](j,i);
            U3U3Q2Q2e(jU3,jU3,iQ2,kQ2)(i,j)+=aut.UUe00[1][1](j,i);
         }
      }
   }
   if( (iU3>= 0)&&(jU3>= 0) ){
      if( jU3<=iU3 ){
         for(int i=0;i<6;i++){
            U3U3Q2Q2e(jU3,iU3,iQ2,kQ2)(i)+=aut.UUe00[1][0](i);
            for(int j=0;j<6;j++){
               U3U3Q2Q2e(jU3,iU3,iQ2,kQ2)(i,j)+=aut.UUe00[1][0](j,i);
            }
         }
      }
      if( iU3<=jU3 ){
         for(int i=0;i<6;i++){
            U3U3Q2Q2e(iU3,jU3,iQ2,kQ2)(i)+=aut.UUe00[0][1](i);
            for(int j=0;j<6;j++){
               U3U3Q2Q2e(iU3,jU3,iQ2,kQ2)(i,j)+=aut.UUe00[0][1](j,i);
            }
         }
      }
   }
   return;
}
