#include "../con/Subset_Contracted_System.hh"
#include "../phi/Block_Pair.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Tra_Automatic.hh"

void Energy_Surfq::TRA_ENE_A(const Tra_Automatic& aut,
                             const Subset_Contracted_System::tM3& con,
                             int jZ0,
                             int jQ2,
                             int iZ0,
                             int iQ2){

   if( jQ2>con.Z0[jZ0].Q2a ){
      if( iQ2>con.Z0[iZ0].Q2a ){
         int jU2=Q2[jQ2].U2;
         int iU2=Q2[iQ2].U2;
         int i1,i2;
         if( jU2<=iU2 ){
            i1=jU2;
            i2=iU2;
         }else{
            i1=iU2;
            i2=jU2;
         }
         for(int iU3= 0;iU3<oU3;iU3++){
            const Block_Pair& ue=U3Q2Q2e(iU3,jQ2,iQ2);
            double z1=( ue(3,3)*Q2[jQ2].c(0,0)*Q2[iQ2].c(0,0)
                       +ue(3,4)*Q2[jQ2].c(0,0)*Q2[iQ2].c(1,0)
                       +ue(3,5)*Q2[jQ2].c(0,0)*Q2[iQ2].c(2,0)
                       +ue(4,3)*Q2[jQ2].c(1,0)*Q2[iQ2].c(0,0)
                       +ue(4,4)*Q2[jQ2].c(1,0)*Q2[iQ2].c(1,0)
                       +ue(4,5)*Q2[jQ2].c(1,0)*Q2[iQ2].c(2,0)
                       +ue(5,3)*Q2[jQ2].c(2,0)*Q2[iQ2].c(0,0)
                       +ue(5,4)*Q2[jQ2].c(2,0)*Q2[iQ2].c(1,0)
                       +ue(5,5)*Q2[jQ2].c(2,0)*Q2[iQ2].c(2,0));
            double z2=( ue(0,3)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(0,0)
                       +ue(0,4)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(1,0)
                       +ue(0,5)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(2,0)
                       +ue(1,3)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(0,0)
                       +ue(1,4)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(1,0)
                       +ue(1,5)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(2,0)
                       +ue(2,3)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(0,0)
                       +ue(2,4)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(1,0)
                       +ue(2,5)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(2,0));
            double z3=( ue(3,0)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(3,1)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(3,2)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(2)
                       +ue(4,0)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(4,1)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(4,2)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(2)
                       +ue(5,0)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(5,1)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(5,2)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(2));
            double z4=( ue(0,0)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(0,1)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(0,2)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(2)
                       +ue(1,0)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(1,1)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(1,2)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(2)
                       +ue(2,0)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(0)
                       +ue(2,1)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(1)
                       +ue(2,2)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(2));
            U3U2U2a(iU3,i1,i2)+=aut.sgnj*( z1 +z2 +z3 +z4);
            for(int jU3=iU3;jU3<oU3;jU3++){
               const Block_Pair& uue=U3U3Q2Q2e(iU3,jU3,jQ2,iQ2);
               z1=( uue(3,3)*Q2[jQ2].c(0,0)*Q2[iQ2].c(0,0)
                   +uue(3,4)*Q2[jQ2].c(0,0)*Q2[iQ2].c(1,0)
                   +uue(3,5)*Q2[jQ2].c(0,0)*Q2[iQ2].c(2,0)
                   +uue(4,3)*Q2[jQ2].c(1,0)*Q2[iQ2].c(0,0)
                   +uue(4,4)*Q2[jQ2].c(1,0)*Q2[iQ2].c(1,0)
                   +uue(4,5)*Q2[jQ2].c(1,0)*Q2[iQ2].c(2,0)
                   +uue(5,3)*Q2[jQ2].c(2,0)*Q2[iQ2].c(0,0)
                   +uue(5,4)*Q2[jQ2].c(2,0)*Q2[iQ2].c(1,0)
                   +uue(5,5)*Q2[jQ2].c(2,0)*Q2[iQ2].c(2,0));
               z2=( uue(0,3)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(0,0)
                   +uue(0,4)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(1,0)
                   +uue(0,5)*Z0Q2y(iZ0,jQ2)(0)*Q2[iQ2].c(2,0)
                   +uue(1,3)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(0,0)
                   +uue(1,4)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(1,0)
                   +uue(1,5)*Z0Q2y(iZ0,jQ2)(1)*Q2[iQ2].c(2,0)
                   +uue(2,3)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(0,0)
                   +uue(2,4)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(1,0)
                   +uue(2,5)*Z0Q2y(iZ0,jQ2)(2)*Q2[iQ2].c(2,0));
               z3=( uue(3,0)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(3,1)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(3,2)*Q2[jQ2].c(0,0)*Z0Q2y(iZ0,iQ2)(2)
                   +uue(4,0)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(4,1)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(4,2)*Q2[jQ2].c(1,0)*Z0Q2y(iZ0,iQ2)(2)
                   +uue(5,0)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(5,1)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(5,2)*Q2[jQ2].c(2,0)*Z0Q2y(iZ0,iQ2)(2));
               z4=( uue(0,0)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(0,1)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(0,2)*Z0Q2y(iZ0,jQ2)(0)*Z0Q2y(iZ0,iQ2)(2)
                   +uue(1,0)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(1,1)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(1,2)*Z0Q2y(iZ0,jQ2)(1)*Z0Q2y(iZ0,iQ2)(2)
                   +uue(2,0)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(0)
                   +uue(2,1)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(1)
                   +uue(2,2)*Z0Q2y(iZ0,jQ2)(2)*Z0Q2y(iZ0,iQ2)(2));
               U3U3U2U2a(iU3,jU3,i1,i2)+=aut.sgnj*( z1 +z2 +z3 +z4);
            }
         }
      }else{
         int iU2=Z0[iZ0].U2a;
         int kU2=Z0[jZ0].U2a;
         int jU2=Q2[jQ2].U2;
         for(int iU3= 0;iU3<oU3;iU3++){
            const Block_Pair& ue=U3Q2Q2e(iU3,jQ2,iQ2);
            const Block_Pair& uf=U3Q2Q2e(iU3,iQ2,jQ2);
            for(int i=0;i<6;i++){
               U3U2U2a(iU3,iU2+i,jU2)+=aut.sgnj*(
                              -ue(0,i)*Z0Q2y(iZ0,jQ2)(0)
                              -ue(1,i)*Z0Q2y(iZ0,jQ2)(1)
                              -ue(2,i)*Z0Q2y(iZ0,jQ2)(2)
                              -ue(3,i)*Q2[jQ2].c(0,0)
                              -ue(4,i)*Q2[jQ2].c(1,0)
                              -ue(5,i)*Q2[jQ2].c(2,0)
                                                 );
               U3U2U2a(iU3,kU2+i,jU2)+=aut.sgnj*(
                               uf(i,0)*Z0Q2y(jZ0,jQ2)(0)
                              +uf(i,1)*Z0Q2y(jZ0,jQ2)(1)
                              +uf(i,2)*Z0Q2y(jZ0,jQ2)(2)
                              +uf(i,3)*Q2[jQ2].c(0,0)
                              +uf(i,4)*Q2[jQ2].c(1,0)
                              +uf(i,5)*Q2[jQ2].c(2,0)
                                                 );
            }
            for(int jU3=iU3;jU3<oU3;jU3++){
               const Block_Pair& uue=U3U3Q2Q2e(iU3,jU3,jQ2,iQ2);
               const Block_Pair& uuf=U3U3Q2Q2e(iU3,jU3,iQ2,jQ2);
               for(int i=0;i<6;i++){
                  U3U3U2U2a(iU3,jU3,iU2+i,jU2)+=aut.sgnj*(
                                 -uue(0,i)*Z0Q2y(iZ0,jQ2)(0)
                                 -uue(1,i)*Z0Q2y(iZ0,jQ2)(1)
                                 -uue(2,i)*Z0Q2y(iZ0,jQ2)(2)
                                 -uue(3,i)*Q2[jQ2].c(0,0)
                                 -uue(4,i)*Q2[jQ2].c(1,0)
                                 -uue(5,i)*Q2[jQ2].c(2,0)
                                                          );
                  U3U3U2U2a(iU3,jU3,kU2+i,jU2)+=aut.sgnj*(
                                  uuf(i,0)*Z0Q2y(jZ0,jQ2)(0)
                                 +uuf(i,1)*Z0Q2y(jZ0,jQ2)(1)
                                 +uuf(i,2)*Z0Q2y(jZ0,jQ2)(2)
                                 +uuf(i,3)*Q2[jQ2].c(0,0)
                                 +uuf(i,4)*Q2[jQ2].c(1,0)
                                 +uuf(i,5)*Q2[jQ2].c(2,0)
                                                          );
               }
            }
         }
      }
   }else{
      if( iQ2>con.Z0[iZ0].Q2a ){
         int kU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         int iU2=Q2[iQ2].U2;
         for(int iU3= 0;iU3<oU3;iU3++){
            const Block_Pair& ue=U3Q2Q2e(iU3,jQ2,iQ2);
            const Block_Pair& uf=U3Q2Q2e(iU3,iQ2,jQ2);
            for(int i=0;i<6;i++){
               U3U2U2a(iU3,kU2+i,iU2)+=(
                              -ue(i,0)*Z0Q2y(iZ0,iQ2)(0)
                              -ue(i,1)*Z0Q2y(iZ0,iQ2)(1)
                              -ue(i,2)*Z0Q2y(iZ0,iQ2)(2)
                              -ue(i,3)*Q2[iQ2].c(0,0)
                              -ue(i,4)*Q2[iQ2].c(1,0)
                              -ue(i,5)*Q2[iQ2].c(2,0)
                                        );
               U3U2U2a(iU3,jU2+i,iU2)+=(
                               uf(0,i)*Z0Q2y(jZ0,iQ2)(0)
                              +uf(1,i)*Z0Q2y(jZ0,iQ2)(1)
                              +uf(2,i)*Z0Q2y(jZ0,iQ2)(2)
                              +uf(3,i)*Q2[iQ2].c(0,0)
                              +uf(4,i)*Q2[iQ2].c(1,0)
                              +uf(5,i)*Q2[iQ2].c(2,0)
                                        );
            }
            for(int jU3=iU3;jU3<oU3;jU3++){
               const Block_Pair& uue=U3U3Q2Q2e(iU3,jU3,jQ2,iQ2);
               const Block_Pair& uuf=U3U3Q2Q2e(iU3,jU3,iQ2,jQ2);
               for(int i=0;i<6;i++){
                  U3U3U2U2a(iU3,jU3,kU2+i,iU2)+=(
                                 -uue(i,0)*Z0Q2y(iZ0,iQ2)(0)
                                 -uue(i,1)*Z0Q2y(iZ0,iQ2)(1)
                                 -uue(i,2)*Z0Q2y(iZ0,iQ2)(2)
                                 -uue(i,3)*Q2[iQ2].c(0,0)
                                 -uue(i,4)*Q2[iQ2].c(1,0)
                                 -uue(i,5)*Q2[iQ2].c(2,0)
                                                 );
                  U3U3U2U2a(iU3,jU3,jU2+i,iU2)+=(
                                  uuf(0,i)*Z0Q2y(jZ0,iQ2)(0)
                                 +uuf(1,i)*Z0Q2y(jZ0,iQ2)(1)
                                 +uuf(2,i)*Z0Q2y(jZ0,iQ2)(2)
                                 +uuf(3,i)*Q2[iQ2].c(0,0)
                                 +uuf(4,i)*Q2[iQ2].c(1,0)
                                 +uuf(5,i)*Q2[iQ2].c(2,0)
                                                 );
               }
            }
         }
      }else{
         int iU2=Z0[iZ0].U2a;
         int jU2=Z0[jZ0].U2a;
         for(int iU3= 0;iU3<oU3;iU3++){
            const Block_Pair& ue=U3Q2Q2e(iU3,jQ2,iQ2);
            const Block_Pair& uh=U3Q2Q2e(iU3,iQ2,jQ2);
            Block_Pair ug;
            for(int i=0;i<3;i++){
               for(int j=0;j<3;j++){
                  ug(  i,  j)=-ue(  i,  j);
                  ug(3+i,  j)=-ue(3+i,  j)
                                 -ue(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                                 -ue(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                                 -ue(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
                  ug(  i,3+j)=-ue(  i,3+j);
                  ug(3+i,3+j)=-ue(3+i,3+j)
                                 -ue(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                                 -ue(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                                 -ue(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
               }
            }
            for(int i=0;i<3;i++){
               U3U2g(iU3,jU2+i)+=uh(i);
               U3U2g(iU3,iU2+i)+=ue(i);
               for(int j=i;j<6;j++){
                  U3U2U2a(iU3,jU2+i,jU2+j)+=uh(j,i);
                  U3U2U2a(iU3,iU2+i,iU2+j)+=ue(i,j);
               }
            }
            for(int i=3;i<6;i++){
               U3U2g(iU3,jU2+i)+=uh(i);
               U3U2g(iU3,iU2+i)+=ue(i);
               for(int j=i;j<6;j++){
                  U3U2U2a(iU3,jU2+i,jU2+j)+=uh(j,i);
                  U3U2U2a(iU3,iU2+i,iU2+j)+=ue(j,i);
               }
            }
            for(int i=0;i<6;i++){
               for(int j=0;j<6;j++){
                  U3U2U2a(iU3,jU2+i,iU2+j)+=ug(i,j);
               }
            }
            for(int jU3=iU3;jU3<oU3;jU3++){
               const Block_Pair& uue=U3U3Q2Q2e(iU3,jU3,jQ2,iQ2);
               const Block_Pair& uuh=U3U3Q2Q2e(iU3,jU3,iQ2,jQ2);
               Block_Pair uug;
               for(int i=0;i<3;i++){
                  for(int j=0;j<3;j++){
                     uug(  i,  j)=-uue(  i,  j);
                     uug(3+i,  j)=-uue(3+i,  j)
                                     -uue(  0,  j)*Z0Z0y(jZ0,iZ0)(0,i)
                                     -uue(  1,  j)*Z0Z0y(jZ0,iZ0)(1,i)
                                     -uue(  2,  j)*Z0Z0y(jZ0,iZ0)(2,i);
                     uug(  i,3+j)=-uue(  i,3+j);
                     uug(3+i,3+j)=-uue(3+i,3+j)
                                     -uue(  0,3+j)*Z0Z0y(jZ0,iZ0)(0,i)
                                     -uue(  1,3+j)*Z0Z0y(jZ0,iZ0)(1,i)
                                     -uue(  2,3+j)*Z0Z0y(jZ0,iZ0)(2,i);
                  }
               }
               for(int i=0;i<3;i++){
                  U3U3U2g(iU3,jU3,jU2+i)+=uuh(i);
                  U3U3U2g(iU3,jU3,iU2+i)+=uue(i);
                  for(int j=i;j<6;j++){
                     U3U3U2U2a(iU3,jU3,jU2+i,jU2+j)+=uuh(j,i);
                     U3U3U2U2a(iU3,jU3,iU2+i,iU2+j)+=uue(i,j);
                  }
               }
               for(int i=3;i<6;i++){
                  U3U3U2g(iU3,jU3,jU2+i)+=uuh(i);
                  U3U3U2g(iU3,jU3,iU2+i)+=uue(i);
                  for(int j=i;j<6;j++){
                     U3U3U2U2a(iU3,jU3,jU2+i,jU2+j)+=uuh(j,i);
                     U3U3U2U2a(iU3,jU3,iU2+i,iU2+j)+=uue(j,i);
                  }
               }
               for(int i=0;i<6;i++){
                  for(int j=0;j<6;j++){
                     U3U3U2U2a(iU3,jU3,jU2+i,iU2+j)+=uug(i,j);
                  }
               }
            }
         }
      }
   }
   return;
}
