#ifndef DEF_TRA_AUTOMATIC
#define DEF_TRA_AUTOMATIC

#include "../phi/Block_Pair.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../phi/Scratch_Multipoles.hh"
#include "../phi/Spherical_Harmonics.hh"
#include <vector>

class Tra_Automatic {
public:
   class tF2 { /*atoms in atom-contracted chain [backward order]*/
   public:
      Coordinates x;            //atom position (bohr)
      Multipoles q;             //atom multipoles
      Multipoles p;             //polarizability site
      /*w site*/
      double v;                 //excluded volume (bohr**3)
      double g;                 //coeff of 1st derivative of Fw wrt v
      double h;                 //coeff of 2nd derivative of Fw wrt v
      tF2(){}
   };
   class tQ3 { /*collections of groups [forward or base] forming sub-residue
                 fragments*/
   public:
      Coordinates x;            //position (bohr)
      Multipoles q;             //multipoles
      double r;                 //radius (bohr)
      tQ3():q(7){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      Coordinates x;            //
      Multipoles q;             //
      double r;                 //
      tQ1():q(7){}
   };
   class tX2 { /*collections of groups [backward] forming sub-residue
                 fragments*/
   public:
      Coordinates x;            //position (bohr)
      Multipoles q;             //multipoles
      double r;                 //radius (bohr)
      tX2():q(7){}
   };
   class tX1 { /*torsions in chains [backward order]*/
   public:
      Coordinates x;            //
      Multipoles q;             //
      double r;                 //
      tX1():q(7){}
   };
   class tG5G5G5 { /*bins of a 3D grid*/
   public:
      int i;                    //start index into set of dots
      int n;                    //number of dots in bin
      tG5G5G5():i(-1),n( 0){}
   };
   class tDOT { /*hydration sites +physical atoms -nonpolar H atoms*/
   public:
      int F2;                   //index of atom
      int G5;                   //mapping to bin of 3D grid
      int ord;                  //mapping order to dot index
      int inv;                  //mapping dot index to order
      tDOT(){}
   };

private:
   std::vector<tG5G5G5> o_G5G5G5;       //3D grid

public:
   Coordinates TRANS;                   //rigid body translation (bohr)
   std::vector<tF2> F2;                 //backward atoms
   Rotation_Matrix PR[3];               //generation matrix resolved wrt branch
   /*path of torsions from base to current*/
   int br;                              //branch level of current torsion
   int BBw;                             //last bb torsion
   int SCa;                             //first sc torsion
   double sgnk;                         //direction of torsion along path
   /*forward sub-blocks*/
   std::vector<tQ3> Q3;                 //fragments
   std::vector<tQ1> Q1;                 //torsions
   /*backward sub-blocks*/
   std::vector<tX2> X2;                 //fragments
   std::vector<tX1> X1;                 //torsions
   std::vector<tDOT> DOT;               //subset of F2 on which Fw dependent
   /*relative position of atom pair*/
   Coordinates x;                       //
   double RR;                           //distance squared
   double R;                            //distance
   double ZZ;                           //(1/R)
   double CT;                           //cos(theta)
   double ST;                           //sin(theta)
   double CP;                           //cos(phi)
   double SP;                           //sin(phi)
   /*polarizabiliy*/
   double pfac;                         //factor (1+D-B+C)
   Multipoles pi;                       //dipole of donor or acceptor
   Multipoles pj;                       //
   Block_Pair_G p_g;                    //
   Block_Pair_G p_h;                    //
   /**/
   bool ISOTROPIC;                      //interaction dependence only on R
   /*derivatives wrt (r,theta,phi,q) of energy of atom pair*/
   double dedr;                         //
   double dedt;                         //
   double dedp;                         //
   double ddedrdr;                      //
   double ddedrdt;                      //
   double ddedrdp;                      //
   double ddedtdt;                      //
   double ddedtdp;                      //
   double ddedpdp;                      //
   double dedq[3];                      //
   double ddedqdr[3];                   //
   double ddedqdt[3];                   //
   double ddedqdp[3];                   //
   double ddedqdq[3][3];                //
   double e;                            //
   /*chain of torsions connecting pair of interacting groups*/
   double sgnj;                         //direction of bond j
   /*construction+destruction outside of inner loop*/
   Scratch_Multipoles q1;               //
   Scratch_Multipoles q2;               //
   Scratch_Multipoles dq2[3];           //
   Scratch_Multipoles ddq2[3][3];       //
   Scratch_Multipoles QQ;               //
   Scratch_Multipoles QdQ[3];           //
   Scratch_Multipoles QddQ[3][3];       //
   Spherical_Harmonics H;               //
   Spherical_Harmonics dH;              //
   Spherical_Harmonics ddH;             //
   Coordinates dx[3];                   //
   Coordinates ddx[3][3];               //
   Block_Pair e11;                      //
   Block_Pair e01;                      //
   Block_Pair e00;                      //
   /*derivatives of energy of atom pair wrt parameters (Te,Tr,Ta)*/
   std::vector<double> de;              //
   std::vector<double> dde;             //
   std::vector<double> ddedr;           //
   std::vector<double> dddedr;          //
   std::vector<double> dddedrdr;        //
   std::vector<double> ddddedrdr;       //
   /*derivatives of radial factor of H-bond wrt parameters (Te,Tr,Ta)*/
   std::vector<double> dG;              //
   std::vector<double> ddG;             //
   std::vector<double> ddGdr;           //
   std::vector<double> dddGdr;          //
   std::vector<double> dddGdrdr;        //
   std::vector<double> ddddGdrdr;       //
   Block_Pair Ue11[2];                  //
   Block_Pair Ue01[2];                  //
   Block_Pair Ue00[2];                  //
   Block_Pair UUe11[2][2];              //
   Block_Pair UUe01[2][2];              //
   Block_Pair UUe00[2][2];              //

   tG5G5G5& G5G5G5(int x,int y,int z){
      return o_G5G5G5.at( 1089*(x+16) +33*(y+16) +(z+16));  }
   tG5G5G5& G5G5G5(int j){
      return o_G5G5G5.at(j);  }

   Tra_Automatic(int oF2,int oQ3,int oQ1,int oX2,int oX1):
      o_G5G5G5(35937),
      F2(oF2),
      Q3(oQ3),
      Q1(oQ1),
      X2(oX2),
      X1(oX1),
      de(6),
      dde(36),
      ddedr(6),
      dddedr(36),
      dddedrdr(6),
      ddddedrdr(36),
      dG(6),
      ddG(36),
      ddGdr(6),
      dddGdr(36),
      dddGdrdr(6),
      ddddGdrdr(36)
   {
   }
};

#endif
