#ifndef DEF_STP_AUTOMATIC
#define DEF_STP_AUTOMATIC

#include <string>
#include <vector>

class Stp_Automatic {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      char c1;                  //1 char class name
      tZ0(){}
   };
   class tR0 { /*residues in chains*/
   public:
      int coil;                 //not alpha or beta
      int expo;                 //exposed
      int loop;                 //not alpha or beta and exposed
      double e[12];             //components of defect energy
      std::string bbcnf;        //2 char backbone conf region
      char sccnf;               //side chain is rotamer
      std::string bbsta;        //2 char backbone state
      tR0(){}
   };
   class tA5 { /*physical atoms in system of molecules*/
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      int P1;                   //index of atom
      double exsa;              //exposed surface area (angstrom**2)
      tA5(){}
   };

public:
   std::vector<tZ0> Z0;         //set of chains
   std::vector<tR0> R0;         //set of residues
   std::vector<tA5> A5;         //set of physical atoms
   int nR0tot;                  //number of total residues
   int nR0in;                   //number of buried residues
   int nR0ex;                   //number of exposed residues

   Stp_Automatic(int oZ0,int oR0,int oA5):
      Z0(oZ0),
      R0(oR0),
      A5(oA5)
   {
   }
};

#endif
