#ifndef DEF_LOCAL_MINIMIZ
#define DEF_LOCAL_MINIMIZ

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include <vector>
#include <cmath>

//
//
// sequence of microsteps and control base class
//
class Local_Minimiz {
public:
   class tM2 { /*minimization step*/
   public:
      double tot;               //function value
      double z;                 //square of gradient
      double bet;               //target step length
      double delF;              //predicted change in energy
      /*adjustment of Lagrange multiplier lamda*/
      double lam0;              //initial value
      double  s0;               //square of step length of lam0
      double ds0;               //derivative of s0 wrt lam
      double lam1[4];           //estimate of negative of lowest eigenvalue
      double  s1[4];            //square of step length of lam1
      double ds1[4];            //derivative of s1 wrt lam
      double lam2;              //value corresponding to target step length
      double  s2;               //square of step length of lam2
      double ds2;               //derivative of s2 wrt lam
      /*iterations in adjustment of lamda*/
      int k1;                   //lam0 st (A +lam0*I) is positive definite
      int k2;                   //decrease toward negative of lowest eigenvalue
      int k3;                   //increase to lam2
      int k4[4];                //selection of lowest eigenvalue
      int k5[4];                //lam1 st (A +lam1*I) is positive definite
      tM2(){}
   };

public:
   /*convergence thresholds*/
   double EPS2;                 //for square of step length
   /*minimization steps*/
   std::vector<tM2> M2;         //set
   int iM2;                     //index
   /*return state from minimization*/
   int ENDSTATE;                //error code for local minimization

   double TRA_LOQ_TARGETBETA(bool INFLATE);
   void TRA_LOQ_INITLAMDA(Lagrange_Multiplier& lag,
                          int ck1,
                          double beta1);

public:
   /*step length*/
   double BETA;                 //target
   double BMAX;                 //maximum target
   double BMIN;                 //minimum target
   double BDEL;                 //fraction controlling rate of adjustment
   /*convergence thresholds*/
   double EPS1;                 //for gradient
   /*minimization steps*/
   int nM2;                     //maximum number

   Local_Minimiz(int oM2,int o):
      EPS2( 1.00e-02),
      M2(oM2),
      BETA( 2.00e-02),
      BMAX( 1.00e-01),
      BMIN( 1.00e-07),
      BDEL( 2.00e-01),
      EPS1( 1.00e-05),
      nM2(64)
   {
      BETA*=std::sqrt( o);
      BMAX*=std::sqrt( o);
      BMIN*=std::sqrt( o);
      EPS1= o*(EPS1*EPS1);
   }
};
//
//
// minimization of restchm wrt generalized coords
//
class Local_Minimizq: public Local_Minimiz {
private:
   std::vector<bool> o_CYCE;    //exclude Fe
   std::vector<bool> o_CYCS;    //exclude Fs
   std::vector<bool> o_CYCT;    //exclude Ft+Fb+Fc
   std::vector<bool> o_CYCH;    //exclude Fh
   std::vector<bool> o_CYCM;    //exclude Fm
   std::vector<bool> o_CYCW;    //exclude Fw

   void TRA_LOQ_BACKUP(Lagrange_Multiplier& lag,
                       Energy_Surfq& enq,
                       bool INFLATE);
   void TRA_LOQ_UPDATE(const DAT_PHYSICS_CONSTS& physics_consts,
                       const Mechanical_System& mol,
                       const Subset_Contracted_System::tM3& con,
                       const Lagrange_Multiplier& lag,
                       Energy_Surfq& enq);

public:
   int iCYC;                    //index
   int oQ;                      //number of eigenvalues inverted
   int aQ;                      //start index for conditional inversion
   int bQ;                      //length increase for conditional inversion

   int TRA_LOQ(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const DAT_REGION_MAPS& region_maps,
               const Thread_Options& opt,
               Output_Streams& out,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep,
               Energy_Surfq& enq,
               bool INFLATE);

   void TRA_LOQ_WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out,
                    Structure& str,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep,
                    const Energy_Surfq& enq,
                    bool INFLATE);

   void CYCE(int i,bool a){
      o_CYCE[ i]=a;  }
   bool CYCE(int i){
      return o_CYCE[ i];  }
   void CYCS(int i,bool a){
      o_CYCS[ i]=a;  }
   bool CYCS(int i){
      return o_CYCS[ i];  }
   void CYCT(int i,bool a){
      o_CYCT[ i]=a;  }
   bool CYCT(int i){
      return o_CYCT[ i];  }
   void CYCH(int i,bool a){
      o_CYCH[ i]=a;  }
   bool CYCH(int i){
      return o_CYCH[ i];  }
   void CYCM(int i,bool a){
      o_CYCM[ i]=a;  }
   bool CYCM(int i){
      return o_CYCM[ i];  }
   void CYCW(int i,bool a){
      o_CYCW[ i]=a;  }
   bool CYCW(int i){
      return o_CYCW[ i];  }

   Local_Minimizq(int oM2,int o):
      Local_Minimiz(oM2,o),
      o_CYCE(5,false),
      o_CYCS(5,false),
      o_CYCT(5,false),
      o_CYCH(5,false),
      o_CYCM(5,false),
      o_CYCW(5,false),
      aQ( 0),
      bQ( 0)
   {
//
      CYCE(0, true);
      CYCS(0, true);
      CYCM(0, true);
//
      CYCE(1, true);
      CYCS(1, true);
      CYCH(1, true);
      CYCM(1, true);
//
      CYCE(2, true);
      CYCS(2, true);
      CYCT(2, true);
      CYCM(2, true);
//
      CYCE(3, true);
      CYCS(3, true);
      CYCH(3, true);
      CYCT(3, true);
   }
};
//
//
// minimization of target func wrt params
//
class Local_Minimizp: public Local_Minimiz {
public:
   class eRecord { /*decomposition of restch+m(approx) energy*/
   public:
      double F;                 //total
      double Fr;                //repulsion+dispersion
      double Fe;                //electrostatic
      double Fs;                //disulfide bond
      double Ft;                //intrinsic torsional
      double Fc;                //distance constraint
      double Fb;                //ring closure
      double Fh;                //hydrophobic
      double Fw;                //excluded vol model of hydration
      double Fp;                //polarization
      double Fp_a;              // H-bonds
      double Fp_b;              // bifurcated H-bonds
      double Fp_c;              // chains of peptide alignment
      double Fp_d;              // mod of pept H-bond by elem type
      double Fp_e;              // nonpolar in the electric field
      eRecord(){}
   };
   class tRecord { /*decomposition of target function*/
   public:
      double F;                 //total
      double Fw;                //kinetic, func of params
      double Fx;                //dist in torsion space from ideal ss elems
      double Fy;                //energy (tot -Fr) of optimal microstep
      double Fz;                //dist in torsion space from min to saddle
      double z;                 //square of gradient for ene surf
      double lamda;             //value corresponding to step length
      double s;                 //step length (for U2t with target BETA=.04)
      double delf;              //predicted change in restchm (for step U2t)
      tRecord(){}
   };

private:
   std::vector<eRecord> o_M2e;  //
   std::vector<tRecord> o_M2t;  //

   void TRA_LOP_BACKUP(Lagrange_Multiplier& lag,
                       Energy_Surfp& enp,
                       Energy_Surfq& ene);
   void TRA_LOP_UPDATE(const DAT_PHYSICS_CONSTS& physics_consts,
                       Output_Streams& out,
                       const Mechanical_System& mol,
                       const Subset_Contracted_System::tM3& con,
                       const Lagrange_Multiplier& lag,
                       Energy_Surfp& enp,
                       Energy_Surfq& ene,
                       Energy_Surfq& enq);
   double TRA_LOP_TARGETBETA(Energy_Surfp& enp);

public:
   eRecord& M2e(int i){
      return o_M2e.at( i);  }
   tRecord& M2t(int i){
      return o_M2t.at( i);  }

   int TRA_LOP(const DAT_PHYSICS_CONSTS& physics_consts,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_RESIDUE_MAPPINGS& residue_mappings,
               const DAT_ENERGY_PARAMS& energy_params,
               const DAT_REGION_MAPS& region_maps,
               Thread_Options& opt,
               Output_Streams& out,
               Structure& str,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep,
               Energy_Surfp& enp,
               Energy_Surfq& ene,
               Local_Minimizq& loq,
               Energy_Surfq& enq);

   void TRA_LOP_WRT(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    Output_Streams& out,
                    Structure& str,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep,
                    const Energy_Surfp& enp,
                    const Energy_Surfq& ene);

   Local_Minimizp(int oM2,int o):
      Local_Minimiz(oM2,o),
      o_M2e(oM2),
      o_M2t(oM2)
   {
   }
};

#endif
