#ifndef DEF_ENERGY_SURF
#define DEF_ENERGY_SURF

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Block_Pair.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
class Ptra_Automatic;
#include "../str/Thread_Options.hh"
#include "../tra/Tra_Automatic.hh"
#include <string>
#include <vector>
//
//
// energy surface and conformation for restchm
// wrt generalized coordinates and parameters
//
//  U2=set of generalized coordinate degrees of freedom
//  U3=set of parameter degrees of freedom
//
class Energy_Surfq {
public:
   class tZ0 { /*chain*/
   public:
      int U2a;                  //start index for trans+rot degs of free
      tZ0(){}
   };
   class tR0 { /*residues*/
   public:
      tR0(){}
   };
   class tQ2 { /*torsion [forward order]*/
   public:
      Rotation_Matrix c;        //unit vector along rotatable bond
      Coordinates x;            //coords of base atom
      int U2;                   //map into degs of free
      tQ2():U2(-1){}
   };
   class tF2 { /*atom [backward order]*/
   public:
      double fq;                //factor of chg decrease by dielec medium
      int D;                    //index into condensed set of hb donors
      int A;                    //index into condensed set of hb acceptors
      tF2(){}
   };
   class tE2 { /*atom pair with torsion dependence*/
   public:
      int O2a;                  //start index
      int cO2;                  //number of intervening degs of free
      double dv;                //derivative of gaussian vol wrt rr
      tE2(){}
   };
   class tO2 { /*torsion of intervening strings for atom pairs E2*/
   public:
      int U2;                   //index into set of degrees of freedom
      double s;                 //dRR/dchi
      tO2(){}
   };
   class tE9 { /*atom pair with torsion dependence*/
   public:
      int O9a;                  //start index
      int cO9;                  //number of intervening degs of free
      tE9(){}
   };
   class tO9 { /*torsion of intervening strings for atom pairs E9*/
   public:
      int U2;                   //index into set of degrees of freedom
      double s;                 //de/dchi
      tO9(){}
   };
   class tR0R0 { /*peptide-peptide H-bond, H-->O*/
   public:
      double e;                 //interaction energy
      bool a;                   //R below 2.4 ang
      bool b;                   //R below threshold
      bool o;                   //R below overlap
      double C;                 //chains of peptide plane alignment
      double B;                 //patterns of H-bonds in helices or sheets
      double D;                 //chg mod by adjacent peptide planes
      tR0R0(){}
   };
   class tF2F2 { /*other H-bond, H-->O*/
   public:
      int iF2;                  //1st index of atom pair
      int jF2;                  //2nd index
      double e;                 //interaction energy
      bool a;                   //R below 2.4 ang
      bool b;                   //R below threshold
      bool o;                   //R below overlap
      double C;                 //chains of peptide plane alignment
      double B;                 //patterns of H-bonds in helices or sheets
      double D;                 //chg mod by adjacent peptide planes
      tF2F2(){}
   };
   class tE4 { /*pairs of H-bonds in extendable patterns*/
   public:
      int iF2;                  //donor 1st pair
      int jF2;                  //acceptor
      int kF2;                  //donor 2nd pair
      int lF2;                  //acceptor
      double f;                 //coeff
      tE4(){}
   };

private:
   int oU2;                                 //6 +number of generalized coords
   int oU3;                                 //number of params
   int oQ2;                                 //number of torsions
   /*restchm energy surf*/
   std::vector<double> o_U3f;               //
   std::vector<double> o_U3U3f;             //
   std::vector<double> o_U2g;               //1st derivative
   std::vector<double> o_U3U2g;             //
   std::vector<double> o_U3U3U2g;           //
   std::vector<double> o_U2U2a;             //2nd derivative
   std::vector<double> o_U3U2U2a;           //
   std::vector<double> o_U3U3U2U2a;         //
   /*conformation*/
   std::vector<double> o_U2chi;             //generalized coordinates
   std::vector<double> o_U2uca;             //unit of circular arc
   /*mapping of pair of atom types to param space*/
   std::vector<int> o_TTiU3;                //1st atom type to index
   std::vector<int> o_TTjU3;                //2nd atom type to index
   /*repulsion+dispersion*/
   std::vector<double> o_TTe;               //eps (hartree)
   std::vector<double> o_TTr;               //rho (bohr)
   std::vector<double> o_TTa;               //alp
   std::vector<double> o_TTde;              //1st deriv wrt (ei,ri,ai,ej,rj,aj)
   std::vector<double> o_TTdr;              //
   std::vector<double> o_TTda;              //
   std::vector<double> o_TTdde;             //2nd deriv wrt (ei,ri,ai,ej,rj,aj)
   std::vector<double> o_TTddr;             //
   std::vector<double> o_TTdda;             //
   /*subset of atom pairs*/
   std::vector<bool> o_F2F2b;               //classified as short range
   /*intermediate quantities*/
   std::vector<Rotation_Matrix> o_Z0Z0y;    //(iZ0,jZ0)=d[tj-ti](k)/dalp(l)
   std::vector<Coordinates> o_Z0Q2y;        //(iZ0,jQ2)=cj x (xj-ti)
   std::vector<Block_Pair> o_Q2Q2e;         //block pair partition
   std::vector<Block_Pair> o_U3Q2Q2e;       //
   std::vector<Block_Pair> o_U3U3Q2Q2e;     //
   /*gaussian Fm*/
   std::vector<int> o_F2F2E2;               //
   std::vector<int> o_F2F2E9;               //map to string of torsions
   /*Fp*/
   std::vector<tR0R0> o_R0R0;               //peptide-peptide H-bond, H-->O
   /*bias to ss prediction of igor*/
   std::vector<double> o_OU2chi;            //Ft target coords (radian)
   std::vector<bool> o_OU2b;                //Ft subset
   std::vector<double> o_U2dt;              //delta step with delta params

   Rotation_Matrix& Z0Z0y(int i,int j){
      return o_Z0Z0y.at( i*oZ0 +j -i*(i+1)/2);
   }
   Coordinates& Z0Q2y(int i,int j){
      return o_Z0Q2y.at( i*oQ2 +j);
   }
   Block_Pair& Q2Q2e(int i,int j){
      return o_Q2Q2e.at( i*oQ2 +j);
   }
   Block_Pair& U3Q2Q2e(int i,int j,int k){
      return o_U3Q2Q2e.at( i*oQ2*oQ2 +j*oQ2 +k);
   }
   Block_Pair& U3U3Q2Q2e(int i,int j,int k,int l){
      return o_U3U3Q2Q2e.at( (i*oU3+j-i*(i+1)/2)*oQ2*oQ2 +k*oQ2 +l);
   }

   void TRA_ENQ_XQ(Tra_Automatic& aut,
                   const DAT_ARRAY_CONSTS& array_consts,
                   Output_Streams& out,
                   const Mechanical_System& mol,
                   const Subset_Contracted_System::tM3& con,
                   const Conf_Dependent_System& dep);
   void TRA_ENQ_WPAR(Tra_Automatic& aut,
                     const DAT_PHYSICS_CONSTS& physics_consts,
                     const Subset_Contracted_System::tM3& con);
   void TRA_ENQ_PPAR(Tra_Automatic& aut,
                     const DAT_PHYSICS_CONSTS& physics_consts,
                     const DAT_ARRAY_CONSTS& array_consts,
                     const DAT_REGION_MAPS& region_maps,
                     const Mechanical_System& mol,
                     const Subset_Contracted_System::tM3& con,
                     const Conf_Dependent_System& dep);
   void TRA_ENQ_RESTCH(Tra_Automatic& aut,
                       const DAT_PHYSICS_CONSTS& physics_consts,
                       const DAT_ARRAY_CONSTS& array_consts,
                       const DAT_ENERGY_PARAMS& energy_params,
                       const Thread_Options& opt,
                       Output_Streams& out,
                       const Subset_Contracted_System::tM3& con,
                       const Conf_Dependent_System& dep);
   void TRA_ENQ_E1RESH(Tra_Automatic& aut,
                       const DAT_PHYSICS_CONSTS& physics_consts,
                       const DAT_ARRAY_CONSTS& array_consts,
                       const DAT_ENERGY_PARAMS& energy_params,
                       const Subset_Contracted_System::tM3& con,
                       int iZ0,
                       int mQ2,
                       int iQ2,
                       int iE1);
   int TRA_ENQ_L(double r,
                 double d,
                 int Lmax);
   void TRA_ENQ_E(Tra_Automatic& aut,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const Multipoles& a1,
                  int kQ2,
                  int jZ0,
                  const Coordinates& x2,
                  const Multipoles& a2,
                  int iQ2,
                  int iZ0,
                  int LTE);
   void TRA_ENQ_RESH(Tra_Automatic& aut,
                     const DAT_PHYSICS_CONSTS& physics_consts,
                     const DAT_ARRAY_CONSTS& array_consts,
                     const DAT_ENERGY_PARAMS& energy_params,
                     const Subset_Contracted_System::tM3& con,
                     int jF2,
                     int kQ2,
                     int jZ0,
                     int iE1,
                     int iF2,
                     int i_3,
                     int iQ2,
                     int iZ0,
                     bool EPASS);
   void TRA_ENE_CHAIN(double dFde,
                      double dFdr,
                      double dFda,
                      double ddFdede,
                      double ddFdedr,
                      double ddFdeda,
                      double ddFdrdr,
                      double ddFdrda,
                      double ddFdada,
                      int iT,
                      int jT,
                      std::vector<double>& df,
                      std::vector<double>& ddf);
   void TRA_ENQ_ME(Tra_Automatic& aut,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const Multipoles& a1,
                   int LTE1,
                   const Multipoles& a2,
                   int LTE2,
                   int LTE,
                   bool MEDIUM);
   void TRA_ENQ_PART(Tra_Automatic& aut,
                     const DAT_ARRAY_CONSTS& array_consts,
                     int kQ2,
                     int jZ0,
                     const Coordinates& x2,
                     int iQ2,
                     int iZ0);
   void TRA_ENE_PART(Tra_Automatic& aut,
                     const DAT_ARRAY_CONSTS& array_consts,
                     int kQ2,
                     int jZ0,
                     const Coordinates& x2,
                     int iQ2,
                     int iZ0,
                     int iU3,
                     int jU3);
   void TRA_ENQ_T1D(const DAT_PHYSICS_CONSTS& physics_consts,
                    const Conf_Dependent_System& dep,
                    int iQ2);
   void TRA_ENQ_T2D(const Subset_Contracted_System::tM3& con,
                    const Conf_Dependent_System& dep,
                    int iZ0);
   void TRA_ENQ_C(Tra_Automatic& aut,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const DAT_ENERGY_PARAMS& energy_params,
                  const Thread_Options& opt,
                  const Subset_Contracted_System::tM3& con,
                  int jF2,
                  int jZ0,
                  int iC1,
                  int iF2,
                  int iQ2,
                  int iZ0);
   void TRA_ENQ_PWM(Tra_Automatic& aut,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const DAT_REGION_MAPS& region_maps,
                    Output_Streams& out,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    const Conf_Dependent_System& dep);
   void TRA_ENQ_E1WM(Tra_Automatic& aut,
                     const DAT_PHYSICS_CONSTS& physics_consts,
                     const DAT_ARRAY_CONSTS& array_consts,
                     const Subset_Contracted_System::tM3& con,
                     int iZ0,
                     int mQ2,
                     int iQ2,
                     int iE1);
   void TRA_ENQ_WM(Tra_Automatic& aut,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const DAT_ARRAY_CONSTS& array_consts,
                   const Subset_Contracted_System::tM3& con,
                   int jF2,
                   int kQ2,
                   int jZ0,
                   int iF2,
                   int iQ2,
                   int iZ0);
   void TRA_ENQ_E2(Tra_Automatic& aut,
                   const Subset_Contracted_System::tM3& con,
                   int jF2,
                   int kQ2,
                   int jZ0,
                   int iF2,
                   int iQ2,
                   int iZ0);
   void TRA_ENQ_O2(const Tra_Automatic& aut,
                   const Subset_Contracted_System::tM3& con,
                   int kQ2,
                   int kZ0,
                   int iF2,
                   int iZ0);
   void TRA_ENQ_E1P(Tra_Automatic& aut,
                    const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const Subset_Contracted_System::tM3& con,
                    int iZ0,
                    int mQ2,
                    int iQ2,
                    int iE1);
   void TRA_ENQ_P(Tra_Automatic& aut,
                  const DAT_PHYSICS_CONSTS& physics_consts,
                  const DAT_ARRAY_CONSTS& array_consts,
                  const Subset_Contracted_System::tM3& con,
                  int jF2,
                  int kQ2,
                  int jZ0,
                  int iF2,
                  int iQ2,
                  int iZ0);
   void TRA_ENQ_PART1(Tra_Automatic& aut,
                      int kQ2,
                      int jZ0,
                      const Coordinates& x2,
                      int iQ2,
                      int iZ0);
   void TRA_ENQ_E9(Tra_Automatic& aut,
                   const Subset_Contracted_System::tM3& con,
                   int jF2,
                   int kQ2,
                   int jZ0,
                   int iF2,
                   int iQ2,
                   int iZ0,
                   int pE9);
   void TRA_ENQ_O9(const Tra_Automatic& aut,
                   const Subset_Contracted_System::tM3& con,
                   int kQ2,
                   int kZ0,
                   int iF2,
                   int iZ0,
                   int pE9);
   void TRA_ENQ_CONT(Tra_Automatic& aut,
                     const Subset_Contracted_System::tM3& con);
   void TRA_ENQ_G(int iZ0,
                  int iQ2);
   void TRA_ENE_G(int iZ0,
                  int iQ2);
   void TRA_ENQ_A(const Tra_Automatic& aut,
                  const Subset_Contracted_System::tM3& con,
                  int jZ0,
                  int jQ2,
                  int iZ0,
                  int iQ2);
   void TRA_ENE_A(const Tra_Automatic& aut,
                  const Subset_Contracted_System::tM3& con,
                  int jZ0,
                  int jQ2,
                  int iZ0,
                  int iQ2);

public:
   int oZ0;                                 //number of chains
   int oR0;                                 //number of residues
   int oF2;                                 //number of interaction sites
   /*restchm energy surf*/
   double TOT;                              //function (Fr+Fe+Fs+Ft+Fc+Fb+Fh+Fm)
   double Fr;                               //repulsion+dispersion
   double Fe;                               //electrostatic
   double Fs;                               //disulfide bond
   double Ft;                               //intrinsic torsional
   double Fc;                               //distance constraint
   double Fb;                               //ring closure
   double Fh;                               //hydrophobic
   double Fw;                               //excluded vol model of hydration
   double Fm;                               //dielectric medium
   double Fp;                               //polarization
   double Fp_a;                             // H-bonds
   double Fp_b;                             // bifurcated H-bonds
   double Fp_c;                             // chains of peptide alignment
   double Fp_d;                             // mod of pept H-bond by elem type
   double Fp_e;                             // nonpolar in the electric field
   /*mapping of degs of free to index*/
   std::vector<tZ0> Z0;                     //chains
   std::vector<tR0> R0;                     //residues
   std::vector<tQ2> Q2;                     //torsions [forward order]
   std::vector<tF2> F2;                     //atoms [reverse order]
   /*sizes of sets*/
   int nU2;                                 //number of generalized coords
   int nU3;                                 //number of params
   /*control of evaluation*/
   double ethresh;                          //conv threshold for mpole expansion
   bool ETARGET;                            //exclude Fe
   bool STARGET;                            //exclude Fs
   bool TTARGET;                            //exclude Ft+Fb+Fc
   bool HTARGET;                            //exclude Fh
   bool MTARGET;                            //exclude Fm
   bool WTARGET;                            //exclude Fw
   double fac_m2;                           //coeff for Fm 2-bod
   double fac_m3;                           //3-bod
   /*gaussian Fm*/
   std::vector<tE2> E2;                     //atom pairs with torsion dependence
   int nE2;                                 //number
   std::vector<tO2> O2;                     //strings of intervening torsions
   int nO2;                                 //number
   /*Fp*/
   int oD;                                  //n of condensed donors
   int oA;                                  //n of condensed acceptors
   std::vector<int> o_DAF2F2;               //map to non pept-pept H-bonds
   int oF2F2;                               //n
   std::vector<tF2F2> o_F2F2;               //non pept-pept H-bond, D-->A
   bool E4RESET;                            //reset subsets b and E4
   std::vector<tE4> E4;                     //pairs of H-bonds in patterns
   int nE4;                                 //number
   std::vector<tE9> E9;                     //atom pairs with torsion dependence
   int nE9;                                 //number
   std::vector<tO9> O9;                     //strings of intervening torsions
   int nO9;                                 //number

   double& U3f(int i){
      return o_U3f.at( i);
   }
   double& U3U3f(int i,int j){
      return o_U3U3f.at( i*oU3 +j -i*(i+1)/2);
   }
   double& U2g(int i){
      return o_U2g.at( i);
   }
   const double& U2g(int i) const {
      return o_U2g.at( i);
   }
   double& U3U2g(int i,int j){
      return o_U3U2g.at( i*oU2 +j);
   }
   double& U3U3U2g(int i,int j,int k){
      return o_U3U3U2g.at( (i*oU3+j-i*(i+1)/2)*oU2 +k);
   }
   double& U2U2a(int i,int j){
      return o_U2U2a.at( i*oU2 +j);
   }
   const double& U2U2a(int i,int j) const {
      return o_U2U2a.at( i*oU2 +j);
   }
   double& U2U2a_up(int i,int j){
      if( i>j ){
         return o_U2U2a.at( j*oU2 +i);
      }else{
         return o_U2U2a.at( i*oU2 +j);
      }
   }
   double& U3U2U2a(int i,int j,int k){
      return o_U3U2U2a.at( i*oU2*oU2 +j*oU2 +k);
   }
   double& U3U3U2U2a(int i,int j,int k,int l){
      return o_U3U3U2U2a.at( (i*oU3+j-i*(i+1)/2)*oU2*oU2 +k*oU2 +l);
   }
   double& U2chi(int i){
      return o_U2chi.at( i);
   }
   const double& U2chi(int i) const {
      return o_U2chi.at( i);
   }
   double& U2uca(int i){
      return o_U2uca.at( i);
   }
   int& TTiU3(int i,int j){
      return o_TTiU3.at( i*32 +j);
   }
   int& TTjU3(int i,int j){
      return o_TTjU3.at( i*32 +j);
   }
   double& TTe(int i,int j){
      return o_TTe.at( i*32 +j);
   }
   double& TTr(int i,int j){
      return o_TTr.at( i*32 +j);
   }
   double& TTa(int i,int j){
      return o_TTa.at( i*32 +j);
   }
   double& TTde(int i,int j,int k){
      return o_TTde.at( i*32*32 +j*32 +k);
   }
   double& TTdr(int i,int j,int k){
      return o_TTdr.at( i*32*32 +j*32 +k);
   }
   double& TTda(int i,int j,int k){
      return o_TTda.at( i*32*32 +j*32 +k);
   }
   double& TTdde(int i,int j,int k,int l){
      return o_TTdde.at( i*6*32*32 +j*32*32 +k*32 +l);
   }
   double& TTddr(int i,int j,int k,int l){
      return o_TTddr.at( i*6*32*32 +j*32*32 +k*32 +l);
   }
   double& TTdda(int i,int j,int k,int l){
      return o_TTdda.at( i*6*32*32 +j*32*32 +k*32 +l);
   }
   void F2F2b(int i,int j,bool a){
      if      ( i<j ){
         o_F2F2b[ i*oF2 -(i+1)*(i+2)/2 +j]=a;
      }else if( j<i ){
         o_F2F2b[ j*oF2 -(j+1)*(j+2)/2 +i]=a;
      }
   }
   bool F2F2b(int i,int j){
      if( i<j ){
         return o_F2F2b[ i*oF2 -(i+1)*(i+2)/2 +j];
      }else if( j<i ){
         return o_F2F2b[ j*oF2 -(j+1)*(j+2)/2 +i];
      }else{
         return true;
      }
   }
   int& F2F2E2(int i,int j){
      if( i<=j ){
         return o_F2F2E2.at( i*oF2 -i*(i+1)/2 +j);
      }else{
         return o_F2F2E2.at( j*oF2 -j*(j+1)/2 +i);
      }
   }
   int& F2F2E9(int i,int j){
      if( i<=j ){
         return o_F2F2E9[ i*oF2 -i*(i+1)/2 +j];
      }else{
         return o_F2F2E9[ j*oF2 -j*(j+1)/2 +i];
      }
   }
   tR0R0& R0R0(int i,int j){
      return o_R0R0.at( i*oR0 +j);
   }
   int& DAF2F2(int i,int j){
      return o_DAF2F2.at( i*oA +j);
   }
   tF2F2& F2F2(int i){
      return o_F2F2.at( i);
   }
   double& OU2chi(int i){
      return o_OU2chi.at( i);
   }
   void OU2b(int i,bool a){
      o_OU2b[ i]=a;
   }
   bool OU2b(int i){
      return o_OU2b[ i];
   }
   double& U2dt(int i){
      return o_U2dt.at( i);  }

   void TRA_ENQ(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_REGION_MAPS& region_maps,
                const Thread_Options& opt,
                Output_Streams& out,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep);

   void UPDATE_CONF(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_RESIDUE_MAPPINGS& residue_mappings,
                    const Structure& str,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep);
   void UPDATE_OU2(const Ptra_Automatic& aut,
                   const DAT_PHYSICS_CONSTS& physics_consts,
                   const Subset_Contracted_System::tM3& con);

   Energy_Surfq(int o,int p,int z,int r,int q,int f):
      oU2(o),
      oU3(p),
      oZ0(z),
      oR0(r),
      oQ2(q),
      oF2(f),
      o_U3f(p),
      o_U3U3f(p*(p+1)/2),
      o_U2g(o),
      o_U3U2g(p*o),
      o_U3U3U2g(p*(p+1)*o/2),
      o_U2U2a(o*o),
      o_U3U2U2a(p*o*o),
      o_U3U3U2U2a(p*(p+1)*o*o/2),
      o_U2chi(o),
      o_U2uca(o),
      o_TTiU3(32*32,-1),
      o_TTjU3(32*32,-1),
      o_TTe(32*32),
      o_TTr(32*32),
      o_TTa(32*32),
      o_TTde(6*32*32),
      o_TTdr(6*32*32),
      o_TTda(6*32*32),
      o_TTdde(6*6*32*32),
      o_TTddr(6*6*32*32),
      o_TTdda(6*6*32*32),
      o_F2F2b(f*(f-1)/2,false),
      o_Z0Z0y(z*(z+1)/2),
      o_Z0Q2y(z*q),
      o_R0R0(r*r),
      o_OU2chi(o,( 0.00)),
      o_OU2b(o,false),
      o_U2dt(o),
      Z0(z),
      R0(r),
      Q2(q),
      F2(f),
      nU2(o-6),
      nU3(p),
      ETARGET(false),
      STARGET(false),
      TTARGET(false),
      HTARGET(false),
      MTARGET(false),
      WTARGET(false)
   {
   }
};
//
//
// energy surface for target func wrt parameters
//
class Energy_Surfp {
private:
   int oU3;                                 //number of params
   int oU2;                                 //number
   /*target function surf*/
   std::vector<double> o_U3g;               //1st derivative
   std::vector<double> o_U3U3a;             //2nd derivative
   std::vector<double> o_U3chi;             //parameters
   std::vector<double> o_U3uca;             //unit of parameter displacement
   /*target function components*/
   std::vector<double> o_U2t;               //newton step
   std::vector<double> o_U3U2t;             //1st derivative of newton step
   std::vector<double> o_U3U3U2t;           //2ne derivative of newton step
   /*target function params*/
   std::vector<double> o_U2chi_por;         //generalized coords pre-inflation

public:
   int nU3;                                 //number of params
   int nU2;                                 //number of generalized coords
   /*target function surf*/
   double TOT;                              //function (Fw+Fy+Fz)
   /*repulsion+dispersion*/
   int oT;                                  //number of atom types
   std::vector<std::string> o_Tatm;         //name of atom type
   std::vector<bool> Tb;                    //subset variable
   std::vector<double> o_Te_pre;            //eps (kcal) pre inflation
   std::vector<double> o_Tr_pre;            //rho (angstrom)
   std::vector<double> o_Ta_pre;            //alp
   std::vector<double> o_Te;                //eps (kcal)
   std::vector<double> o_Tr;                //rho (angstrom)
   std::vector<double> o_Ta;                //alp
   int oH;                                  //number of H-bond types
   std::vector<int> o_Hdon;                 //index of donor atom type
   std::vector<int> o_Hacc;                 //index of acceptor atom type
   std::vector<bool> Hb;                    //subset variable
   std::vector<double> o_He_pre;            //eps (kcal) pre inflation
   std::vector<double> o_Hr_pre;            //rho (angstrom)
   std::vector<double> o_Ha_pre;            //alpha
   std::vector<double> o_He;                //eps (kcal)
   std::vector<double> o_Hr;                //rho (angstrom)
   std::vector<double> o_Ha;                //alpha
   /*target function components*/
   double z;                                //normalized gradient for ene surf
   double lamda;                            //used in calculation of U2t
   double s;                                //normalized length of U2t
   double delf;                             //predicted energy decrease for U2t
   double Fw;                               //fac_w*exp( a*(r-r_pre))
   double Fy;                               //fac_y*(TOT-Fr)
   double Fz;                               //fac_z*| chi -chi_pre|
   double g;                                //normalized gradient for enp surf
   double fac_w;                            //Fw scale factor
   double fac_y;                            //Fy
   double fac_z;                            //Fz

   double& U3g(int i){
      return o_U3g.at( i);
   }
   const double& U3g(int i) const {
      return o_U3g.at( i);
   }
   double& U3U3a(int i,int j){
      return o_U3U3a.at( i*oU3 +j);
   }
   const double& U3U3a(int i,int j) const {
      return o_U3U3a.at( i*oU3 +j);
   }
   double& U3chi(int i){
      return o_U3chi.at( i);
   }
   const double& U3chi(int i) const {
      return o_U3chi.at( i);
   }
   double& U3uca(int i){
      return o_U3uca.at( i);
   }
   double& U2t(int i){
      return o_U2t.at( i);
   }
   double& U3U2t(int i,int j){
      return o_U3U2t.at( i*oU2 +j);
   }
   double& U3U3U2t(int i,int j,int k){
      return o_U3U3U2t.at( (i*oU3+j-i*(i+1)/2)*oU2 +k);
   }
   double& U2chi_por(int i){
      return o_U2chi_por.at( i);
   }
   std::string& Tatm(int i){
      return o_Tatm.at( i);
   }
   double& Te_pre(int i){
      return o_Te_pre.at( i);
   }
   double& Tr_pre(int i){
      return o_Tr_pre.at( i);
   }
   double& Ta_pre(int i){
      return o_Ta_pre.at( i);
   }
   double& Te(int i){
      return o_Te.at( i);
   }
   double& Tr(int i){
      return o_Tr.at( i);
   }
   double& Ta(int i){
      return o_Ta.at( i);
   }
   int& Hdon(int i){
      return o_Hdon.at( i);
   }
   int& Hacc(int i){
      return o_Hacc.at( i);
   }
   double& He_pre(int i){
      return o_He_pre.at( i);
   }
   double& Hr_pre(int i){
      return o_Hr_pre.at( i);
   }
   double& Ha_pre(int i){
      return o_Ha_pre.at( i);
   }
   double& He(int i){
      return o_He.at( i);
   }
   double& Hr(int i){
      return o_Hr.at( i);
   }
   double& Ha(int i){
      return o_Ha.at( i);
   }

   void TRA_ENP(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                const DAT_REGION_MAPS& region_maps,
                const Thread_Options& opt,
                Output_Streams& out,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep,
                Energy_Surfq& enq,
                Energy_Surfq& ene);

   Energy_Surfp(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                int p,int o):
      oU3(p),
      oU2(o),
      o_U3g(p),
      o_U3U3a(p*p),
      o_U3chi(p),
      o_U3uca(p,( 1.00)),
      o_U2t(o),
      o_U3U2t(p*o),
      o_U3U3U2t(p*(p+1)*o/2),
      o_U2chi_por(o),
      nU3(p),
      nU2(o),
      oT(32),
      o_Tatm(32,"  P"),
      Tb(32,false),
      o_Te_pre(32),
      o_Tr_pre(32),
      o_Ta_pre(32),
      o_Te(32),
      o_Tr(32),
      o_Ta(32),
      oH(12),
      o_Hdon(12),
      o_Hacc(12),
      Hb(12,false),
      o_He_pre(12),
      o_Hr_pre(12),
      o_Ha_pre(12),
      o_He(12),
      o_Hr(12),
      o_Ha(12)
   {
      Tatm( 0)="H00";
      Tatm( 1)="M01";
      Tatm( 2)="H02";
      Tatm( 3)="H03";
      Tatm( 4)="M04";
      Tatm( 5)="H05";
      Tatm( 8)="C08";
      Tatm( 9)="C09";
      Tatm(10)="C10";
      Tatm(11)="N11";
      Tatm(12)="N12";
      Tatm(13)="O13";
      Tatm(14)="O14";
      Tatm(15)="S15";
      Tatm(16)="P16";
      Tatm(17)="F17";
      for(int iT= 0;iT<oT;iT++){
         Te_pre(iT)= energy_params.T2T2e(iT,iT)*physics_consts.CAL/
                     energy_params.fac_pp;
         Tr_pre(iT)= energy_params.T2T2r(iT,iT)*physics_consts.ANG;
         Ta_pre(iT)= energy_params.T2T2a(iT,iT);
      }
      Hdon( 0)= 2;
      Hdon( 1)= 2;
      Hdon( 2)= 2;
      Hdon( 3)= 2;
      Hdon( 4)= 2;
      Hdon( 5)= 2;
      Hdon( 6)= 5;
      Hdon( 7)= 5;
      Hdon( 8)= 5;
      Hdon( 9)= 5;
      Hdon(10)= 5;
      Hdon(11)= 5;
      Hacc( 0)=11;
      Hacc( 1)=12;
      Hacc( 2)=13;
      Hacc( 3)=14;
      Hacc( 4)=15;
      Hacc( 5)=17;
      Hacc( 6)=11;
      Hacc( 7)=12;
      Hacc( 8)=13;
      Hacc( 9)=14;
      Hacc(10)=15;
      Hacc(11)=17;
      for(int iH= 0;iH<oH;iH++){
         int iT=Hdon(iH);
         int jT=Hacc(iH);
         He_pre(iH)= energy_params.T2T2e(iT,jT)*physics_consts.CAL/
                     energy_params.fac_pp;
         Hr_pre(iH)= energy_params.T2T2r(iT,jT)*physics_consts.ANG;
         Ha_pre(iH)= energy_params.T2T2a(iT,jT);
      }
   }
};

void SYNC(const DAT_PHYSICS_CONSTS& physics_consts,
          const DAT_ENERGY_PARAMS& energy_params,
          Energy_Surfp& enp,
          Energy_Surfq& enq,
          Energy_Surfq& ene);

#endif
