#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Ptra_Automatic.hh"
#include "../tra/Energy_Surf.hh"
#include <string>
#include <cmath>

void SYNC(const DAT_PHYSICS_CONSTS& physics_consts,
          const DAT_ENERGY_PARAMS& energy_params,
          Energy_Surfp& enp,
          Energy_Surfq& enq,
          Energy_Surfq& ene){
//
//
// enp
//
   double tanhz= std::tanh( -1.6);
   int iU3=0;
   double Tdx[32][3];           //1st derivative of (Te,Tr,Ta) wrt Tr
   double Tddx[32][3];          //2nd derivative of (Te,Tr,Ta) wrt Tr
   for(int iT= 0;iT<enp.oT;iT++){
      if( enp.Tb[iT] ){
         enp.Tr(iT)= enp.U3chi(iU3++);
         double d= (1.00);
         double z= (1.00)/d;
         double x= (-1.6) +z*( enp.Tr(iT) -enp.Tr_pre(iT));
         double tanhx= std::tanh( x);
         double dtanhx=( (1.) -tanhx*tanhx);
         double ddtanhx= (-2.)*tanhx*dtanhx;
         enp.Te(iT)= enp.Te_pre(iT)
                    +( (.02) -enp.Te_pre(iT))*(.5)*( tanhx -tanhz);
         enp.Ta(iT)= enp.Ta_pre(iT)
                    +( (.20) -enp.Ta_pre(iT))*(.5)*( tanhx -tanhz);
         Tdx[iT][0]=( (.02) -enp.Te_pre(iT))*(.5)*z*dtanhx;
         Tdx[iT][1]= (1.00);
         Tdx[iT][2]=( (.20) -enp.Ta_pre(iT))*(.5)*z*dtanhx;
         Tddx[iT][0]=( (.02) -enp.Te_pre(iT))*(.5)*z*z*ddtanhx;
         Tddx[iT][1]= (0.00);
         Tddx[iT][2]=( (.20) -enp.Ta_pre(iT))*(.5)*z*z*ddtanhx;
      }else{
         enp.Te(iT)= enp.Te_pre(iT);
         enp.Tr(iT)= enp.Tr_pre(iT);
         enp.Ta(iT)= enp.Ta_pre(iT);
      }
   }
   double Hdx[12][3];           //1st derivative of (He,Hr,Ha) wrt Hr
   double Hddx[12][3];          //2nd derivative of (He,Hr,Ha) wrt Hr
   for(int iH= 0;iH<enp.oH;iH++){
      if( enp.Hb[iH] ){
         enp.Hr(iH)= enp.U3chi(iU3++);
         double d= (1.00);
         double z= (1.00)/d;
         double x= (-1.6) +z*( enp.Hr(iH) -enp.Hr_pre(iH));
         double tanhx= std::tanh( x);
         double dtanhx=( (1.) -tanhx*tanhx);
         double ddtanhx= (-2.)*tanhx*dtanhx;
         enp.He(iH)= enp.He_pre(iH)
                    +( (.02) -enp.He_pre(iH))*(.5)*( tanhx -tanhz);
         enp.Ha(iH)= enp.Ha_pre(iH)
                    +( (.20) -enp.Ha_pre(iH))*(.5)*( tanhx -tanhz);
         Hdx[iH][0]=( (.02) -enp.He_pre(iH))*(.5)*z*dtanhx;
         Hdx[iH][1]= (1.00);
         Hdx[iH][2]=( (.20) -enp.Ha_pre(iH))*(.5)*z*dtanhx;
         Hddx[iH][0]=( (.02) -enp.He_pre(iH))*(.5)*z*z*ddtanhx;
         Hddx[iH][1]= (0.00);
         Hddx[iH][2]=( (.20) -enp.Ha_pre(iH))*(.5)*z*z*ddtanhx;
      }else{
         enp.He(iH)= enp.He_pre(iH);
         enp.Hr(iH)= enp.Hr_pre(iH);
         enp.Ha(iH)= enp.Ha_pre(iH);
      }
   }
//
//
// enq
//
   for(int iT= 0;iT<enp.oT;iT++){
      for(int jT= 0;jT<enp.oT;jT++){
         enq.TTe(iT,jT)= (0.00);
         enq.TTr(iT,jT)= (0.10);
         enq.TTa(iT,jT)= (0.00);
      }
   }
   for(int iT= 0;iT<enp.oT;iT++){
      if( enp.Tatm(iT)=="  P" )continue;
      for(int jT= 0;jT<enp.oT;jT++){
         if( enp.Tatm(jT)=="  P" )continue;
         double C=( std::pow(enp.Tr(iT),6)
                   +std::pow(enp.Tr(jT),6))/(2.00);
         enq.TTr(iT,jT)= std::exp( ((1.)/(6.))*std::log( C));
         double A= std::sqrt( enp.Te(iT))*std::sqrt( enp.Te(jT));
         double B= std::pow(enp.Tr(iT),3)*std::pow(enp.Tr(jT),3);
         enq.TTe(iT,jT)= A*B/C;
         double Di=( (1.) +enp.Ta(iT))/enp.Ta(iT);
         double Dj=( (1.) +enp.Ta(jT))/enp.Ta(jT);
         double D= std::sqrt( Di)*std::sqrt( Dj);
         double Z= C/B;
         double F= D*std::exp( ((1.)/(7.))*std::log( Z));
         enq.TTa(iT,jT)= (1.)/( F -(1.));
      }
   }
   for(int iH= 0;iH<enp.oH;iH++){
      int iT=enp.Hdon(iH);
      int jT=enp.Hacc(iH);
      enq.TTe(iT,jT)= enp.He(iH);
      enq.TTr(iT,jT)= enp.Hr(iH);
      enq.TTa(iT,jT)= enp.Ha(iH);
      enq.TTe(jT,iT)= enq.TTe(iT,jT);
      enq.TTr(jT,iT)= enq.TTr(iT,jT);
      enq.TTa(jT,iT)= enq.TTa(iT,jT);
   }
   for(int iT= 0;iT<enp.oT;iT++){
      for(int jT= 0;jT<enp.oT;jT++){
         enq.TTe(iT,jT)*=(energy_params.fac_pp
                         /physics_consts.CAL);
         enq.TTr(iT,jT)/=physics_consts.ANG;
      }
   }
//
//
// ene
//
   for(int iT= 0;iT<enp.oT;iT++){
      for(int jT= 0;jT<enp.oT;jT++){
         ene.TTe(iT,jT)= (0.00);
         ene.TTr(iT,jT)= (0.10);
         ene.TTa(iT,jT)= (0.00);
         for(int j=0;j<6;j++){
            ene.TTde(j,iT,jT)= (0.00);
            ene.TTdr(j,iT,jT)= (0.00);
            ene.TTda(j,iT,jT)= (0.00);
            for(int i=j;i<6;i++){
               ene.TTdde(i,j,iT,jT)= (0.00);
               ene.TTddr(i,j,iT,jT)= (0.00);
               ene.TTdda(i,j,iT,jT)= (0.00);
            }
         }
      }
   }
   for(int iT= 0;iT<enp.oT;iT++){
      if( enp.Tatm(iT)=="  P" )continue;
      for(int jT= 0;jT<enp.oT;jT++){
         if( enp.Tatm(jT)=="  P" )continue;
//
//
// combination r and derivatives
//
         double C=( std::pow(enp.Tr(iT),6)
                   +std::pow(enp.Tr(jT),6))/(2.00);
         ene.TTr(iT,jT)= std::exp( ((1.)/(6.))*std::log( C));
         double dC1= (3.)*std::pow(enp.Tr(iT),5);
         double dC4= (3.)*std::pow(enp.Tr(jT),5);
         double ddC11= (5.)*dC1/enp.Tr(iT);
         double ddC44= (5.)*dC4/enp.Tr(jT);
         double drdC= (( 1.)/(6.))*ene.TTr(iT,jT)/C;
         double ddrdCdC= ((-5.)/(6.))*drdC/C;
         ene.TTdr(1,iT,jT)= drdC*dC1;
         ene.TTdr(4,iT,jT)= drdC*dC4;
         ene.TTddr(1,1,iT,jT)= ddrdCdC*dC1*dC1 +drdC*ddC11;
         ene.TTddr(4,1,iT,jT)= ddrdCdC*dC4*dC1;
         ene.TTddr(4,4,iT,jT)= ddrdCdC*dC4*dC4 +drdC*ddC44;
//
//
// combination e and derivatives
//
         double A= std::sqrt( enp.Te(iT))*std::sqrt( enp.Te(jT));
         double B= std::pow(enp.Tr(iT),3)*std::pow(enp.Tr(jT),3);
         ene.TTe(iT,jT)= A*B/C;
         double dA0= (( 1.)/(2.))*A/enp.Te(iT);
         double dA3= (( 1.)/(2.))*A/enp.Te(jT);
         double ddA00= ((-1.)/(2.))*dA0/enp.Te(iT);
         double ddA30= (( 1.)/(2.))*dA0/enp.Te(jT);
         double ddA33= ((-1.)/(2.))*dA3/enp.Te(jT);
         double dB1= (3.)*B/enp.Tr(iT);
         double dB4= (3.)*B/enp.Tr(jT);
         double ddB11= (2.)*dB1/enp.Tr(iT);
         double ddB41= (3.)*dB1/enp.Tr(jT);
         double ddB44= (2.)*dB4/enp.Tr(jT);
         double dedA= ene.TTe(iT,jT)/A;
         double dedB= ene.TTe(iT,jT)/B;
         double dedC=-ene.TTe(iT,jT)/C;
         double ddedAdB= dedA/B;
         double ddedAdC=-dedA/C;
         double ddedBdC=-dedB/C;
         double ddedCdC= (-2.)*dedC/C;
         ene.TTde(0,iT,jT)= dedA*dA0;
         ene.TTde(1,iT,jT)=( dedB*dB1 +dedC*dC1);
         ene.TTde(3,iT,jT)= dedA*dA3;
         ene.TTde(4,iT,jT)=( dedB*dB4 +dedC*dC4);
         ene.TTdde(0,0,iT,jT)= dedA*ddA00;
         ene.TTdde(1,0,iT,jT)=( ddedAdB*dB1 +ddedAdC*dC1)*dA0;
         ene.TTdde(3,0,iT,jT)= dedA*ddA30;
         ene.TTdde(4,0,iT,jT)=( ddedAdB*dB4 +ddedAdC*dC4)*dA0;
         ene.TTdde(1,1,iT,jT)=( dedB*ddB11 +(2.)*ddedBdC*dB1*dC1
                               +ddedCdC*dC1*dC1 +dedC*ddC11);
         ene.TTdde(3,1,iT,jT)=( ddedAdB*dB1 +ddedAdC*dC1)*dA3;
         ene.TTdde(4,1,iT,jT)=( dedB*ddB41 +ddedBdC*( dB1*dC4 +dB4*dC1)
                               +ddedCdC*dC4*dC1);
         ene.TTdde(3,3,iT,jT)= dedA*ddA33;
         ene.TTdde(4,3,iT,jT)=( ddedAdB*dB4 +ddedAdC*dC4)*dA3;
         ene.TTdde(4,4,iT,jT)=( dedB*ddB44 +(2.)*ddedBdC*dB4*dC4
                               +ddedCdC*dC4*dC4 +dedC*ddC44);
//
//
// combination a and derivatives
//
         double Di=( (1.) +enp.Ta(iT))/enp.Ta(iT);
         double Dj=( (1.) +enp.Ta(jT))/enp.Ta(jT);
         double D= std::sqrt( Di)*std::sqrt( Dj);
         double Z= C/B;
         double F= D*std::exp( ((1.)/(7.))*std::log( Z));
         ene.TTa(iT,jT)= (1.)/( F -(1.));
         double BB= B*B;
         double BBB= B*BB;
         double aai= enp.Ta(iT)*enp.Ta(iT);
         double aaj= enp.Ta(jT)*enp.Ta(jT);
         double dD2= ((-1.)/(2.))*D/(Di*aai);
         double dD5= ((-1.)/(2.))*D/(Dj*aaj);
         double ddD22=( (( 1.)/(2.))/(Di*aai) +(-2.)/enp.Ta(iT))*dD2;
         double ddD52= ((-1.)/(2.))*dD2/(Dj*aaj);
         double ddD55=( (( 1.)/(2.))/(Dj*aaj) +(-2.)/enp.Ta(jT))*dD5;
         double dZ1=( dC1/B -C*dB1/BB);
         double dZ4=( dC4/B -C*dB4/BB);
         double ddZ11= ddC11/B -(2.)*dC1*dB1/BB
                      +(2.)*C*dB1*dB1/BBB -C*ddB11/BB;
         double ddZ41=-( dB4*dC1 +dB1*dC4)/BB
                      +(2.)*C*dB1*dB4/BBB -C*ddB41/BB;
         double ddZ44= ddC44/B -(2.)*dC4*dB4/BB
                      +(2.)*C*dB4*dB4/BBB -C*ddB44/BB;
         double dadf=-ene.TTa(iT,jT)/( F -(1.));
         double ddadfdf= (-2.)*dadf/( F -(1.));
         double dfdZ= (( 1.)/(7.))*F/Z;
         double dfdD= F/D;
         double ddfdZdZ= ((-6.)/(7.))*dfdZ/Z;
         double ddfdZdD= dfdZ/D;
         ene.TTda(1,iT,jT)= dadf*dfdZ*dZ1;
         ene.TTda(2,iT,jT)= dadf*dfdD*dD2;
         ene.TTda(4,iT,jT)= dadf*dfdZ*dZ4;
         ene.TTda(5,iT,jT)= dadf*dfdD*dD5;
         ene.TTdda(1,1,iT,jT)= ddadfdf*dfdZ*dZ1*dfdZ*dZ1
                              +dadf*ddfdZdZ*dZ1*dZ1
                              +dadf*dfdZ*ddZ11;
         ene.TTdda(2,1,iT,jT)= ddadfdf*dfdD*dD2*dfdZ*dZ1
                              +dadf*ddfdZdD*dD2*dZ1;
         ene.TTdda(4,1,iT,jT)= ddadfdf*dfdZ*dZ4*dfdZ*dZ1
                              +dadf*ddfdZdZ*dZ4*dZ1
                              +dadf*dfdZ*ddZ41;
         ene.TTdda(5,1,iT,jT)= ddadfdf*dfdD*dD5*dfdZ*dZ1
                              +dadf*ddfdZdD*dD5*dZ1;
         ene.TTdda(2,2,iT,jT)= ddadfdf*dfdD*dD2*dfdD*dD2
                              +dadf*dfdD*ddD22;
         ene.TTdda(4,2,iT,jT)= ddadfdf*dfdZ*dZ4*dfdD*dD2
                              +dadf*ddfdZdD*dZ4*dD2;
         ene.TTdda(5,2,iT,jT)= ddadfdf*dfdD*dD5*dfdD*dD2
                              +dadf*dfdD*ddD52;
         ene.TTdda(4,4,iT,jT)= ddadfdf*dfdZ*dZ4*dfdZ*dZ4
                              +dadf*ddfdZdZ*dZ4*dZ4
                              +dadf*dfdZ*ddZ44;
         ene.TTdda(5,4,iT,jT)= ddadfdf*dfdD*dD5*dfdZ*dZ4
                              +dadf*ddfdZdD*dD5*dZ4;
         ene.TTdda(5,5,iT,jT)= ddadfdf*dfdD*dD5*dfdD*dD5
                              +dadf*dfdD*ddD55;
//
//
// symmetrize
//
         for(int i=0;i<5;i++){
            for(int j=(i+1);j<6;j++){
               ene.TTdde(i,j,iT,jT)= ene.TTdde(j,i,iT,jT);
               ene.TTddr(i,j,iT,jT)= ene.TTddr(j,i,iT,jT);
               ene.TTdda(i,j,iT,jT)= ene.TTdda(j,i,iT,jT);
            }
         }
//
//
// dependence of e and a on r
//
         if( enp.Tb[iT] ){
            double de= (0.00);
            double dr= (0.00);
            double da= (0.00);
            double dde= (0.00);
            double ddr= (0.00);
            double dda= (0.00);
            for(int i=0;i<3;i++){
               de+=ene.TTde(  i,iT,jT)*Tdx[iT][i];
               dr+=ene.TTdr(  i,iT,jT)*Tdx[iT][i];
               da+=ene.TTda(  i,iT,jT)*Tdx[iT][i];
               dde+=ene.TTde(  i,iT,jT)*Tddx[iT][i];
               ddr+=ene.TTdr(  i,iT,jT)*Tddx[iT][i];
               dda+=ene.TTda(  i,iT,jT)*Tddx[iT][i];
               ene.TTde(  i,iT,jT)= (0.00);
               ene.TTdr(  i,iT,jT)= (0.00);
               ene.TTda(  i,iT,jT)= (0.00);
               double ze= (0.00);
               double zr= (0.00);
               double za= (0.00);
               for(int j=0;j<3;j++){
                  ze+=ene.TTdde(  i,  j,iT,jT)*Tdx[iT][j];
                  zr+=ene.TTddr(  i,  j,iT,jT)*Tdx[iT][j];
                  za+=ene.TTdda(  i,  j,iT,jT)*Tdx[iT][j];
                  ene.TTdde(  i,  j,iT,jT)= (0.00);
                  ene.TTddr(  i,  j,iT,jT)= (0.00);
                  ene.TTdda(  i,  j,iT,jT)= (0.00);
               }
               dde+=Tdx[iT][i]*ze;
               ddr+=Tdx[iT][i]*zr;
               dda+=Tdx[iT][i]*za;
            }
            ene.TTde(  1,iT,jT)= de;
            ene.TTdr(  1,iT,jT)= dr;
            ene.TTda(  1,iT,jT)= da;
            ene.TTdde(  1,  1,iT,jT)= dde;
            ene.TTddr(  1,  1,iT,jT)= ddr;
            ene.TTdda(  1,  1,iT,jT)= dda;
         }
         if( enp.Tb[jT] ){
            double de= (0.00);
            double dr= (0.00);
            double da= (0.00);
            double dde= (0.00);
            double ddr= (0.00);
            double dda= (0.00);
            for(int i=0;i<3;i++){
               de+=ene.TTde(3+i,iT,jT)*Tdx[jT][i];
               dr+=ene.TTdr(3+i,iT,jT)*Tdx[jT][i];
               da+=ene.TTda(3+i,iT,jT)*Tdx[jT][i];
               dde+=ene.TTde(3+i,iT,jT)*Tddx[jT][i];
               ddr+=ene.TTdr(3+i,iT,jT)*Tddx[jT][i];
               dda+=ene.TTda(3+i,iT,jT)*Tddx[jT][i];
               ene.TTde(3+i,iT,jT)= (0.00);
               ene.TTdr(3+i,iT,jT)= (0.00);
               ene.TTda(3+i,iT,jT)= (0.00);
               double ze= (0.00);
               double zr= (0.00);
               double za= (0.00);
               for(int j=0;j<3;j++){
                  ze+=ene.TTdde(3+i,3+j,iT,jT)*Tdx[jT][j];
                  zr+=ene.TTddr(3+i,3+j,iT,jT)*Tdx[jT][j];
                  za+=ene.TTdda(3+i,3+j,iT,jT)*Tdx[jT][j];
                  ene.TTdde(3+i,3+j,iT,jT)= (0.00);
                  ene.TTddr(3+i,3+j,iT,jT)= (0.00);
                  ene.TTdda(3+i,3+j,iT,jT)= (0.00);
               }
               dde+=Tdx[jT][i]*ze;
               ddr+=Tdx[jT][i]*zr;
               dda+=Tdx[jT][i]*za;
            }
            ene.TTde(  4,iT,jT)= de;
            ene.TTdr(  4,iT,jT)= dr;
            ene.TTda(  4,iT,jT)= da;
            ene.TTdde(  4,  4,iT,jT)= dde;
            ene.TTddr(  4,  4,iT,jT)= ddr;
            ene.TTdda(  4,  4,iT,jT)= dda;
         }
         if( enp.Tb[iT]&&enp.Tb[jT] ){
            double dde= (0.00);
            double ddr= (0.00);
            double dda= (0.00);
            for(int i=0;i<3;i++){
               double ze= (0.00);
               double zr= (0.00);
               double za= (0.00);
               for(int j=0;j<3;j++){
                  ze+=ene.TTdde(  i,3+j,iT,jT)*Tdx[jT][j];
                  zr+=ene.TTddr(  i,3+j,iT,jT)*Tdx[jT][j];
                  za+=ene.TTdda(  i,3+j,iT,jT)*Tdx[jT][j];
                  ene.TTdde(  i,3+j,iT,jT)= (0.00);
                  ene.TTddr(  i,3+j,iT,jT)= (0.00);
                  ene.TTdda(  i,3+j,iT,jT)= (0.00);
               }
               dde+=Tdx[iT][i]*ze;
               ddr+=Tdx[iT][i]*zr;
               dda+=Tdx[iT][i]*za;
            }
            ene.TTdde(  1,  4,iT,jT)= dde;
            ene.TTddr(  1,  4,iT,jT)= ddr;
            ene.TTdda(  1,  4,iT,jT)= dda;
            dde= (0.00);
            ddr= (0.00);
            dda= (0.00);
            for(int i=0;i<3;i++){
               double ze= (0.00);
               double zr= (0.00);
               double za= (0.00);
               for(int j=0;j<3;j++){
                  ze+=ene.TTdde(3+i,  j,iT,jT)*Tdx[iT][j];
                  zr+=ene.TTddr(3+i,  j,iT,jT)*Tdx[iT][j];
                  za+=ene.TTdda(3+i,  j,iT,jT)*Tdx[iT][j];
                  ene.TTdde(3+i,  j,iT,jT)= (0.00);
                  ene.TTddr(3+i,  j,iT,jT)= (0.00);
                  ene.TTdda(3+i,  j,iT,jT)= (0.00);
               }
               dde+=Tdx[jT][i]*ze;
               ddr+=Tdx[jT][i]*zr;
               dda+=Tdx[jT][i]*za;
            }
            ene.TTdde(  4,  1,iT,jT)= dde;
            ene.TTddr(  4,  1,iT,jT)= ddr;
            ene.TTdda(  4,  1,iT,jT)= dda;
         }

      }
   }
   for(int iH= 0;iH<enp.oH;iH++){
      int iT=enp.Hdon(iH);
      int jT=enp.Hacc(iH);
//
//
// H-bond combinations and derivatives
//
      ene.TTe(iT,jT)= enp.He(iH);
      ene.TTr(iT,jT)= enp.Hr(iH);
      ene.TTa(iT,jT)= enp.Ha(iH);
      ene.TTde(0,iT,jT)= ( .50);
      ene.TTde(1,iT,jT)= (0.00);
      ene.TTde(2,iT,jT)= (0.00);
      ene.TTde(3,iT,jT)= ( .50);
      ene.TTde(4,iT,jT)= (0.00);
      ene.TTde(5,iT,jT)= (0.00);
      ene.TTdr(0,iT,jT)= (0.00);
      ene.TTdr(1,iT,jT)= ( .50);
      ene.TTdr(2,iT,jT)= (0.00);
      ene.TTdr(3,iT,jT)= (0.00);
      ene.TTdr(4,iT,jT)= ( .50);
      ene.TTdr(5,iT,jT)= (0.00);
      ene.TTda(0,iT,jT)= (0.00);
      ene.TTda(1,iT,jT)= (0.00);
      ene.TTda(2,iT,jT)= ( .50);
      ene.TTda(3,iT,jT)= (0.00);
      ene.TTda(4,iT,jT)= (0.00);
      ene.TTda(5,iT,jT)= ( .50);
      for(int i=0;i<6;i++){
         for(int j=0;j<6;j++){
            ene.TTdde(i,j,iT,jT)= (0.00);
            ene.TTddr(i,j,iT,jT)= (0.00);
            ene.TTdda(i,j,iT,jT)= (0.00);
         }
      }
//
//
// dependence of (He,Hr,Ha) on Hr
//
      if( enp.Hb[iH] ){
         ene.TTde(1,iT,jT)= ( .50)*Hdx[iH][0];
         ene.TTde(4,iT,jT)= ( .50)*Hdx[iH][0];
         ene.TTde(0,iT,jT)= (0.00);
         ene.TTde(3,iT,jT)= (0.00);
         ene.TTda(1,iT,jT)= ( .50)*Hdx[iH][2];
         ene.TTda(4,iT,jT)= ( .50)*Hdx[iH][2];
         ene.TTda(2,iT,jT)= (0.00);
         ene.TTda(5,iT,jT)= (0.00);
         ene.TTdde(1,1,iT,jT)= ( .50)*Hddx[iH][0];
         ene.TTdde(4,4,iT,jT)= ( .50)*Hddx[iH][0];
         ene.TTdda(1,1,iT,jT)= ( .50)*Hddx[iH][2];
         ene.TTdda(4,4,iT,jT)= ( .50)*Hddx[iH][2];
      }
//
//
// symmetrize
//
      ene.TTe(jT,iT)= ene.TTe(iT,jT);
      ene.TTr(jT,iT)= ene.TTr(iT,jT);
      ene.TTa(jT,iT)= ene.TTa(iT,jT);
      for(int i=0;i<6;i++){
         ene.TTde(i,jT,iT)= ene.TTde(i,iT,jT);
         ene.TTdr(i,jT,iT)= ene.TTdr(i,iT,jT);
         ene.TTda(i,jT,iT)= ene.TTda(i,iT,jT);
         for(int j=0;j<6;j++){
            ene.TTdde(i,j,jT,iT)= ene.TTdde(i,j,iT,jT);
            ene.TTddr(i,j,jT,iT)= ene.TTddr(i,j,iT,jT);
            ene.TTdda(i,j,jT,iT)= ene.TTdda(i,j,iT,jT);
         }
      }
   }
//
//
// units
//
   for(int iT= 0;iT<enp.oT;iT++){
      for(int jT= 0;jT<enp.oT;jT++){
         ene.TTe(iT,jT)*=(energy_params.fac_pp
                         /physics_consts.CAL);
         ene.TTr(iT,jT)/=physics_consts.ANG;
         for(int i=0;i<6;i++){
            ene.TTde(i,iT,jT)*=(energy_params.fac_pp
                               /physics_consts.CAL);
            ene.TTdr(i,iT,jT)/=physics_consts.ANG;
            for(int j=0;j<6;j++){
               ene.TTdde(i,j,iT,jT)*=(energy_params.fac_pp
                                     /physics_consts.CAL);
               ene.TTddr(i,j,iT,jT)/=physics_consts.ANG;
            }
         }
      }
   }
   return;
}

void Energy_Surfq::UPDATE_CONF(const DAT_PHYSICS_CONSTS& physics_consts,
                               const DAT_RESIDUE_MAPPINGS& residue_mappings,
                               const Structure& str,
                               const Mechanical_System& mol,
                               const Subset_Contracted_System::tM3& con,
                               Conf_Dependent_System& dep){
//
//
// update torsions
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int iQ1bb=(mQ1+1);
      int iQ1sc=(mQ1+mol.Z0[iZ0].cQ1bb);
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int iL0=str.R0[iR0].L0;
         int mQ0=residue_mappings.L0[iL0].Q0a;
         int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
         if( nQ0>=mQ0 ){
            for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
               int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
               std::string tor=mol.Q1[iQ1].tor;
               int jR0=( tor=="OMG" )? iR0-1: iR0;
               int mT1=str.R0[jR0].T1a;
               int nT1=(mT1-1+str.R0[jR0].cT1);
               for(int iT1=mT1;iT1<=nT1;iT1++){
                  if( str.T1[iT1].tor==tor ){
                     dep.Q1[iQ1].chi= str.T1[iT1].chi
                                     *physics_consts.RAD;
                     break;
                  }
               }
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int iQ2=mQ2;
      for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
         if( con.Q1[iQ1].sub ){
            dep.Q2[++iQ2].chi= dep.Q1[iQ1].chi;
         }
      }
   }
   int iU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         dep.Z0[iZ0].trans=str.Z0[iZ0].trans;
         dep.Z0[iZ0].rot=str.Z0[iZ0].rot;
         U2chi(iU2  )= dep.Z0[iZ0].trans(0);
         U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
         U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
         U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
         U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
         U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
         iU2+=6;
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         U2chi(iU2)= dep.Q2[iQ2].chi;
         iU2++;
      }
   }
}

void Energy_Surfq::UPDATE_OU2(const Ptra_Automatic& aut,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const Subset_Contracted_System::tM3& con){
   int iU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( con.Z0[iZ0].sub )iU2+=6;
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
         if( con.Q2[iQ2].br>0 ){
         }else{
            std::string tor=con.Q2[iQ2].tor;
            int iF2=con.Q2[iQ2].bseF2;
            int iR0=con.F2[iF2].R0;
            OU2b(iU2,false);
            OU2chi(iU2)= (   0.00);
            if      ( tor=="PHI" ){
               if      ( aut.ns.R0h(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= ( -65.00)*physics_consts.RAD;
               }else if( aut.ns.R0e(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= (-135.00)*physics_consts.RAD;
               }
            }else if( tor=="PSI" ){
               if      ( aut.ns.R0h(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= ( -55.00)*physics_consts.RAD;
               }else if( aut.ns.R0e(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= ( 150.00)*physics_consts.RAD;
               }
            }else if( tor=="OMG" ){
               if      ( aut.ns.R0h(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= ( 180.00)*physics_consts.RAD;
               }else if( aut.ns.R0e(iR0) ){
                  OU2b(iU2, true);
                  OU2chi(iU2)= ( 180.00)*physics_consts.RAD;
               }
            }
         }
         iU2++;
      }
   }
   return;
}
