#include "../phi/Coordinates.hh"
#include "../sup/Kabsch_Rotation.hh"

Kabsch_Rotation& Kabsch_Rotation::project(){
   Coordinates y;
   y(0)= x(0)/L(0,0);
   y(1)=( x(1) -L(1,0)*y(0))/L(1,1);
   y(2)=( x(2) -L(2,1)*y(1) -L(2,0)*y(0))/L(2,2);
   x(2)= y(2)/L(2,2);
   x(1)=( y(1) -L(2,1)*x(2))/L(1,1);
   x(0)=( y(0) -L(1,0)*x(1) -L(2,0)*x(2))/L(0,0);
   return *this;
}
