#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../sup/Kabsch_Rotation.hh"
#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>

class MEM_sup {
public:
   class tA1 { /*atoms to be superposed*/
   public:
/*coords (angstrom) from pair of structures*/
      Coordinates y;            //fixed
      Coordinates x;            //movable
/*mappings*/
      int Z0;                   //chain
      int R0;                   //residue
      int P1;                   //atom
      tA1(){}
   };
public:
   std::vector<tA1> A1;         //atoms to be superposed
   MEM_sup(){
   }
};

double Structure::SUP(const DAT_PHYSICS_CONSTS& physics_consts,
                      Output_Streams& out,
                      const Trajectory& tra){
//
//
// select subset of atoms to be superposed
//
   MEM_sup vv;
   int nA1=0;
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
//       if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( tra.M0[ 0].P1[iP1].sub==0 )continue;
            if( P1[iP1].sub==0 )continue;
            if( iT2< 8 )continue;
//          if( (atm!=" N  ")&&(atm!=" CA ")&&(atm!=" C  ")&&
//              (atm!=" CB ")&&(atm!=" O  ") )continue;
            if      ( ((aa[3]=='e')||(aa[3]=='z'))&&
                      ((atm==" O  ")||(atm==" OXT")) ){
            }else if( (aa.substr(0,3)=="ASP")&&
                      ((atm==" OD1")||(atm==" OD2")) ){
            }else if( (aa.substr(0,3)=="GLU")&&
                      ((atm==" OE1")||(atm==" OE2")) ){
            }else if( (aa.substr(0,3)=="PHE")&&
                      ((atm==" CD1")||(atm==" CD2")||
                       (atm==" CE1")||(atm==" CE2")) ){
//          }else if( (aa.substr(0,3)=="LEU")&&
//                    ((atm==" CD1")||(atm==" CD2")) ){
            }else if( (aa.substr(0,3)=="ARG")&&
                      ((atm==" NH1")||(atm==" NH2")) ){
//          }else if( (aa.substr(0,3)=="VAL")&&
//                    ((atm==" CG1")||(atm==" CG2")) ){
            }else if( (aa.substr(0,3)=="TYR")&&
                      ((atm==" CD1")||(atm==" CD2")||
                       (atm==" CE1")||(atm==" CE2")) ){
            }else if( (aa.substr(0,3)=="AIB")&&
                      ((atm==" CB2")||(atm==" CB1")) ){
            }else if( (aa=="PO  ")&&
                      ((atm==" O1P")||(atm==" O2P")) ){
            }else if( (aa=="PSR ")&&
                      ((atm==" O1P")||(atm==" S2P")) ){
            }else if( (aa=="PSS ")&&
                      ((atm==" S1P")||(atm==" O2P")) ){
            }else if( (aa=="5PO ")&&
                      ((atm==" O1P")||(atm==" O2P")||
                       (atm==" O3P")) ){
            }else if( (aa=="3PO ")&&
                      ((atm==" O1P")||(atm==" O2P")||
                       (atm==" O3P")) ){
            }else if( (aa=="SEP ")&&
                      ((atm==" O1P")||(atm==" O2P")||
                       (atm==" O3P")) ){
            }else if( (aa=="THP ")&&
                      ((atm==" O1P")||(atm==" O2P")||
                       (atm==" O3P")) ){
            }else if( (aa=="TYP ")&&
                      ((atm==" O1P")||(atm==" O2P")||
                       (atm==" O3P")) ){
            }else{
               vv.A1.push_back( MEM_sup::tA1());
               vv.A1[nA1  ].x=P1[iP1].x;
               vv.A1[nA1  ].y=tra.M0[ 0].P1[iP1].x;
               vv.A1[nA1  ].Z0=iZ0;
               vv.A1[nA1  ].R0=iR0;
               vv.A1[nA1++].P1=iP1;
            }
         }
      }
   }
//
//
// translate st origin is mean position
//
   Coordinates xt;              //mean position movable
   Coordinates yt;              //fixed
   xt.zero();
   yt.zero();
   for(int iA1= 0;iA1<nA1;iA1++){
      xt+=vv.A1[iA1].x;
      yt+=vv.A1[iA1].y;
   }
   xt/=nA1;
   yt/=nA1;
   for(int iA1= 0;iA1<nA1;iA1++){
      vv.A1[iA1].x-=xt;
      vv.A1[iA1].y-=yt;
   }
//
//
// calculate optimal rotation
//
   Rotation_Matrix A;           //covariance matrix
   A.zero();
   for(int iA1= 0;iA1<nA1;iA1++){
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            A(i,j)+=vv.A1[iA1].y(i)*vv.A1[iA1].x(j);
         }
      }
   }
   Kabsch_Rotation kab(physics_consts,A);
//
//
// update structure coordinates
//
   for(int iZ0= 0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            Coordinates b=( P1[iP1].x -xt);
            P1[iP1].x.generate(yt,kab.R,b);
         }
      }
   }
//
//
// calculate heavy atom RMSD
//
   double hrmsd= (0.00);
   for(int iA1= 0;iA1<nA1;iA1++){
      Coordinates b= vv.A1[iA1].x;
      vv.A1[iA1].x.rotate(kab.R,b);
      double z=( vv.A1[iA1].x -vv.A1[iA1].y).rr();
      hrmsd+=z;
//    z= std::sqrt( z);
//    if( z>(1.00) ){
//       int iZ0=vv.A1[iA1].Z0;
//       int iR0=vv.A1[iA1].R0;
//       int iP1=vv.A1[iA1].P1;
//       std::string aa=R0[iR0].aa;
//       std::string atm=P1[iP1].atm;
//       std::cerr<<" iZ0="<< std::setw( 2)<<(iZ0+1)
//                <<" iR0="<< std::setw( 4)<<(iR0-Z0[iZ0].R0a+1)
//                <<" aa="<<aa
//                <<" atm="<<atm<<'\n';
//    }
   }
   hrmsd/=nA1;
   hrmsd= std::sqrt( hrmsd);
//
//
// output
//
   Rotation_Matrix G;           //Lagrange constraint functions
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         G(i,j)= kab.R(0,i)*kab.R(0,j)
                +kab.R(1,i)*kab.R(1,j)
                +kab.R(2,i)*kab.R(2,j);
      }
   }
   if( out.VERBOSE ){
      out.FILE3<< std::fixed<< std::setprecision(3);
      out.FILE3<<" heavy atom RMSD="
               << std::setw( 8)<<hrmsd<<'\n';
   }
// out.FILE3<< std::scientific<< std::setprecision(5);
// out.FILE3<<"eigenvalues"<<'\n';
// out.FILE3<< std::setw(12)<<kab.e1
//          << std::setw(12)<<kab.e2
//          << std::setw(12)<<kab.e3<<'\n';
// out.FILE3<< std::fixed<< std::setprecision(4);
// out.FILE3<<"R"<<'\n';
// for(int i=0;i<3;i++){
//    for(int j=0;j<3;j++){
//       out.FILE3<< std::setw( 7)<<kab.R(i,j);
//    }
//    out.FILE3<<'\n';
// }
// out.FILE3<<"G"<<'\n';
// for(int i=0;i<3;i++){
//    for(int j=0;j<3;j++){
//       out.FILE3<< std::setw( 7)<<G(i,j);
//    }
//    out.FILE3<<'\n';
// }
   return hrmsd;
}
