#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../sup/Kabsch_Rotation.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_paircnf {
public:
   class tA1 { /*atoms to be superposed*/
   public:
      Coordinates y;            //fixed (angstrom)
      Coordinates x;            //movable
      int Z0;                   //chain
      int R0;                   //residue
      int P1;                   //atom
      tA1(){}
   };
public:
   std::vector<Structure> o_Dstr;       //pair of single chain structures
   std::vector<int> o_DZ0;              //pair of chains
   std::vector<tA1> A1;                 //atoms to be superposed
   std::vector<Coordinates> o_Dtrans;   //transformation of multi to single
   std::vector<Rotation_Matrix> o_Drot; //
   MEM_paircnf():
      o_Dstr( 2),
      o_DZ0( 2),
      o_Dtrans( 2),
      o_Drot( 2)
   {
   }
   Structure& Dstr(int i){
      return o_Dstr.at( i);  }
   int& DZ0(int i){
      return o_DZ0.at( i);  }
   Coordinates& Dtrans(int i){
      return o_Dtrans.at( i);  }
   Rotation_Matrix& Drot(int i){
      return o_Drot.at( i);  }
};

void Structure::PAIRCNF(const DAT_PHYSICS_CONSTS& physics_consts,
                        Output_Streams& out,
                        const std::vector<Structure>& Zstr,
                        std::vector<Coordinates>& ZZtrans,
                        std::vector<Coordinates>& ZZrot,
                        std::vector<double>& ZZr){
   int oZ=Zstr.size();
   for(int iZ= 0;iZ<(oZ-1);iZ++){
      for(int jZ=(iZ+1);jZ<oZ;jZ++){
         int iZZ=( iZ*oZ +jZ -((iZ+1)*(iZ+2))/2);
         MEM_paircnf vv;
         vv.Dstr( 0)=Zstr.at(iZ);
         vv.Dstr( 1)=Zstr.at(jZ);
         vv.DZ0( 0)=iZ;
         vv.DZ0( 1)=jZ;
         for(int iD=0;iD<2;iD++){
            int iZ0=vv.DZ0(iD);
            const Structure& str=vv.Dstr(iD);
            int jZ0=iZ0;
            int jR0=Z0[jZ0].R0a;
            int jP1=R0[jR0].P1a;
//
//
// select subset of atoms to be superposed
//
            int nA1=0;
            {
               int mR0=Z0[iZ0].R0a;
               int nR0=(mR0-1+Z0[iZ0].cR0);
               for(int iR0=mR0;iR0<=nR0;iR0++){
                  std::string aa=R0[iR0].aa;
                  if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
//                if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
                  int mP1=R0[iR0].P1a;
                  int nP1=(mP1-1+R0[iR0].cP1);
                  for(int iP1=mP1;iP1<=nP1;iP1++){
                     std::string atm=P1[iP1].atm;
                     int iT2=P1[iP1].typ;
                     if( str.P1[iP1-jP1].sub==0 )continue;
                     if( P1[iP1].sub==0 )continue;
                     if( iT2< 8 )continue;
//                   if( (atm!=" N  ")&&(atm!=" CA ")&&(atm!=" C  ")&&
//                       (atm!=" CB ")&&(atm!=" O  ") )continue;
                     if      ( ((aa[3]=='e')||(aa[3]=='z'))&&
                               ((atm==" O  ")||(atm==" OXT")) ){
                     }else if( (aa.substr(0,3)=="ASP")&&
                               ((atm==" OD1")||(atm==" OD2")) ){
                     }else if( (aa.substr(0,3)=="GLU")&&
                               ((atm==" OE1")||(atm==" OE2")) ){
                     }else if( (aa.substr(0,3)=="PHE")&&
                               ((atm==" CD1")||(atm==" CD2")||
                                (atm==" CE1")||(atm==" CE2")) ){
//                   }else if( (aa.substr(0,3)=="LEU")&&
//                             ((atm==" CD1")||(atm==" CD2")) ){
                     }else if( (aa.substr(0,3)=="ARG")&&
                               ((atm==" NH1")||(atm==" NH2")) ){
//                   }else if( (aa.substr(0,3)=="VAL")&&
//                             ((atm==" CG1")||(atm==" CG2")) ){
                     }else if( (aa.substr(0,3)=="TYR")&&
                               ((atm==" CD1")||(atm==" CD2")||
                                (atm==" CE1")||(atm==" CE2")) ){
                     }else if( (aa.substr(0,3)=="AIB")&&
                               ((atm==" CB2")||(atm==" CB1")) ){
                     }else if( (aa=="PO  ")&&
                               ((atm==" O1P")||(atm==" O2P")) ){
                     }else if( (aa=="PSR ")&&
                               ((atm==" O1P")||(atm==" S2P")) ){
                     }else if( (aa=="PSS ")&&
                               ((atm==" S1P")||(atm==" O2P")) ){
                     }else if( (aa=="5PO ")&&
                               ((atm==" O1P")||(atm==" O2P")||
                                (atm==" O3P")) ){
                     }else if( (aa=="3PO ")&&
                               ((atm==" O1P")||(atm==" O2P")||
                                (atm==" O3P")) ){
                     }else if( (aa=="SEP ")&&
                               ((atm==" O1P")||(atm==" O2P")||
                                (atm==" O3P")) ){
                     }else if( (aa=="THP ")&&
                               ((atm==" O1P")||(atm==" O2P")||
                                (atm==" O3P")) ){
                     }else if( (aa=="TYP ")&&
                               ((atm==" CD1")||(atm==" CD2")||
                                (atm==" CE1")||(atm==" CE2")||
                                (atm==" O1P")||(atm==" O2P")||
                                (atm==" O3P")) ){
                     }else{
                        vv.A1.push_back( MEM_paircnf::tA1());
                        vv.A1[nA1  ].x=P1[iP1].x;
                        vv.A1[nA1  ].y=str.P1[iP1-jP1].x;
                        vv.A1[nA1  ].Z0=iZ0;
                        vv.A1[nA1  ].R0=iR0;
                        vv.A1[nA1++].P1=iP1;
                     }
                  }
               }
            }
//
//
// translate st origin is mean position
//
            Coordinates xt;             //mean position movable
            Coordinates yt;             //fixed
            xt.zero();
            yt.zero();
            for(int iA1= 0;iA1<nA1;iA1++){
               xt+=vv.A1[iA1].x;
               yt+=vv.A1[iA1].y;
            }
            xt/=double(nA1);
            yt/=double(nA1);
            for(int iA1= 0;iA1<nA1;iA1++){
               vv.A1[iA1].x-=xt;
               vv.A1[iA1].y-=yt;
            }
//
//
// calculate optimal rotation
//
            Rotation_Matrix A;           //covariance matrix
            A.zero();
            for(int iA1= 0;iA1<nA1;iA1++){
               for(int i=0;i<3;i++){
                  for(int j=0;j<3;j++){
                     A(i,j)+=vv.A1[iA1].y(i)*vv.A1[iA1].x(j);
                  }
               }
            }
            Kabsch_Rotation kab(physics_consts,A);
//
//
// trans +rot
//
            vv.Dtrans(iD)=( xt -yt);
            vv.Drot(iD)=transpose(kab.R);
//
//
// update structure coordinates
//
//          {
//             int mR0=Z0[iZ0].R0a;
//             int nR0=(mR0-1+Z0[iZ0].cR0);
//             for(int iR0=mR0;iR0<=nR0;iR0++){
//                int mP1=R0[iR0].P1a;
//                int nP1=(mP1-1+R0[iR0].cP1);
//                for(int iP1=mP1;iP1<=nP1;iP1++){
//                   if( P1[iP1].sub==0 )continue;
//                   Coordinates b=( P1[iP1].x -xt);
//                   P1[iP1].x.generate(yt,kab.R,b);
//                }
//             }
//          }
//
//
// calculate heavy atom RMSD
//
//          double rmsd= (0.00);
//          for(int iA1= 0;iA1<nA1;iA1++){
//             Coordinates b= vv.A1[iA1].x;
//             vv.A1[iA1].x.rotate(kab.R,b);
//             double z=( vv.A1[iA1].x -vv.A1[iA1].y).rr();
//             rmsd+=z;
//          }
//          rmsd/=double(nA1);
//          rmsd= std::sqrt( rmsd);
//
//
// output
//
//          if( out.VERBOSE ){
//             out.FILE3<< std::fixed;
//             out.FILE3<<"iD   RMSD"<<'\n';
//             out.FILE3<< std::setw( 2)<<iD
//                      << std::setprecision(3)
//                      << std::setw( 7)<<rmsd<<'\n';
//             out.FILE3<<"TRANS"<<'\n';
//             out.FILE3<<vv.Dtrans(iD)<<'\n';
//             out.FILE3<<"ROT"<<'\n';
//             out.FILE3<<vv.Drot(iD)<<'\n';
//          }
         }
         Coordinates TRANS=transpose(vv.Drot( 0))
                          *( vv.Dtrans( 1) -vv.Dtrans( 0));
         Rotation_Matrix ROT=transpose(vv.Drot( 0))*vv.Drot( 1);
         ZZtrans.at(iZZ)=TRANS;
         ZZrot.at(iZZ)=ROT.euler();
         ZZr.at(iZZ)= ZZtrans.at(iZZ).r();
      }
   }
   return;
}
