#ifndef DEF_KABSCH_ROTATION
#define DEF_KABSCH_ROTATION

#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"

class Kabsch_Rotation {
private:
   Rotation_Matrix L;           //inverse of matrix of Lagrange multipliers
   Coordinates x;               //scratch eigenvector

   Kabsch_Rotation& project();

public:
   double e1,e2,e3;             //eigenvalues of A*Atranspose
   Rotation_Matrix R;           //rotation to superposition

   Kabsch_Rotation(const DAT_PHYSICS_CONSTS& physics_consts,
                   const Rotation_Matrix& A);
};

#endif
