#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../sup/Kabsch_Rotation.hh"
#include <iostream>
#include <cstdlib>
#include <cmath>

Kabsch_Rotation::Kabsch_Rotation(const DAT_PHYSICS_CONSTS& physics_consts,
                                 const Rotation_Matrix& A){
   Rotation_Matrix AA;          //A*Atranspose
   double del;                  //
   bool PD;                     //
   Coordinates x1,x2,x3;        //
   Rotation_Matrix P1,P2,P3;    //
//
//
// obtain eigenvalues as roots of the characteristic polynomial
//
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         AA(i,j)= A(0,i)*A(0,j)
                 +A(1,i)*A(1,j)
                 +A(2,i)*A(2,j);
      }
   }
   double p=-( AA(0,0) +AA(1,1) +AA(2,2));
   double q= ( AA(0,0)*AA(1,1) +AA(0,0)*AA(2,2) +AA(1,1)*AA(2,2))
            -( AA(0,2)*AA(2,0) +AA(0,1)*AA(1,0) +AA(1,2)*AA(2,1));
   double r=-( AA(0,0)*( AA(1,1)*AA(2,2) -AA(1,2)*AA(2,1))
              +AA(0,1)*( AA(1,2)*AA(2,0) -AA(1,0)*AA(2,2))
              +AA(0,2)*( AA(1,0)*AA(2,1) -AA(1,1)*AA(2,0)));
   double a=( (3.)*q -p*p)/(3.);
   double b=( (2.)*p*p*p -(9.)*p*q +(27.)*r)/(27.);
   double c= (2.)*std::sqrt(-a/(3.));
   double Cphi= (-b/(2.))/std::sqrt(-a*a*a/(27.));
   double Sphi= std::sqrt( (1.00) -Cphi*Cphi);
   double phi= std::atan2(Sphi,Cphi);
   e1= c*std::cos( (phi/(3.))) -p/(3.);
   e2= c*std::cos( (phi/(3.)) +(120.)*physics_consts.RAD) -p/(3.);
   e3= c*std::cos( (phi/(3.)) +(240.)*physics_consts.RAD) -p/(3.);
   if( e1>e2 ){
      double e= e1;
      e1= e2;
      e2= e;
   }
   if( e2>e3 ){
      double e= e2;
      e2= e3;
      e3= e;
   }
   if( e1>e2 ){
      double e= e1;
      e1= e2;
      e2= e;
   }
//
//
// eigenvector of e1
//
   del= (e2-e1)/(1.00e+5);
   L=AA;
   L(0,0)+=( -e1 +del);
   L(1,1)+=( -e1 +del);
   L(2,2)+=( -e1 +del);
   x(0)= (1.00);
   x(1)= (1.00);
   x(2)= (1.00);
   PD=L.lower();
   if( !PD ){
      std::cerr<<"FLAG: Negative eigenvalue encountered in superposition.\n";
      R.identity();
      return;
   }
   project().project().project().project();
   x.normalize();
   project().project().project().project();
   x.normalize();
   project().project().project().project();
   x.normalize();
   x1= x;
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         P1(i,j)= x1(i)*x1(j);
      }
   }
//
//
// eigenvector of e2
//
   del= (e3-e2)/(1.00e+5);
   L=AA+(e1+e2+e3)*P1;
   L(0,0)+=( -e2 +del);
   L(1,1)+=( -e2 +del);
   L(2,2)+=( -e2 +del);
   x(0)=( x1(2) -x1(1));
   x(1)=( x1(0) -x1(2));
   x(2)=( x1(1) -x1(0));
   PD=L.lower();
   if( !PD ){
      std::cerr<<"ERROR: Negative eigenvalue encountered in superposition.\n";
      std::exit( 2);
   }
   project().project().project().project();
   x.normalize();
   project().project().project().project();
   x.normalize();
   x2= x;
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         P2(i,j)= x2(i)*x2(j);
      }
   }
//
//
// eigenvector of e3
//
   del= (e1+e2)/(1.00e+5);
   L=AA+(e1+e2+e3)*( P1 +P2);
   L(0,0)+=( -e3 +del);
   L(1,1)+=( -e3 +del);
   L(2,2)+=( -e3 +del);
   x(0)=( x1(1)*x2(2) -x1(2)*x2(1));
   x(1)=( x1(2)*x2(0) -x1(0)*x2(2));
   x(2)=( x1(0)*x2(1) -x1(1)*x2(0));
   PD=L.lower();
   if( !PD ){
      std::cerr<<"ERROR: Negative eigenvalue encountered in superposition.\n";
      std::exit( 2);
   }
   project().project().project().project();
   x.normalize();
   x3= x;
   for(int i=0;i<3;i++){
      for(int j=0;j<3;j++){
         P3(i,j)= x3(i)*x3(j);
      }
   }
//
//
// inverse of symmetric matrix of Lagrange multipliers
//
   double detA=( A(0,0)*( A(1,1)*A(2,2) -A(1,2)*A(2,1))
                +A(0,1)*( A(1,2)*A(2,0) -A(1,0)*A(2,2))
                +A(0,2)*( A(1,0)*A(2,1) -A(1,1)*A(2,0)));
   double sgnA=( detA<( 0.00) )?(-1.00):( 1.00);
   L= (  sgnA/std::sqrt(e1))*P1
     +((1.00)/std::sqrt(e2))*P2
     +((1.00)/std::sqrt(e3))*P3;
//
//
// optimal rotation
//
   R=A*L;
}
