#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>

int main(int argc, char* argv[]){

   if( argc!=3 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 2.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];

   {
      std::string filename="../../"+FAMILY+"/exp/seq."+PROTEIN;
      std::ifstream file_exists(filename.c_str());
      if( !file_exists ){
         std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
         std::exit( 1);
      }else{
         file_exists.close();
      }
   }

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_IGOR_DATA igor_data(physics_consts);

// Output_Streams out;
// {
//    std::string filename="../../"+FAMILY+"/dgn/seqformat."+PROTEIN;
//    out.FILE3.open(filename.c_str());
// }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.FIL2CHA(residue_mappings,igor_data);
   }

   int oZ0=str.nZ0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=str.R0[iR0].c1;
         std::string aa=str.R0[iR0].aa;
         if      ( c1=='a' ){
            if      ( aa=="CYS " ){
               str.R0[iR0].aa="CYH ";
            }else if( aa=="eCYS" ){
               str.R0[iR0].aa="eCYH";
            }else if( aa=="CYSe" ){
               str.R0[iR0].aa="CYHe";
            }
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
         }else if( c1=='p' ){
         }else if( c1=='s' ){
         }
      }
   }
   str.SEQ2FIL();

// out.FILE3.close();
}
