#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Family.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../glo/Glo.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <cmath>

class MEM_rcyc {
public:
   std::vector<Search_Subspace> o_M0sub;        //
   MEM_rcyc(){
   }
   Search_Subspace& M0sub(int i){
      return o_M0sub.at( i);  }
};

int main(int argc, char* argv[]){

   if( argc!=4 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 3.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string CONFORMATION=argv[3];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   Structure s;
   {
      DAT_ENERGY_PARAMS ep(physics_consts);
      DAT_RESIDUE_MAPPINGS rm(physics_consts,array_consts,ep);
      s.fam=FAMILY;
      s.mol=PROTEIN;
      s.FIL2SEQ(rm);
   }
   DAT_ENERGY_PARAMS energy_params(physics_consts,s);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;
   DAT_DEFORM_PARAMS deform_params;

   Thread_Options opt;
   {
      opt.nD0_final=64;
      opt.FUNC="rcyc";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/rcyc."+PROTEIN;
      out.FILE3.open(filename.c_str());
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf=CONFORMATION;
   }
   Trajectory tra;
   Family fam;

   str.FIL2SEQ(residue_mappings);
   str.FIL2TOR(physics_consts);
   str.CAR(physics_consts,residue_mappings);
   str.STA(physics_consts,region_maps);

   for(int iZ0=0;iZ0<str.nZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
//       if( str.R0[iR0].C7<3 )str.R0[iR0].core=':';
         str.R0[iR0].core=':';
      }
   }

   tra.STR2TRA( 0,str);

   MEM_rcyc vv;
   str.CYCSTP(residue_mappings,vv.o_M0sub, 7);
   std::string bse="g";
   int nM0=vv.o_M0sub.size();
   int iM0=0;
   for(int i1=0;i1<=9&&(iM0<nM0);i1++){
      char a1=char('0'+i1);
      for(int i2=0;i2<=9&&(iM0<nM0);i2++){
         char a2=char('0'+i2);
         for(int i3=0;i3<=9&&(iM0<nM0);i3++){
            char a3=char('0'+i3);
            opt.QSUB=bse+a1+a2+a3;
            str.cnf=opt.QSUB;
            Search_Subspace& sub=vv.M0sub(iM0);
//
//
// global energy minimization for a fixed composition
//
            Glo xglo;
            opt.MODE="   ";
            Distance_Constraints dst(physics_consts,residue_mappings,
                                     opt,out,str,sub);
            opt.iW0_active=6;
            xglo.GLO(physics_consts,array_consts,disulfide_links,
                     energy_params,residue_mappings,region_maps,
                     deform_params,
                     opt,out,str,sub,fam,dst);

            tra.STR2TRA(iM0,str);
            str.TOR2FIL(physics_consts);
            str.CAR2FIL();

            iM0++;
         }
      }
   }

   out.FILE3.close();

}
