#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../dst/Distance_Constraints.hh"
#include "../fil/Search_Subspace.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../glo/Glo.hh"
#include "../loc/Loc.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Ptra_Automatic.hh"
#include "../str/Thread_Options.hh"
#include "../tra/Energy_Surf.hh"
#include "../tra/Local_Minimiz.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

int main(int argc, char* argv[]){

   if( argc!=5 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 4.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string CONFORMATION=argv[3];
   std::string SUBSET=argv[4];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   Structure s;
   {
      DAT_ENERGY_PARAMS ep(physics_consts);
      DAT_RESIDUE_MAPPINGS rm(physics_consts,array_consts,ep);
      s.fam=FAMILY;
      s.mol=PROTEIN;
      s.FIL2SEQ(rm);
   }
   DAT_ENERGY_PARAMS energy_params(physics_consts,s);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;
   DAT_DEFORM_PARAMS deform_params;

   Thread_Options opt;
   {
      opt.MODE="lp ";
      opt.Rcut= (999.00);
      opt.iW0_active=2;
      opt.QSUB=SUBSET;
      opt.nD0_final= 8;
      opt.FUNC="ptra";
   }
   Output_Streams out;
   {
      out.FAMILY=FAMILY;
      out.PROTEIN=PROTEIN;
      out.CONFORMATION=CONFORMATION;
      out.SUBSET=SUBSET;
      std::string filename="../../"+FAMILY+"/dgn/ptra."+PROTEIN+"."+CONFORMATION
                          +"."+SUBSET;
      out.FILE3.open(filename.c_str());
      out.SHELL=false;
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf=CONFORMATION;
      str.FIL2SEQ(residue_mappings);
      str.FIL2TOR(physics_consts);
      str.CAR(physics_consts,residue_mappings);
   }
   Search_Subspace sub;
   {
      sub.FIL2STP(residue_mappings,str,opt);
   }
//
//
// set sizes
//
   int oZ0=str.nZ0;
   int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
   int oQ1=oZ0;
   int oU1=0;
   int oF1=0;
   int oB1=0;
   int oG1=0;
   int oH1=0;
   int oJ1=0;
   int oY1=0;
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL0=str.R0[iR0].L0;
      oQ1+=residue_mappings.L0[iL0].cQ0;
      oU1+=residue_mappings.L0[iL0].cU0;
      oF1+=residue_mappings.L0[iL0].cF0;
      oB1+=residue_mappings.L0[iL0].cB0;
      oG1+=residue_mappings.L0[iL0].cG0;
      oH1+=residue_mappings.L0[iL0].cH0;
      oJ1+=residue_mappings.L0[iL0].cJ0;
      oY1+=residue_mappings.L0[iL0].cY0;
   }
//
//
// mechanical system
//
   Subset_Contracted_System col(disulfide_links,residue_mappings,
                                opt,str,sub);
   if( col.nM3!=1 ){
      std::cerr<<"ERROR: Number of subsets of degrees of freedom "
                 "should equal 1.\n";
      std::exit( 2);
   }
   Mechanical_System mol(oZ0,oR0,oQ1,oU1,oF1,oB1,oG1,oH1,oJ1,oY1);
   Conf_Dependent_System dep(oZ0,oQ1,oF1,oG1,oJ1,oY1);
   {
      out.VERBOSE=false;
      Distance_Constraints dst(physics_consts,residue_mappings,
                               opt,out,str,sub);
      opt.iW0_active=-9;
      mol.SET(physics_consts,array_consts,energy_params,residue_mappings,
              opt,str,out,dst,col,dep);
      mol.CON(physics_consts,array_consts,energy_params,
              region_maps,
              opt,out,col,dep);
      out.VERBOSE=true;
   }
   const Subset_Contracted_System::tM3& con=col.M3[ 0];
   int oQ2=con.oQ2;
   int oF2=con.oF2;
   Ptra_Automatic aut(oR0,oF2);
//
//
// local minimization wrt all degs of free
//
   double ztot_full= (0.00);    //energy of previous accepted step
   {
      std::cout<<" SINGLE POINT FULL ENERGY"<< std::endl;
      out.FILE3<<"SINGLE POINT EVALUATION ON RESTBCHMGP\n";
      Loc xloc;
      aut.extern_loc(physics_consts,array_consts,disulfide_links,
                     energy_params,residue_mappings,region_maps,
                     str,out,xloc);
      int n=xloc.Table.size();
      int j=(n-1);
      ztot_full= xloc.Table[j].F;
   }
   Trajectory tra;
   {
      tra.STR2TRA( 0,str);
      tra.STR2TRA( 1,str);
   }
//
// measure of stability wrt unfolded
// neighbor subset
//
   aut.ns.populate(physics_consts,str,con);
//
//
// parameter subspaces
//
   aut.Jrec( 0)='1';            //H00
   aut.Jrec( 1)='0';            //M01
   aut.Jrec( 2)='1';            //H02
   aut.Jrec( 3)='0';            //H03
   aut.Jrec( 4)='0';            //M04
   aut.Jrec( 5)='0';            //H05
   aut.Jrec( 6)='1';            //C08
   aut.Jrec( 7)='1';            //C09
   aut.Jrec( 8)='0';            //C10
   aut.Jrec( 9)='1';            //N11
   aut.Jrec(10)='0';            //N12
   aut.Jrec(11)='1';            //O13
   aut.Jrec(12)='0';            //O14
   aut.Jrec(13)='0';            //S15
   aut.Jrec(14)='0';            //P16
   aut.Jrec(15)='0';            //F17
   aut.Jrec(16)='0';            //H02..N11
   aut.Jrec(17)='0';            //H02..N12
   aut.Jrec(18)='0';            //H02..O13
   aut.Jrec(19)='0';            //H02..O14
   aut.Jrec(20)='0';            //H02..S15
   aut.Jrec(21)='0';            //H02..F17
   aut.Jrec(22)='0';            //H05..N11
   aut.Jrec(23)='0';            //H05..N12
   aut.Jrec(24)='0';            //H05..O13
   aut.Jrec(25)='0';            //H05..O14
   aut.Jrec(26)='0';            //H05..S15
   aut.Jrec(27)='0';            //H05..F17
//
//
// initiate energy surface for restchm wrt generalized coords
//
   int oU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( con.Z0[iZ0].sub )oU2+=6;
      oU2+=(con.Z0[iZ0].cQ2-1);
   }
   Energy_Surfq enq(oU2+6,  0,oZ0,oR0,oQ2,oF2);
   {
      int iU2=0;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         if( con.Z0[iZ0].sub ){
            enq.Z0[iZ0].U2a=iU2;
            enq.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
            enq.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
            enq.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
            enq.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
            enq.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
            enq.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
            enq.U2uca(iU2  )= (2.000);
            enq.U2uca(iU2+1)= (2.000);
            enq.U2uca(iU2+2)= (2.000);
            enq.U2uca(iU2+3)= ( .125);
            enq.U2uca(iU2+4)= ( .125);
            enq.U2uca(iU2+5)= ( .125);
            iU2+=6;
         }else{
            enq.Z0[iZ0].U2a=enq.nU2;
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ2=con.Z0[iZ0].Q2a;
         int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
         if( nQ2>mQ2 ){
            for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
               enq.Q2[iQ2].U2=iU2;
               enq.U2chi(iU2)= dep.Q2[iQ2].chi;
               enq.U2uca(iU2)=( con.Q2[iQ2].br>0 )? ( .500): ( .125);
               iU2++;
            }
         }
      }
      enq.fac_m2= (  .000);
      enq.fac_m3= (  .375);
      enq.UPDATE_OU2(aut,physics_consts,con);
   }
//
//
// initiate local minimization of restchm wrt generalized coords
//
   int oM2=1024;
   Local_Minimizq loq(oM2,oU2);
   {
      loq.iCYC=0;
   }
//
//
// initiate energy surface for target funct wrt params
//
   int oU3=0;
   for(int iJ= 0;iJ<28;iJ++){
      if( aut.Jrec(iJ)=='1' )oU3++;
   }
   Energy_Surfp enp(physics_consts,energy_params,
                    oU3,oU2);
   {
      int iJ=0;
      for(int iT= 0;iT<enp.oT;iT++){
         if( enp.Tatm(iT)=="  P" )continue;
         enp.Tb[iT]=( aut.Jrec(iJ++)=='1' );
      }
      for(int iH= 0;iH<enp.oH;iH++){
         enp.Hb[iH]=( aut.Jrec(iJ++)=='1' );
      }
      int pU3=0;
      for(int iT= 0;iT<enp.oT;iT++){
         if( enp.Tb[iT] ){
            enp.U3chi(pU3++)= enp.Tr_pre(iT);
         }
      }
      for(int iH= 0;iH<enp.oH;iH++){
         if( enp.Hb[iH] ){
            enp.U3chi(pU3++)= enp.Hr_pre(iH);
         }
      }
   }
//
//
// initiate local minimization of target func wrt params
//
   Local_Minimizp lop(oM2,oU3);
   lop.BMAX= (2.00e-00);
   lop.BMIN= (2.00e-02);
   lop.BMAX*=std::sqrt( oU3);
   lop.BMIN*=std::sqrt( oU3);
   lop.BDEL= (5.00e-02);
//
//
// initiate energy surface for restchm wrt generalized coords and params
//
   Energy_Surfq ene(oU2+6,oU3,oZ0,oR0,oQ2,oF2);
   {
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         ene.Z0[iZ0].U2a=enq.Z0[iZ0].U2a;
      }
      for(int iQ2= 0;iQ2<oQ2;iQ2++){
         ene.Q2[iQ2].U2=enq.Q2[iQ2].U2;
      }
      for(int iU2= 0;iU2<oU2;iU2++){
         ene.U2uca(iU2)= enq.U2uca(iU2);
      }
      int pU3=0;
      for(int iT= 0;iT<enp.oT;iT++){
         if( enp.Tb[iT] ){
            for(int jT= 0;jT<enp.oT;jT++){
               ene.TTiU3(iT,jT)=pU3;
               ene.TTjU3(jT,iT)=pU3;
            }
            pU3++;
         }else{
            for(int jT= 0;jT<enp.oT;jT++){
               ene.TTiU3(iT,jT)=-1;
               ene.TTjU3(jT,iT)=-1;
            }
         }
      }
      for(int iH= 0;iH<enp.oH;iH++){
         int iT=enp.Hdon(iH);
         int jT=enp.Hacc(iH);
         if( enp.Hb[iH] ){
            ene.TTiU3(iT,jT)=pU3;
            ene.TTjU3(iT,jT)=pU3;
            ene.TTiU3(jT,iT)=pU3;
            ene.TTjU3(jT,iT)=pU3;
            pU3++;
         }else{
            ene.TTiU3(iT,jT)=-1;
            ene.TTjU3(iT,jT)=-1;
            ene.TTiU3(jT,iT)=-1;
            ene.TTjU3(jT,iT)=-1;
         }
      }
      ene.fac_m2= enq.fac_m2;
      ene.fac_m3= enq.fac_m3;
      for(int iU2= 0;iU2<oU2;iU2++){
         ene.OU2b(iU2, enq.OU2b(iU2));
         ene.OU2chi(iU2)= enq.OU2chi(iU2);
      }
   }
//
//
// generation of trajectory
//
   int zM0( 0);                 //index of last accepted step
   int pM0( 0);                 //index of last restart
   double fac_T( 1.00);         //scale factor for kT
   int bM( 7);                  //base n of param inflation steps
   int oM( 0);                  //adjusted n of param inflation steps
   double ztot_part( 1.00d+5);  //threshold e for global search wrt subset
   int nM0=opt.NCYCLES;         //number of traj of local minima steps
   int iM0=0;
   for(int i1= 0;i1<10&&(iM0<nM0);i1++){
      char a1=char('0'+i1);
      for(int i2= 0;i2<10&&(iM0<nM0);i2++){
         char a2=char('0'+i2);
         for(int i3= 0;i3<10&&(iM0<nM0);i3++){
            char a3=char('0'+i3);
            int MODULO_3=( i1*100 +i2*10 +i3)%3;
            aut.o_Table.push_back( Ptra_Automatic::Record());
            std::cout<<" cycle="<<a1<<a2<<a3<< std::endl;
//
//
// update neighbor subset st consecutive steps vary
//
            for(int iF2= 0;iF2<(oF2- 1);iF2++){
               bool iMASK=( (iF2% 3)==MODULO_3 );
               std::string ai=con.F2[iF2].atm;
               for(int jF2=(iF2+ 1);jF2<oF2;jF2++){
                  bool jMASK=( (jF2% 3)==MODULO_3 );
                  std::string aj=con.F2[jF2].atm;
                  bool NEIGHBOR=(aut.ns.F2F2b(iF2,jF2)||iMASK||jMASK);
                  if( NEIGHBOR ){
                  }else{
                     int iR0=con.F2[iF2].R0;
                     int iP1=str.iatom(iR0,ai);
                     int jR0=con.F2[jF2].R0;
                     int jP1=str.iatom(jR0,aj);
                     double r= ( str.P1[jP1].x -str.P1[iP1].x).r();
                     NEIGHBOR=( r>( 20.00) );
                  }
                  enq.F2F2b(iF2,jF2, NEIGHBOR);
                  ene.F2F2b(iF2,jF2, NEIGHBOR);
               }
            }
//
//
// update target func st consecutive steps vary
//
            {
               double the= double(iM0)*(physics_consts.RAD*(  50.00));
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               enp.fac_w= ( 1.00)*( (1.00) +( .25)*Cthe);
               enp.fac_y= ( 1.00)*( (1.00) +(-.25)*Cthe);
               enp.fac_z= (-5.00)*( (1.00) +(-.25)*Sthe);
            }
//
//
// update local minimization of target func wrt params
//
            lop.BETA= (1.00e-01);
            lop.BETA*=std::sqrt( oU3);
            if( aut.ns.xfold> ( .60) ){
               fac_T=( 1.00);
               oM=bM;
            }else{
               fac_T=( ( 1.00) +(( 1.00)*((  .60)-aut.ns.xfold)/(  .60)) );
               oM=( bM+ int((  7.00)-( 7.00)*aut.ns.xfold/(  .60)) );
            }
            lop.nM2=oM;
//
// inflate
// local minimization of target func wrt params
//
            str.cnf=std::string("i")+a1+a2+a3;
            out.FILE3<<"INFLATE RESTBCHPW CYCLE\n";
            std::cout<<" INFLATION TRAJECTORY"<< std::endl;
            lop.TRA_LOP(physics_consts,array_consts,residue_mappings,
                        energy_params,region_maps,
                        opt,out,str,mol,con,dep,
                        enp,ene,loq,enq);
            lop.TRA_LOP_WRT(physics_consts,residue_mappings,
                            out,str,mol,con,dep,
                            enp,ene);
            SYNC(physics_consts,energy_params,
                 enp,enq,ene);
            out.FILE3<< std::fixed<< std::setprecision( 3);
            out.FILE3<<"       "<<"change in RHO\n";
            for(int iT= 0;iT<enp.oT;iT++){
               if( !enp.Tb[iT] )continue;
               out.FILE3<<' '<<enp.Tatm(iT)<<"     "
                        << std::setw( 8)<<( enp.Tr(iT) -enp.Tr_pre(iT))<<'\n';
            }
            for(int iH= 0;iH<enp.oH;iH++){
               if( !enp.Hb[iH] )continue;
               int iT=enp.Hdon(iH);
               int jT=enp.Hacc(iH);
               out.FILE3<<' '<<enp.Tatm(iT)<<".."<<enp.Tatm(jT)
                        << std::setw( 8)<<( enp.Hr(iH) -enp.Hr_pre(iH))<<'\n';
            }
            str.CAR(physics_consts,residue_mappings);
            aut.Table(iM0).Ri= str.SUP(physics_consts,out,tra);
            tra.STR2TRA((2+2*iM0  ),str);
//          str.TOR2FIL(physics_consts);
//          str.CAR2FIL();
            aut.Table(iM0).oM=lop.iM2;
//
// deflate
// restore params
//
            std::cout<<" RESTORE PARAMETERS"<< std::endl;
            out.FILE3<<"DEFLATE RESTBCHPW\n";
            {
               int iU3=0;
               for(int iT= 0;iT<enp.oT;iT++){
                  if( enp.Tb[iT] ){
                     enp.U3chi(iU3++)= enp.Tr_pre(iT);
                  }
               }
               for(int iH= 0;iH<enp.oH;iH++){
                  if( enp.Hb[iH] ){
                     enp.U3chi(iU3++)= enp.Hr_pre(iH);
                  }
               }
            }
            SYNC(physics_consts,energy_params,
                 enp,enq,ene);
//
//
// local minimization of restchm wrt generalized coordinates
//
            loq.BETA= (2.00e-02);
            loq.BETA*=std::sqrt( oU2);
            loq.BMIN= (1.00e-05);
            loq.BMIN*=std::sqrt( oU2);
            loq.BMAX=( 1.00e-01);
            loq.BMAX*=std::sqrt( oU2);
            loq.EPS1= (1.00e-04);
            loq.EPS1= oU2*loq.EPS1*loq.EPS1;
            loq.nM2=128;
            bool INFLATE=false;
//          out.FILE3<<"________________________________________"
//                     "________________________________________\n";
            std::cout<<" LOCAL MINIMIZATION TRAJECTORY"<< std::endl;
            loq.TRA_LOQ(physics_consts,array_consts,energy_params,
                        region_maps,
                        opt,out,mol,con,dep,
                        enq,INFLATE);
            loq.TRA_LOQ_WRT(physics_consts,residue_mappings,
                            out,str,mol,con,dep,
                            enq,INFLATE);
            str.CAR(physics_consts,residue_mappings);
            if( enq.TOT<ztot_part ){
               ztot_part= enq.TOT;
            }
//
//
// global minimization wrt subset of degs of free
//
            if( enq.TOT<( ztot_part +( 12.00)) ){
               std::cout<<" SEGMENT SEARCH FULL ENERGY"<< std::endl;
               out.FILE3<<"SEGMENT GLOBAL SEARCH ON RESTBCHMGP\n";
               Glo xglo;
               str.cnf=std::string("x")+a1+a2+a3;
               aut.extern_glo(physics_consts,array_consts,disulfide_links,
                              energy_params,residue_mappings,region_maps,
                              deform_params,
                              str,sub,out,xglo);
//
//
// transfer generalized coords from str to enq
//
               enq.UPDATE_CONF(physics_consts,residue_mappings,
                               str,mol,con,dep);
            }
//
//
// local minimization wrt all degs of free
//
            {
               std::cout<<" SINGLE POINT FULL ENERGY"<< std::endl;
               out.FILE3<<"SINGLE POINT EVALUATION ON RESTBCHMGP\n";
               Loc xloc;
               aut.extern_loc(physics_consts,array_consts,disulfide_links,
                              energy_params,residue_mappings,region_maps,
                              str,out,xloc);
               str.cnf=std::string("t")+a1+a2+a3;
               aut.Table(iM0).Rd= str.SUP(physics_consts,out,tra);
               tra.STR2TRA((3+2*iM0  ),str);
               str.TOR2FIL(physics_consts);
               str.CAR2FIL();
               int n=xloc.Table.size();
               int j=(n-1);
               aut.Table(iM0).Ftot= xloc.Table[j].F;
               aut.Table(iM0).Fr= xloc.Table[j].Fr;
               aut.Table(iM0).Fe= xloc.Table[j].Fe;
               aut.Table(iM0).Fs= xloc.Table[j].Fs;
               aut.Table(iM0).Ft= xloc.Table[j].Ft;
               aut.Table(iM0).Fc= xloc.Table[j].Fc;
               aut.Table(iM0).Fb= xloc.Table[j].Fb;
               aut.Table(iM0).Fh= xloc.Table[j].Fh;
               aut.Table(iM0).Fm= xloc.Table[j].Fm;
               aut.Table(iM0).Fg= xloc.Table[j].Fg;
               aut.Table(iM0).Fp= xloc.Table[j].Fp;
//
//
// transfer generalized coords from str to enq
// 
               enq.UPDATE_CONF(physics_consts,residue_mappings,
                               str,mol,con,dep);
            }
//
//
// update reference structure st RMSD is wrt previous step
//
            aut.Table(iM0).g= enp.g;
            double dtot=( aut.Table(iM0).Ftot -ztot_full);
            aut.Table(iM0).dtot= dtot;
            if( dtot<(  0.00) ){
               aut.Table(iM0).accept=2;
               zM0=(3+2*iM0  );
               pM0=iM0;
               ztot_full= aut.Table(iM0).Ftot;
               aut.ns.populate(physics_consts,str,con);
               enq.UPDATE_OU2(aut,physics_consts,con);
               ene.UPDATE_OU2(aut,physics_consts,con);
               tra.STR2TRA( 0,str);
               if( loq.bQ> 0 )loq.bQ--;
            }else{
               double G= aut.rng.random_gen();
               double e= ((.25)*dtot)/(fac_T*physics_consts.ekT);
               double F= std::exp( -e);
               aut.Table(iM0).rn= G;
               aut.Table(iM0).z= F;
               if( F>G ){
                  aut.Table(iM0).accept=2;
                  zM0=(3+2*iM0  );
                  pM0=iM0;
                  ztot_full= aut.Table(iM0).Ftot;
                  aut.ns.populate(physics_consts,str,con);
                  enq.UPDATE_OU2(aut,physics_consts,con);
                  ene.UPDATE_OU2(aut,physics_consts,con);
                  tra.STR2TRA( 0,str);
//                if( loq.bQ> 0 )loq.bQ--;
               }else{
                  if( (iM0<(pM0+ 4))&&(dtot<( 60.00)) ){
                     aut.Table(iM0).accept=1;
                  }else{
                     aut.Table(iM0).accept=0;
                     str.TRA2STR(zM0,tra);
                     enq.UPDATE_CONF(physics_consts,residue_mappings,
                                     str,mol,con,dep);
                     pM0=iM0;
                     if( loq.bQ< 6 )loq.bQ++;
                  }
               }
            }
            aut.Table(iM0).xfold= aut.ns.xfold;
/**/        out.FILE3<<" RMSD_inflate="<<std::setw( 8)<<aut.Table(iM0).Ri
/**/                 <<" RMSD_deflate="<<std::setw( 8)<<aut.Table(iM0).Rd
/**/                 <<" oM="<<std::setw( 2)<<oM<<'\n';
////        if      ( aut.Table(iM0).Ri>( 4.80) ){
////           if( bM> 2 )bM--;
////        }else if( aut.Table(iM0).Ri<( 1.60) ){
////           if( bM<12 )bM++;
////        }
            iM0++;
         }
      }
   }
//
//
// output compact analysis of global minimization trajectory
//
   out.FILE3<<"COMPACT ANALYSIS\n";
   out.FILE3<< std::fixed;
   int n=aut.o_Table.size();
   out.FILE3<<"     RMSD       "
            <<"      Energy Decomposition                                 "
            <<"        Acceptance  \n";
   out.FILE3<<"   "
            <<"  Ri "
            <<" oM"
            <<"  Rd "
            <<"    Ftot"
            <<"    Frsc"
            <<"     Fe "
            <<"     Ftb"
            <<"     Fh "
            <<"     Fm "
            <<"   Fgp"
            <<"  dtot"
            <<" fold"
            <<"   z  "
            <<"  rn  "
            <<" A"
            <<'\n';
   for(int i=0;i<n;i++){
      out.FILE3<< std::setw( 3)<<i
               << std::setprecision(2)
               << std::setw( 5)<<aut.Table(i).Ri
               << std::setw( 3)<<aut.Table(i).oM
               << std::setw( 5)<<aut.Table(i).Rd
               << std::setprecision(1)
               << std::setw( 8)<<aut.Table(i).Ftot
               << std::setw( 8)<<( aut.Table(i).Fr +aut.Table(i).Fs +aut.Table(i).Fc)
               << std::setw( 8)<<aut.Table(i).Fe
               << std::setw( 8)<<( aut.Table(i).Ft +aut.Table(i).Fb)
               << std::setw( 8)<<aut.Table(i).Fh
               << std::setw( 8)<<aut.Table(i).Fm
               << std::setw( 6)<<( aut.Table(i).Fg +aut.Table(i).Fp)
               << std::setw( 6)<<aut.Table(i).dtot
               << std::setprecision(2)
               << std::setw( 5)<<aut.Table(i).xfold
               << std::setprecision(3)
               << std::setw( 6)<<aut.Table(i).z
               << std::setw( 6)<<aut.Table(i).rn
               << std::setw( 2)<<aut.Table(i).accept
               <<'\n';
   }

   out.FILE3.close();

}
