#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>

int main(int argc, char* argv[]){

   if( argc!=4 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 3.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string CONFORMATION=argv[3];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;
   DAT_IGOR_DATA igor_data(physics_consts);

   Thread_Options opt;
   {
      opt.MODE="";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/prof."+PROTEIN
                          +"."+CONFORMATION;
      out.FILE3.open(filename.c_str());
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf=CONFORMATION;
   }
   str.FIL2SEQ(residue_mappings);
   str.FIL2TOR(physics_consts);
   str.FIL2CAR();
   str.STA(physics_consts,region_maps);

   str.DEFECT(physics_consts,array_consts,energy_params,residue_mappings,
              region_maps,igor_data,
              opt,out);

   out.FILE3.close();

}
