#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>

int main(int argc, char* argv[]){

   if( argc!=4 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 3.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string CONFORMATION=argv[3];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_IGOR_DATA igor_data(physics_consts);

   Thread_Options opt;
   {
      opt.MODE="ssp";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/initcar."+PROTEIN;
      out.FILE3.open(filename.c_str());
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf=CONFORMATION;
   }
   str.FIL2SEQ(residue_mappings);
   std::string filename="../../"+FAMILY+"/tor/tor."+PROTEIN+"."+CONFORMATION;
   std::ifstream file_exists(filename.c_str());
   if( file_exists ){
      file_exists.close();
      str.FIL2TOR(physics_consts);
      str.CAR(physics_consts,residue_mappings);
      str.CAR2FIL();
   }else{
      double C7phi[ 4];
      double C7psi[ 4];
      C7phi[ 0]=( 180.00);
      C7psi[ 0]=( 180.00);
      C7phi[ 1]=( -75.00);
      C7psi[ 1]=( -45.00);
      C7phi[ 2]=(-135.00);
      C7psi[ 2]=( 150.00);
      C7phi[ 3]=( -75.00);
      C7psi[ 3]=( 135.00);
//
//
// initiate torsion angles
//
      double x= (0.00);
      int oZ0=str.nZ0;
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         str.Z0[iZ0].trans.zero();
         str.Z0[iZ0].rot.zero();
         str.Z0[iZ0].trans(0)+=x;
         x+=((32.00)/physics_consts.ANG);
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int mT1=str.R0[iR0].T1a;
            int nT1=(mT1-1+str.R0[iR0].cT1);
            for(int iT1=mT1;iT1<=nT1;iT1++){
               if      ( str.T1[iT1].tor=="PHI" ){
                  str.T1[iT1].chi=( -75.00);
               }else if( str.T1[iT1].tor=="PSI" ){
                  str.T1[iT1].chi=(  45.00);
               }else{
                  str.T1[iT1].chi=( 180.00);
               }
            }
            std::string aa=str.R0[iR0].aa;
            if( (aa[0]=='e')||(aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||(aa[3]=='z') )aa=aa.substr(0,3)+' ';
            if      ( aa=="ALA " ){
               str.T1[mT1+ 3].chi=(  60.00);
            }else if( aa=="ILE " ){
               str.T1[mT1+ 5].chi=(  60.00);
               str.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="LEU " ){
               str.T1[mT1+ 5].chi=(  60.00);
               str.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="MET " ){
               str.T1[mT1+ 6].chi=(  60.00);
            }else if( aa=="PRO " ){
               str.T1[mT1   ].chi=( -65.00);
               str.T1[mT1+ 3].chi=(  16.00);
               str.T1[mT1+ 4].chi=( -19.00);
               str.T1[mT1+ 5].chi=(  14.00);
            }else if( aa=="ARG " ){
               str.T1[mT1+ 7].chi=(   0.00);
            }else if( aa=="THR " ){
               str.T1[mT1+ 5].chi=(  60.00);
            }else if( aa=="VAL " ){
               str.T1[mT1+ 4].chi=(  60.00);
               str.T1[mT1+ 5].chi=(  60.00);
            }else if( aa=="TYR " ){
               str.T1[mT1+ 5].chi=(   0.00);
            }else if( aa=="ACE " ){
               str.T1[mT1   ].chi=(   0.00);
            }
         }
      }
//
//
// add bb torsion angles consistent with igor secondary structure prediction
//
      for(int iZ0=0;iZ0<oZ0;iZ0++){
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         Igor_Model igo;
         igo.IGO(physics_consts,array_consts,residue_mappings,igor_data,
                 opt,out,str,
                 iZ0,mR0,nR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iC7=igo.R0[iR0-mR0].C70;
            int mT1=str.R0[iR0].T1a;
            int nT1=(mT1-1+str.R0[iR0].cT1);
            for(int iT1=mT1;iT1<=nT1;iT1++){
               std::string tor=str.T1[iT1].tor;
               if      ( tor=="PHI" ){
                  str.T1[iT1].chi= C7phi[iC7];
               }else if( tor=="PSI" ){
                  str.T1[iT1].chi= C7psi[iC7];
               }
            }
         }
      }
      str.CAR(physics_consts,residue_mappings);
      str.TOR2FIL(physics_consts);
      str.CAR2FIL();
   }
   out.FILE3.close();
}
