#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../hom/Homolog_Model.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <cmath>

class MEM_igor {
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_igor(){
   }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

int main(int argc, char* argv[]){
   MEM_igor vv;

   if( argc!=3 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 2.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];

   {
      std::string filename="../../"+FAMILY+"/exp/seq."+PROTEIN;
      std::ifstream file_exists(filename.c_str());
      if( !file_exists ){
         std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
         std::exit( 1);
      }else{
         file_exists.close();
      }
   }

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_DEFORM_PARAMS deform_params;
   DAT_IGOR_DATA igor_data(physics_consts, true);

   Thread_Options opt;
   {
      opt.MODE="   ";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/igor."+PROTEIN;
      out.FILE3.open(filename.c_str());
      filename="../../"+FAMILY+"/dgn/igodmp."+PROTEIN;
      out.FILE2.open(filename.c_str());
      out.SHELL=false;
   }

   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
      str.cnf="0";
   }
   str.FIL2CHA(residue_mappings,igor_data);
//
//
// for development, start traj from native composition
//
   {
      std::string filename="../../"+FAMILY+"/exp/seq."+PROTEIN;
      std::ifstream ifile(filename.c_str());
      std::string rec;
      while( !std::getline(ifile,rec).eof() ){
         vv.o_Lrec.push_back(rec);
      }
      ifile.close();
      int oL=int(vv.o_Lrec.size());
      rec=vv.Lrec(oL-1);
      int oZ0=str.nZ0;
      int oR0=(str.Z0[oZ0-1].R0a+str.Z0[oZ0-1].cR0);
      for(int iR0= 0;iR0<oR0;iR0++){
         char a1=rec[iR0];
         int iC7=-1;
         for(int jC7=1;jC7<4;jC7++){
            if( igor_data.C7[jC7].a1==a1 ){
               iC7=jC7;
               break;
            }
         }
         if( iC7==-1 ){
            std::cerr<<"ERROR: Unmatched residue ss state in file "
                      +filename.erase( 0, 6)+".\n";
            std::exit( 1);
         }
         str.R0[iR0].C7=iC7;
      }
   }
//
//
// igor fold search
//
   out.FILE3<<"IGOR MODEL FOLD"
            <<std::endl;
   int pZ0= 0;                          //index of chain containing segment
   int pR0min= 0;                       //index of initial res of segment
   int pR0max=(str.Z0[ 0].cR0- 1);      //index of final res
   Igor_Model igo;
   igo.IGO(physics_consts,array_consts,residue_mappings,igor_data,
           opt,out,str,
           pZ0,pR0min,pR0max);
//
//
// output full atom structure of optimal config
//
   int o=( igo.oK7<16 )? igo.oK7: 16;
   for(int iK7=0;iK7<o;iK7++){
      if( igo.K7[iK7].e[ 0]<=(-1.00e+5) )break;
      if( igo.K7[iK7].PACK ){
         char a1=char('0'+(iK7/10));
         char a0=char('0'+(iK7%10));
         Homolog_Model hom;
         {
            hom.tar=str;
            hom.tar.mol=PROTEIN+'_'+a1+a0+'i';
            hom.tar.cnf="igo";
            hom.def.nZ2=0;
         }
//
//
// transfer bb conf
//
         int oZ0=hom.tar.nZ0;
         int oR0=(hom.tar.Z0[oZ0-1].R0a+hom.tar.Z0[oZ0-1].cR0);
         for(int iR0= 0;iR0<oR0;iR0++){
            int iP1=hom.tar.iatom(iR0," CA ");
            hom.tar.P1[iP1].x=igo.K7[iK7].R0[iR0].xca;
            hom.tar.P1[iP1].sub=1;
            iP1=hom.tar.iatom(iR0," N  ");
            hom.tar.P1[iP1].x=igo.K7[iK7].R0[iR0].xn;
            hom.tar.P1[iP1].sub=1;
            iP1=hom.tar.iatom(iR0," C  ");
            hom.tar.P1[iP1].x=igo.K7[iK7].R0[iR0].xc;
            hom.tar.P1[iP1].sub=1;
            if( iR0==(oR0- 1) ){
               Coordinates u=( igo.K7[iK7].R0[iR0].xc
                              -igo.K7[iK7].R0[iR0].xca).normalize();
               Coordinates v=( igo.K7[iK7].R0[iR0].xn
                              -igo.K7[iK7].R0[iR0].xca);
               double vu= dot(v,u);
               v-=vu*u;
               v.normalize();
               Coordinates w=cross(u,v);
               Rotation_Matrix P;
               P(0,0)= u(0);
               P(1,0)= u(1);
               P(2,0)= u(2);
               P(0,1)= v(0);
               P(1,1)= v(1);
               P(2,1)= v(2);
               P(0,2)= w(0);
               P(1,2)= w(1);
               P(2,2)= w(2);
               double d= (1.229);
               double the=( (180.00) -(120.40))*physics_consts.RAD;
               double CT= std::cos( the);
               double ST= std::sin( the);
               double phi= ( 90.00)*physics_consts.RAD;
               double CP= std::cos( phi);
               double SP= std::sin( phi);
               Coordinates x;
               x(0)= d*CT;
               x(1)= d*ST*CP;
               x(2)= d*ST*SP;
               iP1=hom.tar.iatom(iR0," O  ");
               hom.tar.P1[iP1].x=( igo.K7[iK7].R0[iR0].xc +P*x);
               hom.tar.P1[iP1].sub=1;
               x(1)=-x(1);
               x(2)=-x(2);
               iP1=hom.tar.iatom(iR0," OXT");
               hom.tar.P1[iP1].x=( igo.K7[iK7].R0[iR0].xc +P*x);
               hom.tar.P1[iP1].sub=1;
            }
         }
//       std::string backup_cnf=hom.tar.cnf;
//       hom.tar.cnf=std::string("pre")+a1+a0;
//       hom.tar.CAR2FIL();
//       hom.tar.cnf=backup_cnf;
//
//
// pack sc conf onto bb
//
         hom.SUB(physics_consts,energy_params,residue_mappings,deform_params,
                 out,
                  0,(oR0-1));
//
//
// regularize
//
         hom.tar.SEQ2FIL();
         hom.tar.TOR2FIL(physics_consts);
         hom.tar.CAR2FIL();
      }
   }

   out.FILE3.close();
   out.FILE2.close();

}
