#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_DEFORM_PARAMS.hh"
#include "../dat/DAT_DISULFIDE_LINKS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../hom/Homolog_Model.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>

int main(int argc, char* argv[]){

   if( argc!=4 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 3.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];
   std::string TEMPLATE=argv[3];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_DISULFIDE_LINKS disulfide_links;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);
   DAT_REGION_MAPS region_maps;
   DAT_DEFORM_PARAMS deform_params;
   DAT_IGOR_DATA igor_data(physics_consts);

   Thread_Options opt;
   {
      opt.MODE="   ";
   }
   Output_Streams out;
   {
      std::string filename="../../"+FAMILY+"/dgn/hlog."+PROTEIN+"."+TEMPLATE;
      out.FILE3.open(filename.c_str());
   }

   out.FILE3<<"INPUT TEMPLATE STRUCTURES"<< std::endl;
   Homolog_Model hom(physics_consts,array_consts,energy_params,
                     residue_mappings,region_maps,igor_data,
                     opt,out,FAMILY,TEMPLATE);
   out.FILE3<<"ALIGN TEMPLATE STRUCTURES"<< std::endl;
// std::cerr<<" entering SCR"<< std::endl;
   hom.SCR(physics_consts,residue_mappings,
           out);
// std::cerr<<" exiting SCR"<< std::endl;
   hom.tar.fam=FAMILY;
   hom.tar.mol=PROTEIN;
   hom.tar.cnf=TEMPLATE;
   hom.tar.FIL2SEQ(residue_mappings);
   out.FILE3<<"ALIGN TARGET SEQUENCE TO TEMPLATE STRUCTURES"<< std::endl;
// std::cerr<<" entering ALI"<< std::endl;
   hom.ALI(physics_consts,array_consts,disulfide_links,energy_params,
           residue_mappings,region_maps,deform_params,igor_data,
           opt,out);
// std::cerr<<" exiting ALI"<< std::endl;
   int oZ0=hom.tar.nZ0;
   int oR0=(hom.tar.Z0[oZ0-1].R0a+hom.tar.Z0[oZ0-1].cR0);
   out.FILE3<<"BUILD TARGET HOMOLOGY MODEL"<< std::endl;
// std::cerr<<" entering SUB"<< std::endl;
   hom.SUB(physics_consts,energy_params,residue_mappings,deform_params,
           out,
            0,(oR0-1));
// std::cerr<<" exiting SUB"<< std::endl;
   hom.tar.STA(physics_consts,region_maps);
   hom.tar.TOR2FIL(physics_consts);
   hom.tar.CAR2FIL();
   out.FILE3<<"EVALUATE DEFECT PROFILE"<< std::endl;
   hom.tar.DEFECT(physics_consts,array_consts,energy_params,residue_mappings,
                  region_maps,igor_data,
                  opt,out);

   out.FILE3.close();

}
