#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../fil/Trajectory.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>

int main(int argc, char* argv[]){

   if( argc!=3 ){
      std::cerr<<"ERROR: Number of command line arguments "
                 "should equal 2.\n";
      std::exit( 1);
   }
   std::string FAMILY=argv[1];
   std::string PROTEIN=argv[2];

   DAT_PHYSICS_CONSTS physics_consts;
   DAT_ARRAY_CONSTS array_consts;
   DAT_ENERGY_PARAMS energy_params(physics_consts);
   DAT_RESIDUE_MAPPINGS residue_mappings(physics_consts,array_consts,
                                         energy_params);

   std::string filename="../../"+FAMILY+"/exp/"+PROTEIN+".pdb";
   std::ifstream file_exists(filename.c_str());
   if( !file_exists ){
      std::cerr<<"ERROR: File "+filename.erase( 0, 6)+" does not exist.\n";
      std::exit( 1);
   }else{
      file_exists.close();
   }

   Output_Streams out;
   {
      filename="../../"+FAMILY+"/dgn/greg."+PROTEIN;
      out.FILE3.open(filename.c_str());
   }
   Structure str;
   {
      str.fam=FAMILY;
      str.mol=PROTEIN;
   }
   Trajectory tra;

   str.cnf="exp";
   str.REFORM(physics_consts,residue_mappings);
   str.SEQ2FIL();
   str.TOR(physics_consts,residue_mappings);
   tra.STR2TRA( 0,str);

   str.cnf="00";
   out.FILE3<<"REGULARIZE GEOMETRY"<< std::endl;
   str.REG(physics_consts,residue_mappings,out);
   str.POLARH(physics_consts,residue_mappings);
   str.TOR(physics_consts,residue_mappings);
   str.TOR2FIL(physics_consts);
   str.CAR(physics_consts,residue_mappings);
   str.SUP(physics_consts,out,tra);
   str.CAR2FIL();
   out.FILE3.close();

}
